/*******************************************************************************
 * AirHockeyTable_NativeBase generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AirHockeyTable_NativeBase extends Decoration
    native
    collapsecategories;

cpptext
{
// Stripped
}

enum EAirHockeyObj
{
    AIRHOCKEYOBJ_Paddle1,
    AIRHOCKEYOBJ_Paddle2,
    AIRHOCKEYOBJ_Table
};

struct STable
{
    var() float Width;
    var() float Length;
    var() float GoalWidth;
    var() float CornerRadius;
    var() float StuckZone;
};

struct STableCollision
{
    var float MinY;
    var float MaxY;
    var float MinX;
    var float MaxX;
    var float Radius;
    var Vector BottomLeft;
    var Vector BottomRight;
    var Vector TopLeft;
    var Vector TopRight;
    var Vector TopLeftCorner;
    var Vector TopRightCorner;
    var Vector BottomLeftCorner;
    var Vector BottomRightCorner;
    var float TopGoalLineX;
    var Vector TopGoalBottomLeft;
    var Vector TopGoalBottomRight;
    var Vector TopGoalTopLeft;
    var Vector TopGoalTopRight;
    var float BottomGoalLineX;
    var Vector BottomGoalBottomLeft;
    var Vector BottomGoalBottomRight;
    var Vector BottomGoalTopLeft;
    var Vector BottomGoalTopRight;
};

struct SOverlap
{
    var Vector OthersPos;
    var Vector OverlapNorm;
};

struct SSimpleRB
{
    var float Radius;
    var Vector Vel;
    var Vector Posn;
    var Vector OldPos;
    var Vector DesiredDisp;
};

struct SColInfo
{
    var float Percent;
    var Vector CollisionNorm;
    var Vector Vel;
    var AirHockeyTable_NativeBase.EAirHockeyObj OtherObj;
};

struct SPlayer
{
    var Pawn Player;
    var dnControl Ctrl;
    var Decoration Paddle;
    var int Score;
};

var(AirHockeyDebug) noexport bool DebugTable "Draw the table collision boundaries?";
var(AirHockeyDebug) noexport bool DebugPuck "Draw the pucks RB?";
var(AirHockeyDebug) noexport bool DebugPaddles "Draw the paddles RBs?";
var(AirHockeyDebug) noexport bool DebugCollision "Draw collisions?";
var(AirHockeyGame) noexport int WinningScore "How many goals to win?";
var(AirHockeyGame) noexport float ChanceScoreAnim "Chance of playing a score animation after a goal.";
var STable Table;
var Vector WorldSpaceOrigin;
var STableCollision TableCollision;
var SSimpleRB Paddle1RB;
var SSimpleRB Paddle2RB;
var SSimpleRB PuckRB;
var SColInfo Collision;
var SPlayer PlayerInfo[2];
var int Scorer;
var Decoration Puck;
var bool PuckInPlay;
var float PaddlePuckRadius;
var float PaddlePuckRadiusSq;
var float MaxPuckSpeedSq;
var name PuckPaddleSoundName;
var name PuckTableSoundName;
var name ScoreSoundName;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        PlayerInfo;
}

event BumpShader GetScoreTexture(int Index)
{
    return none;
    return;
}

function bool PuckIsResetting()
{
    return false;
    return;
}

event StartPlay()
{
    return;
}

event GoalScored(int PlayerIndex)
{
    return;
}

event GameWon(int PlayerIndex)
{
    return;
}

// Export UAirHockeyTable_NativeBase::execInitTable(FFrame&, void* const)
native function InitTable();

// Export UAirHockeyTable_NativeBase::execTickTable(FFrame&, void* const)
native function TickTable(float Secs);

// Export UAirHockeyTable_NativeBase::execPlayerJoined(FFrame&, void* const)
native function PlayerJoined(int Player, Pawn NewPlayer);

// Export UAirHockeyTable_NativeBase::execPlayerLeft(FFrame&, void* const)
native function PlayerLeft(int Player);

// Export UAirHockeyTable_NativeBase::execGrabPuck(FFrame&, void* const)
native function GrabPuck(Pawn PuckOwner);

// Export UAirHockeyTable_NativeBase::execSetPuckInPlay(FFrame&, void* const)
native function SetPuckInPlay();

// Export UAirHockeyTable_NativeBase::execRemovePuckFromPlay(FFrame&, void* const)
native function RemovePuckFromPlay();

// Export UAirHockeyTable_NativeBase::execCalcShot(FFrame&, void* const)
native function bool CalcShot(int Player, float MaxTime, out Vector OutAccel, out float OutTime, bool DebugShot);
