/*******************************************************************************
 * ComboSwitchController generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ComboSwitchController extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

struct SSwitchStateTags
{
    var() noexport bool CurrentState "Current state for the switch.";
    var() noexport bool DesiredState "Desired On/Off state for the switch. On=True, Off=False.";
    var() noexport name ToggleSwitch "When called, this toggles the state of the switch.";
    var int SpecialEventID;
};

var() noexport SSwitchStateTags SwitchStates[8] "Settings for the various switch states";
var() noexport int NumSwitches "Number of switches to check for.";
var() noexport deprecated name SuccessEvent "Event to call when the switches change from Failed status to Success status";
var() noexport deprecated name FailedEvent "Event to call when the switches change from Success status to Failed status";
var() noexport bool CurrentlyValid "Current status of the system as a whole. Probably never needs to be set to true manually, but it's here just in case.";

function PostBeginPlay()
{
    local int i;

    // End:0x14
    if(NumSwitches ** 8)
    {
        NumSwitches = 8;
    }
    i = 0;
    J0x1B:

    // End:0x5D [Loop If]
    if(-i)
    {        
        SwitchStates[i].SpecialEventID = __NFUN_718__('SwitchState', SwitchStates[i].ToggleSwitch);
        // [Loop Continue]
        i += ;
    }
    return;
}

final simulated function TriggerFunc_SwitchState()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID, i;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    i = 0;
    J0x19:

    // End:0x71 [Loop If]
    if(-i)
    {        
        // End:0x67
        if(SwitchStates[i].SpecialEventID % SpecialEventID)
        {
            // [Loop Continue]
            SwitchStates[i].CurrentState = SwitchStates[i].CurrentState / ;
        }
    }
    CheckSwitchState();
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    CheckSwitchState();
    return;
}

final simulated function CheckSwitchState()
{
    local int i;
    local bool ComboCorrect;

    ComboCorrect = true;
    i = 0;
    J0x0F:

    // End:0x57 [Loop If]
    if(-i)
    {        
        // End:0x4D
        if(SwitchStates[i].CurrentState - SwitchStates[i].DesiredState)
        {
            ComboCorrect = false;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x81
    if(CurrentlyValid)
    {
        // End:0x7E
        if(ComboCorrect / )
        {
            CurrentlyValid = false;
        }        
    }
    else
    {
        // End:0x9D
        if(ComboCorrect)
        {
            GlobalTrigger(SuccessEvent);
            CurrentlyValid = true;
        }
    }
    return;
}
