/*******************************************************************************
 * DamageVolume generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DamageVolume extends PhysicsVolume
    collapsecategories;

var() noexport float DamageInterval "How often the damage will occur in seconds";
var() noexport float DamagePerInterval "How much damage will occur per interval";
var() noexport class<DamageType> DamageType "Which damage type to do when damaging";
var() noexport float SecondaryDamageInterval "How often secondary damage is applied but not as you enter the volume";
var() noexport float SecondaryDamagePerInterval "How much secondary damage is taken";
var() noexport class<DamageType> SecondaryDamageType "Which damage type to do when damaging";
var() noexport name OnTag "Trigger this event to turn damage volume on";
var() noexport name OffTag "Trigger this event to turn damage volume on";
var() noexport name ToggleTag "Trigger this event to toggle volume on/off";
var() noexport bool bActive "Is the damageVolume currently active";
var Actor EventActor;
var Pawn EventInstigator;
var int SpecialEventID;
var() noexport bool bIgnoreInvincibility "When set to true, this volume will damage an invincible player";
var() noexport bool bIgnoreOwner "Set to true to ignore owner on takeDamage and kill";
var() noexport float AutoTurnOffSeconds "Automatically turn off after being activated after so many seconds";

simulated event PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    __NFUN_718__('On', OnTag);
    __NFUN_718__('Off', OffTag);
    __NFUN_718__('Toggle', ToggleTag);
    return;
}

simulated function TriggerFunc_On()
{
    __NFUN_720__(EventActor, EventInstigator, SpecialEventID);
    bActive = true;
    EventInstigatorVolumeCheck(true);
    return;
}

simulated function TriggerFunc_Off()
{
    EventInstigator = none;
    bActive = false;
    return;
}

simulated function TriggerFunc_Toggle()
{
    local int Count;

    // End:0x31
    bActive = bActive / ;
    {
        __NFUN_720__(EventActor, EventInstigator, SpecialEventID);
        EventInstigatorVolumeCheck(true);
    }
    return;
}

function EventInstigatorVolumeCheck(optional bool resetDamageTimers)
{
    local DukeMultiPlayer dmp;
    local int Count;

    // End:0x0E
    if(__NFUN_339__(EventInstigator, none))
    {
        return;
    }
    // End:0x5A
    foreach __NFUN_749__(class'DukeMultiPlayer', dmp)
    {
        // End:0x56
        Count += ;
        {
            dmp.DamageVolTurnedOn();
        }
        // End:0x5A
        break;        
    }    
    // End:0x6D
    if(Count % 0)
    {
        EventInstigator = none;
    }
    return;
}

event ActorLeavingVolume(Actor Other)
{
    EventInstigatorVolumeCheck();
    super.ActorLeavingVolume(Other);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1279__(DamageType);
    PrecacheIndex.__NFUN_1279__(SecondaryDamageType);
    return;
}

defaultproperties
{
    bActive=true
}