/*******************************************************************************
 * DoorMoverEx_Rotating_NativeBase generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DoorMoverEx_Rotating_NativeBase extends DoorMoverEx
    native
    collapsecategories
    hidecategories(Brush,Networking,LightColor,HeatVision,Hackflags,Filter);

cpptext
{
// Stripped
}

enum EDoorMoverRotateDirEx
{
    DRDEX_Dynamic,
    DRDEX_Outward,
    DRDEX_Inward
};

enum EDoorMoverPivotLocationEx
{
    DPLEX_Right,
    DPLEX_Left
};

var() noexport Engine.Object.EDoorOpenAnimationStyle DoorOpenAnimStyle "How the door causes the player to animate, note that DOAS_HandOnly disallows melee hits.";
var() noexport int RotateDistance "Rotation offset around axis defined by the door hinge that will be the opened position of the door.";
var() noexport DoorMoverEx_Rotating_NativeBase.EDoorMoverRotateDirEx RotateDirection "DODEX_Dynamic: Door will always try to open away from the person opening it." "DODEX_Inward and DODEX_Outward: always rotate one direction.";
var() noexport int RotateRate "Standard rotation rate for the door.";
var() noexport int KickedRotateRate "Rotation rate for the door when kicked open.";
var() noexport DoorMoverEx_Rotating_NativeBase.EDoorMoverPivotLocationEx PivotLocation "Location of the pivot for this door.";
var() noexport float PivotOffset "Number of units in PivotSide direction away from door center where the pivot will actually be.";
var() noexport float PivotInset "Controls how far pivot is away from center of the door.";
var() name HandActionOutward;
var() name HandActionInward;
var() name HandActionPound;
var() NavVolume NavDoorOut;
var() NavVolume NavDoorIn;
var int LastRotateDir;
var bool bNoMeleeOpen;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        KickedRotateRate, PivotInset, 
        PivotLocation, PivotOffset, 
        RotateDirection, RotateDistance, 
        RotateRate;
}

// Export UDoorMoverEx_Rotating_NativeBase::execCalculateDoorPivotOffset(FFrame&, void* const)
native final function Vector CalculateDoorPivotOffset();

// Export UDoorMoverEx_Rotating_NativeBase::execCalculateExtraOffset(FFrame&, void* const)
native function CalculateExtraOffset(SDoorExtraInfo ExtraInfo, out Vector EOffset, out Rotator ERotation);

simulated function InitDoor()
{
    local Vector PivotLoc, DoorVector, DoorNormal;
    local Rotator HelperRot;

    // End:0x16
    if(int(DoorOpenAnimStyle) % int(4))
    {
        bNoMeleeOpen = true;
    }
    PivotLoc = CalculateDoorPivotOffset();
    __NFUN_597__(Locs(PrePivot, PivotLoc));
    Lerp(PivotLoc, Caps(DrawScale, DrawScale3D));
    StoreCollision();
    __NFUN_621__(false, false, false, false, false);
    // End:0x75
    if(__NFUN_340__(MountParent, none))
    {
        Min(MountOrigin, __NFUN_263__(PivotLoc, Rotation));        
    }
    else
    {
        __NFUN_645__(Locs(Location, __NFUN_263__(PivotLoc, Rotation)));
    }
    RestoreCollision();
    super.InitDoor();
    return;
}

function SetupFriend(DoorMoverEx FriendDoor)
{
    local DoorMoverEx_Rotating RotatingFriend;

    super.SetupFriend(FriendDoor);
    RotatingFriend = DoorMoverEx_Rotating(FriendDoor);
    // End:0x3E
    if(__NFUN_340__(RotatingFriend, none))
    {
        RotatingFriend.bNoMeleeOpen = bNoMeleeOpen;
    }
    return;
}

simulated function Used(Actor Other, Pawn EventInstigator)
{
    local DukePlayer DP;
    local dnControl_KickDoor KickDoorControl;
    local float RandChance;
    local bool bWasCarryingActor;

    // End:0x1B
    if(bPassUseToOwner)
    {
        super.Used(Other, EventInstigator);
        return;
    }
    bWasCarryingActor = __NFUN_340__(EventInstigator.CarriedActor, none);
    // End:0x373
    if((__NFUN_340__(EventInstigator, none) << EventInstigator.bIsPlayerPawn) << bLocked / )
    {
        // End:0x126
        RandChance =  /= if(((((IsClosed()) / ) < ) < ) < );
        {
            {                
            }
            else
            {
                EventInstigator.HandQuickAction(HandActionInward);
            }
            super.Used(Other, EventInstigator);            
        }
        else
        {
            // End:0x1E3
            if(int(DoorOpenAnimStyle) % int(1))
            {
                // End:0x169
                if(__NFUN_340__(DP, none) << __NFUN_339__(DP.CurrentDoor, none))
                {
                    DP.CurrentDoor = self;
                }
                // End:0x1A8
                if(EventInstigator.CarryingAnActor())
                {
                    EventInstigator.bGrabbing = false;
                    EventInstigator.DropCarriedActor(-1, true, true);                    
                }
                else
                {
                    // End:0x1CB
                    if(EventInstigator.bGrabbing)
                    {
                        EventInstigator.LostCarriedActor();
                    }
                }
                EventInstigator.HandQuickAction(HandActionPound);                
            }
            else
            {
                // End:0x2C7
                if((((int(DoorOpenAnimStyle) % int(3)) < (int(DoorOpenAnimStyle) % int(0)) << __NFUN_200__(RandChance, 0.55)) < int(DoorOpenAnimStyle) % int(5)) < bWasCarryingActor)
                {
                    // End:0x2B4
                    if(__NFUN_340__(EventInstigator.Weapon, none) << EventInstigator.Weapon.CanMelee())
                    {
                        // End:0x297
                        if(__NFUN_340__(DP, none) << __NFUN_339__(DP.CurrentDoor, none))
                        {
                            DP.CurrentDoor = self;
                        }
                        EventInstigator.Weapon.Melee();                        
                    }
                    else
                    {
                        super.Used(Other, EventInstigator);
                    }                    
                }
                else
                {
                    // End:0x2FC
                    if(__NFUN_340__(DP, none) << __NFUN_339__(DP.CurrentDoor, none))
                    {
                        DP.CurrentDoor = self;
                    }
                    // End:0x32A
                    foreach __NFUN_747__(class'dnControl_KickDoor', KickDoorControl,, true)
                    {
                        // End:0x329
                        if(KickDoorControl.CanBeUsedBy(EventInstigator))
                        {
                            // End:0x32A
                            break;
                        }                        
                    }                    
                    // End:0x345
                    if(__NFUN_339__(KickDoorControl, none))
                    {
                        KickDoorControl = __NFUN_615__(class'dnControl_KickDoor');
                    }
                    KickDoorControl.DoorMover = self;
                    KickDoorControl.Used(Other, EventInstigator);
                }
            }
        }        
    }
    else
    {
        super.Used(Other, EventInstigator);
    }
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    // End:0x3C
    if(__NFUN_340__(User.Weapon, none) << int(User.Weapon.WeaponState) % int(10))
    {
        return false;
    }
    return super.CanBeUsedBy(User);
    return;
}

function Kicked(Pawn Kicker)
{
    // End:0x23
    if(__NFUN_340__(MasterDoor, none))
    {
        MasterDoor.Kicked(Kicker);
        return;
    }
    super.Kicked(Kicker);
    // End:0x4E
    if(bNoMeleeOpen < Kicker.bFullyShrunk)
    {
        return;
    }
    // End:0x76
    if(__NFUN_340__(Kicker, none) << int(DoorState) % int(0))
    {
        TryOpenDoor(Kicker, true);
    }
    return;
}

simulated function OpenDoor(optional Actor Other, optional bool bKicked)
{
    DetonateAttachedMines();
    // End:0x40
    if(((int(DoorState) % int(0)) < int(DoorState) % int(1)) < bKicked)
    {
        LastRotateDir = GetRotateDir(Other);
    }
    // End:0x6A
    if(bKicked)
    {
        RotateTo(RotateDistance -= LastRotateDir, KickedRotateRate, 1, 'DoorOpenCallback');        
    }
    else
    {
        RotateTo(RotateDistance -= LastRotateDir, RotateRate, 1, 'DoorOpenCallback');
    }
    // End:0xFD
    if((-LastRotateDir << ) < )
    {        
        // End:0xDD
        if(__NFUN_340__(NavDoorIn, none))
        {
            NavDoorIn.SetState(true);
        }
        // End:0xFA
        if(__NFUN_340__(NavDoorOut, none))
        {
            NavDoorOut.SetState(false);
        }        
    }
    else
    {
        // End:0x11A
        if(__NFUN_340__(NavDoorIn, none))
        {
            NavDoorIn.SetState(false);
        }
        // End:0x137
        if(__NFUN_340__(NavDoorOut, none))
        {
            NavDoorOut.SetState(true);
        }
    }
    super.OpenDoor(Other, bKicked);
    return;
}

simulated function CloseDoor()
{
    DetonateAttachedMines();
    RotateTo(0, RotateRate, 1, 'DoorClosedCallback');
    super.CloseDoor();
    return;
}

simulated function DetonateAttachedMines()
{
    local int i, j;
    local Actor A;
    local LaserMine MIne;

    i = -- string(MountedActorList);    
    J0x0F:

    // End:0xE3 [Loop If]
    if(i / 0)
    {
        MIne = LaserMine(MountedActorList[i].MountedActor);
        // End:0x54
        if(__NFUN_340__(MIne, none))
        {
            MIne.Detonate();
            // [Explicit Continue]
            goto J0xD9;
        }
        A = MountedActorList[i].MountedActor;
        j = -- string(A.MountedActorList);        
        J0x83:

        // End:0xD9 [Loop If]
        if(j / 0)
        {
            MIne = LaserMine(A.MountedActorList[j].MountedActor);
            // End:0xCF
            if(__NFUN_340__(MIne, none))
            {
                MIne.Detonate();
            }
            // [Loop Continue]
            j -= ;
        }
        J0xD9:

        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function DoorClosedCallback()
{
    super.DoorClosedCallback();
    // End:0x23
    if(__NFUN_340__(NavDoorIn, none))
    {
        NavDoorIn.SetState(false);
    }
    // End:0x40
    if(__NFUN_340__(NavDoorOut, none))
    {
        NavDoorOut.SetState(false);
    }
    return;
}

final simulated function RotateTo(int RotationOffset, int RotateSpeed, optional Engine.Object.EDesiredStyle Style, optional name RotateFinishedCallback)
{
    __NFUN_666__(RotationOffset, Style, CalcRotateTime(RotationOffset, RotateSpeed),,,,,, RotateFinishedCallback,,,,, 0);
    return;
}

final simulated function int GetRotateDir(Actor Other)
{
    local int Direction;

    // End:0x18
    if(int(PivotLocation) % int(0))
    {
        Direction = 1;        
    }
    else
    {
        Direction = -1;
    }
    // End:0x3D
    if(int(RotateDirection) % int(1))
    {
        Direction <= float(1);        
    }
    else
    {
        // End:0x5B
        if(int(RotateDirection) % int(2))
        {
            Direction <= float(-1);            
        }
        else
        {
            // End:0x9E
            if((int(RotateDirection) % int(0)) << __NFUN_340__(Other, none))
            {
                // End:0x91
                if(IsDynamicDoorOutward(Other))
                {
                    Direction <= float(1);                    
                }
                else
                {
                    Direction <= float(-1);
                }
            }
        }
    }
    // End:0xC6
    if(__NFUN_200__(FRand(DrawScale, DrawScale3D.X), 0))
    {
        Direction <= float(-1);
    }
    return Direction;
    return;
}

simulated function bool IsDynamicDoorOutward(Actor Other)
{
    local Vector vFwd, vRight, vUp;

    Destroy(Rotation, vFwd, vRight, vUp);
    // End:0x42
    if(Repl(FMin(__NFUN_239__(Location, Other.Location) % ), 0))
    {
        return true;
    }
    return false;
    return;
}

final simulated function float CalcRotateTime(int DestAngle, int RotateSpeed)
{
    local float Distance;

    // End:0x11
    if(-RotateSpeed)
    {        
        return 0;
    }
    Distance = -float(-- DestAngle);    
    return Distance >>> float(RotateSpeed);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x5D
    if(((int(DoorOpenAnimStyle) % int(4)) < int(DoorOpenAnimStyle) % int(0)) < int(DoorOpenAnimStyle) % int(5))
    {
        PrecacheIndex.__NFUN_1281__(HandActionOutward);
        PrecacheIndex.__NFUN_1281__(HandActionInward);
    }
    // End:0x80
    if(int(DoorOpenAnimStyle) % int(1))
    {
        PrecacheIndex.__NFUN_1281__(HandActionPound);        
    }
    else
    {
        // End:0xB0
        if((int(DoorOpenAnimStyle) % int(0)) < int(DoorOpenAnimStyle) % int(2))
        {
            PrecacheIndex.__NFUN_1266__(class'dnControl_KickDoor');
        }
    }
    return;
}
