/*******************************************************************************
 * DukeHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukeHUD extends HUD
    native
    collapsecategories
    dependson(dnGrenade)
    dependson(TriggerPlayer)
    dependson(dnQuestItem)
    dependson(VehicleSpaceBase)
    dependson(VehicleBase)
    dependson(MP_PipeBombBase)
    dependson(TripMine)
    dependson(PipeBomb)
    dependson(Detonator);

enum EWeaponSelectPosition
{
    WSP_Up,
    WSP_Down,
    WSP_Left,
    WSP_Right
};

struct SquareRegion
{
    var() int X;
    var() int Y;
    var() int W;
    var() int h;
};

struct SClassPackageEntry
{
    var name Package;
    var name XClass;
};

struct SQuestItemHUDInfo
{
    var class<dnQuestItem> Class;
    var float Alpha;
    var float AlphaTarget;
    var float GlowAlpha;
    var float GlowAlphaTarget;
    var float GlowHoldTime;
};

struct SPickupEvent
{
    var float EventTime;
    var MaterialEx EventTexture;
    var float EventNumber;
    var Color EventColor;
};

struct SInteractKeyInfoText
{
    var() string String;
    var() string Description;
    var() float Alpha;
};

struct SInteractKeyInfo
{
    var() noexport float OffsetX "X-offset from HUDAnchor.";
    var() noexport float OffsetY "Base Y-offset from HUDAnchor.";
    var() noexport float Alpha "Current alpha of this key info box";
    var() noexport float TargetAlpha "Target alpha of this key info box";
    var() noexport SInteractKeyInfoText Text "Current text that could be fading in.";
    var() noexport array<SInteractKeyInfoText> OldTexts "Old texts that are fading out.";
    var() noexport bool bTap "Tap bounce?  Makes the info bounce up and down to indicate that tapping is needed.";
    var() noexport bool bHighlight "Are we highlighted?";
    var() noexport bool bAttachToHUD "If true, the alpha for this SInteractKeyInfo will be controlled by HUDAlpha.";
    var() noexport float DrawScale "If non zero, this will be used to scale the image drawn.";
    var() noexport Engine.Actor.EHUDAnchor HUDAnchor "Position that Offset X and Y are relative to.";
};

struct SWeaponSelectEntry
{
    var Weapon TheWeapon;
    var string Name;
    var MaterialEx Icon;
    var int AmmoCount;
};

var Pawn PawnOwner;
var float OldClipX;
var float OldClipY;
var bool bHideHUD;
var bool bNoDraw;
var Color TextColor;
var Color HUDColor;
var Color TextAltColor;
var array<HUDLocalizedMessage> MessageQueue;
var float HUDTimeSeconds;
var bool bTitleDisplayed;
var MaterialEx TitleBackgroundMaterial;
var float TitleBackgroundPadding;
var float DesiredIndexTop;
var float RootIndexTop;
var float IndexTop;
var float IndexBottom;
var float IndexAdjust;
var int ItemSpace;
var InteractiveActor OldLookActor;
var InteractiveActor LookActor;
var float LookPopoutTimer;
var int UseInfoPosition;
var float StaticTime;
var float StaticLength;
var float CursorTime;
var bool TypingCursor;
var array<MaterialEx> CrosshairTextures;
var float CrosshairAlpha;
var bool bCrossHairColorSet;
var transient bool bNotFirstDraw;
var float TitleBarYPos;
var float TitleBarHeight;
var float TitleBarTextYPos;
var localized string CheckpointMessage;
var localized string WritingCheckpointMessage;
var localized string ThrowMessage;
var localized string DropMessage;
var Inventory OldSelectedItem;
var Texture InventorySplash;
var Texture InventoryDpadSplash;
var Texture InventoryTex[5];
var Texture InventoryActiveTex[5];
var Engine.Object.EInputKey LastDpadDown;
var float LastDpadTime;
var Texture InfinityIcon;
var name DukeVisionInventoryName;
var name HoloDukeInventoryName;
var name SteroidsInventoryName;
var name BeerInventoryName;
var name JetpackInventoryName;
var float HoloDukeSpawnFailedTimer;
var Texture HoloDukeSpawnFailedTex;
var float WeaponChangeTime;
var Weapon WeaponChangedTo;
var array< class<Weapon> > QuickWeaponList;
var array<dnGrenade> ActivePipeBombs;
var MaterialEx WeaponAmmoBackdrop;
var MaterialEx WeaponAmmoDirtyOverlay;
var MaterialEx WeaponAmmoPipeBomb;
var MaterialEx WeaponAmmoTripMine;
var MaterialEx WeaponAmmoStickyBomb;
var class<MP_PipeBombBase> StickyBombClass;
var Weapon LastWeaponDrawn;
var float FadeStartTime;
var float HUDAlpha;
var float FadeTotalTime;
var float HUDPersistTime;
var bool bFading;
var bool bActive;
var float EgoBarBaseWidth;
var float EgoGhostPCT;
var float EgoGhostFadeDelay;
var float EgoGhostFadeRate;
var float LastFrameEgoPCT;
var float LastFrameEgoCap;
var float EgoCapIncreaseFlashVal;
var float EgoCapIncreaseAmount;
var localized string MaxEgoCapHintMessage;
var localized string MaxEgoCapMessage;
var localized string MaxEgoCapAcheivedMessage;
var Color EgoBarColor;
var Color EgoBarMaxColor;
var Color EgoBarRedColor;
var MaterialEx EgoBackdrop;
var MaterialEx EgoBar;
var MaterialEx EgoBarFill;
var Vector2D EgoHudUpperLeft;
var Vector2D EgoBackdropOffset;
var Vector2D EgoTextOffset;
var Vector2D EgoBarHaloOffset;
var Vector2D EgoBarBorderOffset;
var Vector2D EgoBarFillOffset;
var SquareRegion EgoBarHaloRegion[3];
var SquareRegion EgoBarBorderRegion[3];
var Vector2D BossTextOffset;
var Vector2D BossBarHaloOffset;
var Vector2D BossBarBorderOffset;
var Vector2D BossBarFillOffset;
var localized string EgoMeterText;
var string BossMeterText;
var localized string TemperatureText;
var MaterialEx BoostMeter;
var float BoostWarnPCT;
var float BoostWarnPCT2nd;
var Color BoostWarnYellow;
var Color BoostWarnOrange;
var Color BoostWarnRed;
var float BreathAlpha;
var MaterialEx BlackTexture;
var MaterialEx WhiteTexture;
var array<SClassPackageEntry> QuickWeaponListClassNames;
var array<Actor> OverlayList;
var int NumHUDEffects;
var int MaxHUDEffects;
var array<SHUDEffect> HUDEffects;
var MaterialEx FilmGrainVignetteMaterial;
var TexScaler FilmGrainVignetteTexScaler;
var name DukeVisionBlackHackHUDEffectName;
var bool bDrawBounds;
var bool bDrawCyl;
var bool bDrawDebugHUD;
var bool bDrawCoordsHUD;
var bool bDrawDebugAIHUD;
var bool bDrawDebugAnimHUD;
var bool bDrawDamageDebugHUD;
var bool bDrawWeapDebugHUD;
var bool bDrawNetWeapDebugHUD;
var bool bDrawNetPlayerDebugHUD;
var bool bDrawScaleModDebugHUD;
var bool bDrawActorDebugHUD;
var bool bDrawKarmaDebugHUD;
var bool bDrawVehicleDebugHUD;
var bool bDrawDebugBlend;
var class<Actor> ActorClass;
var float ActorRadius;
var name ActorTag;
var name AnimWatchClassName;
var name ScaleModDebugHUDGroup;
var bool bIsSpectator;
var localized string SpectatorMessage;
var localized string SpectatorModeMessage;
var localized string SpectatorViewingMessage;
var bool bDrawPlayerIcons;
var float IconSize;
var float SmallIconSize;
var SmackerTexture PanelMap;
var string PanelMapStr;
var SmackerTexture PanelStaticSmack;
var string PanelStaticStr;
var bool bOldUseHelpPanel;
var MaterialEx FrozenOverlay;
var float GrenadeIndicatorDangerRadius;
var MaterialEx GrenadeIndicatorMaterial;
var Color GrenadeIndicatorColor;
var noexport array<SQuestItemHUDInfo> QuestItems "List of the current quest items in our inventory.";
var float QuestItemFadeRate;
var float QuestItemGlowHoldTime;
var float QuestItemGlowFadeRate;
var array<SPickupEvent> PickupEvents;
var float PickupEventLifetime;
var float PickupEventFadeTime;
var float PickupEventSpacing;
var float PickupEventXOffset;
var float PickupEventYOffset;
var MaterialEx BarBodyMaterial;
var MaterialEx BarCapMaterial;
var Font AmmoCountFont;
var float AmmoCountOffsetX;
var float AmmoCountOffsetY;
var float QuestItemIconFadeTime;
var(InteractKeys) noexport SInteractKeyInfo InteractKeyInfo[9] "Our pre-defined key infos.";
var(InteractKeys) noexport float InteractKeyFadeRate "Rate that key info fades in/out.";
var(InteractKeys) noexport MaterialEx InteractKeyBox "The material to use as a background for the interact key info popups.";
var(InteractKeys) noexport float InteractKeyInfoScaleX "X-scale for interact key info background image for keyboard/mouse binds.";
var(InteractKeys) noexport float InteractKeyInfoScaleY "Y-scale for interact key info background image for keyboard/mouse binds.";
var(InteractKeys) noexport float GamepadInteractKeyInfoScale "Scale for key info gamepad button images.";
var(InteractKeys) noexport float InteractKeyInfoTapDisplacement "Vertical movement for interact key info when it is marked as a tap.";
var(InteractKeys) noexport float InteractKeyInfoTapRate "Rate at which interact key info will move up and down when it is marked as a tap.";
var(InteractKeys) noexport float InteractKeyInfoAlphaScale "Alpha scale for the interact key info background image for keyboard/mouse binds.";
var(InteractKeys) noexport float InteractKeyInfoTextAlphaScale "Alpha scale for the interact key info text for keyboard/mouse binds.";
var(InteractKeys) noexport float InteractKeyInfoTextHighlight "Text alpha scale adjustment when an interact key info is marked as highlight.";
var Texture ZoomReticle;
var float ZoomReticleSize;
var bool bDrawBossMeter;
var RenderActor BossMeterActor;
var float PrevBossHealthPct;
var float BossMeterAlpha;
var MaterialEx BossMeterAtlas;
var transient float CrouchEndTime;
var float CrouchingYOffset;
var MaterialEx CrouchingIcon;
var MaterialEx StandingIcon;
var bool bIsMetagame;
var localized string LMBText;
var localized string RMBText;
var localized string SPCText;
var localized string ENTText;
var localized string MMBText;
var localized string ShiftText;
var localized string MWUText;
var localized string MWDText;
var localized string UpText;
var localized string DownText;
var localized string LeftText;
var localized string RightText;
var TriggerPlayer BossMeterReference;
var Texture WeaponSelectBackground;
var Texture WeaponSelectBackgroundHighlighted;

function bool OwnerFireDown()
{
    return false;
    return;
}

function SaveComplete()
{
    super.SaveComplete();
    // End:0x24
    if(__NFUN_308__(Level.MapFileName, "Map23"))
    {
        return;
    }
    // End:0x5C
    if((__NFUN_401__() / ) << HUDMessages[2].TargetAlpha = 1)
    {
    }
    return;
}

simulated function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    currentInventoryCategory = -1;
    currentInventoryItem = 0;
    bNotFirstDraw = false;
    ClientRestart();
    // End:0x78
    if(OnlineAgent(class'Engine'.static.__NFUN_503__()).IsDLCInstalled('DLC01'))
    {
        StickyBombClass = class<MP_PipeBombBase>(__NFUN_366__("DLC01_Game.MP_StickyBomb", class'Class'));
    }
    return;
}

event PreGameInit()
{
    super(Actor).PreGameInit();
    ShortKeyName[1] = LMBText;
    ShortKeyName[2] = RMBText;
    ShortKeyName[4] = MMBText;
    ShortKeyName[32] = SPCText;
    ShortKeyName[13] = ENTText;
    ShortKeyName[16] = ShiftText;
    ShortKeyName[236] = MWUText;
    ShortKeyName[237] = MWDText;
    ShortKeyName[37] = LeftText;
    ShortKeyName[38] = UpText;
    ShortKeyName[39] = RightText;
    ShortKeyName[40] = DownText;
    // End:0xBE
    if(__NFUN_414__())
    {
        MaxHUDEffects = 8;        
    }
    else
    {
        MaxHUDEffects = 32;
    }
    // End:0xDF
    if(__NFUN_414__())
    {
        InteractKeyInfo[8].OffsetY = -28;
    }
    CrouchEndTime = -10;
    return;
}

simulated event PreRender(Canvas Canvas)
{
    super.PreRender(Canvas);
    ItemSpace = int(FRand(float(default.ItemSpace), HUDScaleY));
    RootIndexTop = FRand(default.RootIndexTop, HUDScaleY);
    DesiredIndexTop = Round(RootIndexTop, FRand(IndexAdjust, HUDScaleY));
    IndexTop = Round(RootIndexTop, FRand(IndexAdjust, HUDScaleY));
    return;
}

simulated event FirstDraw(Canvas C)
{
    local class<GameInfo> GameInfoClass;

    PlayerOwner = PlayerPawn(Owner);
    // End:0x1E
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    // End:0x42
    if(__NFUN_339__(PlayerOwner.ViewTarget, none))
    {
        PawnOwner = PlayerOwner;        
    }
    else
    {
        // End:0x7C
        if(PlayerOwner.ViewTarget.bIsPawn)
        {
            PawnOwner = Pawn(PlayerOwner.ViewTarget);            
        }
        else
        {
            PawnOwner = PlayerOwner;
        }
    }
    // End:0xB4
    if(__NFUN_340__(PlayerOwner, none))
    {
        LastFrameEgoCap = PlayerOwner.EgoCap;
        LastFrameEgoPCT = GetEgoPCT();
    }
    // End:0x11B
    if(__NFUN_339__(WindowConsole(PlayerPawn(Owner).Player.Console).Root, none))
    {
        WindowConsole(PlayerPawn(Owner).Player.Console).CreateRootWindow(C);
    }
    FadeStartTime = 0;
    return;
}

// Export UDukeHUD::execTickHUDEffects(FFrame&, void* const)
native simulated function TickHUDEffects(float DeltaTime);

// Export UDukeHUD::execInitializeHUDEffect(FFrame&, void* const)
native simulated function InitializeHUDEffect(SHUDEffect Effect);

// Export UDukeHUD::execAddHudEffect(FFrame&, void* const)
native simulated function AddHudEffect(SHUDEffect HE);

simulated function RemoveHudEffect(name EffectName)
{
    local int i;

    i = -- string(HUDEffects);    
    J0x0F:

    // End:0x68 [Loop If]
    if(i / 0)
    {
        // End:0x5E
        if(__NFUN_341__(EffectName, HUDEffects[i].Name))
        {
            // End:0x50
            if(HUDEffects[i].bLimited)
            {
                NumHUDEffects -= ;
            }
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated event int FindHUDEffectIndex(name EffectName, optional int LowestIndex)
{
    local int i;

    i = LowestIndex;
    J0x0B:

    // End:0x46 [Loop If]
    if(-i)
    {        
        // End:0x3C
        if(__NFUN_341__(HUDEffects[i].Name, EffectName))
        {
            return i;
        }
        // [Loop Continue]
        i += ;
    }
    return -1;
    return;
}

simulated event GetHUDEffectByIndex(int Index, out SHUDEffect out_Effect)
{
    // End:0x1F
    if(Index / string(HUDEffects))
    {
        out_Effect = HUDEffects[0];
        return;
    }
    out_Effect = HUDEffects[Index];
    return;
    return;
}

simulated event SetHUDEffectByIndex(int Index, SHUDEffect HE)
{
    // End:0x12
    if(Index / string(HUDEffects))
    {
        return;
    }
    HUDEffects[Index] = HE;
    return;
}

function DrawPlayerIcon(Canvas C)
{
    return;
}

simulated function ClientRestart()
{
    // End:0x2D
    if(__NFUN_340__(PlayerOwner, none))
    {
        LastFrameEgoPCT = GetEgoPCT();
        LastFrameEgoCap = PlayerOwner.EgoCap;
    }
    return;
}

function OwnerDied()
{
    return;
}

// Export UDukeHUD::execDrawBoostMeter(FFrame&, void* const)
native simulated function DrawBoostMeter(Canvas C, float BoostMeterPCT, float BoostMeterAlpha);

final function DrawStatusBar(Canvas C, float StartX, float StartY, float Length, float Height, float PCT, optional MaterialEx Tile, optional float Alpha)
{
    local float midX;
    local Color col, stdColor, lowColor, usedColor;

    // End:0x1A
    if(__NFUN_204__(Alpha, 0))
    {
        Alpha = 1;
    }
    midX = StartX *= FRand(Length, PCT);
    stdColor = NewColorBytes(213, 182, 16, byte(FRand(222, Alpha)));
    lowColor = NewColorBytes(200, 0, 0, byte(FRand(128, Alpha)));
    usedColor = NewColorBytes(177, 155, 79, byte(FRand(128, Alpha)));
    col = stdColor;
    // End:0x140
    if(__NFUN_200__(PCT, 1))
    {
        // End:0xC4
        if(__NFUN_200__(PCT, 0.25))
        {
            col = lowColor;
        }
        C.__NFUN_1257__(StartX, StartY, midX, StartY *= Height, col, true, true, BarBodyMaterial, BarCapMaterial);
        C.__NFUN_1257__(midX, StartY, StartX *= Length, StartY *= Height, usedColor, false, true, BarBodyMaterial, BarCapMaterial);        
    }
    else
    {
        C.__NFUN_1257__(StartX, StartY, midX, StartY *= Height, col, true, true, BarBodyMaterial, BarCapMaterial);
    }
    // End:0x201
    if(__NFUN_340__(Tile, none))
    {
        C.__NFUN_1250__(Round(StartX, FRand(float(30), CenterScale)), StartY);
        C.__NFUN_1234__(Tile, FRand(15, CenterScale), FRand(15, CenterScale), 0, 0, float(Tile.__NFUN_1191__()), float(Tile.__NFUN_1192__()),,,,, Alpha);
    }
    return;
}

simulated function FlashAmmoCount()
{
    __NFUN_577__('HUDAmmoCountAlpha', 'Alpha', 0, 1, 2);
    return;
}

exec function AmmoOffsetX(float X)
{
    AmmoCountOffsetX = X;
    return;
}

exec function AmmoOffsetY(float Y)
{
    AmmoCountOffsetY = Y;
    return;
}

final function bool CheckActive()
{
    return true;
    return;
}

final function float GetClipPCT()
{
    // End:0x31
    if(__NFUN_340__(PlayerOwner.Weapon, none))
    {
        return PlayerOwner.Weapon.GetClipPCT();
    }
    return 0;
    return;
}

final function float GetHealthPCT()
{
    return Normal2D(PlayerOwner.Health >>> PlayerOwner.HealthCap, 0, 1);
    return;
}

final function float GetEgoPCT()
{
    return Normal2D(PlayerOwner.Ego >>> PlayerOwner.EgoCap, 0, 1);
    return;
}

final function float GetAmmoPCT()
{
    // End:0x1C
    if(__NFUN_339__(PlayerOwner.Weapon, none))
    {
        return 0;
    }
    // End:0x42
    if(PlayerOwner.Weapon.GetMaximumAmmo() % 0)
    {
        return 1;
    }
    return Normal2D(float(PlayerOwner.Weapon.GetTotalAmmo()) >>> float(PlayerOwner.Weapon.GetMaximumAmmo()), 0, 1);
    return;
}

function int AddToOverlayList(Actor A)
{
    OverlayList[OverlayList.Add(1)] = A;
    return -- string(OverlayList);    
    return;
}

function RemoveFromOverlayList(int Index)
{
    OverlayList.Remove(Index, 1);
    return;
}

// Export UDukeHUD::execPostRender(FFrame&, void* const)
native simulated function PostRender(Canvas C);

simulated event PostPostRender(Canvas C)
{
    return;
}

simulated event DrawDebugHUDs(Canvas C)
{
    local Actor A;
    local Vector Min, Max;

    // End:0x14
    if(bDrawDebugBlend)
    {
        DrawDebugBlend(C);
    }
    // End:0x28
    if(bDrawCoordsHUD)
    {
        DrawCoordsHUD(C);
    }
    // End:0x3C
    if(bDrawDebugHUD)
    {
        DrawDebugHUD(C);
    }
    // End:0x50
    if(bDrawDebugAnimHUD)
    {
        DrawDebugAnimHUD(C);
    }
    // End:0x64
    if(bDrawScaleModDebugHUD)
    {
        DrawDebugScaleModHUD(C);
    }
    // End:0x78
    if(bDrawNetWeapDebugHUD)
    {
        DrawNetWeapDebugHUD(C);
    }
    // End:0x8C
    if(bDrawWeapDebugHUD)
    {
        DrawWeapDebugHud(C);
    }
    // End:0xA0
    if(bDrawNetPlayerDebugHUD)
    {
        DrawNetPlayerDebugHUD(C);
    }
    // End:0xB4
    if(bDrawDamageDebugHUD)
    {
        DrawDamageDebugHUD(C);
    }
    // End:0xC8
    if(bDrawActorDebugHUD)
    {
        DrawActorDebugHUD(C);
    }
    // End:0xDC
    if(bDrawKarmaDebugHUD)
    {
        DrawKarmaDebugHUD(C);
    }
    // End:0xF0
    if(bDrawVehicleDebugHUD)
    {
        DrawVehicleDebugHUD(C);
    }
    // End:0x543
    if(bDrawBounds)
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 0;
        C.DrawColor.B = 255;
        // End:0x542
        foreach __NFUN_747__(class'Actor', A)
        {
            // End:0x541
            if((A.bHidden / ) << )
            {
                C.__NFUN_1240__(WarnInternal(Min.X, Min.Y, Min.Z), WarnInternal(Min.X, Min.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Max.X, Min.Y, Min.Z), WarnInternal(Max.X, Min.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Max.Y, Min.Z), WarnInternal(Min.X, Max.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Max.X, Max.Y, Min.Z), WarnInternal(Max.X, Max.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Min.Y, Min.Z), WarnInternal(Min.X, Max.Y, Min.Z), true);
                C.__NFUN_1240__(WarnInternal(Max.X, Min.Y, Min.Z), WarnInternal(Max.X, Max.Y, Min.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Min.Y, Max.Z), WarnInternal(Min.X, Max.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Max.X, Min.Y, Max.Z), WarnInternal(Max.X, Max.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Min.Y, Min.Z), WarnInternal(Max.X, Min.Y, Min.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Max.Y, Min.Z), WarnInternal(Max.X, Max.Y, Min.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Min.Y, Max.Z), WarnInternal(Max.X, Min.Y, Max.Z), true);
                C.__NFUN_1240__(WarnInternal(Min.X, Max.Y, Max.Z), WarnInternal(Max.X, Max.Y, Max.Z), true);
            }            
        }        
    }
    // End:0x5F2
    if(bDrawCyl)
    {
        C.DrawColor.R = 0;
        C.DrawColor.G = 0;
        C.DrawColor.B = 255;
        // End:0x5F1
        foreach __NFUN_747__(class'Actor', A)
        {
            // End:0x5F0
            if(A.bHidden / )
            {
            }            
        }        
    }
    return;
}

simulated event DrawWeaponSelect(Canvas C)
{
    local float X, Y, ButtonPressDelta;
    local bool bShowWeaponSelectMenu;

    // End:0x3C
    if(PlayerOwner.bWeaponSelectPressed)
    {
        ButtonPressDelta = Round(Level.TimeSeconds, PlayerOwner.WeaponSelectStartTime);        
    }
    else
    {
        ButtonPressDelta = -1;
    }
    bShowWeaponSelectMenu = Repl(ButtonPressDelta, PlayerOwner.WeaponSelectActivateTime);
    // End:0x102
    if(bShowWeaponSelectMenu << (IsMyDigs()) / )
    {
        DrawWeaponSelectEntry(C, GetWeaponSelectEntry(PlayerOwner.PrimaryWeapon2), 1);
        DrawWeaponSelectEntry(C, GetWeaponSelectEntry(PlayerOwner.PrimaryWeapon3), 2);
        DrawWeaponSelectEntry(C, GetWeaponSelectEntry(PlayerOwner.PrimaryWeapon4), 3);
    }
    return;
}

simulated function SWeaponSelectEntry GetWeaponSelectEntry(Weapon TheWeapon)
{
    local SWeaponSelectEntry Entry;

    // End:0x63
    if(__NFUN_340__(TheWeapon, none))
    {
        Entry.TheWeapon = TheWeapon;
        Entry.Name = GetWeaponName(TheWeapon);
        Entry.Icon = GetWeaponIcon(TheWeapon);
        Entry.AmmoCount = TheWeapon.GetTotalAmmo();
    }
    return Entry;
    return;
}

simulated function DrawWeaponSelectEntry(Canvas C, SWeaponSelectEntry Entry, DukeHUD.EWeaponSelectPosition pos)
{
    local float X, Y, XL, YL, EntryWidth, EntryHeight,
	    EntryCenterX, EntryCenterY;

    local Color HighlightColor, TextColor;
    local float EntryPadX, EntryPadY, AmmoPadX;
    local string Text;
    local float CenterX, CenterY;
    local MaterialEx BackgroundTex;
    local bool bSelected;

    HighlightColor = NewColorBytes(255, 255, 0, 255);
    TextColor = NewColorBytes(255, 255, 255, 255);
    EntryWidth = FRand(235, CenterScale);
    EntryHeight = FRand(60, CenterScale);
    EntryPadX = FRand(60, CenterScale);
    EntryPadY = FRand(40, CenterScale);
    AmmoPadX = FRand(25, CenterScale);
    CenterX = FRand(C.ClipX, 0.5);
    CenterY = FRand(C.ClipY, 0.5);
    switch(pos)
    {
        // End:0xF5
        case 0:
            EntryCenterX = CenterX;
            EntryCenterY = Round(Round(CenterY, FRand(EntryHeight, 0.5)), EntryPadY);
            // End:0x191
            break;
        // End:0x128
        case 1:
            EntryCenterX = CenterX;
            EntryCenterY = (CenterY *= FRand(EntryHeight, 0.5)) *= EntryPadY;
            // End:0x191
            break;
        // End:0x15B
        case 2:
            EntryCenterX = Round(Round(CenterX, FRand(EntryWidth, 0.5)), EntryPadX);
            EntryCenterY = CenterY;
            // End:0x191
            break;
        // End:0x18E
        case 3:
            EntryCenterX = (CenterX *= FRand(EntryWidth, 0.5)) *= EntryPadX;
            EntryCenterY = CenterY;
            // End:0x191
            break;
        // End:0xFFFF
        default:
            break;
    }
    bSelected = __NFUN_340__(PlayerOwner.WeaponSelectSelectedWeapon, none) << __NFUN_339__(PlayerOwner.WeaponSelectSelectedWeapon, Entry.TheWeapon);
    // End:0x1E3
    if(bSelected)
    {
        BackgroundTex = WeaponSelectBackgroundHighlighted;        
    }
    else
    {
        BackgroundTex = WeaponSelectBackground;
    }
    X = Round(EntryCenterX, FRand(FRand(float(BackgroundTex.__NFUN_1191__()), 0.5), CenterScale));
    Y = Round(EntryCenterY, FRand(FRand(float(BackgroundTex.__NFUN_1192__()), 0.5), CenterScale));
    C.__NFUN_1250__(X, Y);
    C.DrawColor = NewColorBytes(255, 255, 255, 255);
    C.DrawRect(BackgroundTex, FRand(float(BackgroundTex.__NFUN_1191__()), CenterScale), FRand(float(BackgroundTex.__NFUN_1192__()), CenterScale));
    X = Round(EntryCenterX, FRand(FRand(float(Entry.Icon.__NFUN_1191__()), 0.5), CenterScale));
    Y = Round(EntryCenterY, FRand(FRand(float(Entry.Icon.__NFUN_1192__()), 0.5), CenterScale));
    C.__NFUN_1250__(X, Y);
    C.DrawColor = NewColorBytes(255, 255, 255, 255);
    C.DrawRect(Entry.Icon, FRand(float(Entry.Icon.__NFUN_1191__()), CenterScale), FRand(float(Entry.Icon.__NFUN_1192__()), CenterScale));
    // End:0x3B4
    if(bSelected)
    {
        C.DrawColor = HighlightColor;        
    }
    else
    {
        C.DrawColor = TextColor;
    }
    C.Font = AmmoCountFont;
    Text = Entry.Name;
    C.__NFUN_1238__(Text, XL, YL, TTFontScale, TTFontScale);
    X = Round(EntryCenterX, FRand(XL, 0.5));
    Y = Round(Y, FRand(YL, 0.5));
    C.__NFUN_1250__(X, Y);
    C.__NFUN_1233__(Text,,,, TTFontScale, TTFontScale);
    // End:0x53A
    if(__NFUN_340__(Entry.TheWeapon, none))
    {
        Text = string(Entry.AmmoCount);
        C.__NFUN_1238__(Text, XL, YL, TTFontScale, TTFontScale);
        X = Round(Round(EntryCenterX *= FRand(EntryWidth, 0.5), XL), AmmoPadX);
        Y = Round(EntryCenterY, FRand(YL, 0.5));
        C.__NFUN_1250__(X, Y);
        C.__NFUN_1233__(Text,,,, TTFontScale, TTFontScale);
    }
    return;
}

simulated function MaterialEx GetWeaponIcon(Weapon TheWeapon)
{
    return IconTable.default.PickupEventIcons[TheWeapon.HUDPickupEventIcon].Success;
    return;
}

simulated function string GetWeaponName(Weapon TheWeapon)
{
    // End:0x48
    if(__NFUN_340__(TheWeapon, none) << __NFUN_340__(class<WeaponPickup>(TheWeapon.PickupClass), none))
    {
        return class<WeaponPickup>(TheWeapon.PickupClass).default.ItemName;
    }
    return string(TheWeapon.Class);
    return;
}

// Export UDukeHUD::execGetLookActor(FFrame&, void* const)
native simulated function GetLookActor();

simulated event int DrawUseContextInfo(Canvas C, string Commands, optional float Alpha)
{
    local float XL, YL;
    local Font f;

    // End:0x13
    if(UseInfoPosition ** 10)
    {
        UseInfoPosition = 0;
    }
    // End:0x2F
    if(__NFUN_308__(Commands, "") < UseInfoPosition * 0)
    {
        return 0;
    }
    f = C.Font;
    C.Font = AmmoCountFont;
    C.Style = 1;
    C.DrawColor.R = 228;
    C.DrawColor.G = 228;
    C.DrawColor.B = 228;
    C.__NFUN_1238__(Commands, XL, YL, TTFontScale, TTFontScale);
    C.__NFUN_1250__(Round(float(C.SizeX) >>> 2, XL >>> 2), float(++ C.SizeY) *= );    
    C.__NFUN_1233__(Commands,,,, TTFontScale, TTFontScale, Alpha);
    C.Font = f;
    return 1;
    return;
}

final simulated function GetUseInfoPositon(Canvas C, float XL, float YL)
{
    local float leftX, CenterX, rightX, bottomY, CenterY, UpperY,
	    Border;

    Border = FRand(YL, 0.5);
    leftX = Border;
    CenterX = Round(FRand(FRand(float(DefaultResX), HUDScaleX), 0.5), FRand(XL, 0.5));
    rightX = Round(Round(FRand(float(DefaultResX), HUDScaleX), XL), Border);
    bottomY = Round(Round(FRand(float(DefaultResY), HUDScaleY), YL), Border);
    CenterY = FRand(FRand(float(DefaultResY), HUDScaleY), 0.5);
    UpperY = Border;
    switch(UseInfoPosition)
    {
        // End:0xD2
        case 1:
            C.__NFUN_1250__(CenterX, bottomY);
            // End:0x214
            break;
        // End:0xF1
        case 2:
            C.__NFUN_1250__(rightX, bottomY);
            // End:0x214
            break;
        // End:0x110
        case 3:
            C.__NFUN_1250__(rightX, CenterY);
            // End:0x214
            break;
        // End:0x12F
        case 4:
            C.__NFUN_1250__(rightX, UpperY);
            // End:0x214
            break;
        // End:0x14E
        case 5:
            C.__NFUN_1250__(CenterX, UpperY);
            // End:0x214
            break;
        // End:0x16D
        case 6:
            C.__NFUN_1250__(leftX, UpperY);
            // End:0x214
            break;
        // End:0x18C
        case 7:
            C.__NFUN_1250__(leftX, CenterY);
            // End:0x214
            break;
        // End:0x1B7
        case 8:
            C.__NFUN_1250__(leftX, Round(bottomY, FRand(float(128), HUDScaleY)));
            // End:0x214
            break;
        // End:0x1E4
        case 9:
            C.__NFUN_1250__(CenterX, Round(CenterY, FRand(YL, 2.5)));
            // End:0x214
            break;
        // End:0x211
        case 10:
            C.__NFUN_1250__(CenterX, CenterY *= FRand(YL, 1.5));
            // End:0x214
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function bool pointInRect(int X, int Y, int Left, int Top, int Right, int Bottom)
{
    // End:0x11
    if(-X)
    {        
        return false;
    }
    // End:0x22
    if(X ** Right)
    {
        return false;
    }
    // End:0x33
    if(-Y)
    {        
        return false;
    }
    // End:0x44
    if(Y ** Bottom)
    {
        return false;
    }
    return true;
    return;
}

simulated function RegisterWeaponChange(Weapon NewWeapon)
{
    // End:0x2F
    if(__NFUN_340__(NewWeapon, none) << NewWeapon.WeaponConfig.default.bStandardWeaponSwitch / )
    {
    }
    WeaponChangeTime = Level.GameTimeSeconds;
    WeaponChangedTo = NewWeapon;
    return;
}

simulated function BuildQuickWeaponList()
{
    local int Crap;

    QuickWeaponList.Empty();
    Crap = QuickWeaponList.Add(string(QuickWeaponListClassNames));
    return;
}

simulated event DrawTypingPrompt(Canvas C, optional bool bTeam)
{
    local int Count;
    local float X, Y, XL, YL, SelX, SelXL;

    // End:0x23
    if(__NFUN_340__(PlayerOwner, none) << PlayerOwner.bTakingCubeShot)
    {
        return;
    }
    C.Font = C.HUDFontSmall;
    C.Style = 1;
    C.DrawColor = MainHUDColor;
    C.__NFUN_1238__("SOS:\\>", XL, YL, TTFontScale, TTFontScale);
    X = FRand(YL, 0.25);
    Y = X;
    // End:0xEA
    if(__NFUN_414__() << __NFUN_200__(TTFontScale, 1))
    {
        X = FRand(45, CenterScale);
        Y = FRand(40, CenterScale);
    }
    C.__NFUN_1250__(X, Y);
    C.__NFUN_1233__("SOS:\\>", false,,, TTFontScale, TTFontScale);
    __NFUN_209__(X, XL);
    // End:0x4A9
    if(PlayerOwner.Player.Console.TypingCursorPos + PlayerOwner.Player.Console.SelectionPos)
    {
        // End:0x332
        if(PlayerOwner.Player.Console.TypingCursorPos ** PlayerOwner.Player.Console.SelectionPos)
        {
            Count = -- PlayerOwner.Player.Console.TypingCursorPos;            
            C.__NFUN_1238__(PlayerOwner.Player.Console.TypedStr - PlayerOwner.Player.Console.SelectionPos, XL, YL, TTFontScale, TTFontScale);
            C.__NFUN_1238__(PlayerOwner.Player.Console.TypedStr + PlayerOwner.Player.Console.SelectionPos);            
            SelXL
            YL
            TTFontScale
            TTFontScale                        
        }
        else
        {
            C.__NFUN_1238__(PlayerOwner.Player.Console.TypedStr - PlayerOwner.Player.Console.TypingCursorPos, XL, YL, TTFontScale, TTFontScale);
            C.__NFUN_1238__(PlayerOwner.Player.Console.TypedStr + PlayerOwner.Player.Console.TypingCursorPos);            
            SelXL
            YL
            TTFontScale
            TTFontScale            
        }
        C.__NFUN_1250__(X *= XL, Y);
        C.DrawColor = NewColorBytes(0, 0, 128, 255);
        C.DrawRect(WhiteTexture, SelXL, YL);
    }
    C.__NFUN_1250__(X, Y);
    C.DrawColor = MainHUDColor;
    C.__NFUN_1233__(PlayerOwner.Player.Console.TypedStr, false,,, TTFontScale, TTFontScale);
    // End:0x61B
    if(Repl(FRand(Level.TimeSeconds, 10 >>> Level.TimeDilation) * ))
    {
        // End:0x5E4
        if(PlayerOwner.Player.Console.TypingCursorPos ** 0)
        {
            C.__NFUN_1238__(PlayerOwner.Player.Console.TypedStr - PlayerOwner.Player.Console.TypingCursorPos, XL, YL, TTFontScale, TTFontScale);
            __NFUN_209__(X, XL);
        }
        C.__NFUN_1240__(WarnInternal(X, Y, 0), WarnInternal(X, Y *= YL, 0), false);
    }
    return;
}

simulated event DrawMessageArea(Canvas C)
{
    local int i, j;
    local float Alpha;
    local int YPosMA;
    local Font f;
    local bool ScrollUp;

    ScrollUp = false;
    i = 0;
    J0x0F:

    // End:0x72 [Loop If]
    if(-i)
    {        
        // End:0x68
        if(__NFUN_339__(MessageQueue[i].Message, none) < Level.GameTimeSeconds != MessageQueue[i].EndOfLife)
        {
            MessageQueue.Remove(i, 1);
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x80
    if(string(MessageQueue) * 0)
    {
        return;
    }
    // End:0xAF
    if(ScrollUp)
    {
        YPosMA = int(Round(float(C.SizeY), FRand(float(30), CenterScale)));        
    }
    else
    {
        YPosMA = int(FRand(float(30), CenterScale));
    }
    f = C.Font;
    C.Font = C.HUDFontSmall;
    i = -- string(MessageQueue);    
    J0x103:

    // End:0x30A [Loop If]
    if(i / Tan(-- -- string(MessageQueue), 1))
    {                
        // End:0x300
        if(__NFUN_340__(MessageQueue[i].Message, none))
        {
            C.bCenter = false;
            C.DrawColor = MainHUDColor;
            C.Style = 1;
            C.__NFUN_1238__(MessageQueue[i].StringMessage, MessageQueue[i].XL, MessageQueue[i].YL, FRand(MessageQueue[i].Message.default.FontScaleX, TTFontScale), FRand(MessageQueue[i].Message.default.FontScaleY, TTFontScale));
            C.__NFUN_1250__(FRand(9.375, CenterScale), float(YPosMA));
            Alpha = 1;
            C.__NFUN_1233__(MessageQueue[i].StringMessage, false, true,, FRand(MessageQueue[i].Message.default.FontScaleX, TTFontScale), FRand(MessageQueue[i].Message.default.FontScaleY, TTFontScale), Alpha, 1);
            // End:0x2BF
            if(ScrollUp)
            {
                YPosMA = int(Round(Round(float(YPosMA), MessageQueue[i].YL), FRand(float(ItemSpace), CenterScale)));                
            }
            else
            {
                YPosMA = int(C.CurY *= FRand(float(ItemSpace), CenterScale));
            }
            // End:0x300
            if(YPosMA / C.SizeY)
            {
                // [Explicit Break]
                goto J0x30A;
            }
        }
        // [Loop Continue]
        i -= ;
    }
    J0x30A:

    C.Font = f;
    return;
}

simulated function Message(PlayerReplicationInfo PRI, coerce string msg, name MsgType)
{
    local int i;
    local class<LocalMessage> MessageClass;

    switch(MsgType)
    {
        // End:0x1E
        case 'Say':
            MessageClass = class'dnSayMessage';
            // End:0x87
            break;
        // End:0x34
        case 'TeamSay':
            MessageClass = class'dnTeamSayMessage';
            // End:0x87
            break;
        // End:0x4A
        case 'SpectatorSay':
            MessageClass = class'dnSpectatorSayMessage';
            // End:0x87
            break;
        // End:0x60
        case 'Private':
            MessageClass = class'dnPrivateMessage';
            // End:0x87
            break;
        // End:0x76
        case 'CriticalEvent':
            MessageClass = class'CriticalString';
            // End:0x87
            break;
        // End:0xFFFF
        default:
            MessageClass = class'StringMessage';
            // End:0x87
            break;
            break;
    }
    AddMessage(MessageClass, PRI, msg);
    return;
}

simulated function LocalizedMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional string CriticalString, optional Class OptionalClass)
{
    AddLocalMessage(Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject, CriticalString, OptionalClass);
    return;
}

simulated function AddMessage(class<LocalMessage> Message, PlayerReplicationInfo PRI, string msg)
{
    local int i;

    i = MessageQueue.Add(1);
    MessageQueue[i].Message = Message;
    MessageQueue[i].Switch = 0;
    MessageQueue[i].RelatedPRI = PRI;
    MessageQueue[i].EndOfLife = float(Message.default.Lifetime) *= Level.GameTimeSeconds;
    MessageQueue[i].StringMessage = Message.static.AssembleString(self, 0, PRI, msg);
    // End:0xE2
    if(__NFUN_339__(Message, class'dnSayMessage') < __NFUN_339__(Message, class'dnPrivateMessage'))
    {
        MessageQueue[i].bIcon = true;        
    }
    else
    {
        MessageQueue[i].bIcon = false;
    }
    return;
}

simulated function AddLocalMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional string CriticalString, optional Class OptionalClass)
{
    local int i;

    i = MessageQueue.Add(1);
    MessageQueue[i].Message = Message;
    MessageQueue[i].Switch = Switch;
    MessageQueue[i].RelatedPRI = RelatedPRI_1;
    MessageQueue[i].OptionalObject = OptionalObject;
    MessageQueue[i].EndOfLife = float(Message.default.Lifetime) *= Level.GameTimeSeconds;
    MessageQueue[i].StringMessage = Message.static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject, OptionalClass);
    // End:0x109
    if(__NFUN_339__(Message, class'dnSayMessage') < __NFUN_339__(Message, class'dnPrivateMessage'))
    {
        MessageQueue[i].bIcon = true;        
    }
    else
    {
        MessageQueue[i].bIcon = false;
    }
    return;
}

simulated function bool DisplayMessages(Canvas C)
{
    return true;
    return;
}

simulated event DeactivateHUD()
{
    bFading = true;
    FadeStartTime = Level.GameTimeSeconds;
    __NFUN_608__('DeactivateHUD');
    return;
}

simulated event ActivateHUD()
{
    // End:0x38
    if((bFading / ) << bFading = true)
    {        
    }
    else
    {
        // End:0x5F
        if(bActive << bFading / )
        {            
        }
        else
        {
            // End:0x90
            if(bActive << bFading)
            {
                bActive = false;
                FadeStartTime = Level.GameTimeSeconds;
            }
        }
    }
    return;
}

simulated event bool GetPipeBombs(out int Ammo, out int MaxClip, out int bIsActive)
{
    local PipeBomb pipe;

    pipe = PipeBomb(PlayerOwner.__NFUN_919__(class'PipeBomb'));
    bIsActive = 0;
    // End:0xAF
    if(__NFUN_340__(pipe, none))
    {
        Ammo = pipe.GetTotalAmmo();
        MaxClip = pipe.GetMaxClip();
        // End:0xAD
        if(__NFUN_340__(pipe.DetonatorRef, none) << pipe.bActive < pipe.DetonatorRef.bActive)
        {
            bIsActive = 1;
        }
        return true;
    }
    Ammo = 0;
    MaxClip = 0;
    return false;
    return;
}

simulated event bool GetTripMines(out int Ammo, out int MaxClip)
{
    local TripMine trip;

    trip = TripMine(PlayerOwner.__NFUN_919__(class'TripMine'));
    // End:0x57
    if(__NFUN_340__(trip, none))
    {
        Ammo = trip.GetTotalAmmo();
        MaxClip = trip.GetMaxClip();
        return true;
    }
    Ammo = 0;
    MaxClip = 0;
    return false;
    return;
}

simulated function initStickyBombTexture()
{
    // End:0x77
    if(OnlineAgent(class'Engine'.static.__NFUN_503__()).IsDLCInstalled('DLC01') << __NFUN_339__(WeaponAmmoStickyBomb, none))
    {
        WeaponAmmoStickyBomb = Texture(__NFUN_366__("DLC01_dt_hud.ingame_hud.StickyGrenade_ammocount", class'Texture'));
    }
    return;
}

simulated event bool GetStickyBombs(out int Ammo, out int MaxClip)
{
    local MP_PipeBombBase stickybomb;

    // End:0x63
    if(__NFUN_340__(StickyBombClass, none))
    {
        stickybomb = MP_PipeBombBase(PlayerOwner.__NFUN_919__(StickyBombClass));
        // End:0x63
        if(__NFUN_340__(stickybomb, none))
        {
            Ammo = stickybomb.GetTotalAmmo();
            MaxClip = stickybomb.GetMaxClip();
            return true;
        }
    }
    Ammo = 0;
    MaxClip = 0;
    return false;
    return;
}

simulated event DrawNukeSymbol(Canvas C)
{
    return;
}

exec function GrowHUD()
{
    // End:0x14
    if(bHideCrosshair)
    {
        bHideCrosshair = false;        
    }
    else
    {
        // End:0x25
        if(bHideHUD)
        {
            bHideHUD = false;
        }
    }
    return;
}

exec function ShrinkHUD()
{
    // End:0x16
    if(bHideHUD / )
    {        
    }
    else
    {
        // End:0x29
        if(bHideCrosshair / )
        {
        }
    }
    return;
}

simulated function Tick(float Delta)
{
    super.Tick(Delta);
    // End:0x19
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    // End:0x2E
    if(Level.bPaused)
    {
        return;
    }
    __NFUN_209__(HUDTimeSeconds, Delta);
    TickEgoChanges(Delta);
    TickPickupEvents(Delta);
    TickStatusIndex(Delta);
    TickHUDEffects(Delta);
    TickQuestItemInfo(Delta);
    TickInventory(Delta);
    return;
}

simulated function TickInventory(float Delta)
{
    local float DpadTimeout;

    DpadTimeout = 0.2;
    // End:0x37
    if(Repl(LastDpadTime, float(0)))
    {
        LastDpadTime ~= Delta;
        // End:0x37
        if(__NFUN_202__(LastDpadTime, float(0)))
        {
            LastDpadDown = 204;
        }
    }
    // End:0x45
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    // End:0x6A
    if(PlayerOwner.IsSeatControllerReplicationViewer(200))
    {
        LastDpadDown = 200;
        LastDpadTime = DpadTimeout;
    }
    // End:0x8F
    if(PlayerOwner.IsSeatControllerReplicationViewer(201))
    {
        LastDpadDown = 201;
        LastDpadTime = DpadTimeout;
    }
    // End:0xB4
    if(PlayerOwner.IsSeatControllerReplicationViewer(202))
    {
        LastDpadDown = 202;
        LastDpadTime = DpadTimeout;
    }
    // End:0xD9
    if(PlayerOwner.IsSeatControllerReplicationViewer(203))
    {
        LastDpadDown = 203;
        LastDpadTime = DpadTimeout;
    }
    return;
}

final simulated function EgoCapIncreaseBegin()
{
    EgoCapIncreaseFlash();
    // End:0x7C
    if(__NFUN_340__(PlayerOwner, none))
    {
        PlayerOwner.FindAndStopSound('EgoCap_Increase');
        // End:0x67
        if(__NFUN_200__(PlayerOwner.EgoCap, DukePlayer(PlayerOwner).MaxEgoCap))
        {
            PlayerOwner.FindAndPlaySound('EgoCap_Increase');            
        }
        else
        {
            PlayerOwner.FindAndPlaySound('EgoCap_Max');
        }
    }
    return;
}

final simulated function EgoCapIncreaseFlash()
{
    EgoCapIncreaseFlashVal = 1;
    // End:0x36
    if(__NFUN_340__(PlayerOwner, none))
    {
        PlayerOwner.AddRumble(PlayerOwner.EgoCapIncreaseRumbleInfo);
    }
    return;
}

simulated function TickEgoChanges(float Delta)
{
    local float EgoPCT, TimerAdjust;
    local DukePlayer DukeOwner;

    EgoPCT = GetEgoPCT();
    // End:0x2E
    if(Repl(EgoCapIncreaseFlashVal, 0))
    {
        EgoCapIncreaseFlashVal ~= FRand(2, Delta);
    }
    // End:0x35F
    if(bNotFirstDraw << __NFUN_206__(LastFrameEgoCap, PlayerOwner.EgoCap))
    {
        __NFUN_209__(EgoCapIncreaseAmount, Round(PlayerOwner.EgoCap, LastFrameEgoCap));
        LastFrameEgoPCT = EgoPCT;
        LastFrameEgoCap = PlayerOwner.EgoCap;
        EgoGhostFadeDelay = 0;
        EgoGhostPCT = 0;
        DukeOwner = DukePlayer(PlayerOwner);
        // End:0x35C
        if((__NFUN_340__(DukeOwner, none) << (IsMP()) / ) << )
        {
            {
                ConsoleCommand("set DukePlayer bDisplayedEgoCapIncreaseHint true");
                HUDMessages[4].TargetAlpha = 1;
                HUDMessages[4].HoldTimer = 4;
                HUDMessages[4].Message = MaxEgoCapHintMessage;                
            }
            else
            {
                // End:0x1D7
                if(__NFUN_200__(DukeOwner.EgoCap, DukePlayer(PlayerOwner).MaxEgoCap))
                {
                    HUDMessages[4].TargetAlpha = 1;
                    HUDMessages[4].HoldTimer = 4;
                    HUDMessages[4].Message = MaxEgoCapMessage;                    
                }
                else
                {
                    HUDMessages[4].TargetAlpha = 1;
                    HUDMessages[4].HoldTimer = 4;
                    HUDMessages[4].Message = MaxEgoCapAcheivedMessage;
                }
            }
            ActiveHint = none;
            ActivateHUD();
            // End:0x246
            if(__NFUN_200__(HUDAlpha, 1))
            {
                __NFUN_209__(TimerAdjust, FRand(Round(1, HUDAlpha), FadeTotalTime));
            }
            __NFUN_607__(0 *= TimerAdjust, false, 'EgoCapIncreaseBegin', true, true);
            __NFUN_607__(0.21 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
            __NFUN_607__(0.64 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
            // End:0x33D
            if(DukeOwner.EgoCap != DukePlayer(PlayerOwner).MaxEgoCap)
            {
                __NFUN_607__(1.28 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
                __NFUN_607__(1.5 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
                __NFUN_607__(1.92 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
                __NFUN_607__(5.14 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
                __NFUN_607__(5.35 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
                __NFUN_607__(6.85 *= TimerAdjust, false, 'EgoCapIncreaseFlash', true, true);
            }
            __NFUN_608__('ResetEgoCapIncrease');
            __NFUN_607__(3 *= TimerAdjust, false, 'ResetEgoCapIncrease', true, true);
        }        
    }
    else
    {
        // End:0x396
        if(Repl(LastFrameEgoPCT, EgoPCT))
        {
            // End:0x388
            if(Repl(LastFrameEgoPCT, EgoGhostPCT))
            {
                EgoGhostPCT = LastFrameEgoPCT;
            }
            EgoGhostFadeDelay = default.EgoGhostFadeDelay;            
        }
        else
        {
            // End:0x3BB
            if(__NFUN_200__(LastFrameEgoPCT, EgoPCT))
            {
                EgoGhostFadeDelay = 0;
                EgoGhostPCT = 0;
            }
        }
    }
    LastFrameEgoPCT = EgoPCT;
    // End:0x400
    if(__NFUN_206__(EgoGhostPCT, float(0)))
    {
        // End:0x3ED
        if(Repl(EgoGhostFadeDelay, float(0)))
        {
            EgoGhostFadeDelay ~= Delta;            
        }
        else
        {
            EgoGhostPCT ~= FRand(EgoGhostFadeRate, Delta);
        }
    }
    return;
}

final simulated function ResetEgoCapIncrease()
{
    EgoCapIncreaseAmount = 0;
    return;
}

simulated function TickStatusIndex(float Delta)
{
    // End:0x35
    if(__NFUN_200__(LookPopoutTimer, 0.1))
    {
        __NFUN_209__(LookPopoutTimer, Delta);
        // End:0x35
        if(Repl(LookPopoutTimer, 0.1))
        {
            LookPopoutTimer = 0.1;
        }
    }
    // End:0x61
    if(Repl(IndexTop, DesiredIndexTop))
    {
        // End:0x5E
        if(__NFUN_200__(IndexTop, DesiredIndexTop))
        {
            IndexTop = DesiredIndexTop;
        }        
    }
    else
    {
        // End:0x8A
        if(__NFUN_200__(IndexTop, DesiredIndexTop))
        {
            // End:0x8A
            if(Repl(IndexTop, DesiredIndexTop))
            {
                IndexTop = DesiredIndexTop;
            }
        }
    }
    return;
}

function ShowStatic(float inStaticLength)
{
    StaticTime = Level.GameTimeSeconds;
    StaticLength = inStaticLength;
    return;
}

exec function DebugBlend()
{
    bDrawDebugBlend = bDrawDebugBlend / ;
}

simulated function DrawDebugBlend(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    C.Font = C.SmallFont;
    C.Style = 1;
    XPos = FRand(9, HUDScaleX);
    YPos = FRand(60, HUDScaleY);
    C.__NFUN_1250__(XPos, YPos);
    C.DrawColor = WhiteColor;
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("White / No Alpha Blend");
    C.__NFUN_1250__(XPos, C.CurY);
    C.DrawColor = RedColor;
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("Red / No Alpha Blend");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 3;
    C.DrawColor.R = byte(++ int(255));    
    C.DrawColor.G = byte(++ int(255));    
    C.DrawColor.B = byte(++ int(255));    
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("Gray 0.5 0.5 0.5  / Alpha 1 / STY_Translucent");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 3;
    C.DrawColor.R = byte(++ int(255));    
    C.DrawColor.G = 0;
    C.DrawColor.B = 0;
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("Red 0.5 1 1  / Alpha 1 / STY_Translucent");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 5;
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1,,,,, 0.5);
    C.__NFUN_1232__("White / Alpha 0.5 / STY_Translucent2");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 5;
    C.DrawColor.R = 255;
    C.DrawColor.G = 0;
    C.DrawColor.B = 0;
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1,,,,, 0.5);
    C.__NFUN_1232__("Red / Alpha 0.5 / STY_Translucent2");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 6;
    C.DrawColor.R = byte(float(255) >>> 1.5);
    C.DrawColor.G = byte(float(255) >>> 1.5);
    C.DrawColor.B = byte(float(255) >>> 1.5);
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("Gray 0.66 0.66 0.66 / Alpha 1 / STY_LightenModulate");
    C.__NFUN_1250__(XPos, C.CurY);
    C.Style = 7;
    C.DrawColor.R = byte(++ int(255));    
    C.DrawColor.G = byte(++ int(255));    
    C.DrawColor.B = byte(++ int(255));    
    C.__NFUN_1234__(WhiteTexture, 32, 32, 1, 1, 1, 1);
    C.__NFUN_1232__("Gray 0.25 0.25 0.25 / Alpha 1 / STY_DarkenModulate");
    return;
}

exec function CoordsHUD()
{
    bDrawCoordsHUD = bDrawCoordsHUD / ;
}

simulated function DrawCoordsHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local class<Material> m;

    C.Font = C.SmallFont;
    C.Style = 1;
    XPos = 0;
    YPos = C.ClipY >>> float(2);
    C.__NFUN_1238__("Player Coordinates", XL, YL);
    C.__NFUN_1238__("View Rotation: ", XL2, YL2);
    C.DrawColor = GoldColor;
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(0)));
    C.__NFUN_1232__("Player Coordinates");
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(1)));
    C.__NFUN_1232__("Location:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(2)));
    C.__NFUN_1232__("Rotation:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(3)));
    C.__NFUN_1232__("View Location:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(4)));
    C.__NFUN_1232__("View Rotation:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(5)));
    C.__NFUN_1232__("Acceleration:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(6)));
    C.__NFUN_1232__("Velocity:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(7)));
    C.__NFUN_1232__("Speed:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(8)));
    C.__NFUN_1232__("Standing On:");
    C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(9)));
    C.__NFUN_1232__("Region:");
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(1)));
    C.__NFUN_1232__(string(PlayerOwner.Location));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(2)));
    C.__NFUN_1232__(string(PlayerOwner.Rotation));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(3)));
    C.__NFUN_1232__(string(PlayerOwner.CalcedViewLocation));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(4)));
    C.__NFUN_1232__(string(PlayerOwner.ViewRotation));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(5)));
    C.__NFUN_1232__(string(PlayerOwner.Acceleration));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(6)));
    C.__NFUN_1232__(string(PlayerOwner.Velocity));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(7)));
    C.__NFUN_1232__(string(Clamp(PlayerOwner.Velocity)));
    m = PlayerOwner.LastWalkMaterial;
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(8)));
    C.__NFUN_1232__(string(m));
    C.__NFUN_1250__(XPos *= XL2, YPos *= FRand(YL, float(9)));
    C.__NFUN_1232__(PlayerOwner.Region.Zone.ZoneName);
    return;
}

exec function DebugAnimHUD()
{
    bDrawDebugAnimHUD = bDrawDebugAnimHUD / ;
}

final simulated function DrawAnimsInternal(Canvas C, RenderActor A, float XPos, out float YPos, float YL, optional name GroupName)
{
    local SAllAnimInfo AnimInfo;
    local string str;

    // End:0x0E
    if(__NFUN_339__(A, none))
    {
        return;
    }
    // End:0x27B
    foreach A.__NFUN_840__(AnimInfo, GroupName)
    {
        C.DrawColor = WhiteColor;
        str = __NFUN_303__(__NFUN_303__(string(AnimInfo.Channel), ":"), string(AnimInfo.Sequence));
        str = __NFUN_303__(__NFUN_303__(__NFUN_303__(str, "{{"), string(AnimInfo.RefId)), "}}");
        str = __NFUN_302__(__NFUN_302__(__NFUN_303__(str, "["), string(AnimInfo.Blend)), "]  (op:");
        switch(int(AnimInfo.Op))
        {
            // End:0xE0
            case 1:
                str = __NFUN_303__(str, "Replace");
                // End:0x135
                break;
            // End:0xFB
            case 2:
                str = __NFUN_303__(str, "Add");
                // End:0x135
                break;
            // End:0x11B
            case 3:
                str = __NFUN_303__(str, "Subtract");
                // End:0x135
                break;
            // End:0xFFFF
            default:
                str = __NFUN_303__(str, "NULL");
                // End:0x135
                break;
                break;
        }
        str = __NFUN_302__(str, ")");
        // End:0x17B
        if(AnimInfo.bIsGroup / )
        {
        }
        // End:0x1A7
        if(AnimInfo.bEventEnabled)
        {
            str = __NFUN_303__(str, "[Events On]");            
        }
        else
        {
            str = __NFUN_303__(str, "[Events Off]");
        }
        // End:0x209
        if(A.__NFUN_568__().__NFUN_552__(AnimInfo.Channel, GroupName).bLoop)
        {
            str = __NFUN_303__(str, "[Looping]");
        }
        C.__NFUN_1250__(XPos, YPos);
        C.__NFUN_1232__(str);
        __NFUN_209__(YPos, YL);
        // End:0x27A
        if(AnimInfo.bIsGroup)
        {
            super(DukeHUD).DrawAnimsInternal(C, A, XPos *= float(8), YPos, YL, AnimInfo.Sequence);
        }        
    }    
    return;
}

simulated function DrawAnims(Canvas C, RenderActor A, float XPos, out float YPos, float YL)
{
    C.DrawColor = GoldColor;
    C.__NFUN_1250__(XPos, YPos);
    C.__NFUN_1232__(__NFUN_302__("Actor:", string(A)));
    __NFUN_209__(YPos, YL);
    DrawAnimsInternal(C, A, XPos, YPos, YL);
    return;
}

function float GetDebugAnimHUDStartPosition(out float XPos, out float YPos)
{
    XPos = DebugTreeBGSizeX *= FRand(float(9), HUDScaleX);
    YPos = FRand(9, HUDScaleY);
    return;
}

simulated function DrawDebugAnimHUD(Canvas C)
{
    local float XL, YL, XPos, YPos;
    local RenderActor A;

    C.Font = C.SmallFont;
    C.Style = 1;
    GetDebugAnimHUDStartPosition(XPos, YPos);
    C.__NFUN_1238__("JUNKJUNK", XL, YL);
    C.DrawColor = GoldColor;
    C.__NFUN_1250__(XPos, YPos);
    C.__NFUN_1232__("Animations");
    C.DrawColor = WhiteColor;
    __NFUN_209__(YPos, YL);
    DrawAnims(C, PlayerOwner, XPos, YPos, YL);
    // End:0x165
    if(__NFUN_342__(AnimWatchClassName, 'None'))
    {
        // End:0x164
        foreach __NFUN_747__(class'RenderActor', A)
        {
            // End:0x163
            if(A.__NFUN_358__(AnimWatchClassName))
            {
                DrawAnims(C, A, XPos, YPos, YL);
                __NFUN_209__(YPos, YL);
                // End:0x163
                if(Repl(YPos, C.ClipY))
                {
                    // End:0x164
                    break;
                }
            }            
        }        
    }
    return;
}

exec function WatchAnimClass(name InClassName)
{
    AnimWatchClassName = InClassName;
    return;
}

exec function DebugScaleMod(name InName)
{
    // End:0x2D
    if(__NFUN_341__(InName, 'None'))
    {
        bDrawScaleModDebugHUD = bDrawScaleModDebugHUD / ;        
    }
    else
    {
        // End:0x4B
        if(__NFUN_341__(InName, 'All'))
        {
            ScaleModDebugHUDGroup = 'None';            
        }
        else
        {
            bDrawScaleModDebugHUD = true;
            ScaleModDebugHUDGroup = InName;
        }
    }
    return;
}

simulated function DrawDebugScaleModHUD(Canvas C)
{
    local int i, E;
    local float XPos, YPos, XL, YL;

    C.Font = C.SmallFont;
    C.Style = 1;
    XPos = FRand(9, HUDScaleX);
    YPos = FRand(60, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    i = -- string(PlayerOwner.ScaleModifierGroupList);    
    J0x9A:

    // End:0x5D9 [Loop If]
    if(i / 0)
    {
        // End:0x5CF
        if(__NFUN_341__(ScaleModDebugHUDGroup, 'None') < __NFUN_341__(PlayerOwner.ScaleModifierGroupList[i].Identifier, ScaleModDebugHUDGroup))
        {
            C.DrawColor = GoldColor;
            C.__NFUN_1250__(XPos, YPos);
            C.__NFUN_1232__(__NFUN_302__("Group ID:        ", string(PlayerOwner.ScaleModifierGroupList[i].Identifier)));
            __NFUN_209__(YPos, YL);
            C.DrawColor = WhiteColor;
            C.__NFUN_1250__(XPos, YPos);
            C.__NFUN_1232__(__NFUN_302__("DefaultModValue: ", string(PlayerOwner.ScaleModifierGroupList[i].DefaultModValue)));
            __NFUN_209__(YPos, YL);
            C.__NFUN_1250__(XPos, YPos);
            C.__NFUN_1232__(__NFUN_302__("LastValue:       ", string(PlayerOwner.ScaleModifierGroupList[i].LastValue)));
            __NFUN_209__(YPos, YL);
            E = -- string(PlayerOwner.ScaleModifierGroupList[i].Modifiers);            
            J0x24D:

            // End:0x5CF [Loop If]
            if(E / 0)
            {
                C.DrawColor = GoldColor;
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("Identifier:  ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].Identifier)));
                __NFUN_209__(YPos, YL);
                C.DrawColor = WhiteColor;
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("Style:       ", string(__NFUN_365__(class'EScaleModifier', int(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].Style)))));
                __NFUN_209__(YPos, YL);
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("ScaleStart:  ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].ScaleStart)));
                __NFUN_209__(YPos, YL);
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("ScaleTarget: ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].ScaleTarget)));
                __NFUN_209__(YPos, YL);
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("Scale:       ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].Scale)));
                __NFUN_209__(YPos, YL);
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("TimeRamp:    ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].TimeRamp)));
                __NFUN_209__(YPos, YL);
                C.__NFUN_1250__(XPos *= FRand(60, HUDScaleX), YPos);
                C.__NFUN_1232__(__NFUN_302__("Timer:       ", string(PlayerOwner.ScaleModifierGroupList[i].Modifiers[E].Timer)));
                __NFUN_209__(YPos, YL);
                // [Loop Continue]
                E -= ;
            }
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

exec function DebugHUD()
{
    bDrawDebugHUD = bDrawDebugHUD / ;
}

simulated function DrawDebugHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j, V, saveRow;
    local Actor A;
    local Texture t;
    local class<Material> m;
    local bool bNoMaterial;
    local MeshInstance minst;
    local Decoration D;
    local int NumDecos, NumNoneDecorations, NumFallingDecorations;
    local Inventory Inv;
    local string InvName;
    local AnimChanInfo ChanInfo;
    local Pawn PawnIter;

    C.Font = C.SmallFont;
    C.Style = 1;
    XPos = FRand(9, HUDScaleX);
    YPos = FRand(60, HUDScaleY);
    i = 0;
    C.DrawColor = GoldColor;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // [Loop Continue]
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 38 & Type:Loop Position:0x2C71
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 38 & Type:Loop Position:0x2C71
}

exec function NetWeapDebugHUD()
{
    __NFUN_355__("NetWeapDebugHud");
    bDrawNetWeapDebugHUD = bDrawNetWeapDebugHUD / ;
}

simulated function DrawNetWeapDebugHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j;
    local Pawn P;
    local Inventory Inv;
    local string InvName;

    __NFUN_355__(__NFUN_303__("DrawNetWeapDebugHUD", string(C)));
    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    P = Level.PawnList;
    J0xA5:

    // End:0x437 [Loop If]
    if(__NFUN_340__(P, none))
    {
        XPos = FRand(9, HUDScaleX);
        C.DrawColor = WhiteColor;
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__("PlayerName:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(2)));
        C.__NFUN_1232__("Weapon:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(3)));
        C.__NFUN_1232__("Sequence:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(4)));
        C.__NFUN_1232__("State:");
        // End:0x2B3
        if(__NFUN_340__(P.Weapon, none))
        {
            C.__NFUN_1250__(XPos *= XL, YPos *= YL);
            C.__NFUN_1232__(P.PlayerReplicationInfo.PlayerName);
            C.__NFUN_1250__(XPos *= XL, YPos *= FRand(YL, float(2)));
            C.__NFUN_1232__(string(P.Weapon));
            C.__NFUN_1250__(XPos *= XL, YPos *= FRand(YL, float(3)));
            C.__NFUN_1232__(string(P.Weapon.__NFUN_399__()));
        }
        __NFUN_209__(YPos, FRand(YL, float(4)));
        XPos = FRand(15, HUDScaleX);
        C.DrawColor = OrangeColor;
        C.__NFUN_1250__(XPos, YPos);
        C.__NFUN_1232__("Inventory");
        C.DrawColor = WhiteColor;
        Inv = P.InventoryListHead;
        J0x344:

        // End:0x413 [Loop If]
        if(__NFUN_340__(Inv, none))
        {
            __NFUN_209__(YPos, YL);
            InvName = string(Inv);
            j = __NFUN_315__(InvName, ".");
            InvName = InvName += -- -- __NFUN_314__(InvName);                        
            C.__NFUN_1250__(XPos, YPos);
            C.__NFUN_1232__(InvName);
            C.__NFUN_1250__(XPos *= XL, YPos);
            C.__NFUN_1232__(string(Inv.__NFUN_399__()));
            Inv = Inv.NextInventory;
            // [Loop Continue]
            goto J0x344;
        }
        __NFUN_209__(YPos, YL);
        P = P.NextPawn;
        // [Loop Continue]
        goto J0xA5;
    }
    return;
}

exec function WeapDebugHUD()
{
    bDrawWeapDebugHUD = bDrawWeapDebugHUD / ;
}

simulated function DrawWeapDebugHud(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j;
    local Pawn P;
    local Inventory Inv;
    local Weapon W;
    local string InvName;

    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    P = Level.PawnList;
    J0x84:

    // End:0x417 [Loop If]
    if(__NFUN_340__(P, none))
    {
        XPos = FRand(9, HUDScaleX);
        C.DrawColor = WhiteColor;
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__("PlayerName:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(2)));
        C.__NFUN_1232__("Weapon:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(3)));
        C.__NFUN_1232__("Sequence:");
        C.__NFUN_1250__(XPos, YPos *= FRand(YL, float(4)));
        C.__NFUN_1232__("State:");
        // End:0x292
        if(__NFUN_340__(P.Weapon, none))
        {
            C.__NFUN_1250__(XPos *= XL, YPos *= YL);
            C.__NFUN_1232__(P.PlayerReplicationInfo.PlayerName);
            C.__NFUN_1250__(XPos *= XL, YPos *= FRand(YL, float(2)));
            C.__NFUN_1232__(string(P.Weapon));
            C.__NFUN_1250__(XPos *= XL, YPos *= FRand(YL, float(3)));
            C.__NFUN_1232__(string(P.Weapon.__NFUN_399__()));
        }
        __NFUN_209__(YPos, FRand(YL, float(4)));
        XPos = FRand(15, HUDScaleX);
        C.DrawColor = OrangeColor;
        C.__NFUN_1250__(XPos, YPos);
        C.__NFUN_1232__("Weapons");
        C.DrawColor = WhiteColor;
        __NFUN_209__(YPos, YL);
        // End:0x3F2
        foreach __NFUN_747__(class'Weapon', W)
        {
            // End:0x346
            if(__NFUN_340__(W.Instigator, P))
            {
                continue;                
            }
            __NFUN_209__(YPos, YL);
            InvName = string(W);
            j = __NFUN_315__(InvName, ".");
            InvName = InvName += -- -- __NFUN_314__(InvName);                        
            C.__NFUN_1250__(XPos, YPos);
            C.__NFUN_1232__(InvName);
            C.__NFUN_1250__(XPos *= XL, YPos);
            C.__NFUN_1232__(string(W.__NFUN_399__()));            
        }        
        __NFUN_209__(YPos, YL);
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x84;
    }
    return;
}

exec function NetPlayerDebugHUD()
{
    bDrawNetPlayerDebugHUD = bDrawNetPlayerDebugHUD / ;
}

simulated function DrawNetPlayerDebugHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j;
    local Pawn P;

    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    __NFUN_209__(YL, float(1));
    P = Level.PawnList;
    J0x8D:

    // End:0x45C [Loop If]
    if(__NFUN_340__(P, none))
    {
        XPos = FRand(9, HUDScaleX);
        C.DrawColor = WhiteColor;
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__("PlayerName:");
        C.DrawColor = GoldColor;
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(P.PlayerReplicationInfo.PlayerName);
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Location:", string(P.Location)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Role:", string(__NFUN_365__(class'ENetRole', int(P.Role)))));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Physics:", string(__NFUN_365__(class'EPhysics', int(P.Physics)))));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Collision Height:", string(P.CollisionHeight)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Collision Radius:", string(P.CollisionRadius)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Block Karma:", string(P.bBlockKarma)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Velocity:", string(P.Velocity)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("PostureState:", string(__NFUN_365__(class'EPostureStateEx', int(P.PostureStateEx)))));
        __NFUN_209__(YPos, FRand(YL, float(5)));
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x8D;
    }
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(XPos, YPos *= YL);
    C.__NFUN_1232__("PRI Array:");
    i = 0;
    J0x4AF:

    // End:0x5D8 [Loop If]
    if(-i)
    {        
        C.DrawColor = GoldColor;
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Name: ", PlayerOwner.GameReplicationInfo.PRIArray[i].PlayerName));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos *= XL, YPos);
        C.__NFUN_1232__(__NFUN_303__("Game State: ", string(__NFUN_365__(class'EGameState', int(PlayerOwner.GameReplicationInfo.PRIArray[i].GameState)))));
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function DebugDamageHUD()
{
    bDrawDamageDebugHUD = bDrawDamageDebugHUD / ;
}

simulated function DrawDamageDebugHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j;
    local Pawn P;

    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    i = 0;
    J0x76:

    // End:0x14D [Loop If]
    if(-i)
    {        
        XPos = FRand(9, HUDScaleX);
        // End:0xD3
        if(i % -- PlayerOwner.GameReplicationInfo.DmgStrIndex)
        {            
            C.DrawColor = GoldColor;            
        }
        else
        {
            C.DrawColor = WhiteColor;
        }
        C.__NFUN_1250__(XPos, YPos);
        C.__NFUN_1232__(__NFUN_303__("Damage:", PlayerOwner.GameReplicationInfo.DebugDamageStrings[i]));
        __NFUN_209__(YPos, YL);
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function ActorDebugHUD()
{
    bDrawActorDebugHUD = bDrawActorDebugHUD / ;
}

exec function VehicleDebugHUD()
{
    bDrawVehicleDebugHUD = bDrawVehicleDebugHUD / ;
}

exec function KarmaDebugHUD()
{
    bDrawKarmaDebugHUD = bDrawKarmaDebugHUD / ;
}

exec function DebugActor(string aClass)
{
    ActorClass = class<Actor>(__NFUN_366__(aClass, class'Class'));
    BroadcastMessage(__NFUN_303__("Now Debugging", string(ActorClass)));
    return;
}

exec function DebugActorRadius(int Radius)
{
    ActorRadius = float(Radius);
    BroadcastMessage(__NFUN_303__("Debug Actor Radius Change", string(Radius)));
    return;
}

exec function DebugActorTag(coerce name dTag)
{
    ActorTag = dTag;
    BroadcastMessage(__NFUN_303__("Debug Actor Tag", string(dTag)));
    return;
}

simulated function DrawKarmaDebugHUD(Canvas C)
{
    local int i;
    local KarmaActor A;
    local float XL, YL, XL2, YL2, XPos, YPos;

    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    C.DrawColor = WhiteColor;
    C.__NFUN_1232__("Debugging Karma Objects");
    __NFUN_209__(YPos, YL);
    return;
}

simulated function DrawVehicleDebugHUD(Canvas C)
{
    local float XL, YL, XPos, YPos;
    local VehicleSpaceBase A;

    C.Font = C.SmallFont;
    C.Style = 1;
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    C.DrawColor = WhiteColor;
    XPos = FRand(9, HUDScaleX);
    YPos = FRand(60, HUDScaleY);
    // End:0x2EA
    foreach __NFUN_747__(class'VehicleSpaceBase', A)
    {
        XPos = FRand(9, HUDScaleX);
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__(string(A.Name));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__(__NFUN_303__("Location:", string(A.Location)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__(__NFUN_303__("Game Velocity:", string(Clamp(A.Vehicle.Velocity))));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__(__NFUN_303__("Vehicle Speed:", string(A.Vehicle.oForwardVelocity)));
        __NFUN_209__(YPos, YL);
        C.__NFUN_1250__(XPos, YPos *= YL);
        C.__NFUN_1232__(__NFUN_303__("User:", string(A.User)));
        __NFUN_209__(YPos, YL);
        // End:0x2E9
        if(__NFUN_340__(A.User, none))
        {
            C.__NFUN_1250__(XPos, YPos *= YL);
            C.__NFUN_1232__(__NFUN_303__("User Location:", string(A.User.Location)));
            __NFUN_209__(YPos, YL);
        }        
    }    
    return;
}

simulated function DrawActorDebugHUD(Canvas C)
{
    local float XL, YL, XL2, YL2, XPos, YPos;

    local int i, j;
    local Actor A;
    local float Distance;
    local Vector Delta;

    C.Font = C.SmallFont;
    C.Style = 1;
    YPos = FRand(64, HUDScaleY);
    C.__NFUN_1238__("PADDING PADDING PAD", XL, YL);
    C.DrawColor = WhiteColor;
    // End:0x15B
    if(Repl(ActorRadius, float(0)))
    {
        // End:0x158
        if(__NFUN_340__(Owner, none))
        {
            // End:0x157
            foreach Owner.__NFUN_751__(ActorClass, A, ActorRadius)
            {
                Delta = __NFUN_239__(A.Location, Owner.Location);
                Distance = Clamp(Delta);
                XPos = FRand(9, HUDScaleX);
                C.__NFUN_1250__(XPos, YPos *= YL);
                C.__NFUN_1232__(__NFUN_302__(__NFUN_302__(string(A.Name), ":"), string(Distance)));
                __NFUN_209__(YPos, YL);                
            }            
        }        
    }
    else
    {
        // End:0x207
        foreach __NFUN_747__(ActorClass, A)
        {
            Delta = __NFUN_239__(A.Location, Owner.Location);
            Distance = Clamp(Delta);
            XPos = FRand(9, HUDScaleX);
            C.__NFUN_1250__(XPos, YPos *= YL);
            C.__NFUN_1232__(__NFUN_302__(__NFUN_302__(string(A.Name), ":"), string(Distance)));
            __NFUN_209__(YPos, YL);            
        }        
    }
    return;
}

function DrawOutlineActorFrame(Canvas C, Actor A, Color DrawColor)
{
    local float x1, y1, x2, y2, Width, Height;

    local int BarSize;

    BarSize = 2;
    C.DrawColor = DrawColor;
    C.__NFUN_1243__(A, x1, x2, y1, y2);
    Width = Round(x2, x1);
    Height = Round(y2, y1);
    BarSize = 2;
    C.__NFUN_1250__(x1, y1);
    C.__NFUN_1234__(WhiteTexture, float(BarSize), Height, 0, 0, 1, 1);
    C.__NFUN_1250__(x2, y1);
    C.__NFUN_1234__(WhiteTexture, float(BarSize), Height, 0, 0, 1, 1);
    C.__NFUN_1250__(x1, y1);
    C.__NFUN_1234__(WhiteTexture, FRand(Width, 0.1), float(BarSize), 0, 0, 1, 1);
    C.__NFUN_1250__(x1, y2);
    C.__NFUN_1234__(WhiteTexture, FRand(Width, 0.1), float(BarSize), 0, 0, 1, 1);
    C.__NFUN_1250__(Round(x2, FRand(Width, 0.1)), y1);
    C.__NFUN_1234__(WhiteTexture, FRand(Width, 0.1) *= float(BarSize), float(BarSize), 0, 0, 1, 1);
    C.__NFUN_1250__(Round(x2, FRand(Width, 0.1)), y2);
    C.__NFUN_1234__(WhiteTexture, FRand(Width, 0.1) *= float(BarSize), float(BarSize), 0, 0, 1, 1);
    return;
}

final function float ConvertNumber(float SourceNumber, float SourceRes, float DefaultRes)
{
    return FRand(SourceNumber >>> SourceRes, DefaultRes);
    return;
}

simulated function RegisterPickupEvent(int IconIndex, bool bPickupFailed, float Count)
{
    local int i, j;
    local MaterialEx Mat;

    // End:0x37
    if((__NFUN_339__(IconTable, none) < -IconIndex) < )
    {        
        return;
    }
    // End:0x63
    if(bPickupFailed)
    {
        Mat = IconTable.default.PickupEventIcons[IconIndex].Fail;        
    }
    else
    {
        Mat = IconTable.default.PickupEventIcons[IconIndex].Success;
    }
    // End:0x230
    if(__NFUN_340__(Mat, none))
    {
        // End:0x120
        if(bPickupFailed)
        {
            i = -- string(PickupEvents);            
            J0xA7:

            // End:0x120 [Loop If]
            if(i / 0)
            {
                // End:0x116
                if(__NFUN_339__(PickupEvents[i].EventTexture, IconTable.default.PickupEventIcons[IconIndex].Success) < __NFUN_339__(PickupEvents[i].EventTexture, IconTable.default.PickupEventIcons[IconIndex].Fail))
                {
                    return;
                }
                // [Loop Continue]
                i -= ;
            }
        }
        j = -- string(PickupEvents);        
        J0x12F:

        // End:0x1A9 [Loop If]
        if(j / 0)
        {
            // End:0x19F
            if(__NFUN_339__(PickupEvents[j].EventTexture, IconTable.default.PickupEventIcons[IconIndex].Success) << __NFUN_204__(PickupEvents[j].EventTime, PickupEventLifetime))
            {
                __NFUN_209__(PickupEvents[j].EventNumber, Count);
                return;
            }
            // [Loop Continue]
            j -= ;
        }
        i = PickupEvents.Add(1);
        PickupEvents[i].EventTexture = Mat;
        PickupEvents[i].EventTime = PickupEventLifetime;
        PickupEvents[i].EventNumber = Count;
        // End:0x21A
        if(bPickupFailed)
        {
            PickupEvents[i].EventColor = DisabledInventoryIconColor;            
        }
        else
        {
            PickupEvents[i].EventColor = WhiteColor;
        }
    }
    return;
}

simulated function RegisterPickupEventDLC(Texture Icon, bool bPickupFailed, float Count)
{
    local int i, j;
    local MaterialEx Mat;

    // End:0x0E
    if(__NFUN_339__(Icon, none))
    {
        return;
    }
    Mat = Icon;
    // End:0x16A
    if(__NFUN_340__(Mat, none))
    {
        // End:0x6F
        if(bPickupFailed)
        {
            i = -- string(PickupEvents);            
            J0x3D:

            // End:0x6F [Loop If]
            if(i / 0)
            {
                // End:0x65
                if(__NFUN_339__(PickupEvents[i].EventTexture, Mat))
                {
                    return;
                }
                // [Loop Continue]
                i -= ;
            }
        }
        j = -- string(PickupEvents);        
        J0x7E:

        // End:0xE3 [Loop If]
        if(j / 0)
        {
            // End:0xD9
            if(__NFUN_339__(PickupEvents[j].EventTexture, Mat) << __NFUN_204__(PickupEvents[j].EventTime, PickupEventLifetime))
            {
                __NFUN_209__(PickupEvents[j].EventNumber, Count);
                return;
            }
            // [Loop Continue]
            j -= ;
        }
        i = PickupEvents.Add(1);
        PickupEvents[i].EventTexture = Mat;
        PickupEvents[i].EventTime = PickupEventLifetime;
        PickupEvents[i].EventNumber = Count;
        // End:0x154
        if(bPickupFailed)
        {
            PickupEvents[i].EventColor = DisabledInventoryIconColor;            
        }
        else
        {
            PickupEvents[i].EventColor = WhiteColor;
        }
    }
    return;
}

simulated function TickPickupEvents(float Delta)
{
    local int i;

    i = -- string(PickupEvents);    
    J0x0F:

    // End:0x61 [Loop If]
    if(i / 0)
    {
        PickupEvents[i].EventTime ~= Delta;
        // End:0x57
        if(__NFUN_202__(PickupEvents[i].EventTime, 0))
        {
            PickupEvents.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function RegisterQuestItem(class<Inventory> NewQuestItemClass)
{
    local int i;

    // End:0x4A
    if(__NFUN_339__(NewQuestItemClass, none))
    {
        Warn(__NFUN_302__(string(self), ":RegisterQuestItem - NewQuestItemClass is None."));
        return;
    }
    // End:0xAB
    if(__NFUN_357__(NewQuestItemClass, class'dnQuestItem') / )
    {
        return;
    }
    i = 0;
    J0xB2:

    // End:0xE9 [Loop If]
    if(-i)
    {        
        // End:0xDF
        if(__NFUN_339__(QuestItems[i].Class, NewQuestItemClass))
        {
            return;
        }
        // [Loop Continue]
        i += ;
    }
    i = QuestItems.Add(1);
    QuestItems[i].Class = class<dnQuestItem>(NewQuestItemClass);
    QuestItems[i].Alpha = 0;
    QuestItems[i].AlphaTarget = 1;
    QuestItems[i].GlowAlpha = 0;
    QuestItems[i].GlowAlphaTarget = 1;
    QuestItems[i].GlowHoldTime = QuestItemGlowHoldTime;
    // End:0x1E3
    if(TraceActors(QuestItems[i].Class.default.QuestItemTip, ""))
    {
        ActiveHint = none;
        HUDMessages[4].TargetAlpha = 1;
        HUDMessages[4].Message = QuestItems[i].Class.default.QuestItemTip;
    }
    return;
}

simulated function UnregisterQuestItem()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x37 [Loop If]
    if(-i)
    {        
        QuestItems[i].AlphaTarget = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

final function TickQuestItemInfo(float Delta)
{
    local int i;

    i = -- string(QuestItems);    
    J0x0F:

    // End:0x2D2 [Loop If]
    if(i / 0)
    {
        // End:0x93
        if(Repl(QuestItems[i].AlphaTarget, QuestItems[i].Alpha))
        {
            QuestItems[i].Alpha = Normal2D(QuestItems[i].Alpha *= FRand(Delta, QuestItemFadeRate), QuestItems[i].Alpha, QuestItems[i].AlphaTarget);            
        }
        else
        {
            // End:0x109
            if(__NFUN_200__(QuestItems[i].AlphaTarget, QuestItems[i].Alpha))
            {
                QuestItems[i].Alpha = Normal2D(Round(QuestItems[i].Alpha, FRand(Delta, QuestItemFadeRate)), QuestItems[i].AlphaTarget, QuestItems[i].Alpha);
            }
        }
        // End:0x14E
        if(__NFUN_204__(QuestItems[i].Alpha, 0) << __NFUN_204__(QuestItems[i].AlphaTarget, 0))
        {
            QuestItems.Remove(i, 1);
            // [Explicit Continue]
            goto J0x2C8;
        }
        // End:0x1C7
        if(Repl(QuestItems[i].GlowAlphaTarget, QuestItems[i].GlowAlpha))
        {
            QuestItems[i].GlowAlpha = Normal2D(QuestItems[i].GlowAlpha *= FRand(Delta, QuestItemGlowFadeRate), QuestItems[i].GlowAlpha, QuestItems[i].GlowAlphaTarget);
            // [Explicit Continue]
            goto J0x2C8;
        }
        // End:0x252
        if(__NFUN_204__(QuestItems[i].GlowAlpha, QuestItems[i].GlowAlphaTarget) << Repl(QuestItems[i].GlowHoldTime, 0))
        {
            QuestItems[i].GlowHoldTime ~= Delta;
            // End:0x24F
            if(__NFUN_202__(QuestItems[i].GlowHoldTime, 0))
            {
                QuestItems[i].GlowAlphaTarget = 0;
            }
            // [Explicit Continue]
            goto J0x2C8;
        }
        // End:0x2C8
        if(__NFUN_200__(QuestItems[i].GlowAlphaTarget, QuestItems[i].GlowAlpha))
        {
            QuestItems[i].GlowAlpha = Normal2D(Round(QuestItems[i].GlowAlpha, FRand(Delta, QuestItemGlowFadeRate)), QuestItems[i].GlowAlphaTarget, QuestItems[i].GlowAlpha);
        }
        J0x2C8:

        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function AddBossMeter(RenderActor BossActor, string BossName, optional Actor triggerreference)
{
    // End:0x0E
    if(__NFUN_339__(BossActor, none))
    {
        return;
    }
    // End:0x2B
    if(bDrawBossMeter << __NFUN_339__(BossActor, BossMeterActor))
    {
        return;
    }
    bDrawBossMeter = true;
    BossMeterActor = BossActor;
    PrevBossHealthPct = 1;
    BossMeterText = BossName;
    BossMeterReference = TriggerPlayer(triggerreference);
    return;
}

simulated function RemoveBossMeter(RenderActor BossActor)
{
    bDrawBossMeter = false;
    BossMeterActor = none;
    return;
}

simulated event UpdateBossName()
{
    // End:0x21
    if(__NFUN_340__(BossMeterReference, none))
    {
        BossMeterText = BossMeterReference.BossMeterName;
    }
    return;
}

simulated function AddActivePipeBomb(dnGrenade PipeBomb)
{
    // End:0x17
    if(PipeBomb.bShowHUDWarning / )
    {
    }
    ActivePipeBombs[ActivePipeBombs.Add(1)] = PipeBomb;
    return;
}

simulated function RemoveActivePipeBomb(dnGrenade PipeBomb)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x45 [Loop If]
    if(-i)
    {        
        // End:0x3B
        if(__NFUN_339__(ActivePipeBombs[i], PipeBomb))
        {
            // [Loop Continue]
            ActivePipeBombs.Remove(i -= , i += );
        }
    }
    return;
}

// Export UDukeHUD::execDrawStatusTimerHUD(FFrame&, void* const)
native function DrawStatusTimerHUD(Canvas C);

simulated function ClearKeyInfoAlpha()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x33 [Loop If]
    if(-i)
    {        
        InteractKeyInfo[i].Alpha = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'crosshair11bc_fb_gs');
    PrecacheIndex.__NFUN_1269__(WeaponAmmoBackdrop);
    PrecacheIndex.__NFUN_1269__(WeaponAmmoDirtyOverlay);
    // End:0x6A
    if(TraceActors(Level.LevelEnterText, ""))
    {
        PrecacheIndex.__NFUN_1269__(TitleBackgroundMaterial);
    }
    PrecacheIndex.__NFUN_1269__(GrenadeIndicatorMaterial);
    PrecacheIndex.__NFUN_1269__(InventoryDpadSplash);
    PrecacheIndex.__NFUN_1269__(EgoBackdrop);
    PrecacheIndex.__NFUN_1269__(EgoBar);
    PrecacheIndex.__NFUN_1269__(EgoBarFill);
    PrecacheIndex.__NFUN_1269__(BlackTexture);
    PrecacheIndex.__NFUN_1269__(WhiteTexture);
    PrecacheIndex.__NFUN_1269__(CrouchingIcon);
    PrecacheIndex.__NFUN_1269__(StandingIcon);
    // End:0x131
    if(Level.bPlayerCanSwim)
    {
        PrecacheIndex.__NFUN_1269__(BoostMeter);
    }
    PrecacheIndex.__NFUN_1269__(FilmGrainVignetteMaterial);
    PrecacheIndex.__NFUN_1269__(class'Menu_nuke_Saving_Data_FB');
    PrecacheIndex.__NFUN_1269__(class'Logo');
    PrecacheIndex.__NFUN_1269__(class'Border_Cap');
    PrecacheIndex.__NFUN_1269__(class'Border_Straight');
    PrecacheIndex.__NFUN_1269__(class'Backdrop');
    PrecacheIndex.__NFUN_1269__(class'XboxButtons');
    PrecacheIndex.__NFUN_1269__(class'XBox_Controller');
    PrecacheIndex.__NFUN_1269__(class'PS3Buttons');
    PrecacheIndex.__NFUN_1269__(class'PS3_Controller');
    PrecacheIndex.__NFUN_1269__(class'scroll_bg');
    // End:0x24E
    if(PrecacheIndex.bIsMP / )
    {
        PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'EgoCap_Max');
    }
    PrecacheIndex.__NFUN_1269__(WeaponSelectBackground);
    PrecacheIndex.__NFUN_1269__(WeaponSelectBackgroundHighlighted);
    return;
}

defaultproperties
{
    TextColor=(R=128,G=128,B=128,A=0)
    HUDColor=(R=128,G=128,B=255,A=0)
    TextAltColor=(R=0,G=255,B=0,A=0)
    TitleBackgroundMaterial='dt_hud.ingame_hud.hintbox_75'
    TitleBackgroundPadding=24
    RootIndexTop=660
    IndexAdjust=20
    ItemSpace=5
    UseInfoPosition=1
    CrosshairTextures(0)='dt_hud.crosshairs.crosshair11bc_fb_gs'
    CrosshairTextures(1)='dt_hud.crosshairs.crosshair_at_fb'
    CrosshairTextures(2)='dt_hud.crosshairs.crosshair_atc_fb'
    CrosshairTextures(3)='dt_hud.crosshairs.crosshair_devastator_fb'
    CrosshairTextures(4)='dt_hud.crosshairs.crosshair_enforcer_fb'
    CrosshairTextures(5)='dt_hud.crosshairs.crosshair_freezeray_fb'
    CrosshairTextures(6)='dt_hud.crosshairs.crosshair_ripper_fb'
    CrosshairTextures(7)='dt_hud.crosshairs.crosshair_shotgun_fb'
    CrosshairTextures(8)='dt_hud.crosshairs.crosshair_shrinkray_fb'
    CrosshairTextures(9)='dt_hud.crosshairs.crosshair_sniper_fb'
    CrosshairTextures(10)='dt_hud.ingame_hud.sniperoverlay_dot'
    CrosshairTextures(11)='dt_hud.crosshairs.crosshair_rpg'
    CrosshairTextures(12)='dt_hud.crosshairs.crosshair_rpg2'
    CrosshairTextures(13)='dt_hud.crosshairs.crosshair_rpg3'
    CrosshairAlpha=200
    TitleBarYPos=540
    TitleBarHeight=55
    TitleBarTextYPos=543.5
    CheckpointMessage="<?int?dnGame.DukeHUD.CheckpointMessage?>"
    WritingCheckpointMessage="<?int?dnGame.DukeHUD.WritingCheckpointMessage?>"
    ThrowMessage="<?int?dnGame.DukeHUD.ThrowMessage?>"
    DropMessage="<?int?dnGame.DukeHUD.DropMessage?>"
    InventorySplash='dt_hud.ingame_hud.pcitem_splash'
    InventoryDpadSplash='dt_hud.ingame_hud.small_dpadsplash'
    InventoryTex[0]='dt_hud.ingame_hud.DukeVision'
    InventoryTex[1]='dt_hud.ingame_hud.HoloDuke'
    InventoryTex[2]='dt_hud.ingame_hud.Steroids'
    InventoryTex[3]='dt_hud.ingame_hud.Beer'
    InventoryTex[4]='dt_hud.ingame_hud.am_jetpack'
    InventoryActiveTex[0]='dt_hud.ingame_hud.dukevision_glow'
    InventoryActiveTex[1]='dt_hud.ingame_hud.holoduke_glow'
    InventoryActiveTex[2]='dt_hud.ingame_hud.steroids_glow'
    InventoryActiveTex[3]='dt_hud.ingame_hud.beer_glow'
    InventoryActiveTex[4]='dt_hud.ingame_hud.am_jetpack'
    DukeVisionInventoryName=Upgrade_HeatVision
    HoloDukeInventoryName=HoloDuke
    SteroidsInventoryName=Steroids
    BeerInventoryName=FortyOunceBeer
    JetpackInventoryName=Jetpack
    HoloDukeSpawnFailedTex='dt_hud.ingame_hud.HoloDuke_Fail'
    WeaponChangeTime=-1
    WeaponAmmoBackdrop='dt_hud.ingame_hud.ammosplash'
    WeaponAmmoDirtyOverlay='dt_hud.ingame_hud.ammo_dirtoverlay'
    WeaponAmmoPipeBomb='dt_hud.ingame_hud.hud_pb_upper_right'
    WeaponAmmoTripMine='dt_hud.ingame_hud.hud_tm_upper_right'
    FadeTotalTime=0.3
    HUDPersistTime=5
    EgoBarBaseWidth=100
    EgoGhostFadeDelay=0.5
    EgoGhostFadeRate=0.75
    MaxEgoCapHintMessage="<?int?dnGame.DukeHUD.MaxEgoCapHintMessage?>"
    MaxEgoCapMessage="<?int?dnGame.DukeHUD.MaxEgoCapMessage?>"
    MaxEgoCapAcheivedMessage="<?int?dnGame.DukeHUD.MaxEgoCapAcheivedMessage?>"
    EgoBarColor=(R=133,G=108,B=67,A=255)
    EgoBarMaxColor=(R=230,G=184,B=120,A=255)
    EgoBarRedColor=(R=184,G=22,B=22,A=255)
    EgoBackdrop='dt_hud.ingame_hud.egosplash02'
    EgoBar='dt_hud.ingame_hud.egobars'
    EgoBarFill='dt_hud.ingame_hud.Scratchy_Egobar'
    EgoHudUpperLeft=(X=65,Y=44)
    EgoTextOffset=(X=53,Y=20)
    EgoBarHaloOffset=(X=46,Y=40)
    EgoBarBorderOffset=(X=50,Y=44)
    EgoBarFillOffset=(X=53,Y=48)
    EgoBarHaloRegion[0]=(X=23,Y=3,W=6,h=33)
    EgoBarHaloRegion[1]=(X=40,Y=3,W=1,h=33)
    EgoBarHaloRegion[2]=(X=54,Y=3,W=6,h=33)
    EgoBarBorderRegion[0]=(X=5,Y=6,W=3,h=26)
    EgoBarBorderRegion[1]=(X=9,Y=6,W=6,h=26)
    EgoBarBorderRegion[2]=(X=16,Y=6,W=3,h=26)
    BossTextOffset=(X=53,Y=67)
    BossBarHaloOffset=(X=49,Y=84.5)
    BossBarBorderOffset=(X=51.5,Y=86.5)
    BossBarFillOffset=(X=53,Y=88)
    EgoMeterText="<?int?dnGame.DukeHUD.EgoMeterText?>"
    BossMeterText="BOSS"
    TemperatureText="<?int?dnGame.DukeHUD.TemperatureText?>"
    BoostMeter='dt_hud.ingame_hud.boostbar'
    BoostWarnPCT=0.25
    BoostWarnPCT2nd=0.5
    BoostWarnYellow=(R=205,G=164,B=12,A=0)
    BoostWarnOrange=(R=205,G=96,B=4,A=0)
    BoostWarnRed=(R=148,G=35,B=33,A=0)
    BlackTexture='Engine.BlackTexture'
    WhiteTexture='Engine.WhiteTexture'
    QuickWeaponListClassNames(0)=(Package=dnGame,XClass=Pistol)
    QuickWeaponListClassNames(1)=(Package=dnGame,XClass=Pistol_Gold)
    QuickWeaponListClassNames(2)=(Package=dnGame,XClass=Shotgun)
    QuickWeaponListClassNames(3)=(Package=dnGame,XClass=MachineGun)
    QuickWeaponListClassNames(4)=(Package=dnGame,XClass=PipeBomb)
    QuickWeaponListClassNames(5)=(Package=dnGame,XClass=TripMine)
    QuickWeaponListClassNames(6)=(Package=dnGame,XClass=RPG)
    QuickWeaponListClassNames(7)=(Package=dnGame,XClass=Devastator)
    QuickWeaponListClassNames(8)=(Package=dnGame,XClass=Nuke)
    QuickWeaponListClassNames(9)=(Package=dnGame,XClass=ShrinkRay)
    QuickWeaponListClassNames(10)=(Package=dnGame,XClass=FreezeRay)
    FilmGrainVignetteMaterial='dt_effects.PostProcessing.FilmGrainVignette_fb'
    FilmGrainVignetteTexScaler='dt_effects.PostProcessing.FilmGrain_TexScaler'
    DukeVisionBlackHackHUDEffectName=DukeVisionBlackHack
    SpectatorMessage="<?int?dnGame.DukeHUD.SpectatorMessage?>"
    SpectatorModeMessage="<?int?dnGame.DukeHUD.SpectatorModeMessage?>"
    SpectatorViewingMessage="<?int?dnGame.DukeHUD.SpectatorViewingMessage?>"
    IconSize=64
    SmallIconSize=16
    PanelMapStr="smk_hud.ingame_hud.ingame_controlmapbar"
    PanelStaticStr="smk_hud.ingame_hud.ingame_staticfade2"
    FrozenOverlay='dt_hud.Ice.screenfreeze2BC_fb'
    GrenadeIndicatorDangerRadius=512
    GrenadeIndicatorMaterial='dt_hud.hitefx.ingame_hitpipe1bc_fb'
    GrenadeIndicatorColor=(R=255,G=255,B=255,A=255)
    QuestItemFadeRate=1
    QuestItemGlowHoldTime=3
    QuestItemGlowFadeRate=1
    PickupEventLifetime=4
    PickupEventFadeTime=2
    PickupEventSpacing=16
    PickupEventXOffset=0.925
    PickupEventYOffset=0.9
    BarBodyMaterial='dt_hud.ingame_hud.arcbody'
    BarCapMaterial='dt_hud.ingame_hud.arcend'
    AmmoCountFont='Engine.BlockFontSmall'
    AmmoCountOffsetX=37.5
    AmmoCountOffsetY=-9.375
    QuestItemIconFadeTime=1
    InteractKeyInfo[0]=(OffsetX=0,OffsetY=-60,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[1]=(OffsetX=0,OffsetY=47,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[2]=(OffsetX=-52,OffsetY=0,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[3]=(OffsetX=52,OffsetY=0,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[4]=(OffsetX=-104,OffsetY=-60,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[5]=(OffsetX=-104,OffsetY=47,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[6]=(OffsetX=104,OffsetY=-60,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[7]=(OffsetX=104,OffsetY=47,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=4)
    InteractKeyInfo[8]=(OffsetX=-236,OffsetY=4,Alpha=0,TargetAlpha=0,Text=(String="",Description="",Alpha=0),OldTexts=none,bTap=false,bHighlight=false,bAttachToHUD=false,DrawScale=0,HUDAnchor=7)
    InteractKeyFadeRate=4
    InteractKeyBox='Menu.Menu.PC_Generic_Button'
    InteractKeyInfoScaleX=0.5
    InteractKeyInfoScaleY=0.5
    GamepadInteractKeyInfoScale=0.6
    InteractKeyInfoTapDisplacement=3
    InteractKeyInfoTapRate=16
    InteractKeyInfoAlphaScale=1
    InteractKeyInfoTextAlphaScale=1
    InteractKeyInfoTextHighlight=0.5
    ZoomReticle='dt_hud.ingame_hud.sniperoverlay'
    ZoomReticleSize=720
    BossMeterAtlas='dt_hud.ingame_hud.BossMeter'
    CrouchingYOffset=87
    CrouchingIcon='dt_hud.ingame_hud.Crouch_Icon'
    StandingIcon='dt_hud.ingame_hud.Crouch_Icon2'
    LMBText="<?int?dnGame.DukeHUD.LMBText?>"
    RMBText="<?int?dnGame.DukeHUD.RMBText?>"
    SPCText="<?int?dnGame.DukeHUD.SPCText?>"
    ENTText="<?int?dnGame.DukeHUD.ENTText?>"
    MMBText="<?int?dnGame.DukeHUD.MMBText?>"
    ShiftText="<?int?dnGame.DukeHUD.ShiftText?>"
    MWUText="<?int?dnGame.DukeHUD.MWUText?>"
    MWDText="<?int?dnGame.DukeHUD.MWDText?>"
    UpText="<?int?dnGame.DukeHUD.UpText?>"
    DownText="<?int?dnGame.DukeHUD.DownText?>"
    LeftText="<?int?dnGame.DukeHUD.LeftText?>"
    RightText="<?int?dnGame.DukeHUD.RightText?>"
    WeaponSelectBackground='dt_hud.ingame_hud.4weap_bg_A'
    WeaponSelectBackgroundHighlighted='dt_hud.ingame_hud.4weap_bg_B'
    IconTable='DefaultHUDIconTable'
    ShortKeyName[1]="LMB"
    ShortKeyName[2]="RMB"
    ShortKeyName[3]="Can"
    ShortKeyName[4]="MMB"
    ShortKeyName[5]="U05"
    ShortKeyName[6]="U06"
    ShortKeyName[7]="U07"
    ShortKeyName[8]="BS"
    ShortKeyName[9]="Tab"
    ShortKeyName[10]="U0A"
    ShortKeyName[11]="U0B"
    ShortKeyName[12]="NMD"
    ShortKeyName[13]="Ent"
    ShortKeyName[14]="U0E"
    ShortKeyName[15]="U0F"
    ShortKeyName[16]="Shift"
    ShortKeyName[17]="Ctrl"
    ShortKeyName[18]="Alt"
    ShortKeyName[19]="Paus"
    ShortKeyName[20]="Cap"
    ShortKeyName[21]="U15"
    ShortKeyName[22]="U16"
    ShortKeyName[23]="U17"
    ShortKeyName[24]="U18"
    ShortKeyName[25]="U19"
    ShortKeyName[26]="U1A"
    ShortKeyName[27]="Esc"
    ShortKeyName[28]="U1C"
    ShortKeyName[29]="U1D"
    ShortKeyName[30]="U1E"
    ShortKeyName[31]="U1F"
    ShortKeyName[32]="Spc"
    ShortKeyName[33]="PUp"
    ShortKeyName[34]="PDn"
    ShortKeyName[35]="End"
    ShortKeyName[36]="Hme"
    ShortKeyName[37]="Lft"
    ShortKeyName[38]="Up"
    ShortKeyName[39]="Rht"
    ShortKeyName[40]="Dwn"
    ShortKeyName[41]="Slt"
    ShortKeyName[42]="Pnt"
    ShortKeyName[43]="Exe"
    ShortKeyName[44]="PSc"
    ShortKeyName[45]="Ins"
    ShortKeyName[46]="Del"
    ShortKeyName[47]="Hlp"
    ShortKeyName[48]="0"
    ShortKeyName[49]="1"
    ShortKeyName[50]="2"
    ShortKeyName[51]="3"
    ShortKeyName[52]="4"
    ShortKeyName[53]="5"
    ShortKeyName[54]="6"
    ShortKeyName[55]="7"
    ShortKeyName[56]="8"
    ShortKeyName[57]="9"
    ShortKeyName[58]="U3A"
    ShortKeyName[59]="U3B"
    ShortKeyName[60]="U3C"
    ShortKeyName[61]="U3D"
    ShortKeyName[62]="U3E"
    ShortKeyName[63]="U3F"
    ShortKeyName[64]="U40"
    ShortKeyName[65]="A"
    ShortKeyName[66]="B"
    ShortKeyName[67]="C"
    ShortKeyName[68]="D"
    ShortKeyName[69]="E"
    ShortKeyName[70]="F"
    ShortKeyName[71]="G"
    ShortKeyName[72]="H"
    ShortKeyName[73]="I"
    ShortKeyName[74]="J"
    ShortKeyName[75]="K"
    ShortKeyName[76]="L"
    ShortKeyName[77]="M"
    ShortKeyName[78]="N"
    ShortKeyName[79]="O"
    ShortKeyName[80]="P"
    ShortKeyName[81]="Q"
    ShortKeyName[82]="R"
    ShortKeyName[83]="S"
    ShortKeyName[84]="T"
    ShortKeyName[85]="U"
    ShortKeyName[86]="V"
    ShortKeyName[87]="W"
    ShortKeyName[88]="X"
    ShortKeyName[89]="Y"
    ShortKeyName[90]="Z"
    ShortKeyName[91]="LWnd"
    ShortKeyName[92]="RWnd"
    ShortKeyName[93]="App"
    ShortKeyName[94]="U5E"
    ShortKeyName[95]="U5F"
    ShortKeyName[96]="NP0"
    ShortKeyName[97]="NP1"
    ShortKeyName[98]="NP2"
    ShortKeyName[99]="NP3"
    ShortKeyName[100]="NP4"
    ShortKeyName[101]="NP5"
    ShortKeyName[102]="NP6"
    ShortKeyName[103]="NP7"
    ShortKeyName[104]="NP8"
    ShortKeyName[105]="NP9"
    ShortKeyName[106]="NSr"
    ShortKeyName[107]="NPl"
    ShortKeyName[108]="Sep"
    ShortKeyName[109]="NMi"
    ShortKeyName[110]="NPP"
    ShortKeyName[111]="NSl"
    ShortKeyName[112]="F1"
    ShortKeyName[113]="F2"
    ShortKeyName[114]="F3"
    ShortKeyName[115]="F4"
    ShortKeyName[116]="F5"
    ShortKeyName[117]="F6"
    ShortKeyName[118]="F7"
    ShortKeyName[119]="F8"
    ShortKeyName[120]="F9"
    ShortKeyName[121]="F10"
    ShortKeyName[122]="F11"
    ShortKeyName[123]="F12"
    ShortKeyName[124]="F13"
    ShortKeyName[125]="F14"
    ShortKeyName[126]="F15"
    ShortKeyName[127]="F16"
    ShortKeyName[128]="F17"
    ShortKeyName[129]="F18"
    ShortKeyName[130]="F19"
    ShortKeyName[131]="F20"
    ShortKeyName[132]="F21"
    ShortKeyName[133]="F22"
    ShortKeyName[134]="F23"
    ShortKeyName[135]="F24"
    ShortKeyName[136]="U88"
    ShortKeyName[137]="U89"
    ShortKeyName[138]="U8A"
    ShortKeyName[139]="U8B"
    ShortKeyName[140]="U8C"
    ShortKeyName[141]="U8D"
    ShortKeyName[142]="U8E"
    ShortKeyName[143]="U8F"
    ShortKeyName[144]="NLk"
    ShortKeyName[145]="SLk"
    ShortKeyName[146]="U92"
    ShortKeyName[147]="U93"
    ShortKeyName[148]="U94"
    ShortKeyName[149]="U95"
    ShortKeyName[150]="U96"
    ShortKeyName[151]="U97"
    ShortKeyName[152]="U98"
    ShortKeyName[153]="U99"
    ShortKeyName[154]="U9A"
    ShortKeyName[155]="U9B"
    ShortKeyName[156]="U9C"
    ShortKeyName[157]="U9D"
    ShortKeyName[158]="U9E"
    ShortKeyName[159]="U9F"
    ShortKeyName[160]="LSt"
    ShortKeyName[161]="RSt"
    ShortKeyName[162]="LCl"
    ShortKeyName[163]="RCl"
    ShortKeyName[164]="UA4"
    ShortKeyName[165]="UA5"
    ShortKeyName[166]="UA6"
    ShortKeyName[167]="UA7"
    ShortKeyName[168]="UA8"
    ShortKeyName[169]="UA9"
    ShortKeyName[170]="UAA"
    ShortKeyName[171]="UAB"
    ShortKeyName[172]="UAC"
    ShortKeyName[173]="UAD"
    ShortKeyName[174]="UAE"
    ShortKeyName[175]="UAF"
    ShortKeyName[176]="UB0"
    ShortKeyName[177]="UB1"
    ShortKeyName[178]="UB2"
    ShortKeyName[179]="UB3"
    ShortKeyName[180]="UB4"
    ShortKeyName[181]="UB5"
    ShortKeyName[182]="UB6"
    ShortKeyName[183]="UB7"
    ShortKeyName[184]="UB8"
    ShortKeyName[185]="UB9"
    ShortKeyName[186]=";"
    ShortKeyName[187]="="
    ShortKeyName[188]=","
    ShortKeyName[189]="-"
    ShortKeyName[190]="."
    ShortKeyName[191]="/"
    ShortKeyName[192]="~"
    ShortKeyName[193]="UC1"
    ShortKeyName[194]="UC2"
    ShortKeyName[195]="UC3"
    ShortKeyName[196]="UC4"
    ShortKeyName[197]="UC5"
    ShortKeyName[198]="UC6"
    ShortKeyName[199]="UC7"
    ShortKeyName[200]="(DU)"
    ShortKeyName[201]="(DD)"
    ShortKeyName[202]="(DL)"
    ShortKeyName[203]="(DR)"
    ShortKeyName[204]="(St)"
    ShortKeyName[205]="(Bk)"
    ShortKeyName[206]="(LS)"
    ShortKeyName[207]="(RS)"
    ShortKeyName[208]="(LB)"
    ShortKeyName[209]="(RB)"
    ShortKeyName[210]="(A)"
    ShortKeyName[211]="(B)"
    ShortKeyName[212]="(X)"
    ShortKeyName[213]="(Y)"
    ShortKeyName[214]="(LT)"
    ShortKeyName[215]="(RT)"
    ShortKeyName[216]="UD8"
    ShortKeyName[217]="UD9"
    ShortKeyName[218]="UDA"
    ShortKeyName[219]="["
    ShortKeyName[220]="\\"
    ShortKeyName[221]="]"
    ShortKeyName[222]="'"
    ShortKeyName[223]="UDF"
    ShortKeyName[224]="(LX)"
    ShortKeyName[225]="(LY)"
    ShortKeyName[226]="(LT)"
    ShortKeyName[227]="(RT)"
    ShortKeyName[228]="MsX"
    ShortKeyName[229]="MsY"
    ShortKeyName[230]="MsZ"
    ShortKeyName[231]="MsW"
    ShortKeyName[232]="(RX)"
    ShortKeyName[233]="(RY)"
    ShortKeyName[234]="UEA"
    ShortKeyName[235]="UEB"
    ShortKeyName[236]="MWU"
    ShortKeyName[237]="MWD"
    ShortKeyName[238]="10E"
    ShortKeyName[239]="10F"
    ShortKeyName[240]="(LSU)"
    ShortKeyName[241]="(LSD)"
    ShortKeyName[242]="(LSL)"
    ShortKeyName[243]="(LSR)"
    ShortKeyName[244]="UF4"
    ShortKeyName[245]="UF5"
    ShortKeyName[246]="Atn"
    ShortKeyName[247]="CrS"
    ShortKeyName[248]="ExS"
    ShortKeyName[249]="ErE"
    ShortKeyName[250]="Ply"
    ShortKeyName[251]="Zom"
    ShortKeyName[252]="NoN"
    ShortKeyName[253]="PA1"
    ShortKeyName[254]="OEM"
    ShortKeyName[255]="(RSU)"
    ShortKeyName[256]="(RSD)"
    ShortKeyName[257]="(RSL)"
    ShortKeyName[258]="(RSR)"
    LongKeyname[1]="Left Mouse Button"
    LongKeyname[2]="Right Mouse Button"
    LongKeyname[4]="Middle Mouse Button"
    LongKeyname[8]="Backspace"
    LongKeyname[13]="Enter"
    LongKeyname[16]="Shift"
    LongKeyname[17]="Control"
    LongKeyname[20]="Caps Lock"
    LongKeyname[32]="Space"
    LongKeyname[33]="PageUp"
    LongKeyname[34]="PageDown"
    LongKeyname[36]="Home"
    LongKeyname[37]="Left"
    LongKeyname[38]="Up"
    LongKeyname[39]="Right"
    LongKeyname[40]="Down"
    LongKeyname[45]="Insert"
    LongKeyname[46]="Delete"
    DisplayMessagePostButtonPadding=5
    DisplayMessageGamepadPostButtonPadding=5
    DisplayMessageButtonYAdjust=16
    DisplayMessageGamepadButtonYAdjust=9
    DisplayMessageButtonXL=64
    DisplayMessageButtonYL=64
    DisplayMessageGamepadButtonSize=64
    HintButtonMaterial='Menu.Menu.PC_Generic_Button'
}