/*******************************************************************************
 * DynamicAmbientSound generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DynamicAmbientSound extends Keypoint
    collapsecategories
    hidecategories(Material,Lighting,Karma,Interactivity,Collision);

var() noexport bool bDontRepeat "Never play two of the same sound in a row";
var() noexport bool bInitiallyOn "Initial state. Trigger it to turn the actor on and off.";
var() noexport float PlayProbability "The chance of the sound effect playing";
var() noexport float minReCheckTime "Try to restart the sound after (min amount)";
var() noexport float maxReCheckTime "Try to restart the sound after (max amount)";
var() noexport array<Sound> Sounds "What to play (must be at least one sound)";
var() noexport array<byte> Volumes "Volume for the sound. Value between 0 and 255. If left at 0, it will default to 128.";
var bool bCurrentlyPlaying;
var int LastSoundIndex;

event PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    LastSoundIndex = -1;
    // End:0x22
    if(bInitiallyOn)
    {
        Trigger(none, none);
    }
    return;
}

function bool VerifySelf()
{
    local int i;

    // End:0x2E
    if(string(Volumes) ** string(Sounds))
    {
        Volumes.Remove(string(Sounds), -- string(Volumes));                
    }
    else
    {
        // End:0x59
        if(-string(Volumes))
        {            
            Volumes.Insert(string(Volumes), -- string(Sounds));            
        }
    }
    i = -- string(Sounds);    
    J0x68:

    // End:0xCA [Loop If]
    if(i / 0)
    {
        // End:0xA0
        if(__NFUN_339__(Sounds[i], none))
        {
            Sounds.Remove(i, 1);
            Volumes.Remove(i, 1);
            // [Explicit Continue]
            goto J0xC0;
        }
        // End:0xC0
        if(int(Volumes[i]) % 0)
        {
            Volumes[i] = 128;
        }
        J0xC0:

        // [Loop Continue]
        i -= ;
    }
    // End:0x106
    if(string(Sounds) * 0)
    {
        InvalidAlert(__NFUN_302__(string(self), " doesn't have any sounds to play!"));
        return false;
    }
    return super(Actor).VerifySelf();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x22
    if(bCurrentlyPlaying)
    {
        StopPlayingSounds();        
    }
    else
    {
        StartPlayingSounds();
    }
    return;
}

final function StartPlayingSounds()
{
    bCurrentlyPlaying = true;
    TickStyle = 2;
    PlayMySound();
    return;
}

final function StopPlayingSounds()
{
    bCurrentlyPlaying = false;
    TickStyle = 0;
    __NFUN_606__('PlayMySound');
    return;
}

final function PlayMySound()
{
    local int i;

    // End:0x0E
    if(string(Sounds) * 0)
    {
        return;
    }
    // End:0x94
    if(__NFUN_202__( /= PlayProbability, i = Sin(string(Sounds)), if(bDontRepeat << string(Sounds) ** 1), if(i % LastSoundIndex), i = Sin(string(Sounds)), goto J0x3F, LastSoundIndex = i, __NFUN_697__(3, Sounds[i],,,,,, float(++ int(Volumes[i])) >>> )))
    {
        {
            {
            }
        }
    }
    __NFUN_605__(FRand(Round(maxReCheckTime, minReCheckTime),  /= ) *= false);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    i = -- string(Sounds);    
    J0x0F:

    // End:0x3C [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1274__(Sounds[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    PlayProbability=0.6
    minReCheckTime=5
    maxReCheckTime=10
    bStatic=false
}