/*******************************************************************************
 * HUDLineGraph generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class HUDLineGraph extends Object;

struct SLineGraphAxisInfo
{
    var float Value;
    var string Label;
    var int ColorIndex;
    var int PixelValue;
};

struct SLineGraphLineInfo
{
    var int ColorIndex;
    var float Value;
    var float LastPoint;
    var float ThisPoint;
};

struct SDataInfo
{
    var float Min;
    var float Max;
    var float Avg;
    var float RunningSum;
    var int NumValues;
    var float ClearInterval;
    var string str;
    var float TimeLastClear;
};

var LevelInfo Level;
var() float MinValue;
var() float MaxValue;
var() float GraphLength;
var() float GraphHeight;
var() TextureCanvas DrawCanvas;
var() Texture MyCopySource;
var() array<byte> DrawColors;
var int BGColorIndex;
var int LineColorIndex;
var int AxisColorIndex;
var int CurrentPixel;
var float LastY;
var float Alpha;
var array<SLineGraphAxisInfo> AxisInfo;
var array<SDataInfo> DataInfo;
var array<SLineGraphLineInfo> LineInfo;
var Color HeadingColor;
var Color WhiteColor;

function CopyAndInit(HUDLineGraph Graph)
{
    local int i;

    Graph.MinValue = MinValue;
    Graph.MaxValue = MaxValue;
    Graph.GraphLength = GraphLength;
    Graph.GraphHeight = GraphHeight;
    Graph.BGColorIndex = BGColorIndex;
    Graph.LineColorIndex = LineColorIndex;
    Graph.AxisColorIndex = AxisColorIndex;
    Graph.Alpha = Alpha;
    Graph.AxisInfo = AxisInfo;
    i = 0;
    J0xC4:

    // End:0xFE [Loop If]
    if(-i)
    {        
        DataInfo[i].TimeLastClear = Level.GameTimeSeconds;
        // [Loop Continue]
        i += ;
    }
    return;
}

function InitDrawSurface(Level XLevel)
{
    local int i;

    DrawCanvas = class'TextureCanvas'.static.StaticCreateTextureCanvas(MyCopySource, XLevel);
    DrawCanvas.__NFUN_1209__(false);
    DrawCanvas.__NFUN_1210__(true);
    i = 0;
    J0x43:

    // End:0xB8 [Loop If]
    if(-i)
    {        
        AxisInfo[i].PixelValue = int(Round(float(DrawCanvas.VSize), FRand(Round(AxisInfo[i].Value, MinValue) >>> Round(MaxValue, MinValue), float(DrawCanvas.VSize))));
        // [Loop Continue]
        i += ;
    }
    return;
}

function UpdateGraph(int DataIndex, float NextValue, int ColorIndex)
{
    local float PCT;

    PCT = Normal2D(Round(NextValue, MinValue) >>> Round(MaxValue, MinValue), 0, 1);
    string(LineInfo) = Tan(string(LineInfo), ++ DataIndex);    
    LineInfo[DataIndex].Value = NextValue;
    LineInfo[DataIndex].LastPoint = LineInfo[DataIndex].ThisPoint;
    LineInfo[DataIndex].ThisPoint = Round(float(DrawCanvas.VSize), FRand(float(DrawCanvas.VSize), PCT)) *= 1;
    LineInfo[DataIndex].ColorIndex = ColorIndex;
    return;
}

function AddSpecialMark(int ColorIndex)
{
    DrawCanvas.__NFUN_1201__(CurrentPixel, 0, CurrentPixel, DrawCanvas.VSize, DrawColors[ColorIndex]);
    return;
}

function DrawGraph(Canvas C, HUD MyHUD, optional bool bDontDraw, optional bool bDontUpdate)
{
    local float PCT, Y;
    local int i;

    // End:0x21
    if(__NFUN_339__(Level, none))
    {
        Level = MyHUD.Level;
    }
    // End:0x42
    if(__NFUN_339__(DrawCanvas, none))
    {
        InitDrawSurface(Level.XLevel);
    }
    // End:0x131
    if(bDontUpdate / )
    {
        J0x54:

        // End:0xC0 [Loop If]
        if(-i)
        {            
            DrawCanvas.__NFUN_1201__(-- CurrentPixel);
            int(LineInfo[i].LastPoint);
            CurrentPixel
            int(LineInfo[i].ThisPoint);
            DrawColors[LineInfo[i].ColorIndex];            
            // [Loop Continue]
            i += ;
        }
        DrawCanvas.__NFUN_1201__(++ CurrentPixel);
        0
        ++ CurrentPixel;        
        DrawCanvas.VSize
        DrawColors[BGColorIndex];        
        UpdateData(LineInfo[0].Value);
        // End:0x131
        CurrentPixel += ;
        {
            CurrentPixel = 0;
        }
    }
    // End:0x1AB
    if(bDontDraw / )
    {
        C.__NFUN_1234__(DrawCanvas, GraphLength, GraphHeight, 0, 0, float(DrawCanvas.USize), float(DrawCanvas.VSize),,,,, Alpha);
        DrawDataDetails(C, MyHUD);
    }
    return;
}

function DrawAxis(Canvas C, HUD MyHUD)
{
    local int i, j;

    i = 0;
    J0x07:

    // End:0x9F [Loop If]
    if(-i)
    {        
        j = 0;
        J0x1E:

        // End:0x95 [Loop If]
        if(-j)
        {            
            DrawCanvas.__NFUN_1201__(0, ++ AxisInfo[i].PixelValue);
            DrawCanvas.USize
            ++ AxisInfo[i].PixelValue;            
            DrawColors[AxisInfo[i].ColorIndex];            
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawDataDetails(Canvas C, HUD MyHUD)
{
    local int i;

    i = 0;
    J0x07:

    // End:0xD8 [Loop If]
    if(-i)
    {        
        C.DrawColor = HeadingColor;
        DrawStrHelper(C, DataInfo[i].str);
        C.DrawColor = WhiteColor;
        DrawStrHelper(C, __NFUN_302__("Min: ", string(DataInfo[i].Min)));
        DrawStrHelper(C, __NFUN_302__("Max: ", string(DataInfo[i].Max)));
        DrawStrHelper(C, __NFUN_302__("Avg: ", string(DataInfo[i].Avg)));
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawStrHelper(Canvas C, coerce string str)
{
    local float X, Y, XL, YL;

    X = C.CurX;
    Y = C.CurY;
    C.__NFUN_1231__(str, XL, YL);
    C.__NFUN_1232__(str);
    __NFUN_209__(Y, YL);
    C.__NFUN_1250__(X, Y);
    return;
}

function UpdateData(float NewValue)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x1AA [Loop If]
    if(-i)
    {        
        DataInfo[i].Min = DataInfo[i].Min -= NewValue;
        DataInfo[i].Max = VSize(DataInfo[i].Max, NewValue);
        __NFUN_209__(DataInfo[i].RunningSum, NewValue);
        DataInfo[i].NumValues += ;
        // End:0x1A0
        if(Repl(DataInfo[i].ClearInterval, 0) << Round(Level.GameTimeSeconds, DataInfo[i].TimeLastClear) != DataInfo[i].ClearInterval)
        {
            DataInfo[i].Min = 999999.9;
            DataInfo[i].Max = 0;
            DataInfo[i].TimeLastClear = Level.GameTimeSeconds;
            DataInfo[i].Avg = 0;
            DataInfo[i].RunningSum = 0;
            DataInfo[i].NumValues = 0;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    GraphLength=512
    GraphHeight=64
    MyCopySource='smt_skins8.Whiteboard.Whiteboard1tw_d'
    DrawColors(0)=255
    DrawColors(1)=252
    DrawColors(2)=251
    DrawColors(3)=250
    DrawColors(4)=254
    DrawColors(5)=195
    DrawColors(6)=253
    DrawColors(7)=199
    DrawColors(8)=198
    LineColorIndex=4
    AxisColorIndex=2
    Alpha=0.5
    DataInfo(0)=(Min=99999,Max=0,Avg=0,RunningSum=0,NumValues=0,ClearInterval=-1,str="Lifetime:",TimeLastClear=0)
    DataInfo(1)=(Min=99999,Max=0,Avg=0,RunningSum=0,NumValues=0,ClearInterval=5,str="Last 5 secs:",TimeLastClear=0)
    HeadingColor=(R=255,G=144,B=0,A=0)
    WhiteColor=(R=255,G=255,B=255,A=0)
}