/*******************************************************************************
 * Jetpack generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Jetpack extends Upgrade_SOS;

const kJetpack_MinimumBoostSoundSpeedSq = 256.0f;

enum EJetpackControlMode
{
    JETPACKCONTROL_Planar,
    JETPACKCONTROL_Swimming
};

enum EJetpackHoverStyle
{
    JETPACKHOVER_Free_NO_Recharge,
    JETPACKHOVER_Free_AND_Recharge,
    JETPACKHOVER_Delay_Then_Drift,
    JETPACKHOVER_NOT_Free
};

enum EJetpackState
{
    JETPACKSTATE_Flying,
    JETPACKSTATE_Recharge,
    JETPACKSTATE_
};

var Jetpack.EJetpackControlMode ControlMode;
var float JetpackActivationTime;
var float JetpackMotionScale;
var float JetpackVerticalMotionPower;
var SoftParticleSystem JetBurnFX[2];
var SoftParticleSystem JetSmokeFX;
var SMountedActorPrefab JetBurnMountPrefab[2];
var SMountedActorPrefab JetSmokeMountPrefab;
var float JetpackBobHVelocity;
var float JetpackBobVVelocity;
var float JetpackBobHCycle;
var float JetpackBobVCycle;
var bool bCanPlayBoost;
var bool bWasMoving;
var Jetpack.EJetpackState JetpackState;
var() noexport float FuelUseRate "Rate to drain fuel. rate = 1/time to drain in seconds";
var() noexport float FuelRechargeRate "Rate to recharge fuel. rate = 1/time to recharge in seconds";
var() noexport float FlightSpeedFlying "How fast we move when in flying mode";
var noexport float FlightSpeedRecharging "How fast we move when in recharge mode";
var() noexport Jetpack.EJetpackHoverStyle HoverStyle "How to treat idle hovering in the flight state";
var bool bIsBraking;
var() noexport float EBrakeThreshold "Z Velocity at which to kick on the EBrake";
var() noexport float EBrakeMagnitude "Strength of ebrake.";
var bool bCanInitialThrust;
var() noexport Vector InitialThrust "A burst impulse that is applied to the player on activation";
var() noexport float InitialThrustCooldown "Minimum time between initial thrusts. To avoid abuse";
var float InternalHoverGraceTime;
var() noexport float HoverGraceTime "Time, in seconds, to allow for free hovering before entering a dritft state";
var() noexport float DriftStateFuelRate "Rate to drain fuel when in drift state. rate = 1/time to drain in seconds.";
var() noexport float GravityDriftScale "Gravity scale when in drift mode. 0 = no gravity. 1 = full gravity";
var bool bIsDrifting;
var bool bIsHovering;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        rPlayJetBurn, rStopJetBurn;
}

simulated function PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    // End:0x15
    if(bActive)
    {
        rPlayJetBurn();
    }
    return;
}

simulated function bool CanActivateNow()
{
    // End:0x30
    if(__NFUN_340__(Instigator.InventoryPhysicsItem, none) << __NFUN_340__(Instigator.InventoryPhysicsItem, self))
    {
        return false;
    }
    // End:0x47
    if(Instigator.bIsPlayerPawn / )
    {
    }
    return super.CanActivateNow();
    return;
}

simulated function Activate()
{
    super(ActivatableInventory).Activate();
    return;
}

simulated function StartActivate()
{
    local Vector ScaledInitialThrust;

    super(ActivatableInventory).StartActivate();
    FindAndPlaySound('JetPack_Ambience');
    __NFUN_590__(false);
    JetpackActivationTime = Level.TimeSeconds;
    bCanPlayBoost = true;
    JetpackState = 0;
    Instigator.InventoryPhysicsItem = self;
    Instigator.bCanFly = true;
    // End:0xDC
    if(bCanInitialThrust << Instigator.__NFUN_958__())
    {
        ScaledInitialThrust = Caps(Instigator.DrawScale, InitialThrust);
        Instigator.__NFUN_820__(__NFUN_241__(ScaledInitialThrust, Instigator.Rotation), Instigator.Location);
        bCanInitialThrust = false;
        __NFUN_607__(InitialThrustCooldown, false, 'EndInitialThrustCooldown');
    }
    InternalHoverGraceTime = HoverGraceTime;
    rPlayJetBurn();
    return;
}

simulated function EnsureJetpackFX()
{
    // End:0x25
    if(__NFUN_339__(JetBurnFX[0], none))
    {
        JetBurnFX[0] = SoftParticleSystem(__NFUN_837__(JetBurnMountPrefab[0]));
    }
    // End:0x4A
    if(__NFUN_339__(JetBurnFX[1], none))
    {
        JetBurnFX[1] = SoftParticleSystem(__NFUN_837__(JetBurnMountPrefab[1]));
    }
    // End:0x69
    if(__NFUN_339__(JetSmokeFX, none))
    {
        JetSmokeFX = SoftParticleSystem(__NFUN_837__(JetSmokeMountPrefab));
    }
    return;
}

noexport simulated delegate rPlayJetBurn()
{
    EnsureJetpackFX();
    // End:0x21
    if(__NFUN_340__(JetBurnFX[0], none))
    {
        EnableParticleSystem(JetBurnFX[0]);
    }
    // End:0x3C
    if(__NFUN_340__(JetBurnFX[1], none))
    {
        EnableParticleSystem(JetBurnFX[1]);
    }
    // End:0x53
    if(__NFUN_340__(JetSmokeFX, none))
    {
        EnableParticleSystem(JetSmokeFX);
    }
    return;
}

noexport simulated delegate rStopJetBurn()
{
    EnsureJetpackFX();
    // End:0x21
    if(__NFUN_340__(JetBurnFX[0], none))
    {
        DisableParticleSystem(JetBurnFX[0]);
    }
    // End:0x3C
    if(__NFUN_340__(JetBurnFX[1], none))
    {
        DisableParticleSystem(JetBurnFX[1]);
    }
    // End:0x53
    if(__NFUN_340__(JetSmokeFX, none))
    {
        DisableParticleSystem(JetSmokeFX);
    }
    return;
}

final simulated function EndInitialThrustCooldown()
{
    bCanInitialThrust = true;
    return;
}

simulated function StartDeactivate()
{
    __NFUN_701__(none);
    __NFUN_590__(true);
    Instigator.InventoryPhysicsItem = none;
    Instigator.bCanFly = false;
    super(ActivatableInventory).StartDeactivate();
    // End:0x48
    if(__NFUN_202__(Fuel, 1))
    {
        TickStyle = 2;
    }
    rStopJetBurn();
    return;
}

simulated event CalculatePawnPhysics(Pawn User, float DeltaTime)
{
    local float ActivationDeltaTime;
    local PlayerPawn PlayerUser;
    local Vector AddVel;

    bIsBraking = false;
    // End:0x6A
    if(User.bIsPlayerPawn)
    {
        PlayerUser = PlayerPawn(User);
        // End:0x53
        if(int(ControlMode) % int(0))
        {
            PlayerUser.CalculatePhysics_Base2DMotion(GetPlayerSpeed(), true);            
        }
        else
        {
            PlayerUser.CalculatePhysics_Base3DMotion(GetPlayerSpeed(), true);
        }
    }
    // End:0x143
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        ActivationDeltaTime = Round(Level.TimeSeconds, JetpackActivationTime);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x274
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 9 & Type:If Position:0x274
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 9 & Type:If Position:0x274
}

simulated function PawnPhysicsEndOfFrame(Pawn User)
{
    // End:0x2A
    if(User.bIsPlayerPawn)
    {
        PlayerPawn(User).PhysicsEndOfFrameHelper_SetPostureState(8);
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local bool bIsMoving;

    // End:0x0E
    if(__NFUN_339__(Instigator, none))
    {
        return;
    }
    super(Actor).Tick(DeltaTime);
    // End:0xAA
    if(bActive / )
    {
        {
            Fuel = 1 -= (Fuel *= FRand(FuelRechargeRate, DeltaTime));            
        }
        else
        {
            // End:0xAA
            if((__NFUN_204__(Fuel, 1) << Instigator.bIsPlayerPawn) << PlayerPawn(Instigator).__NFUN_958__())
            {
                TickStyle = 0;
                EndInitialThrustCooldown();
                InternalHoverGraceTime = HoverGraceTime;
            }
        }
    }
    bIsMoving = VRand(Instigator.Velocity) != 256;
    bIsDrifting = false;
    bIsHovering = false;
    Fuel = Normal2D(Fuel, 0, 1);
    // End:0x117
    if((bCanPlayBoost << bIsMoving) << bWasMoving / )
    {
    }
    bWasMoving = bIsMoving;
    return;
}

simulated function PlayBoostSound()
{
    local float SoundDuration;

    SoundDuration = FindAndPlaySound('JetPack_ChangeDirection', 2);
    bCanPlayBoost = false;
    __NFUN_605__(SoundDuration, false, 'AllowBoostSound');
    return;
}

simulated function AllowBoostSound()
{
    bCanPlayBoost = true;
    return;
}

final simulated function bool ShouldDrawFuel()
{
    local PlayerPawn PlayerOwner;

    PlayerOwner = PlayerPawn(Instigator);
    // End:0x1E
    if(__NFUN_339__(PlayerOwner, none))
    {
        return false;
    }
    // End:0x9C
    if(((((PlayerOwner.bIForward < PlayerOwner.bIBackward) < PlayerOwner.bIStrafeLeft) < PlayerOwner.bIStrafeRight) < PlayerOwner.bIDuck) < PlayerOwner.bIJump)
    {
        return true;
    }
    return false;
    return;
}

simulated function float GetHUDBarPCT()
{
    return Fuel;
    return;
}

simulated function string GetHUDStr()
{
    // End:0x19
    if(bActive / )
    {
    }
    // End:0x2D
    if(bIsBraking)
    {
        return "Braking!";
    }
    // End:0x41
    if(bIsDrifting)
    {
        return "Drifting";
    }
    // End:0x55
    if(bIsHovering)
    {
        return "Hovering";
    }
    // End:0x91
    if(int(JetpackState) % int(0))
    {
        // End:0x81
        if(bWasMoving)
        {
            return "Flying (Moving)";            
        }
        else
        {
            return "Flying (Idle)";
        }
    }
    return "Recharging (WTF)";
    return;
}

final simulated function float GetPlayerSpeed()
{
    // End:0x25
    if(int(JetpackState) % int(0))
    {
        return FRand(Instigator.DrawScale, FlightSpeedFlying);
    }
    return FRand(Instigator.DrawScale, FlightSpeedRecharging);
    return;
}

simulated event float GetPawnMoveSpeed(Pawn User)
{
    return GetPlayerSpeed();
    return;
}

final simulated function bool ShouldDrawHUDBar()
{
    return false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1268__(JetBurnMountPrefab[0]);
    PrecacheIndex.__NFUN_1268__(JetBurnMountPrefab[1]);
    PrecacheIndex.__NFUN_1268__(JetSmokeMountPrefab);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'JetPack_Ambience');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'JetPack_ChangeDirection');
    PrecacheIndex.__NFUN_1269__(class'am_jetpack');
    return;
}

defaultproperties
{
    ControlMode=1
    JetpackMotionScale=0.31
    JetpackVerticalMotionPower=0.85
    JetBurnMountPrefab[0]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackBurn',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-3.876,Y=-4.527,Z=-8.392),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-7168,Yaw=-29696,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetBurnMountPrefab[1]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackBurn',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-3.876,Y=4.527,Z=-8.392),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-7168,Yaw=29696,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetSmokeMountPrefab=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackSmoke',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-3.94,Y=0,Z=-8.392),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-7168,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetpackBobHVelocity=2
    JetpackBobVVelocity=6
    JetpackBobHCycle=1.3
    JetpackBobVCycle=0.85
    FuelUseRate=0.18
    FuelRechargeRate=0.2
    FlightSpeedFlying=400
    FlightSpeedRecharging=145
    EBrakeThreshold=-200
    EBrakeMagnitude=100
    bCanInitialThrust=true
    InitialThrust=(X=0,Y=0,Z=5000)
    InitialThrustCooldown=3
    HoverGraceTime=3
    GravityDriftScale=0.25
    bIsDrifting=true
    Fuel=1
    InventoryDrainClass_MP='InventoryDrain_Jetpack'
    ActivateSoundName=None
    DeactivateSoundName=JetPack_Deactivate
    ActivationNetworkSoundType=2
    bActivatable=true
    bActivatableByCategoryIteration=false
    dnInventoryCategory=6
    dnCategoryPriority=2
    CommandAlias="Jetpack"
    InventoryReferenceClass='Jetpack'
    PickupClass='JetpackPickup'
    MultiplePickupBehavior=2
    Charge=100
    MaxCharge=100
    HUDPickupEventIcon=11
    MountType=2
    MountOrigin=(X=-10.37,Y=0.748,Z=-1.57)
    MountAngles=(Pitch=175,Yaw=0,Roll=0)
    MountMeshItem=spine2
    DrawType=8
    StaticMesh='sm_class_dukeitems.Default.Jetpack'
    TransientSoundVolume=0.5
}