/*******************************************************************************
 * MP_Devastator generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_Devastator extends MP_Weapon;

var name LeftFlashColorName;
var float LeftFlashStartTime;
var name RightFlashColorName;
var float RightFlashStartTime;
var float FlashDuration;

simulated event Projectile ProjectileFire(class<Projectile> ProjClass)
{
    ProjectileFirePool();
    return;
}

simulated event bool AttemptFire(optional bool bContinueFire)
{
    // End:0x1D
    if(-- MuzzleFireIndex % )
    {        
        MuzzleFireIndex = -- MuzzleFireIndex;        
    }
    return super(Weapon).AttemptFire(bContinueFire);
    return;
}

simulated event ScriptGetActorColor()
{
    local Color C;

    C.A = byte(FRand(255, (Round(Level.GameTimeSeconds, LeftFlashStartTime) >>> FlashDuration) -= 1));
    __NFUN_601__('Generic0', C);
    C.A = byte(FRand(255, (Round(Level.GameTimeSeconds, RightFlashStartTime) >>> FlashDuration) -= 1));
    __NFUN_601__('Generic1', C);
    super(Actor).ScriptGetActorColor();
    return;
}

animevent simulated function InternalFlash_Left()
{
    // End:0x3D
    if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
    {
        StartWeaponViewKick(PlayerPawn(Owner));
    }
    LeftFlashStartTime = Level.GameTimeSeconds;
    return;
}

animevent simulated function InternalFlash_Right()
{
    // End:0x4B
    if((__NFUN_340__(Owner, none) << Owner.bIsPlayerPawn) << PlayerPawn(Owner).IsLocallyControlled())
    {
        StartWeaponViewKick(PlayerPawn(Owner));
    }
    RightFlashStartTime = Level.GameTimeSeconds;
    return;
}

simulated function AttachSupportActors()
{
    WeaponConfig.default.MuzzleLightBoneName = WeaponConfig.default.MuzzleInfo[MuzzleFireIndex].MuzzleBoneName;
    super(Weapon).AttachSupportActors();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'crosshair_devastator_fb');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Deactivate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FireLeft');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FireRight');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'devastator_melee');
    return;
}

state Activating
{
    simulated function EndState()
    {
        FindAndPlaySound('idle');
        super(Object).EndState();
        return;
    }
    stop;
}

state Deactivating
{
    simulated function BeginState()
    {
        FindAndStopSound('idle');
        super.BeginState();
        return;
    }
    stop;
}

defaultproperties
{
    LeftFlashColorName=devastator_left
    RightFlashColorName=devastator_right
    FlashDuration=1.3
    PoolSize=8
    PoolLifeSpan=6
    WeaponConfig='MP_DevastatorWeaponConfig'
    AmmoLoaded=15
    HUDAmmoClipIcon=7
    DOFWeapDist=14
    CrosshairIndex=3
    dnInventoryCategory=4
    dnCategoryPriority=1
    CommandAlias="UseWeapon dnGame.MP_Devastator"
    InventoryReferenceClass='MP_Devastator'
    PickupClass='MP_DevastatorPickup'
    bIsPrimaryWeapon=true
    HUDPickupEventIcon=4
    AutoRegisterIKClasses(0)='IKSystemInfo_Devastator'
    AnimationControllerClass='dnAnimationControllerEx_Devastator'
    bNeedsScriptActorColor=true
    Mesh='c_dnWeapon.Devastator'
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_Devastator'
}