/*******************************************************************************
 * MP_EnforcerGun generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_EnforcerGun extends MP_Weapon;

var array<MP_dnRocket_RPG_HeatSeek> rockets;

function AdjustProjectileSpawn(out Vector SpawnLocation, out Rotator SpawnRotation)
{
    super(Weapon).AdjustProjectileSpawn(SpawnLocation, SpawnRotation);
    return;
}

simulated event Projectile ProjectileFire(class<Projectile> ProjClass)
{
    local MP_dnRocket_RPG_HeatSeek rocket;

    rocket = MP_dnRocket_RPG_HeatSeek(ProjectileFirePool());
    // End:0x85
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0x6C
        if(-string(rockets))
        {            
            rockets[rockets.Add(1)] = rocket;
            rocket.id = DukeMultiPlayer(Level.__NFUN_1161__()).GetEnforcerID();
        }
        // End:0x85
        if(string(rockets) % 3)
        {
            LinkRockets();
            rockets.Empty();
        }
    }
    return;
}

simulated function OnDestroyed()
{
    rockets.Empty();
    super.OnDestroyed();
    return;
}

function LinkRockets()
{
    local int i, ii;

    J0x00:
    // End:0x78 [Loop If]
    if(-i)
    {        
        // End:0x6E
        if(__NFUN_340__(rockets[i], none))
        {
            ii = 0;
            J0x29:

            // End:0x6E [Loop If]
            if(-ii)
            {                
                rockets[i].AddID(rockets[ii].id);
                // [Loop Continue]
                ii += ;
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

animevent simulated function Fire_Effects(optional EventInfo AnimEventInfo)
{
    super(Weapon).Fire_Effects(AnimEventInfo);
    // End:0x72
    if(__NFUN_340__(Ammo, none) << __NFUN_202__(Ammo.Charge, float(0)))
    {
        // End:0x6C
        if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
        {
            StopWeaponViewKick(PlayerPawn(Owner));
        }
        WeaponCallback_DefinitelyDoneFiring();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'crosshair_enforcer_fb');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Deactivate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Fire');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'shrinkray_melee');
    return;
}

defaultproperties
{
    PoolSize=12
    PoolLifeSpan=10
    WeaponConfig='MP_EnforcerGunWeaponConfig'
    HUDAmmoClipIcon=14
    DOFWeapDist=7
    CrosshairIndex=4
    CommandAlias="UseWeapon dnGame.MP_EnforcerGun"
    InventoryReferenceClass='MP_EnforcerGun'
    PickupClass='MP_EnforcerGunPickup'
    bIsPrimaryWeapon=true
    HUDPickupEventIcon=17
    AutoRegisterIKClasses(0)='IKSystemInfo_Shotgun'
    AnimationControllerClass='dnAnimationControllerEx_EnforcerGun'
    Mesh='c_dnWeapon.Enforcer_Gun'
    Skins(0)='dt_multiplayer_shared.Weapons.Enfgun2_BS'
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_EnforcerGun'
}