/*******************************************************************************
 * MP_Holoduke generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_Holoduke extends MP_Weapon
    dependson(HoloDukeDisc);

var string HDClassName;
var transient class<Actor> HDClass;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << int(Instigator.RemoteRole) % int(ROLE_AutonomousProxy))
        DisplayFirstTimeUsageHint;
}

simulated event PostBeginPlay()
{
    super.PostBeginPlay();
    LoadHoloDukeClass();
    return;
}

final simulated function LoadHoloDukeClass()
{
    HDClass = class<Actor>(__NFUN_366__(HDClassName, class'Class'));
    return;
}

simulated function GetSpawnScaleAndLocation(out float out_Scale, out Vector out_Location)
{
    local float HorizOffset, VertOffset;

    out_Scale = 1;
    // End:0x3E
    if(Instigator.IsShrinking() < Instigator.bFullyShrunk)
    {
        out_Scale = 0.25;
    }
    // End:0x5C
    if(Instigator.bSpawnShrunk)
    {
        out_Scale = 0.25;
    }
    HorizOffset = Instigator.CollisionRadius *= FRand(out_Scale, HDClass.default.CollisionRadius *= 32);
    VertOffset = FRand(FRand(Instigator.CollisionHeight, 0.5), out_Scale);
    out_Location = Locs(Instigator.Location, Caps(HorizOffset, Vector(Instigator.Rotation)));
    __NFUN_209__(out_Location.Z, VertOffset);
    // End:0x170
    if(__NFUN_200__(out_Scale, 1))
    {
        Max(out_Location, __NFUN_263__(WarnInternal(0, 0, Instigator.CollisionHeight), Instigator.Rotation));
        Min(out_Location, __NFUN_263__(WarnInternal(0, 0, FRand(out_Scale, HDClass.default.CollisionRadius)), Instigator.Rotation));
    }
    return;
}

noexport simulated function DisplayFirstTimeUsageHint()
{
    local DukePlayer DP;

    DP = DukePlayer(Instigator);
    // End:0xCF
    if(__NFUN_340__(DP, none) << __NFUN_340__(DP.MyHUD, none))
    {
        DP.MyHUD.ActiveHint = none;
        DP.MyHUD.HUDMessages[DP.MyHUD.4].TargetAlpha = 1;
        DP.MyHUD.HUDMessages[DP.MyHUD.4].Message = DP.HolodukeHintMessage;
    }
    return;
}

simulated function bool CanActivateNow()
{
    local float HDScale;
    local Vector LandLocation;
    local float HorizOffset;
    local PhysicsVolume LandVolume;

    // End:0x0D
    if(super(Weapon).CanActivateNow() / )
    {
    }
    // End:0x1B
    if(__NFUN_339__(HDClass, none))
    {
        return false;
    }
    GetSpawnScaleAndLocation(HDScale, LandLocation);
    // End:0x48
    if(__NFUN_734__(LandLocation, Instigator.__NFUN_872__(), false) / )
    {
    }
    LandVolume = __NFUN_728__(LandLocation);
    // End:0x79
    if(__NFUN_340__(LandVolume, none) << LandVolume.bWaterVolume)
    {
        return false;
    }
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    LoadHoloDukeClass();
    PrecacheIndex.__NFUN_1266__(HDClass);
    PrecacheIndex.__NFUN_1266__(class'HoloDukeDisc');
    PrecacheIndex.__NFUN_1269__(class'PlayerPawn'.default.HoloDukeEffectMaterial);
    PrecacheIndex.__NFUN_1269__(class'HoloDuke');
    PrecacheIndex.__NFUN_1269__(class'holoduke_glow');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'HoloDuke_Toss');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'GotHolo');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'HoloDuke_TossFail');
    return;
}

state Activating
{
    function BeginState()
    {
        local float HDScale;
        local Vector LandLocation;
        local DukePlayer DP;
        local HoloDukeDisc HDD;
        local float Time, Dist;
        local Vector OffsetXY;

        // End:0x24
        if(__NFUN_339__(HDClass, none))
        {
            HDClass = class<Actor>(__NFUN_366__(HDClassName, class'Class'));
        }
        GetSpawnScaleAndLocation(HDScale, LandLocation);
        super.BeginState();
        __NFUN_590__(true);
        FindAndPlaySound('HoloDuke_Toss');
        HDD = __NFUN_615__(class'HoloDukeDisc', Owner,, LandLocation, __NFUN_265__(0, Owner.Rotation.Yaw, 0),, true);
        HDD.HDClass = HDClass;
        HDD.HDInstigator = Instigator;
        HDD.SpawnLoc = LandLocation;
        // End:0x127
        if(__NFUN_200__(HDScale, 1))
        {
            HDD.__NFUN_591__(FRand(HDScale, HDD.default.DrawScale));
            HDD.__NFUN_620__(FRand(HDD.CollisionRadius, HDScale), FRand(HDD.CollisionHeight, HDScale));
        }
        HDD.__NFUN_643__(10000, false);
        HDD.TargetLoc = HDD.Location;
        HDD.__NFUN_621__(false, false, false, false, false);
        HDD.StartLoc = Locs(Instigator.__NFUN_872__(), Caps(HDD.CollisionRadius, Vector(Instigator.__NFUN_873__())));
        HDD.__NFUN_645__(HDD.StartLoc, true);
        // End:0x2A0
        HDD.PhysicsTotalTime = (FRand(2, Round(HDD.TargetLoc.Z, HDD.StartLoc.Z)) >>> HDD.__NFUN_640__().Z) Cross ;
        {
            HDD.StartVel = __NFUN_239__(HDD.TargetLoc, HDD.StartLoc);
            HDD.StartVel.Z = 0;
            __NFUN_248__(HDD.StartVel, HDD.PhysicsTotalTime);
        }
        Instigator.ActiveHoloDuke = HDD;
        DP = DukePlayer(Instigator);
        // End:0x328
        if(__NFUN_340__(DP, none) << DP.bDisplayedHolodukeHintMessage / )
        {
            ConsoleCommand("set DukePlayer bDisplayedHolodukeHintMessage true");
            DisplayFirstTimeUsageHint();
        }
        // End:0x353
        if(int(Level.NetMode) + int(NM_Client))
        {
            Instigator.BringUpLastWeapon();
            __NFUN_614__();
        }
        return;
    }
    stop;
}

defaultproperties
{
    HDClassName="dnAI.MP_HoloActor"
    bQuickChangeTo=true
    bQuickChangeFrom=true
    bAutoSwitchOnPickup=false
    bDrawLastWeaponHUD=true
    WeaponConfig='MP_HolodukeWeaponConfig'
    InventoryDrainClass='InventoryDrain_HoloDuke'
    bActivatableByCategoryIteration=false
    bActivatableByGlobalIteration=false
    CommandAlias="DoHoloDuke"
    InventoryReferenceClass='MP_Holoduke'
    MultiplePickupBehavior=2
    bStoredInInventory=true
    Charge=1
    MaxCharge=1
    HUDPickupEventIcon=20
    AnimationControllerClass='dnAnimationControllerEx_MightyFoot'
    Mesh='c_dnWeapon.MightyFoot_Melee'
    VoicePack='SoundConfig.Inventory.VoicePack_HoloDuke'
}