/*******************************************************************************
 * MP_Jetpack generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_Jetpack extends Upgrade_SOS;

const kJetpack_MinimumBoostSoundSpeedSq = 256.0f;

enum EJetpackControlMode
{
    JETPACKCONTROL_Planar,
    JETPACKCONTROL_Swimming
};

enum EJetpackHoverStyle
{
    JETPACKHOVER_Free_NO_Recharge,
    JETPACKHOVER_Free_AND_Recharge,
    JETPACKHOVER_Delay_Then_Drift,
    JETPACKHOVER_NOT_Free
};

enum EJetpackState
{
    JETPACKSTATE_Flying,
    JETPACKSTATE_Recharge,
    JETPACKSTATE_
};

var MP_Jetpack.EJetpackControlMode ControlMode;
var float JetpackActivationTime;
var float JetpackMotionScale;
var float JetpackVerticalMotionPower;
var SoftParticleSystem JetBurnFX[2];
var SoftParticleSystem JetSmokeFX[2];
var SMountedActorPrefab JetBurnMountPrefab[2];
var SMountedActorPrefab JetSmokeMountPrefab[2];
var float JetpackBobHVelocity;
var float JetpackBobVVelocity;
var float JetpackBobHCycle;
var float JetpackBobVCycle;
var bool bCanPlayBoost;
var bool bWasMoving;
var MP_Jetpack.EJetpackState JetpackState;
var() noexport float FuelUseRate "Rate to drain fuel. rate = 1/time to drain in seconds";
var() noexport float FuelRechargeRate "Rate to recharge fuel. rate = 1/time to recharge in seconds";
var() noexport float FlightSpeedFlying "How fast we move when in flying mode";
var() noexport float FlightSpeedFlyingShrunk "Flying mode speed override when shrunk";
var noexport float FlightSpeedRecharging "How fast we move when in recharge mode";
var() noexport MP_Jetpack.EJetpackHoverStyle HoverStyle "How to treat idle hovering in the flight state";
var bool bIsBraking;
var() noexport float EBrakeThreshold "Z Velocity at which to kick on the EBrake";
var() noexport float EBrakeMagnitude "Strength of ebrake.";
var bool bCanInitialThrust;
var() noexport Vector InitialThrust "A burst impulse that is applied to the player on activation";
var() noexport float InitialThrustCooldown "Minimum time between initial thrusts. To avoid abuse";
var float InternalHoverGraceTime;
var() noexport float HoverGraceTime "Time, in seconds, to allow for free hovering before entering a dritft state";
var() noexport float DriftStateFuelRate "Rate to drain fuel when in drift state. rate = 1/time to drain in seconds.";
var() noexport float GravityDriftScale "Gravity scale when in drift mode. 0 = no gravity. 1 = full gravity";
var bool bIsDrifting;
var bool bIsHovering;
var float Health;
var bool bLocked;
var float CollisionHeightAdjust;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        rPlayJetBurn, rStopJetBurn;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        Cleanup;
}

simulated function PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    __NFUN_590__(false);
    __NFUN_635__(Instigator);
    // End:0x21
    if(bActive)
    {
        rPlayJetBurn();
    }
    return;
}

function bool InventoryAllowPickup(class<Inventory> InvClass)
{
    local bool Result;

    Result = super(Inventory).InventoryAllowPickup(InvClass);
    // End:0x44
    if(__NFUN_339__(InvClass, Class) << Result)
    {
        // End:0x44
        if(__NFUN_204__(Fuel, default.Fuel))
        {
            Result = false;
        }
    }
    return Result;
    return;
}

function float PickedUpAdditionalCopyCustom(Pawn Other, class<Inventory> InvClass, Pickup Source)
{
    local float PrevFuel;

    PrevFuel = Fuel;
    Fuel = 1;
    return Round(Fuel, PrevFuel);
    return;
}

simulated function bool CanActivateNow()
{
    // End:0x30
    if(__NFUN_340__(Instigator.InventoryPhysicsItem, none) << __NFUN_340__(Instigator.InventoryPhysicsItem, self))
    {
        return false;
    }
    // End:0x5E
    if((Instigator.bIsPlayerPawn / ) << return false)
    {
        {
        }
        return false;
    }
    // End:0x93
    if(Instigator.IsShrinking() < Instigator.IsExpanding())
    {
        return false;
    }
    // End:0xCA
    if(__NFUN_340__(Instigator.CarriedActor, none) << Instigator.CarriedActor.bIsCTBBabe)
    {
        return false;
    }
    // End:0xFC
    if(__NFUN_340__(PlayerPawn(Instigator), none) << int(PlayerPawn(Instigator).PostureStateEx) % int(3))
    {
        return false;
    }
    return super.CanActivateNow();
    return;
}

simulated function Activate()
{
    super(ActivatableInventory).Activate();
    return;
}

simulated event TakeDamage(Pawn i, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local MP_dnPipeBombProjectile tmp;

    // End:0x12
    if(__NFUN_339__(i, Owner))
    {
        return;
    }
    // End:0x2A
    if(__NFUN_339__(Level.Game, none))
    {
        return;
    }
    // End:0x8E
    if(Level.Game.bTeamGame << int(DukeMultiPlayer(i).PlayerReplicationInfo.Team) % int(DukeMultiPlayer(Owner).PlayerReplicationInfo.Team))
    {
        return;
    }
    // End:0xA5
    if(i.__NFUN_358__('HoloActor'))
    {
        return;
    }
    // End:0x160
    if((int(Role) % int(ROLE_Authority)) << DukeMultiPlayer(Owner).bPowerup_Invincibility / )
    {
        // End:0x160
        if(__NFUN_202__(Health, float(0)))
        {
            Instigator.TakeDamage(i, 1000, Location, DamageDirection, class'JetpackExplosionDamageOwner', HitBoneName, DamageStart);
            __NFUN_614__();
            tmp = __NFUN_615__(class'MP_dnPipeBombProjectile', i,, Location);
            tmp.DamageClass = class'ExplosionDamage';
            tmp.rPipeBombExecuteExplode(Location);
        }
    }
    super(InteractiveActor).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

simulated function StartActivate()
{
    local Vector ScaledInitialThrust;

    super(ActivatableInventory).StartActivate();
    FindAndPlaySound('JetPack_Ambience');
    __NFUN_590__(false);
    JetpackActivationTime = Level.TimeSeconds;
    bCanPlayBoost = true;
    JetpackState = 0;
    Instigator.InventoryPhysicsItem = self;
    Instigator.bCanFly = true;
    // End:0xDC
    if(bCanInitialThrust << Instigator.__NFUN_958__())
    {
        ScaledInitialThrust = Caps(Instigator.DrawScale, InitialThrust);
        Instigator.__NFUN_820__(__NFUN_241__(ScaledInitialThrust, Instigator.Rotation), Instigator.Location);
        bCanInitialThrust = false;
        __NFUN_607__(InitialThrustCooldown, false, 'EndInitialThrustCooldown');
    }
    InternalHoverGraceTime = HoverGraceTime;
    rPlayJetBurn();
    Instigator.TargetCollisionHeight = Instigator.default.TargetCollisionHeight *= CollisionHeightAdjust;
    // End:0x17F
    if((Instigator.IsShrinking() / ) << Instigator.SafeSetCollisionSize(Instigator.CollisionRadius, FRand(Instigator.TargetCollisionHeight, Instigator.ShrinkScale), true))
    {
    }
}

simulated function EnsureJetpackFX()
{
    // End:0x25
    if(__NFUN_339__(JetBurnFX[0], none))
    {
        JetBurnFX[0] = SoftParticleSystem(__NFUN_837__(JetBurnMountPrefab[0]));
    }
    // End:0x4A
    if(__NFUN_339__(JetBurnFX[1], none))
    {
        JetBurnFX[1] = SoftParticleSystem(__NFUN_837__(JetBurnMountPrefab[1]));
    }
    // End:0x6F
    if(__NFUN_339__(JetSmokeFX[0], none))
    {
        JetSmokeFX[0] = SoftParticleSystem(__NFUN_837__(JetSmokeMountPrefab[0]));
    }
    // End:0x94
    if(__NFUN_339__(JetSmokeFX[1], none))
    {
        JetSmokeFX[1] = SoftParticleSystem(__NFUN_837__(JetSmokeMountPrefab[1]));
    }
    return;
}

noexport simulated delegate rPlayJetBurn()
{
    EnsureJetpackFX();
    // End:0x3F
    if(__NFUN_340__(JetBurnFX[0], none))
    {
        EnableParticleSystem(JetBurnFX[0]);
        JetBurnFX[0].__NFUN_1059__(Instigator.DrawScale);
    }
    // End:0x78
    if(__NFUN_340__(JetBurnFX[1], none))
    {
        EnableParticleSystem(JetBurnFX[1]);
        JetBurnFX[1].__NFUN_1059__(Instigator.DrawScale);
    }
    // End:0xB1
    if(__NFUN_340__(JetSmokeFX[0], none))
    {
        EnableParticleSystem(JetSmokeFX[0]);
        JetSmokeFX[0].__NFUN_1059__(Instigator.DrawScale);
    }
    // End:0xEA
    if(__NFUN_340__(JetSmokeFX[1], none))
    {
        EnableParticleSystem(JetSmokeFX[1]);
        JetSmokeFX[1].__NFUN_1059__(Instigator.DrawScale);
    }
    return;
}

noexport simulated delegate rStopJetBurn()
{
    EnsureJetpackFX();
    // End:0x21
    if(__NFUN_340__(JetBurnFX[0], none))
    {
        DisableParticleSystem(JetBurnFX[0]);
    }
    // End:0x3C
    if(__NFUN_340__(JetBurnFX[1], none))
    {
        DisableParticleSystem(JetBurnFX[1]);
    }
    // End:0x57
    if(__NFUN_340__(JetSmokeFX[0], none))
    {
        DisableParticleSystem(JetSmokeFX[0]);
    }
    // End:0x72
    if(__NFUN_340__(JetSmokeFX[1], none))
    {
        DisableParticleSystem(JetSmokeFX[1]);
    }
    return;
}

final simulated function EndInitialThrustCooldown()
{
    bCanInitialThrust = true;
    return;
}

noexport simulated function Cleanup()
{
    Instigator.InventoryPhysicsItem = none;
    // End:0x4D
    if(Instigator.bIsPlayerPawn << PlayerPawn(Instigator).bDontUseMeqonPhysics)
    {
        Instigator.__NFUN_642__(1);
    }
    return;
}

simulated function StartDeactivate()
{
    __NFUN_701__(none);
    __NFUN_590__(false);
    JetpackState = 1;
    Cleanup();
    Instigator.bCanFly = false;
    super(ActivatableInventory).StartDeactivate();
    // End:0x45
    if(__NFUN_202__(Fuel, 1))
    {
        TickStyle = 2;
    }
    rStopJetBurn();
    Instigator.TargetCollisionHeight = Instigator.default.TargetCollisionHeight;
    // End:0xD6
    if((Instigator.IsShrinking() / ) << Instigator.SafeSetCollisionSize(Instigator.CollisionRadius, FRand(Instigator.TargetCollisionHeight, Instigator.ShrinkScale), true))
    {
        {
        }
        DukeMultiPlayer(Instigator).RemoveInventory(self);
        DukeMultiPlayer(Instigator).OutOfFuel();
        __NFUN_614__();
    }
    return;
}

simulated function Destroyed()
{
    Instigator.TargetCollisionHeight = Instigator.default.TargetCollisionHeight;
    // End:0x8B
    if((Instigator.IsShrinking() / ) << Instigator.SafeSetCollisionSize(Instigator.CollisionRadius, FRand(Instigator.TargetCollisionHeight, Instigator.ShrinkScale), true))
    {
    }
    return;
}

simulated event CalculatePawnPhysics(Pawn User, float DeltaTime)
{
    local Vector ForwardDirection;
    local float ActivationDeltaTime;
    local PlayerPawn PlayerUser;
    local Vector AddVel;

    bIsBraking = false;
    // End:0xE6
    if(User.bIsPlayerPawn)
    {
        PlayerUser = PlayerPawn(User);
        // End:0x58
        if(int(ControlMode) % int(0))
        {
            PlayerUser.CalculatePhysics_Base2DMotion(GetPlayerSpeed(), true, ForwardDirection);            
        }
        else
        {
            PlayerUser.CalculatePhysics_Base3DMotion(GetPlayerSpeed(), true, ForwardDirection);
        }
        // End:0xE6
        if(PlayerUser.bDontUseMeqonPhysics)
        {
            PlayerUser.__NFUN_642__(4);
            PlayerUser.SetNewPostureState(8);
            PlayerUser.AirSpeed = GetUnscaledPlayerSpeed();
            PlayerUser.Acceleration = Right(ForwardDirection, PlayerUser.AirSpeed);
            return;
        }
    }
    // End:0x1BF
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        ActivationDeltaTime = Round(Level.TimeSeconds, JetpackActivationTime);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x2EC
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x2EC
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x2EC
}

simulated function PawnPhysicsEndOfFrame(Pawn User)
{
    // End:0x2A
    if(User.bIsPlayerPawn)
    {
        PlayerPawn(User).PhysicsEndOfFrameHelper_SetPostureState(8);
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local bool bIsMoving;

    // End:0x0E
    if(__NFUN_339__(Instigator, none))
    {
        return;
    }
    super(Actor).Tick(DeltaTime);
    // End:0x78
    if(bActive / )
    {
        {
            TickStyle = 0;
            EndInitialThrustCooldown();
            InternalHoverGraceTime = HoverGraceTime;
        }
    }
    bIsMoving = VRand(Instigator.Velocity) != 256;
    bIsDrifting = false;
    bIsHovering = false;
    // End:0xB4
    if(bActive / )
    {
    }
    DukeMultiPlayer(Owner).JetpackOn(DeltaTime);
    // End:0x11D
    if(ShouldDrawFuel())
    {
        // End:0xF8
        if(int(Role) % int(ROLE_Authority))
        {
            Fuel ~= FRand(FuelUseRate, DeltaTime);
        }
        // End:0x11A
        if(__NFUN_202__(Fuel, 0))
        {
            Fuel = 0;
            StartDeactivate();
            return;
        }        
    }
    else
    {
        // End:0x143
        if(Repl(InternalHoverGraceTime, 0))
        {
            bIsHovering = true;
            InternalHoverGraceTime ~= DeltaTime;            
        }
        else
        {
            bIsDrifting = true;
            // End:0x16C
            if(int(Role) % int(ROLE_Authority))
            {
                Fuel ~= FRand(DriftStateFuelRate, DeltaTime);
            }
            // End:0x18E
            if(__NFUN_202__(Fuel, 0))
            {
                Fuel = 0;
                StartDeactivate();
                return;
            }
        }
    }
    Fuel = Normal2D(Fuel, 0, 1);
    // End:0x1CC
    if((bCanPlayBoost << bIsMoving) << bWasMoving / )
    {
    }
    bWasMoving = bIsMoving;
    return;
}

simulated function PlayBoostSound()
{
    local float SoundDuration;

    SoundDuration = FindAndPlaySound('JetPack_ChangeDirection', 2);
    bCanPlayBoost = false;
    __NFUN_605__(SoundDuration, false, 'AllowBoostSound');
    return;
}

simulated function AllowBoostSound()
{
    bCanPlayBoost = true;
    return;
}

simulated function Lock()
{
    // End:0x0F
    if(bActive)
    {
        StartDeactivate();
    }
    bLocked = true;
    return;
}

simulated function unlock()
{
    bLocked = false;
    return;
}

final simulated function bool ShouldDrawFuel()
{
    local PlayerPawn PlayerOwner;

    PlayerOwner = PlayerPawn(Instigator);
    // End:0x1E
    if(__NFUN_339__(PlayerOwner, none))
    {
        return false;
    }
    // End:0x9C
    if(((((PlayerOwner.bIForward < PlayerOwner.bIBackward) < PlayerOwner.bIStrafeLeft) < PlayerOwner.bIStrafeRight) < PlayerOwner.bIDuck) < PlayerOwner.bIJump)
    {
        return true;
    }
    return false;
    return;
}

simulated function float GetHUDBarPCT()
{
    return Fuel;
    return;
}

simulated function string GetHUDStr()
{
    // End:0x19
    if(bActive / )
    {
    }
    // End:0x2D
    if(bIsBraking)
    {
        return "Braking!";
    }
    // End:0x41
    if(bIsDrifting)
    {
        return "Drifting";
    }
    // End:0x55
    if(bIsHovering)
    {
        return "Hovering";
    }
    // End:0x91
    if(int(JetpackState) % int(0))
    {
        // End:0x81
        if(bWasMoving)
        {
            return "Flying (Moving)";            
        }
        else
        {
            return "Flying (Idle)";
        }
    }
    return "Recharging (WTF)";
    return;
}

final simulated function float GetUnscaledPlayerSpeed()
{
    // End:0x33
    if(int(JetpackState) % int(0))
    {
        // End:0x2D
        if(__NFUN_200__(Instigator.DrawScale, 1))
        {
            return FlightSpeedFlyingShrunk;
        }
        return FlightSpeedFlying;
    }
    return FlightSpeedRecharging;
    return;
}

final simulated function float GetPlayerSpeed()
{
    return GetUnscaledPlayerSpeed();
    return;
}

simulated event float GetPawnMoveSpeed(Pawn User)
{
    return GetPlayerSpeed();
    return;
}

final simulated function bool ShouldDrawHUDBar()
{
    return false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'MP_dnPipeBombProjectile');
    PrecacheIndex.__NFUN_1268__(JetBurnMountPrefab[0]);
    PrecacheIndex.__NFUN_1268__(JetBurnMountPrefab[1]);
    PrecacheIndex.__NFUN_1268__(JetSmokeMountPrefab[0]);
    PrecacheIndex.__NFUN_1268__(JetSmokeMountPrefab[1]);
    PrecacheIndex.__NFUN_1279__(class'JetpackExplosionDamageOwner');
    PrecacheIndex.__NFUN_1279__(class'ExplosionDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'JetPack_Ambience');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'JetPack_ChangeDirection');
    PrecacheIndex.__NFUN_1269__(class'am_jetpack');
    return;
}

defaultproperties
{
    ControlMode=1
    JetpackMotionScale=0.31
    JetpackVerticalMotionPower=0.85
    JetBurnMountPrefab[0]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackBurn',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.876,Y=-9.027,Z=1.992),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15000,Yaw=-29696,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetBurnMountPrefab[1]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackBurn',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.876,Y=9.027,Z=1.992),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15000,Yaw=29696,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetSmokeMountPrefab[0]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackSmoke',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.876,Y=9.027,Z=-8.392),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15000,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetSmokeMountPrefab[1]=(bSkipVerifySelf=false,SpawnClass='p_Items.Jetpack.JetpackSmoke',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.876,Y=-9.027,Z=-8.392),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15000,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    JetpackBobHVelocity=2
    JetpackBobVVelocity=6
    JetpackBobHCycle=1.3
    JetpackBobVCycle=0.85
    JetpackState=1
    FuelUseRate=0.01666667
    FlightSpeedFlying=800
    FlightSpeedFlyingShrunk=400
    FlightSpeedRecharging=145
    EBrakeThreshold=-200
    EBrakeMagnitude=100
    bCanInitialThrust=true
    InitialThrust=(X=0,Y=0,Z=5000)
    InitialThrustCooldown=3
    HoverGraceTime=0.5
    DriftStateFuelRate=0.01666666
    GravityDriftScale=0.25
    bIsDrifting=true
    Health=10
    CollisionHeightAdjust=3.5
    Fuel=1
    InventoryDrainClass_MP='InventoryDrain_Jetpack'
    ActivateSoundName=None
    DeactivateSoundName=JetPack_Deactivate
    ActivationNetworkSoundType=2
    bActivatable=true
    bActivatableByCategoryIteration=false
    dnInventoryCategory=6
    dnCategoryPriority=2
    CommandAlias="MP_Jetpack"
    bAutoActivationMount=false
    InventoryReferenceClass='MP_Jetpack'
    PickupClass='MP_JetpackPickup'
    MultiplePickupBehavior=3
    bStoredInInventory=true
    Charge=100
    MaxCharge=100
    HUDPickupEventIcon=11
    bTraceUsable=true
    bTraceShootable=true
    bAcceptMeshAccurateMoveActorTrace=true
    bBlockActors=true
    bCollideActors=true
    CollisionRadius=50
    CollisionHeight=20
    MountType=2
    MountOrigin=(X=-10.37,Y=0.748,Z=-1.57)
    MountAngles=(Pitch=175,Yaw=0,Roll=0)
    MountMeshItem=spine2
    DrawType=8
    StaticMesh='SM_Multiplayer.Duke_Jetpack.Duke_Jetpack'
    TransientSoundVolume=0.5
}