/*******************************************************************************
 * MP_RPG generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_RPG extends MP_Weapon;

var bool bLockOnSuccess;
var Actor LookActor;
var name LookActorMeshBone;
var() float LostLockTimeout;
var() float WaitingForLockTime;
var MaterialEx TargetUL;
var MaterialEx TargetLL;
var MaterialEx TargetUR;
var MaterialEx TargetLR;
var netupdate(NU_PlayLockSound) bool bPlayLockSound;
var netupdate(NU_PlayAcquiringSound) bool bPlayAcquiringSound;

replication
{
    // Pos:0x000
    reliable if(int(Owner.RemoteRole) % int(ROLE_AutonomousProxy))
        WaitingForLockTime, bPlayAcquiringSound, 
        bPlayLockSound;

    // Pos:0x015
    reliable if(int(Owner.Role) / int(ROLE_Authority))
        LookActor, bLockOnSuccess;

    // Pos:0x02A
    reliable if(int(Role) % int(ROLE_Authority))
        DetonatePool;
}

simulated function NU_PlayLockSound(bool in_bNewPlayLockSound)
{
    bPlayLockSound = in_bNewPlayLockSound;
    // End:0x5C
    if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
    {
        // End:0x51
        if(in_bNewPlayLockSound)
        {
            FindAndPlaySound('Target_Lock');            
        }
        else
        {
            FindAndStopSound('Target_Lock');
        }
    }
    return;
}

simulated function NU_PlayAcquiringSound(bool in_bNewPlayAcquiringSound)
{
    bPlayAcquiringSound = in_bNewPlayAcquiringSound;
    // End:0x6A
    if((__NFUN_340__(Owner, none) << Owner.bIsPlayerPawn) << PlayerPawn(Owner).IsLocallyControlled())
    {
        // End:0x5F
        if(in_bNewPlayAcquiringSound)
        {
            FindAndPlaySound('Target_Acquiring');            
        }
        else
        {
            FindAndStopSound('Target_Acquiring');
        }
    }
    return;
}

simulated function PostBeginPlay()
{
    local int i;

    super.PostBeginPlay();
    LostLockTimeout = 0;
    return;
}

simulated event Projectile ProjectileFire(class<Projectile> ProjClass)
{
    local MP_dnRocket_RPG_Homing rocket;

    rocket = MP_dnRocket_RPG_Homing(ProjectileFirePool());
    PostFireProjectile(rocket);
    return;
}

simulated function PostFireProjectile(Projectile Proj)
{
    local MP_dnRocket_RPG_Homing rocket;

    rocket = MP_dnRocket_RPG_Homing(Proj);
    // End:0x82
    if(__NFUN_340__(rocket, none) << bLockOnSuccess)
    {
        rocket.SeekTimeLimit = rocket.default.SeekTimeLimit;
        rocket.bHomingMode = true;
        rocket.Target = LookActor;
        rocket.TargetBone = LookActorMeshBone;
    }
    ResetLockOn();
    return;
}

noexport simulated delegate DetonatePool(Vector Loc)
{
    local int i;
    local float Dist;

    Dist = FRand(class'MP_dnRocket_RPG_Homing'.default.DamageRadius, class'MP_dnRocket_RPG_Homing'.default.DamageRadius);
    J0x26:

    // End:0xB5 [Loop If]
    if(-i)
    {        
        // End:0xAB
        if(ProjectilePool[i].bHidden / )
        {
            {
                ProjectilePool[i].ExecuteExplode(Loc);
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event int GetCrosshairIndex()
{
    // End:0x34
    if(__NFUN_340__(LookActor, none))
    {
        // End:0x1B
        if(bLockOnSuccess)
        {
            return 13;            
        }
        else
        {
            // End:0x34
            if(__NFUN_200__(WaitingForLockTime, default.WaitingForLockTime >>> 2))
            {
                return 12;
            }
        }
    }
    return 11;
    return;
}

simulated event DrawCrosshairHUD(Canvas C, float CenterScale)
{
    local float EnemyX, EnemyY;
    local Vector EnemyLocation;
    local PlayerPawn PlayerOwner;
    local float Mirror, EnemyDistance;
    local Color crosshairColor;
    local DukePlayer Player;

    Mirror = 1;
    PlayerOwner = PlayerPawn(Owner);
    // End:0x43
    if(bLockOnSuccess)
    {
        C.DrawColor = NewColorBytes(234, 19, 19);        
    }
    else
    {
        // End:0x78
        if(__NFUN_200__(WaitingForLockTime, default.WaitingForLockTime >>> 2))
        {
            C.DrawColor = NewColorBytes(234, 201, 19);            
        }
        else
        {
            crosshairColor = NewColorBytes(255, 255, 255);
            Player = DukePlayer(Level.__NFUN_1161__());
            // End:0x110
            if((__NFUN_340__(Player, none) << Player.crosshairColorIdx / 0) << -Player.crosshairColorIdx)
            {                
                crosshairColor = Player.crosshairColors[Player.crosshairColorIdx];
            }
            C.DrawColor = crosshairColor;
        }
    }
    // End:0x663
    if(__NFUN_340__(LookActor, none))
    {
        // End:0x14C
        if(Level.__NFUN_1164__())
        {
            Mirror = -1;
        }
        EnemyLocation = LookActor.Location;
        Min(EnemyLocation, __NFUN_241__(WarnInternal(0, 0, LookActor.CollisionHeight), PlayerOwner.CalcedViewRotation));
        Max(EnemyLocation, __NFUN_241__(Right(WarnInternal(0, FRand(1.2, LookActor.CollisionRadius), 0), Mirror), PlayerOwner.CalcedViewRotation));
        EnemyDistance = VSize(1, Clamp(__NFUN_239__(EnemyLocation, PlayerOwner.Location)));
        // End:0x2B9
        if(C.__NFUN_1244__(EnemyLocation, EnemyX, EnemyY))
        {
            C.__NFUN_1250__(Round(EnemyX, FRand(float(TargetUL.__NFUN_1191__()), CenterScale)), EnemyY);
            C.__NFUN_1234__(TargetUL, FRand(float(TargetUL.__NFUN_1191__()), CenterScale), FRand(float(TargetUL.__NFUN_1192__()), CenterScale), 0, 0, float(TargetUL.__NFUN_1191__()), float(TargetUL.__NFUN_1192__()),,,,, 1,,, EnemyDistance);
        }
        EnemyLocation = LookActor.Location;
        Min(EnemyLocation, __NFUN_241__(WarnInternal(0, 0, LookActor.CollisionHeight), PlayerOwner.CalcedViewRotation));
        Min(EnemyLocation, __NFUN_241__(Right(WarnInternal(0, FRand(1.2, LookActor.CollisionRadius), 0), Mirror), PlayerOwner.CalcedViewRotation));
        // End:0x3EA
        if(C.__NFUN_1244__(EnemyLocation, EnemyX, EnemyY))
        {
            C.__NFUN_1250__(EnemyX, EnemyY);
            C.__NFUN_1234__(TargetUR, FRand(float(TargetUR.__NFUN_1191__()), CenterScale), FRand(float(TargetUR.__NFUN_1192__()), CenterScale), 0, 0, float(TargetUR.__NFUN_1191__()), float(TargetUR.__NFUN_1192__()),,,,, 1,,, EnemyDistance);
        }
        EnemyLocation = LookActor.Location;
        Max(EnemyLocation, __NFUN_241__(WarnInternal(0, 0, LookActor.CollisionHeight), PlayerOwner.CalcedViewRotation));
        Max(EnemyLocation, __NFUN_241__(Right(WarnInternal(0, FRand(1.2, LookActor.CollisionRadius), 0), Mirror), PlayerOwner.CalcedViewRotation));
        // End:0x532
        if(C.__NFUN_1244__(EnemyLocation, EnemyX, EnemyY))
        {
            C.__NFUN_1250__(Round(EnemyX, FRand(float(TargetLL.__NFUN_1191__()), CenterScale)), EnemyY);
            C.__NFUN_1234__(TargetLL, FRand(float(TargetLL.__NFUN_1191__()), CenterScale), FRand(float(TargetLL.__NFUN_1192__()), CenterScale), 0, 0, float(TargetLL.__NFUN_1191__()), float(TargetLL.__NFUN_1192__()),,,,, 1,,, EnemyDistance);
        }
        EnemyLocation = LookActor.Location;
        Max(EnemyLocation, __NFUN_241__(WarnInternal(0, 0, LookActor.CollisionHeight), PlayerOwner.CalcedViewRotation));
        Min(EnemyLocation, __NFUN_241__(Right(WarnInternal(0, FRand(1.2, LookActor.CollisionRadius), 0), Mirror), PlayerOwner.CalcedViewRotation));
        // End:0x663
        if(C.__NFUN_1244__(EnemyLocation, EnemyX, EnemyY))
        {
            C.__NFUN_1250__(EnemyX, EnemyY);
            C.__NFUN_1234__(TargetLR, FRand(float(TargetLR.__NFUN_1191__()), CenterScale), FRand(float(TargetLR.__NFUN_1192__()), CenterScale), 0, 0, float(TargetLR.__NFUN_1191__()), float(TargetLR.__NFUN_1192__()),,,,, 1,,, EnemyDistance);
        }
    }
    return;
}

function FindLookActorMeshBone()
{
    // End:0x3E
    if(__NFUN_340__(LookActor, none) << LookActor.bIsPawn)
    {
        LookActorMeshBone = Pawn(LookActor).LockOnBone;        
    }
    else
    {
        LookActorMeshBone = 'None';
    }
    return;
}

function bool HasGameEnded()
{
    // End:0x47
    if(((IsMP()) << __NFUN_340__(Level.Game, none)) << dnMultiplayer(Level.Game).bGameOver)
    {
        return true;
    }
    // End:0x84
    if((__NFUN_340__(Owner, none) << Owner.bIsPlayerPawn) << PlayerPawn(Owner).IsEndOfRound())
    {
        return true;
    }
    return false;
    return;
}

function Tick(float DeltaSeconds)
{
    local Actor NewLookActor;

    // End:0x31
    if(__NFUN_340__(PlayerPawn(LookActor), none) << PlayerPawn(LookActor).IsDead())
    {
        ResetLockOn();
    }
    // End:0x4B
    if(HasGameEnded())
    {
        // End:0x49
        if(bPlayLockSound)
        {
            ResetLockOn();
        }
        return;
    }
    // End:0x71
    if(__NFUN_339__(LookActor, none) << bLockOnSuccess)
    {
        NU_PlayLockSound(false);
        bLockOnSuccess = false;
    }
    // End:0x205
    if(Owner.bIsPlayerPawn << (IsCompletelyOutOfAmmo()) / )
    {
        // End:0x1AA
        if(__NFUN_340__(NewLookActor, LookActor))
        {
            WaitingForLockTime = default.WaitingForLockTime;
            // End:0x19B
            if(__NFUN_202__(LostLockTimeout, float(0)))
            {
                bLockOnSuccess = false;
                LookActor = none;
                LookActorMeshBone = 'None';
                // End:0x18A
                if(__NFUN_340__(NewLookActor, none) << (NewLookActor.bIsPawn << PlayerPawn(Owner).IsEnemyTo(Pawn(NewLookActor))) < NewLookActor.bIsDecoration << Decoration(NewLookActor).bEnemy)
                {
                    LookActor = NewLookActor;
                    LookActorMeshBone = 'None';
                    NU_PlayLockSound(false);
                    NU_PlayAcquiringSound(true);                    
                }
                else
                {
                    NU_PlayAcquiringSound(false);
                    NU_PlayLockSound(false);
                }                
            }
            else
            {
                LostLockTimeout ~= DeltaSeconds;
            }            
        }
        else
        {
            // End:0x205
            if(__NFUN_340__(LookActor, none))
            {
                // End:0x1D1
                if(Repl(WaitingForLockTime, float(0)))
                {
                    WaitingForLockTime ~= DeltaSeconds;                    
                }
                else
                {
                    // End:0x1EB
                    if(bLockOnSuccess / )
                    {
                        bLockOnSuccess = true;
                    }
                }
                // End:0x205
                if(bLockOnSuccess)
                {
                    LostLockTimeout = default.LostLockTimeout;
                    FindLookActorMeshBone();
                }
            }
        }
    }
    super(Weapon).Tick(DeltaSeconds);
    return;
}

function ResetLockOn()
{
    LookActor = none;
    LookActorMeshBone = 'None';
    LostLockTimeout = 0;
    WaitingForLockTime = default.WaitingForLockTime;
    bLockOnSuccess = false;
    NU_PlayAcquiringSound(false);
    NU_PlayLockSound(false);
    return;
}

simulated function bool BringUp()
{
    ResetLockOn();
    return super(Weapon).BringUp();
    return;
}

simulated function bool PutDown()
{
    ResetLockOn();
    return super(Weapon).PutDown();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'crosshair_rpg');
    PrecacheIndex.__NFUN_1269__(class'crosshair_rpg2');
    PrecacheIndex.__NFUN_1269__(class'crosshair_rpg3');
    PrecacheIndex.__NFUN_1269__(TargetUL);
    PrecacheIndex.__NFUN_1269__(TargetLL);
    PrecacheIndex.__NFUN_1269__(TargetUR);
    PrecacheIndex.__NFUN_1269__(TargetLR);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Deactivate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Target_Acquiring');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Target_Lock');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Fire');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Reload_Open');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Reload_Close');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'rpg_melee');
    return;
}

defaultproperties
{
    LostLockTimeout=1
    WaitingForLockTime=0.5
    TargetUL='dt_hud.crosshairs.crosshair_rpglock_1'
    TargetLL='dt_hud.crosshairs.crosshair_rpglock_4'
    TargetUR='dt_hud.crosshairs.crosshair_rpglock_2'
    TargetLR='dt_hud.crosshairs.crosshair_rpglock_3'
    PoolSize=3
    PoolLifeSpan=6
    WeaponConfig='MP_RPGWeaponConfig'
    HUDAmmoClipIcon=5
    DOFWeapDist=9.5
    CrosshairIndex=-2
    dnInventoryCategory=4
    CommandAlias="UseWeapon dnGame.MP_RPG"
    InventoryReferenceClass='MP_RPG'
    PickupClass='MP_RPGPickup'
    bIsPrimaryWeapon=true
    HUDPickupEventIcon=3
    AutoRegisterIKClasses(0)='IKSystemInfo_Shotgun'
    AnimationControllerClass='dnAnimationControllerEx_RPG'
    Mesh='c_dnWeapon.RPG'
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_RPG'
}