/*******************************************************************************
 * MP_dnContinuousFireWeapon generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_dnContinuousFireWeapon extends MP_Weapon
    abstract;

var bool bFiringSoundForFireStart;
var bool bFiringSoundActive;

simulated function EnableFiringSound()
{
    // End:0x20
    if(bFiringSoundActive / )
    {
        FindAndPlaySound('FiringLoop', 1);
    }
    return;
}

simulated function FadeFiringSound()
{
    bFiringSoundActive = false;
    FindAndStopSound('FiringLoop', 3);
    return;
}

simulated function DisableFiringSound()
{
    bFiringSoundActive = false;
    FindAndStopSound('FiringLoop');
    return;
}

simulated function MaybeEnableFiringSound()
{
    // End:0x32
    if((int(WeaponState) % int(4)) < (int(WeaponState) % int(5)) << bFiringSoundForFireStart)
    {
        EnableFiringSound();        
    }
    else
    {
        FadeFiringSound();
    }
    return;
}

simulated function OwnerPause()
{
    super(Actor).OwnerPause();
    DisableFiringSound();
    // End:0x49
    if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
    {
        StopWeaponViewKick(PlayerPawn(Owner));
    }
    return;
}

simulated function OwnerUnpause()
{
    super(Actor).OwnerUnpause();
    MaybeEnableFiringSound();
    return;
}

simulated function OnDestroyed()
{
    super.OnDestroyed();
    DisableFiringSound();
    return;
}

simulated function bool PutDown()
{
    super(Weapon).PutDown();
    FadeFiringSound();
    return;
}

simulated function SetWeaponState(byte NewWeaponState)
{
    super(Weapon).SetWeaponState(NewWeaponState);
    MaybeEnableFiringSound();
    return;
}

simulated function FireSuccess(bool bContinueFire)
{
    super(Weapon).FireSuccess(bContinueFire);
    // End:0x34
    if((bContinueFire / ) << (EnableFiringSound()))
    {
    }
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FiringLoop');
    return;
}

defaultproperties
{
    bAlwaysRelevant=true
}