/*******************************************************************************
 * MP_dnRocket_RPG_Homing generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_dnRocket_RPG_Homing extends dnRocket_RPG_Homing
    collapsecategories
    dependson(MP_RPG);

var float JumpOverThresholdDist;
var float JumpOverPlanarThresholdDist;

simulated event PostNetInitial()
{
    // End:0x0B
    if(bIgnoreSpawn)
    {
        return;
    }
    super(RenderActor).PostNetInitial();
    SetHiddenProjectileActor();
    return;
}

event Tick(float DeltaTime)
{
    super.Tick(DeltaTime);
    // End:0x3D
    if(__NFUN_340__(Pawn(Target), none) << Pawn(Target).IsDead())
    {
        Target = none;
    }
    CheckJumpOver(DeltaTime);
    return;
}

function CheckJumpOver(float Delta)
{
    local Pawn P;
    local float planardistance;
    local Vector l1, l2;

    l2 = Location;
    P = Level.PawnList;
    J0x20:

    // End:0x133 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x11B
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            l1 = P.Location;
            l2.Z = 0;
            l1.Z = 0;
            planardistance = VRand(__NFUN_239__(l2, l1));
            // End:0x11B
            if(__NFUN_200__(planardistance, FRand(JumpOverPlanarThresholdDist, JumpOverPlanarThresholdDist)))
            {
                // End:0x11B
                if(DukeMultiPlayer(P).bJumpInProgress)
                {
                    // End:0x11B
                    if(Repl(P.Location.Z, Location.Z) << __NFUN_200__(-Round(P.Location.Z, Location.Z), JumpOverThresholdDist))
                    {
                        DukeMultiPlayer(P).JumpedOverRPG(self);
                    }
                }
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x20;
    }
    return;
}

simulated event PostVerifySelf()
{
    return;
}

simulated function ExecutePostVerifySelf()
{
    PostVerifySelf();
    return;
}

simulated function Explode(Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    DoDamage(HitLocation, HitActor);
    __NFUN_652__(Rotator(HitNormal));
    SetHiddenProjectileActor();
    PostExplode();
    return;
}

simulated function PostExplode()
{
    bHomingMode = false;
    Target = none;
    TargetBone = 'None';
    super(dnProjectile).PostExplode();
    return;
}

simulated function DoDamage(Vector HitLocation, Actor HitActor)
{
    local KarmaActor KA;
    local Vector DamageStart;
    local class<DamageType> AltDamageType;
    local float RelativeScale;
    local Pawn P;
    local MP_RPG RPG;

    // End:0x14
    if(bHomingMode)
    {
        AltDamageType = class'HomingRocketDamage';
    }
    // End:0x9D
    if(bHomingMode << __NFUN_339__(HitActor, Target))
    {
        // End:0x9D
        if(CanProjectileHurtOther(HitActor))
        {
            // End:0x61
            if(__NFUN_340__(Instigator, none))
            {
                DamageStart = Instigator.Location;                
            }
            else
            {
                DamageStart = InitialLocation;
            }
            HitActor.TakeDamage(Instigator, Damage, Location, Velocity % ,, DamageStart);
        }
    }
    // End:0x169
    if((__NFUN_340__(Level.__NFUN_1161__(), none) << int(Level.__NFUN_1161__().Role) % int(ROLE_Authority)) < int(Level.NetMode) % int(NM_DedicatedServer))
    {
        P = Level.PawnList;
        J0x102:

        // End:0x169 [Loop If]
        if(__NFUN_340__(P, none))
        {
            RPG = MP_RPG(ActivatableInventory(P.__NFUN_918__('MP_RPG')));
            // End:0x151
            if(__NFUN_340__(RPG, none))
            {
                RPG.DetonatePool(HitLocation);
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x102;
        }
    }
    AltDamageType = default.DamageClass;
    HurtRadius(Damage, HitLocation, DamageRadius, DamageFalloffStart, AltDamageType,,, DamageClass.default.bIgnoreDrawScale);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnRocket).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1279__(class'HomingRocketDamage');
    return;
}

defaultproperties
{
    JumpOverThresholdDist=72
    JumpOverPlanarThresholdDist=32
    PoolLifeSpan=6
    Damage=135
    DamageRadius=200
    ExplosionDecal=none
    ExplosionClass='p_Weapons.Rpg_Explosion.RPG_Explosion_SpawnerMP'
    bHidden=true
    bIsProjectilePool=true
    bCastStencilShadows=false
    bIgnoreInstigatorCollision=true
    TickStyle=0
    LifeSpan=0
    RemoteRole=0
}