/*******************************************************************************
 * PipeBomb generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PipeBomb extends PipeBombBase;

var Detonator DetonatorRef;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner)
        DetonatorRef;
}

simulated function bool CanActivate()
{
    return bActivatable << __NFUN_339__(Instigator.CarriedActor, none);
    return;
}

simulated function bool CanActivateNow()
{
    // End:0x1F
    if(__NFUN_340__(GetAlternateInvItem(), self))
    {
        return GetAlternateInvItem().CanActivateNow();
    }
    return super(Weapon).CanActivateNow();
    return;
}

simulated function ActivatableInventory GetAlternateInvItem()
{
    // End:0x45
    if((__NFUN_340__(DetonatorRef, none) << __NFUN_340__(Instigator.Weapon, DetonatorRef)) << DetonatorRef.ActivePipeBombCount ** 0)
    {
        return DetonatorRef;
    }
    return self;
    return;
}

event float GiveTo(Pawn Other, optional bool bTravel)
{
    local dnPipeBombProjectile P;

    super(Weapon).GiveTo(Other, bTravel);
    FindDetonatorRef(Other);
    DetonatorRef.PipeBombRef = self;
    return float(GetTotalAmmo());
    return;
}

function Detonator FindDetonatorRef(Pawn Other, optional bool bTravel)
{
    local PlayerPawn Player;

    DetonatorRef = Detonator(Other.__NFUN_917__(class'Detonator'));
    // End:0x9C
    if(__NFUN_339__(DetonatorRef, none))
    {
        DetonatorRef = Detonator(class'Inventory'.static.SpawnCopy(class'Detonator', none, Other));
        // End:0x71
        if(__NFUN_340__(DetonatorRef, none))
        {
            DetonatorRef.ModifyCopy(none, Other);
        }
        DetonatorRef.Ammo = Ammo;
        DetonatorRef.GiveTo(Other, true);
    }
    Player = PlayerPawn(Other);
    // End:0xCD
    if(__NFUN_340__(Player, none))
    {
        Player.DetonatorRef = DetonatorRef;
    }
    return DetonatorRef;
    return;
}

simulated function Fire(optional bool bContinueFire)
{
    __NFUN_397__('ThrowStart');
    return;
}

function SetupProjectile(Projectile Proj)
{
    super.SetupProjectile(Proj);
    // End:0x31
    if(__NFUN_340__(Proj, none))
    {
        DetonatorRef.AddPipebomb(dnPipeBombProjectile(Proj));
    }
    StartWeaponViewKick(PlayerPawn(Owner));
    return;
}

function AdjustProjectileSpawn(out Vector SpawnLocation, out Rotator SpawnRotation)
{
    SpawnLocation = Locs(Instigator.__NFUN_872__(), __NFUN_263__(Caps(DrawScale, WarnInternal(10, 0, 0)), Instigator.ViewRotation));
    super.AdjustProjectileSpawn(SpawnLocation, SpawnRotation);
    return;
}

simulated function name GetWeaponAnimReq(byte WeaponStateReq, optional out byte byForceReset)
{
    // End:0x1C
    if(int(WeaponState) % int(5))
    {
        byForceReset = 1;
        return 'ThrowStart';
    }
    // End:0x38
    if(int(WeaponState) % int(4))
    {
        byForceReset = 1;
        return 'Throw';
    }
    return super(Weapon).GetWeaponAnimReq(WeaponStateReq, byForceReset);
    return;
}

function float GetThrowForce()
{
    return WeaponConfig.default.ProjectileClass.default.Speed;
    return;
}

simulated function bool ShouldShowHUDAmmoActivate(class<Weapon> OldWeaponClass)
{
    return __NFUN_340__(OldWeaponClass, class'Detonator');
    return;
}

simulated event bool AttemptFire(optional bool bContinueFire)
{
    // End:0x0B
    if(IsCompletelyOutOfAmmo())
    {
        return false;
    }
    return super(Weapon).AttemptFire(bContinueFire);
    return;
}

simulated function WpnDeactivate()
{
    DoneDeactivating();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x69
    if(PrecacheIndex.__NFUN_1285__(self))
    {
        PrecacheIndex.__NFUN_1269__(class'hud_pb_upper_right');
        PrecacheIndex.__NFUN_1266__(class'Detonator');
        PrecacheIndex.__NFUN_1266__(class'PipeBombPickup');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Fire');
    }
    return;
}

state Activating
{
    simulated function BeginState()
    {
        super.BeginState();
        HideWeapon();
        __NFUN_397__('Throw');
        return;
    }
    stop;
}

state ThrowStart
{
    simulated event BeginState()
    {
        SetWeaponState(5);
        return;
    }

    simulated function Unfire()
    {
        __NFUN_397__('Throw');
        return;
    }
    stop;
}

state Throw
{
    simulated event BeginState()
    {
        bDeactivationAllowed = false;
        SetWeaponState(4);
        return;
    }

    animevent simulated function WeaponCallback_DefinitelyDoneFiring()
    {
        bDeactivationAllowed = true;
        ChangeSpeed = 1;
        // End:0x49
        if(__NFUN_340__(DetonatorRef, none) << DetonatorRef.CanActivateNow())
        {
            Instigator.ChangeToWeapon(DetonatorRef);            
        }
        else
        {
            Instigator.BringUpLastWeapon();
        }
        return;
    }
    stop;
}

defaultproperties
{
    UpwardsViewBoost=2048
    RollDamping=0.25
    bQuickChangeTo=true
    bAutoSwitchOnPickup=false
    bDrawLastWeaponHUD=true
    WeaponConfig='PipeBombWeaponConfig'
    HUDAmmoClipIcon=8
    bActivatableByCategoryIteration=false
    bActivatableByGlobalIteration=false
    dnInventoryCategory=3
    dnCategoryPriority=1
    CommandAlias="UseWeapon dnGame.PipeBomb"
    InventoryReferenceClass='PipeBomb'
    HUDPickupEventIcon=6
    AnimationControllerClass='dnAnimationControllerEx_PipeBomb'
    Mesh='c_dnWeapon.PipeBomb'
    VoicePack='SoundConfig.Inventory.VoicePack_PipeBomb'
}