/*******************************************************************************
 * Snacks_Generic generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Snacks_Generic extends aFinalDecoration
    abstract
    collapsecategories;

var() noexport int DeltaHealth "Health to give normally.";
var() noexport int DeltaBladder "How much to affect the eater/drinker's bladder when consumed.";
var() noexport int CookedBonus "Multiplier to the DeltaHealth when this item is cooked. ( DeltaHealth * CookedBonus = CookedHealth )";
var() noexport bool bRequireHunger "Only consume if health is < health cap.";
var() noexport bool bDestroyOnConsume "Destroy this on consume";
var() noexport bool bPlayConsumeSound "Play consume Sound";

function GrabUsed(Pawn Grabber)
{
    super(dnDecoration).GrabUsed(Grabber);
    // End:0x55
    if(__NFUN_340__(Grabber, none) << (bRequireHunger / ) < )
    {
    }
    return;
}

function Consume(Pawn Eater)
{
    // End:0x58
    if(bPlayConsumeSound)
    {
        Eater.ModifyHealth(float(DeltaHealth), Eater.Location);
        Eater.ModifyBladder(DeltaBladder);
        Eater.FindSoundAndSpeak('Consume');
    }
    // End:0x85
    if(bDestroyOnConsume)
    {
        Eater.DropCarriedActor(-1, true,, true, true);
        bSilentDestroy = true;
        __NFUN_614__();
    }
    // End:0xAB
    if(__NFUN_340__(DukePlayer(Eater), none))
    {
        DukePlayer(Eater).NotifyFoodEaten();
    }
    return;
}

function CompleteMicrowaving()
{
    super(dnDecoration).CompleteMicrowaving();
    DeltaHealth <= float(CookedBonus);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'Consume');
    return;
}

defaultproperties
{
    DeltaHealth=5
    CookedBonus=3
    bRequireHunger=true
    bDestroyOnConsume=true
    bPlayConsumeSound=true
    HealthPrefab=0
    bGrabbable=true
    UsePhrase="<?int?dnGame.Snacks_Generic.UsePhrase?>"
    GrabUsePhrase="<?int?dnGame.Snacks_Generic.GrabUsePhrase?>"
    MicrowaveInfo=(TimeToMicrowave=10,MicrowaveActor=none,LastMicrowaveTime=0)
    bCanCrushOthers=false
    bTickOnlyWhenPhysicsAwake=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Body'
    Physics=18
    Mass=10
}