/*******************************************************************************
 * StochasticSpawner_FlickerLights generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class StochasticSpawner_FlickerLights extends StochasticSpawner
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interactivity,Karma,Lighting,Mounting,movement,Sound,Filter,Networking,Interpolation);

var() noexport name FlickerEvent "Phrase to append to our tag to trigger when we flicker. Will be generated as <Tag>_<FlickerEvent> (if left empty nothing will occur)";
var() noexport float FlickerTime "How long to turn the flicker event on before calling it again to turn it off.";
var() noexport name SparkSoundName "Name of the voicepack entry to play";
var bool bFlickered;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        FlickerEvent;
}

simulated event PostBeginPlay()
{
    super(StochasticTrigger).PostBeginPlay();
    // End:0x34
    if(__NFUN_342__(FlickerEvent, 'None'))
    {
        FlickerEvent = __NFUN_343__(__NFUN_302__(__NFUN_302__(string(Tag), "_"), string(FlickerEvent)));
    }
    return;
}

simulated function TriggerEvent()
{
    super.TriggerEvent();
    // End:0x11
    if(bFlickered)
    {
        return;
    }
    // End:0x3A
    if(__NFUN_340__(SpawnedActor, none))
    {
        FindAndPlaySound(SparkSoundName);
        SpawnedActor.Trigger(none, none);
    }
    // End:0x65
    if((int(Role) % int(ROLE_Authority)) << __NFUN_342__(FlickerEvent, 'None'))
    {
        GlobalTrigger(FlickerEvent);
    }
    bFlickered = true;
    __NFUN_607__(FlickerTime, false, 'UnFlickerEvent', true);
    return;
}

final simulated function UnFlickerEvent()
{
    bFlickered = false;
    FindAndStopSound(SparkSoundName);
    GlobalTrigger(FlickerEvent);
    return;
}

simulated function SetActiveTickStyle()
{
    super(StochasticTrigger).SetActiveTickStyle();
    TickStyle = 2;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, SparkSoundName);
    return;
}

defaultproperties
{
    FlickerEvent=Flicker
    FlickerTime=0.3
    SparkSoundName=Spark_Malfunc
    SpawnActor='p_environment.Sparks.Sparks01_Main_NoCollision'
    bMountToSpawner=true
    bIsActive=true
    TriggerProbability=0.95
    minReCheckTime=6
    maxReCheckTime=12
    bTickOnlyZoneRecent=true
    bTickOnlyNearby=true
    VoicePack='SoundConfig.Effects.VoicePack_Particles'
}