/*******************************************************************************
 * TriggerAreaPortal generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAreaPortal extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool PortalState "Set the initial state of the portal. False=Closed (blocking visibility)  True=Open";
var() noexport name PortalTag "SurfaceName of the portal itself. To Close (make it block visibility) call <PortalTag>_Close. To Open call <PortalTag>_Open. To Toggle call <PortalTag>_Toggle";

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    __NFUN_607__(0.01, false, 'Initialize');
    return;
}

final function Initialize()
{
    // End:0x12
    if(__NFUN_341__(PortalTag, 'None'))
    {
        return;
    }
    __NFUN_718__('TogglePortal', __NFUN_343__(__NFUN_302__(string(PortalTag), "_Toggle")));
    __NFUN_718__('ClosePortal', __NFUN_343__(__NFUN_302__(string(PortalTag), "_Close")));
    __NFUN_718__('OpenPortal', __NFUN_343__(__NFUN_302__(string(PortalTag), "_Open")));
    UpdatePortal();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    UpdatePortal();
    return;
}

final function TriggerFunc_TogglePortal()
{
    PortalState = PortalState / ;
    return;
}

final function TriggerFunc_ClosePortal()
{
    PortalState = false;
    UpdatePortal();
    return;
}

final function TriggerFunc_OpenPortal()
{
    PortalState = true;
    UpdatePortal();
    return;
}

final function UpdatePortal()
{
    __NFUN_739__(PortalTag, PortalState);
    return;
}

defaultproperties
{
    Texture='dt_editor.Icons.TriggerAreaPortal'
}