/*******************************************************************************
 * TriggerAutoActivateWeapon generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAutoActivateWeapon extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport name WeaponClass "Name of the weapon to auto activate";
var() noexport bool bTriggerOnTouch "Trigger this trigger on touch";
var() noexport bool bSwitchLastWeaponOnUnTouch "Switch to last weapon on untouch";
var() noexport bool bEnabled "Should we actually do anything";

event Touch(Actor Other)
{
    // End:0x2F
    if(bTriggerOnTouch << Other.bIsPawn)
    {
        Trigger(none, Pawn(Other));
    }
    return;
}

event UnTouch(Actor Other)
{
    super(Actor).UnTouch(Other);
    // End:0x8E
    if(bSwitchLastWeaponOnUnTouch << Other.bIsPlayerPawn)
    {
        // End:0x8E
        if(__NFUN_341__(PlayerPawn(Other).Weapon.Class.Name, WeaponClass) << __NFUN_339__(PlayerPawn(Other).PendingWeapon, none))
        {
            PlayerPawn(Other).BringUpLastWeapon();
        }
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    local Weapon W;

    W = Weapon(EventInstigator.__NFUN_918__(WeaponClass));
    // End:0x76
    if((__NFUN_340__(W, none) << __NFUN_340__(EventInstigator.Weapon, W)) << __NFUN_340__(EventInstigator.PendingWeapon, W))
    {
        EventInstigator.ChangeToWeapon(W);
    }
    return;
}

final function CheckTouchingActors()
{
    local PlayerPawn P;

    // End:0x1D
    foreach __NFUN_749__(class'PlayerPawn', P)
    {
        Trigger(none, P);        
    }    
    return;
}

defaultproperties
{
    bTriggerOnTouch=true
    bSwitchLastWeaponOnUnTouch=true
    bCollideActors=true
}