/*******************************************************************************
 * TriggerMultipleRelay generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerMultipleRelay extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bAllowRepeats "When this is true, then when an index gets hit again, it will allow it to fire off the event again. Otherise the index being hit has to be different than the last one received.";
var() noexport int CurrentIndex "Most recent slot that was 'used'.";
var() noexport name ResetTag "Calling this will reset the CurrentIndex back to the original default setting.";
var() noexport array<name> IncomingTags "Tags that get called to figure out which out event gets used";
var() noexport deprecated array<name> OutgoingEvents "Event to call when we get a matching IncomingTag";
var int OriginalIndex;
var array<int> SpecialEventIDs;

function bool VerifySelf()
{
    local int i;

    // End:0x2E
    if(string(IncomingTags) ** string(OutgoingEvents))
    {
        OutgoingEvents.Insert(string(OutgoingEvents), -- string(IncomingTags));                
    }
    else
    {
        // End:0x59
        if(string(OutgoingEvents) ** string(IncomingTags))
        {
            OutgoingEvents.Remove(string(IncomingTags), -- string(OutgoingEvents));            
        }
    }
    i = 0;
    J0x60:

    // End:0xA8 [Loop If]
    if(-i)
    {        
        // End:0x9E
        if(__NFUN_341__(IncomingTags[i], 'None'))
        {
            IncomingTags.Remove(i, 1);
            OutgoingEvents.Remove(i, 1);
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x13B
    if(string(IncomingTags) * 0)
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " had 0 IncomingTags and realized his life wasn't worth living. "), string(self)), " has left the game with -1 frags."));
        return false;
    }
    return super(Actor).VerifySelf();
    return;
}

function PostVerifySelf()
{
    local int i;

    super(Actor).PostVerifySelf();
    __NFUN_718__('ResetTriggerMultipleRelay', ResetTag);
    OriginalIndex = CurrentIndex;
    SpecialEventIDs.Insert(0, string(IncomingTags));
    i = 0;
    J0x32:

    // End:0x6B [Loop If]
    if(-i)
    {        
        SpecialEventIDs[i] = __NFUN_718__('Relay', IncomingTags[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function TriggerFunc_Relay()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID, i;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    i = 0;
    J0x19:

    // End:0x8E [Loop If]
    if(-i)
    {        
        // End:0x41
        if(SpecialEventID + SpecialEventIDs[i])
        {
            // [Explicit Continue]
            goto J0x84;
        }
        // End:0x84
        if(bAllowRepeats < i + CurrentIndex)
        {
            GlobalTrigger(OutgoingEvents[i], EventInstigator, Other);
            CurrentIndex = i;
            // [Explicit Break]
            goto J0x8E;
        }
        J0x84:

        // [Loop Continue]
        i += ;
    }
    J0x8E:

    return;
}

function TriggerFunc_ResetTriggerMultipleRelay()
{
    CurrentIndex = OriginalIndex;
    return;
}

defaultproperties
{
    CurrentIndex=-1
    Texture='Engine.S_TriggerRelay'
}