/*******************************************************************************
 * TriggerQuestItemHint generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerQuestItemHint extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport class<dnQuestItem> QuestItem "Quest Item to associate with this trigger";
var() noexport SSoundInfo SoundInfo "Sound info the play";
var() noexport float ReTriggerDelay "Minimum time before reminder can be triggered again";
var bool bCanTrigger;

event Trigger(Actor Other, Pawn Instigator)
{
    local DukePlayer C;
    local int i;

    // End:0x7C
    if(bCanTrigger)
    {
        super(Actor).Trigger(Other, Instigator);
        // End:0x56
        foreach __NFUN_747__(class'DukePlayer', C)
        {
            C.RegisterQuestItem(QuestItem);
            C.PlaySoundInfo(1, SoundInfo);            
        }        
        // End:0x7C
        if(Repl(ReTriggerDelay, 0))
        {
            bCanTrigger = false;
            __NFUN_607__(ReTriggerDelay, false, 'ResetSelf');
        }
    }
    return;
}

final function ResetSelf()
{
    bCanTrigger = true;
    return;
}

defaultproperties
{
    bCanTrigger=true
    Texture='dt_editor.Icons.TrigQuest'
}