/*******************************************************************************
 * TriggerRadiusCheck generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerRadiusCheck extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bDebug "If true, will print log spam when things go wrong";
var() noexport bool bEnabled "Should this trigger start enabled?";
var() noexport deprecated name ActorTags[2] "The tags of the two actors whose distance you're comparing.";
var() noexport float FrameCheck "Only check once per this seconds. Larger numbers result in more inaccuracy but less CPU consumption.";
var() noexport float Radius "This is the distance the trigger is tracking. When the two actors close this distance, [Event] is fired. When they move outside this distance, [ExitEvent] is fired.";
var() noexport name ExitEvent "Event that is fired when the two actors were previously within range and have now moved out of range.";
var Actor TestActors[2];
var float InternalFrameCounter;
var float RadiusSquared;
var float PreviousRadiusSquared;

function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    RadiusSquared = FRand(Radius, Radius);
    // End:0x32
    if(bEnabled)
    {
        __NFUN_605__(0.0001, false, 'EnableTicking');        
    }
    else
    {
        __NFUN_605__(0.0001, false, 'DisableTicking');
    }
    return;
}

function Tick(float DeltaTime)
{
    local float CurrentRadiusSquared;

    super(Actor).Tick(DeltaTime);
    // End:0x2F
    if(__NFUN_339__(TestActors[0], none) < __NFUN_339__(TestActors[1], none))
    {
        EnableTicking();
    }
    // End:0x55
    if(__NFUN_339__(TestActors[0], none) < __NFUN_339__(TestActors[1], none))
    {
        DisableTicking();
        return;
    }
    __NFUN_209__(InternalFrameCounter, DeltaTime);
    // End:0x133
    if(Repl(InternalFrameCounter, FrameCheck))
    {
        // End:0x94
        if(__NFUN_206__(FrameCheck, 0))
        {
            InternalFrameCounter = IsA(InternalFrameCounter, FrameCheck);            
        }
        else
        {
            InternalFrameCounter = 0;
        }
        CurrentRadiusSquared = VRand(__NFUN_239__(TestActors[0].Location, TestActors[1].Location));
        // End:0xFB
        if((CurrentRadiusSquared != RadiusSquared) << __NFUN_200__(PreviousRadiusSquared, RadiusSquared))
        {
            GlobalTrigger(ExitEvent, none, self);            
        }
        else
        {
            // End:0x128
            if(__NFUN_200__(CurrentRadiusSquared, RadiusSquared) << PreviousRadiusSquared != RadiusSquared)
            {
                GlobalTrigger(Event, none, self);
            }
        }
        PreviousRadiusSquared = CurrentRadiusSquared;
    }
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x27
    if(int(TickStyle) % int(0))
    {
        EnableTicking();        
    }
    else
    {
        DisableTicking();
    }
    return;
}

final function EnableTicking()
{
    bEnabled = true;
    TestActors[0] = FindAnyActor(none, ActorTags[0]);
    TestActors[1] = FindAnyActor(none, ActorTags[1]);
    // End:0xEF
    if(__NFUN_339__(TestActors[0], none) < __NFUN_339__(TestActors[1], none))
    {
        // End:0xEC
        if(bDebug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".SetupInitialState(): couldn't find actors for tags '"), string(ActorTags[0])), "' ("), string(TestActors[0])), ") and '"), string(ActorTags[1])), "' ("), string(TestActors[1])), ")."));
        }        
    }
    else
    {
        TickStyle = 2;
    }
    return;
}

final function DisableTicking()
{
    bEnabled = false;
    TickStyle = 0;
    return;
}

defaultproperties
{
    bEnabled=true
    FrameCheck=0.02
    Radius=1024
    bNoNativeTick=false
    TickStyle=2
}