/*******************************************************************************
 * TriggerStinger generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerStinger extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var SSoundInfo Stinger;
var() noexport Sound StingerSound "Stinger Sound";
var() noexport float PlayDelay "How long before the music will fade out prior to playing the stinger.";
var() noexport float FadeOutTime "How long it takes for the music to fade out.";
var() noexport name MixerGroupOverride "Mixer group to use instead of SoundFX.";
var() noexport name DonePlayingEvent "What event to trigger when the sound ends (should be musicTrigger).";

event Trigger(Actor Other, Pawn EventInstigator)
{
    local float Duration;

    __NFUN_699__("",, FadeOutTime);
    Stinger.SimpleSingleSound = StingerSound;
    Stinger.Delay = PlayDelay;
    Stinger.MixerGroupOverride = MixerGroupOverride;
    Duration = PlaySoundInfo(3, Stinger);
    __NFUN_607__(Duration *= PlayDelay, false, 'CallDonePlayingEvent');
    return;
}

final function CallDonePlayingEvent()
{
    GlobalTrigger(DonePlayingEvent);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    PrecacheIndex.__NFUN_1274__(StingerSound);
    return;
}

defaultproperties
{
    Stinger=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=false,bNoFilter=true,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=true,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    StingerSound='a_stingers.Combat.Combat_Over_01'
    PlayDelay=2
    FadeOutTime=0.5
    MixerGroupOverride=Special
}