/*******************************************************************************
 * Upgrade_HeatVision generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Upgrade_HeatVision extends Upgrade_ViewMode
    dependson(DukeVisionLight);

var SHUDEffect HUDEffect;
var SHUDEffect HUDEffectRemove;
var SHUDEffect BlackHUDEffect;
var SHUDEffect BlackHUDEffectRemove;
var SMountPrefab DukeVisionLightMountPrefab;
var float DukeVisionIntensityScale;
var float DukeVisionLightRadius;
var Color DukeVisionLightColor;
var Color DukeVisionOffLightColor;
var DukeVisionLight DukeVisionLight;

event TravelPostAccept()
{
    super(Actor).TravelPostAccept();
    // End:0x21
    if(bActive)
    {
        RemoveAllHUDEffects();
        DelayedDeactivation();
        StartActivate();
    }
    return;
}

event PreRemove()
{
    // End:0x1B
    if(bActive)
    {
        StartDeactivate();
        RemoveAllHUDEffects();
        DelayedDeactivation();
    }
    return;
}

function RemoveAllHUDEffects()
{
    RemoveHudEffect(BlackHUDEffect.Name);
    RemoveHudEffect(HUDEffect.Name);
    RemoveHudEffect(BlackHUDEffectRemove.Name);
    RemoveHudEffect(HUDEffectRemove.Name);
    return;
}

function RemoveHudEffect(name HUDEffectName)
{
    local PlayerPawn P;

    P = PlayerPawn(Instigator);
    // End:0x7F
    if(__NFUN_340__(P, none) << __NFUN_340__(P.MyHUD, none))
    {
        J0x34:

        // End:0x7F [Loop If]
        if(P.MyHUD.FindHUDEffectIndex(HUDEffectName) + -1)
        {
            P.MyHUD.RemoveHudEffect(HUDEffectName);
            // [Loop Continue]
            goto J0x34;
        }
    }
    return;
}

final simulated function UpdateDukeVisionLight(bool bLightActive)
{
    // End:0x25
    if(__NFUN_339__(Instigator, none) < Instigator.IsLocallyControlled() / )
    {
    }
    // End:0xC7
    if(bLightActive)
    {
        // End:0x49
        if(__NFUN_339__(DukeVisionLight, none))
        {
            DukeVisionLight = __NFUN_615__(class'DukeVisionLight', self);
        }
        DukeVisionLight.IntensityAlpha = 1;
        DukeVisionLight.LightRadius = DukeVisionLightRadius;
        DukeVisionLight.LightColor = DukeVisionLightColor;
        DukeVisionLight.TickStyle = 3;
        DukeVisionLight.bAlwaysVisible = true;
        DukeVisionLight.__NFUN_633__(DukeVisionLightMountPrefab, Instigator, false);        
    }
    else
    {
        // End:0x14C
        if(__NFUN_340__(DukeVisionLight, none))
        {
            DukeVisionLight.LightIntensity = 0;
            DukeVisionLight.LightRadius = 0;
            DukeVisionLight.LightColor = NewColorBytes(0, 0, 0, 0);
            DukeVisionLight.TickStyle = 0;
            DukeVisionLight.bAlwaysVisible = false;
            DukeVisionLight.__NFUN_631__();
        }
    }
    return;
}

simulated function StartActivate()
{
    local PlayerPawn P;

    P = PlayerPawn(Instigator);
    // End:0x1E
    if(__NFUN_339__(P, none))
    {
        return;
    }
    // End:0x66
    if(__NFUN_340__(P.MyHUD, none) << P.MyHUD.FindHUDEffectIndex(BlackHUDEffect.Name) + -1)
    {
        return;
    }
    super.StartActivate();
    P.__NFUN_577__('DOFBlurAmount', 'DukeVisionOverride', 0.5, 1, 1.75,,,,, 6);
    P.__NFUN_577__('DOFFocalRangeMin', 'DukeVisionOverride', 8, 0, 1.75,,,,, 6);
    P.__NFUN_577__('DOFFocalRangeMax', 'DukeVisionOverride', 512, 0, 1.75,,,,, 6);
    P.__NFUN_577__('DOFFocalDistance', 'DukeVisionOverride', 16, 1, 1.75,,,,, 6);
    // End:0x17C
    if(__NFUN_340__(P.MyHUD, none))
    {
        P.MyHUD.AddHudEffect(BlackHUDEffect);
        P.MyHUD.AddHudEffect(HUDEffect);
    }
    UpdateDukeVisionLight(true);
    // End:0x1B8
    if(P.IsLocallyControlled() << __NFUN_340__(DukeVisionLight, none))
    {
        FindAndPlaySound('DukeVision_Amb', 0,,, DukeVisionLight);
    }
    return;
}

simulated function StartDeactivate()
{
    local PlayerPawn P;

    P = PlayerPawn(Instigator);
    // End:0x1E
    if(__NFUN_339__(P, none))
    {
        return;
    }
    // End:0x66
    if(__NFUN_340__(P.MyHUD, none) << P.MyHUD.FindHUDEffectIndex(BlackHUDEffect.Name) + -1)
    {
        return;
    }
    // End:0xCA
    if(__NFUN_340__(P.MyHUD, none))
    {
        RemoveHudEffect(HUDEffect.Name);
        P.MyHUD.AddHudEffect(BlackHUDEffectRemove);
        P.MyHUD.AddHudEffect(HUDEffectRemove);
    }
    __NFUN_607__(HUDEffectRemove.MaxLife, false, 'DelayedDeactivation');
    return;
}

simulated function DelayedDeactivation()
{
    local PlayerPawn P;

    StartDeactivate();
    P = PlayerPawn(Instigator);
    // End:0x24
    if(__NFUN_339__(P, none))
    {
        return;
    }
    P.__NFUN_583__('DOFBlurAmount', 'DukeVisionOverride');
    P.__NFUN_583__('DOFFocalRangeMin', 'DukeVisionOverride');
    P.__NFUN_583__('DOFFocalRangeMax', 'DukeVisionOverride');
    P.__NFUN_583__('DOFFocalDistance', 'DukeVisionOverride');
    UpdateDukeVisionLight(false);
    // End:0xB9
    if(P.IsLocallyControlled() << __NFUN_340__(DukeVisionLight, none))
    {
        FindAndStopSound('DukeVision_Amb',, DukeVisionLight);
    }
    return;
}

event Destroyed()
{
    super(Inventory).Destroyed();
    // End:0x1F
    if(__NFUN_340__(DukeVisionLight, none))
    {
        DukeVisionLight.__NFUN_614__();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'DukeVisionLight');
    PrecacheIndex.__NFUN_1269__(HUDEffect.Texture);
    PrecacheIndex.__NFUN_1269__(HUDEffectRemove.Texture);
    PrecacheIndex.__NFUN_1269__(BlackHUDEffect.Texture);
    PrecacheIndex.__NFUN_1269__(BlackHUDEffectRemove.Texture);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'DukeVision_Amb');
    PrecacheIndex.__NFUN_1269__(class'DukeVision');
    PrecacheIndex.__NFUN_1269__(class'dukevision_glow');
    return;
}

defaultproperties
{
    HUDEffect=(Name=DukeVisionHUDEffect,Texture='dt_hud.DukeVision.DukeVision_fb',bFullScreen=false,bUseAlphaGraph=false,bUseAlphaRamp=false,bUseAlphaWave=false,bUseScaleXRamp=true,bUseScaleYRamp=true,bCenter=true,bMaintainAspectRatio=false,bTiled=false,bFlipInMirrorMode=false,bAlwaysFirst=true,bLimited=false,bClampAgeScale=true,bUseViewportDims=true,MaxLife=-0.2,UnderwaterTimescale=1,Lifetime=0,AlphaStart=1,AlphaEnd=1,AlphaMid=0,AlphaRampMid=0,AlphaGraph=0,AlphaGraph[1]=0,AlphaGraph[2]=0,AlphaGraph[3]=0,AlphaGraph[4]=0,AlphaGraph[5]=0,AlphaGraph[6]=0,AlphaGraph[7]=0,AlphaGraph[8]=0,AlphaGraph[9]=0,AlphaGraphTime=0,AlphaGraphTime[1]=0,AlphaGraphTime[2]=0,AlphaGraphTime[3]=0,AlphaGraphTime[4]=0,AlphaGraphTime[5]=0,AlphaGraphTime[6]=0,AlphaGraphTime[7]=0,AlphaGraphTime[8]=0,AlphaGraphTime[9]=0,AlphaGraphCount=0,AlphaWaveFreq=0,AlphaWaveAmp=0,AlphaWaveYOffset=0,Alpha=0,ScaleXStart=0,ScaleXEnd=1,ScaleXMid=1,ScaleXRampMid=0.5,ScaleX=0,ScaleYStart=0.01,ScaleYEnd=1,ScaleYMid=0.01,ScaleYRampMid=0.5,ScaleY=0,Rotation=0,RotationVelocity=0,RotationAcceleration=0,Depth=0,DepthScaleFar=0,DepthScaleNear=0,Location=(X=480,Y=360,Z=0),Velocity=(X=0,Y=0,Z=0),Acceleration=(X=0,Y=0,Z=0),x1=0,y1=0,x2=0,y2=0,IgnoredVisionTypes=none)
    HUDEffectRemove=(Name=DukeVisionHUDEffectRemove,Texture='dt_hud.DukeVision.DukeVision_fb',bFullScreen=false,bUseAlphaGraph=false,bUseAlphaRamp=false,bUseAlphaWave=false,bUseScaleXRamp=true,bUseScaleYRamp=true,bCenter=true,bMaintainAspectRatio=false,bTiled=false,bFlipInMirrorMode=false,bAlwaysFirst=true,bLimited=false,bClampAgeScale=true,bUseViewportDims=true,MaxLife=0.2,UnderwaterTimescale=1,Lifetime=0,AlphaStart=1,AlphaEnd=1,AlphaMid=0,AlphaRampMid=0,AlphaGraph=0,AlphaGraph[1]=0,AlphaGraph[2]=0,AlphaGraph[3]=0,AlphaGraph[4]=0,AlphaGraph[5]=0,AlphaGraph[6]=0,AlphaGraph[7]=0,AlphaGraph[8]=0,AlphaGraph[9]=0,AlphaGraphTime=0,AlphaGraphTime[1]=0,AlphaGraphTime[2]=0,AlphaGraphTime[3]=0,AlphaGraphTime[4]=0,AlphaGraphTime[5]=0,AlphaGraphTime[6]=0,AlphaGraphTime[7]=0,AlphaGraphTime[8]=0,AlphaGraphTime[9]=0,AlphaGraphCount=0,AlphaWaveFreq=0,AlphaWaveAmp=0,AlphaWaveYOffset=0,Alpha=0,ScaleXStart=1,ScaleXEnd=0,ScaleXMid=1,ScaleXRampMid=0.5,ScaleX=0,ScaleYStart=1,ScaleYEnd=0,ScaleYMid=0.01,ScaleYRampMid=0.5,ScaleY=0,Rotation=0,RotationVelocity=0,RotationAcceleration=0,Depth=0,DepthScaleFar=0,DepthScaleNear=0,Location=(X=480,Y=360,Z=0),Velocity=(X=0,Y=0,Z=0),Acceleration=(X=0,Y=0,Z=0),x1=0,y1=0,x2=0,y2=0,IgnoredVisionTypes=none)
    BlackHUDEffect=(Name=DukeVisionBlackHack,Texture='Engine.BlackTexture',bFullScreen=true,bUseAlphaGraph=false,bUseAlphaRamp=false,bUseAlphaWave=false,bUseScaleXRamp=false,bUseScaleYRamp=false,bCenter=false,bMaintainAspectRatio=false,bTiled=false,bFlipInMirrorMode=false,bAlwaysFirst=true,bLimited=false,bClampAgeScale=false,bUseViewportDims=false,MaxLife=0.2,UnderwaterTimescale=1,Lifetime=0,AlphaStart=1,AlphaEnd=1,AlphaMid=0,AlphaRampMid=0,AlphaGraph=0,AlphaGraph[1]=0,AlphaGraph[2]=0,AlphaGraph[3]=0,AlphaGraph[4]=0,AlphaGraph[5]=0,AlphaGraph[6]=0,AlphaGraph[7]=0,AlphaGraph[8]=0,AlphaGraph[9]=0,AlphaGraphTime=0,AlphaGraphTime[1]=0,AlphaGraphTime[2]=0,AlphaGraphTime[3]=0,AlphaGraphTime[4]=0,AlphaGraphTime[5]=0,AlphaGraphTime[6]=0,AlphaGraphTime[7]=0,AlphaGraphTime[8]=0,AlphaGraphTime[9]=0,AlphaGraphCount=0,AlphaWaveFreq=0,AlphaWaveAmp=0,AlphaWaveYOffset=0,Alpha=0,ScaleXStart=0,ScaleXEnd=0,ScaleXMid=0,ScaleXRampMid=0,ScaleX=0,ScaleYStart=0,ScaleYEnd=0,ScaleYMid=0,ScaleYRampMid=0,ScaleY=0,Rotation=0,RotationVelocity=0,RotationAcceleration=0,Depth=0,DepthScaleFar=0,DepthScaleNear=0,Location=(X=0,Y=0,Z=0),Velocity=(X=0,Y=0,Z=0),Acceleration=(X=0,Y=0,Z=0),x1=0,y1=0,x2=0,y2=0,IgnoredVisionTypes=none)
    BlackHUDEffectRemove=(Name=DukeVisionBlackHack,Texture='dt_hud.DukeVision.DukeVision_BlackAlphaBlendMaterial',bFullScreen=true,bUseAlphaGraph=false,bUseAlphaRamp=true,bUseAlphaWave=false,bUseScaleXRamp=false,bUseScaleYRamp=false,bCenter=false,bMaintainAspectRatio=false,bTiled=false,bFlipInMirrorMode=false,bAlwaysFirst=true,bLimited=false,bClampAgeScale=false,bUseViewportDims=false,MaxLife=0.5,UnderwaterTimescale=1,Lifetime=0,AlphaStart=1,AlphaEnd=0,AlphaMid=1,AlphaRampMid=0.5,AlphaGraph=0,AlphaGraph[1]=0,AlphaGraph[2]=0,AlphaGraph[3]=0,AlphaGraph[4]=0,AlphaGraph[5]=0,AlphaGraph[6]=0,AlphaGraph[7]=0,AlphaGraph[8]=0,AlphaGraph[9]=0,AlphaGraphTime=0,AlphaGraphTime[1]=0,AlphaGraphTime[2]=0,AlphaGraphTime[3]=0,AlphaGraphTime[4]=0,AlphaGraphTime[5]=0,AlphaGraphTime[6]=0,AlphaGraphTime[7]=0,AlphaGraphTime[8]=0,AlphaGraphTime[9]=0,AlphaGraphCount=0,AlphaWaveFreq=0,AlphaWaveAmp=0,AlphaWaveYOffset=0,Alpha=0,ScaleXStart=0,ScaleXEnd=0,ScaleXMid=0,ScaleXRampMid=0,ScaleX=0,ScaleYStart=0,ScaleYEnd=0,ScaleYMid=0,ScaleYRampMid=0,ScaleY=0,Rotation=0,RotationVelocity=0,RotationAcceleration=0,Depth=0,DepthScaleFar=0,DepthScaleNear=0,Location=(X=0,Y=0,Z=0),Velocity=(X=0,Y=0,Z=0),Acceleration=(X=0,Y=0,Z=0),x1=0,y1=0,x2=0,y2=0,IgnoredVisionTypes=none)
    DukeVisionLightMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=true,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_camera,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    DukeVisionIntensityScale=4
    DukeVisionLightRadius=1024
    DukeVisionLightColor=(R=64,G=128,B=255,A=255)
    bAffectCameraStyle=true
    SpecialCameraStyle=1
    InventoryDrainClass='InventoryDrain_HeatVision'
    ActivateSoundName=DukeVision_Activate
    DeactivateSoundName=DukeVision_Deactivate
    bActivatable=true
    bActivatableByCategoryIteration=false
    bActivatableWhileAttached=true
    dnInventoryCategory=6
    CommandAlias="DoHeatVision"
    InventoryReferenceClass='Upgrade_HeatVision'
    MultiplePickupBehavior=0
    CollisionRadius=5
    CollisionHeight=6
    DrawType=0
}