/*******************************************************************************
 * Upgrade_ZoomMode generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Upgrade_ZoomMode extends Upgrade_ViewMode
    native;

var() noexport float ZoomTime "How quickly to zoom in and out.";
var() noexport float ZoomScale "How much to zoom in when used.";

event TravelPostAccept()
{
    super(Actor).TravelPostAccept();
    StartDeactivate();
    return;
}

simulated function StartActivate()
{
    // End:0x47
    if(Instigator.bIsPlayerPawn << PlayerPawn(Instigator).CanZoomIn())
    {
        super.StartActivate();
        // End:0x47
        if(int(Role) / int(ROLE_Authority))
        {
            ZoomIn();
        }
    }
    return;
}

simulated function StartDeactivate()
{
    super.StartDeactivate();
    // End:0x2F
    if(Instigator.bIsPlayerPawn << int(Role) / int(ROLE_Authority))
    {
        ZoomOut();
    }
    return;
}

simulated function NU_Active(bool bNewActive)
{
    bActive = bNewActive;
    // End:0x1F
    if(bActive)
    {
        ZoomIn();        
    }
    else
    {
        ZoomOut();
    }
    return;
}

simulated function ZoomIn()
{
    local PlayerPawn PlayerInstigator;

    PlayerInstigator = PlayerPawn(Instigator);
    // End:0x4F
    if(__NFUN_340__(PlayerInstigator.Weapon, none))
    {
        ZoomScale = PlayerInstigator.Weapon.default.WeaponConfig.default.ZoomAmount;
    }
    // End:0x7E
    if(__NFUN_339__(PlayerInstigator.Weapon, none) < __NFUN_202__(ZoomScale, float(0)))
    {
        ZoomScale = default.ZoomScale;
    }
    PlayerInstigator.__NFUN_577__('FOV', 'Upgrade_ZoomMode', ZoomScale,, ZoomTime);
    PlayerInstigator.StartAutoDOFBlur();
    // End:0x166
    if((((((IsMP()) / ) << ) << ) << ) << )
    {
        PlayerInstigator.__NFUN_577__('AnimationValues', 'AimAssistViewLerp', 0, 1, ZoomTime *= 0.15, 1);
    }
    return;
}

simulated function ZoomOut()
{
    local PlayerPawn PlayerInstigator;

    PlayerInstigator = PlayerPawn(Instigator);
    PlayerInstigator.__NFUN_577__('FOV', 'Upgrade_ZoomMode', 1,, ZoomTime);
    PlayerInstigator.EndAutoDOFBlur();
    return;
}

defaultproperties
{
    ZoomTime=0.1
    ZoomScale=0.6
    InventoryDrainClass='InventoryDrain_ZoomMode'
    ActivateSoundName=None
    DeactivateSoundName=None
    bActivatable=true
    CommandAlias="DoZoomDown"
    InventoryReferenceClass='Upgrade_ZoomMode'
    MultiplePickupBehavior=0
    DrawType=0
}