/*******************************************************************************
 * VehicleSpaceBase generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class VehicleSpaceBase extends dnControl
    abstract
    native
    collapsecategories
    dependson(VehicleBase)
    dependson(dnRadio);

var() const bool bVehicleRelative;
var() const bool bDriverSeat;
var() const noexport bool bEjectWhenFlipped "Eject the user of this vehicle space when vehicle is flipped.";
var() const noexport bool bAllowUserItemPickup "When true, the pawn using this vehicle space can pick up items that the car drives over.";
var transient float Throttle;
var transient float LeftRightHeading;
var transient bool bGoForward;
var transient bool bGoBackward;
var transient bool bSteerLeft;
var transient bool bSteerRight;
var transient bool bFire;
var transient bool bEjecting;
var transient bool bExiting;
var transient bool bBoost;
var transient bool bZoom;
var transient netupdate(NU_bHandbrake) bool bHandbrake;
var VehicleBase Vehicle;
var Pawn PreviousRider;
var bool bRequireVehicleForUse;
var bool bUseFirstPersonFOV;
var float FirstPersonFOV;
var localized string FlipMessage;
var float FlipReuseTime;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        Vehicle;
}

simulated event PostNetInitial()
{
    super(dnUsableSomething).PostNetInitial();
    // End:0x1A
    if(int(Role) % int(ROLE_SimulatedProxy))
    {
        NetSetVehicle();
    }
    return;
}

simulated function NU_bHandbrake(bool bNewHandbrake)
{
    // End:0x0E
    if(__NFUN_339__(Vehicle, none))
    {
        return;
    }
    // End:0x2A
    if(bNewHandbrake)
    {
        Vehicle.EnableHandBrake();        
    }
    else
    {
        Vehicle.DisableHandBrake();
    }
    return;
}

final simulated function NetSetVehicle()
{
    __NFUN_354__(int(Role) % int(ROLE_SimulatedProxy), "NetSetVehicle - Not simulated!");
    // End:0x58
    if(__NFUN_339__(Vehicle, none) < __NFUN_339__(InternalControlRemapper, none))
    {
        __NFUN_607__(0.1, false, 'NetSetVehicle');
        return;
    }
    SetVehicle(Vehicle);
    Vehicle.VehicleSpaces[Vehicle.VehicleSpaces.Add(1)] = self;
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    // End:0x5F
    if(bMimicOwner / )
    {
        {
            return false;
        }
        // End:0x5F
        if(__NFUN_200__(Level.GameTimeSeconds, FlipReuseTime))
        {
            return false;
        }
    }
    // End:0xA6
    if(__NFUN_340__(Vehicle, none) << __NFUN_200__(Vehicle.oUpness, Vehicle.FlipThreshold))
    {
        return Vehicle.CanBeUsedBy(User);
    }
    return super(dnUsableSomething).CanBeUsedBy(User);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    // End:0x6C
    if((__NFUN_339__(User, EventInstigator) << Repl(-Vehicle.oForwardVelocity, Vehicle.ForwardVelocityThreshold)) << bUsable)
    {
        // End:0x6A
        if(bInternalUseDetach < bPreserveInternalUseDetach / )
        {
        }
        return;
    }
    super(dnUsableSomething).Used(Other, EventInstigator);
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x108
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x108
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x108
}

simulated function SetVehicle(VehicleBase NewVehicle)
{
    local int i;

    Vehicle = NewVehicle;
    // End:0x3E
    if(bVehicleRelative)
    {
        InternalControlRemapper.InterpForceActor = Vehicle;
        InternalControlRemapper.PlayerMountForceActor = Vehicle;
    }
    i = -- string(Vehicle.AdditionalInputHookControlRemappers);    
    J0x57:

    // End:0x98 [Loop If]
    if(i / 0)
    {
        InternalControlRemapper.AddHookActor(Vehicle.AdditionalInputHookControlRemappers[i].ControlRemapper, false, true);
        // [Loop Continue]
        i -= ;
    }
    PretendSelf = Vehicle;
    CalculateCollisionBounds();
    return;
}

function bool CanAttachPawn(Pawn Attachee)
{
    // End:0x12
    if(super.CanAttachPawn(Attachee) / )
    {
    }
    return Vehicle.RequestSpaceEntrance(self, Attachee);
    return;
}

function bool CanDetachPawn(bool bForceDetach)
{
    // End:0x28
    if(Vehicle.bTeleporting < super.CanDetachPawn(bForceDetach) / )
    {
    }
    return Vehicle.RequestSpaceExit(self, User);
    return;
}

simulated function ResetInputState()
{
    Throttle = 0;
    LeftRightHeading = 0;
    bGoForward = false;
    bGoBackward = false;
    bSteerLeft = false;
    bSteerRight = false;
    bFire = false;
    bBoost = false;
    bZoom = false;
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    bEjecting = true;
    ResetInputState();
    EnterSpace(Attachee);
    super.AttachPawnSuccess(Attachee, bForced < IsMP());
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    bExiting = true;
    ResetInputState();
    super.DetachPawnSuccess(bForced);
    // End:0x40
    if(__NFUN_339__(Vehicle.CurrentDrivingVehicleSpace, self))
    {
        Vehicle.TurnIgnitionOff();
    }
    Vehicle.DisableHandBrake();
    Vehicle.SpaceLeft(self);
    return;
}

simulated function AttachComplete()
{
    super(dnUsableSomething).AttachComplete();
    bEjecting = false;
    InternalControlRemapper.AddHookActor(Vehicle, true, false);
    return;
}

simulated function AnimCallback_UserAttached()
{
    super.AnimCallback_UserAttached();
    // End:0x5A
    if(__NFUN_339__(Vehicle.CurrentDrivingVehicleSpace, self))
    {
        // End:0x5A
        if((Vehicle.default.bIgnition + true) < Vehicle.bIgnition + false)
        {
            Vehicle.TurnIgnitionOn();
        }
    }
    return;
}

simulated function DetachComplete()
{
    // End:0x3C
    if(__NFUN_340__(PlayerPawn(User), none))
    {
        PlayerPawn(User).LastFallingDamageTime = Level.GameTimeSeconds *= 0.1;
    }
    // End:0x6E
    if(__NFUN_340__(User, none))
    {
        User.__NFUN_652__(__NFUN_265__(0, User.Rotation.Yaw, 0));
    }
    // End:0x9B
    if(__NFUN_340__(Vehicle, none))
    {
        Vehicle.CurrentDrivingVehicleSpace = none;
        Vehicle.NotifyDetachComplete();
    }
    // End:0xE7
    if((__NFUN_340__(Vehicle, none) << Vehicle.NumFilledSpaces % 0) << int(Vehicle.default.DynamicInteractionClassification) % int(4))
    {
        Vehicle.__NFUN_812__(4);
    }
    super.DetachComplete();
    InternalControlRemapper.RemoveHookActor(Vehicle, true, false);
    return;
}

simulated function CREvent_InterpolatingIn(ControlRemapperEx CR)
{
    super(Actor).CREvent_InterpolatingIn(CR);
    __NFUN_361__('Tick');
    bNoNativeTick = false;
    return;
}

simulated function CREvent_NoUserAttached(ControlRemapperEx CR)
{
    bExiting = false;
    super.CREvent_NoUserAttached(CR);
    __NFUN_362__('Tick');
    bNoNativeTick = true;
    return;
}

simulated function VehicleSpaceTick_FullyEntered(float DeltaTime)
{
    return;
}

simulated function bool SpaceIsFullyEntered()
{
    return __NFUN_341__(__NFUN_399__(), 'idle');
    return;
}

simulated function bool DriverIsExiting()
{
    return bExiting;
    return;
}

simulated function EnterSpace(Pawn Other)
{
    PreviousRider = Other;
    // End:0x32
    if(int(Vehicle.default.DynamicInteractionClassification) % int(4))
    {
        Vehicle.__NFUN_812__(6);
    }
    Vehicle.SpaceEntered(self);
    return;
}

simulated function float VehicleSpace_GetSteerGridY()
{
    return 0;
    return;
}

simulated function VehicleSpaceState_AnimTick()
{
    local PointRegion PR;

    // End:0x15
    if(Vehicle.bTeleporting)
    {
        return;
    }
    // End:0xAA
    if(((((bEjecting / ) << ) << ) << ) << if((User.bIsPlayerPawn / ) << ))
    {
        {
        }
        User.ForceDetachCompleteFromUsableSomething();
    }
    return;
}

function VehicleViewChange()
{
    // End:0x1C
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        InternalControlRemapper.ClearRotationTimer();
    }
    return;
}

simulated function CycleRiderPOV()
{
    local PlayerPawn PlayerUser;

    PlayerUser = PlayerPawn(User);
    // End:0x1E
    if(__NFUN_339__(PlayerUser, none))
    {
        return;
    }
    switch(PlayerUser.VehiclePOV)
    {
        // End:0x3F
        case 0:
            SetRiderPOV(1);
            return;
        // End:0x4E
        case 1:
            SetRiderPOV(0);
            return;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

simulated function SetRiderPOV(Engine.Actor.EVehiclePOV NewPOV, optional bool bDontStore)
{
    local PlayerPawn PlayerUser;

    PlayerUser = PlayerPawn(User);
    // End:0x3B
    if(__NFUN_339__(PlayerUser, none) < int(NewPOV) % int(PlayerUser.VehiclePOV))
    {
        return;
    }
    // End:0x5B
    if(bDontStore / )
    {
    }
    switch(NewPOV)
    {
        // End:0x93
        case 0:
            MouseInputX = 0;
            MouseInputY = 0;
            PlayerUser.bCameraLook = false;
            // End:0xF4
            break;
        // End:0xF1
        case 1:
            PlayerUser.ViewRotation = Vehicle.Rotation;
            PlayerUser.ViewRotation.Pitch != Vehicle.ViewElevationAngle;
            PlayerUser.bCameraLook = true;
            // End:0xF4
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated event bool UsableSomethingOverrideFOV()
{
    // End:0x31
    if(bUseFirstPersonFOV)
    {
        // End:0x31
        if(__NFUN_340__(PlayerUser, none) << int(PlayerUser.VehiclePOV) % int(0))
        {
            return true;
        }
    }
    return super(Decoration).UsableSomethingOverrideFOV();
    return;
}

simulated event float UsableSomethingGetOverrideFOV()
{
    return FirstPersonFOV;
    return;
}

function bool ToggleHeadlights()
{
    return Vehicle.Vehicle_ToggleHeadlights(self);
    return;
}

final simulated function float UpdateStickAlpha(float Current, float Target, float DeltaTime, float MoveRate)
{
    local float UpdateAmount, RetVal;

    UpdateAmount = FRand(DeltaTime, MoveRate);
    // End:0x4B
    if(Repl(Current, Target))
    {
        RetVal = Round(Current, UpdateAmount);
        // End:0x48
        if(__NFUN_200__(RetVal, Target))
        {
            return Target;
        }        
    }
    else
    {
        RetVal = Current *= UpdateAmount;
        // End:0x72
        if(Repl(RetVal, Target))
        {
            return Target;
        }
    }
    return RetVal;
    return;
}

final simulated function ClearAllInput()
{
    bSteerLeft = false;
    bSteerRight = false;
    bGoForward = false;
    bGoBackward = false;
    bHandbrake = false;
    bFire = false;
    bZoom = false;
    return;
}

simulated event bool IsVehicleSpace()
{
    return true;
    return;
}

simulated event VehicleBase GetVehicle()
{
    return Vehicle;
    return;
}

function bool ShouldPassDamageToUser()
{
    return true;
    return;
}

simulated function bool ShouldReceiveDamageFromVehicle()
{
    return true;
    return;
}

simulated function float UsableSomethingGetDamageScale(Pawn Pawn, class<DamageType> DamageType)
{
    // End:0x6B
    if(__NFUN_340__(Vehicle, none) << ShouldReceiveDamageFromVehicle())
    {
        PassedDamageScale = Vehicle.PassedDamageScale;
        PassedDamageScaleAI = Vehicle.PassedDamageScaleAI;
        PassedPhysicsDamageScale = Vehicle.PassedPhysicsDamageScale;
        PassedPhysicsDamageScaleAI = Vehicle.PassedPhysicsDamageScaleAI;
    }
    return super.UsableSomethingGetDamageScale(Pawn, DamageType);
    return;
}

simulated event float GetThrottleInput()
{
    // End:0x100
    if(__NFUN_340__(PlayerUser, none))
    {
        // End:0xAD
        if(PlayerUser.__NFUN_994__())
        {
            // End:0x6C
            if(__NFUN_402__())
            {
                Throttle = 0;
                // End:0x4B
                if(PlayerUser.IsSeatControllerReplicationViewer(209))
                {
                    __NFUN_209__(Throttle, 1);
                }
                // End:0x69
                if(PlayerUser.IsSeatControllerReplicationViewer(208))
                {
                    Throttle ~= 1;
                }                
            }
            else
            {
                Throttle = Round(Normal2D(PlayerUser.aRightTrigger, 0, 1), Normal2D(PlayerUser.aLeftTrigger, 0, 1));
            }            
        }
        else
        {
            // End:0xD1
            if(bGoForward << bGoBackward / )
            {                
            }
            else
            {
                // End:0xF5
                if(bGoBackward << bGoForward / )
                {                    
                }
                else
                {
                    Throttle = 0;
                }
            }
        }
    }
    return Throttle;
    return;
}

simulated function float GetSteeringInput()
{
    // End:0x95
    if(__NFUN_340__(PlayerUser, none))
    {
        // End:0x42
        if(PlayerUser.__NFUN_994__())
        {
            LeftRightHeading = Square(Normal2D(PlayerUser.aStrafe, -1, 1));            
        }
        else
        {
            // End:0x66
            if(bSteerLeft << bSteerRight / )
            {                
            }
            else
            {
                // End:0x8A
                if(bSteerRight << bSteerLeft / )
                {                    
                }
                else
                {
                    LeftRightHeading = 0;
                }
            }
        }
    }
    return LeftRightHeading;
    return;
}

simulated function NU_CurrentStateIndex(int NewIndex)
{
    // End:0x17
    if(NewIndex % 5)
    {
        super.NU_CurrentStateIndex(10);        
    }
    else
    {
        super.NU_CurrentStateIndex(NewIndex);
    }
    return;
}

state() idle
{
    simulated function Tick(float DeltaTime)
    {
        global.Tick(DeltaTime);
        VehicleSpaceTick_FullyEntered(DeltaTime);
        VehicleSpaceState_AnimTick();
        return;
    }

    function VehicleHandBrakeEnable()
    {
        // End:0x23
        if(bHandbrake / )
        {
            Vehicle.EnableHandBrake();
        }
        return;
    }

    function VehicleHandBrakeDisable()
    {
        // End:0x21
        if(bHandbrake)
        {
            bHandbrake = false;
            Vehicle.DisableHandBrake();
        }
        return;
    }

    function VehicleBoostEnable()
    {
        bBoost = true;
        return;
    }

    function VehicleBoostDisable()
    {
        bBoost = false;
        return;
    }

    function VehicleFireDown()
    {
        bFire = true;
        return;
    }

    function VehicleFireUp()
    {
        bFire = false;
        return;
    }

    function VehicleZoomDown()
    {
        bZoom = true;
        return;
    }

    function VehicleZoomUp()
    {
        bZoom = false;
        return;
    }

    function VehicleRadioChange()
    {
        // End:0x54
        if(__NFUN_340__(Vehicle.RadioActor, none) << Vehicle.bEngineForcedOff / )
        {
            Vehicle.RadioActor.TuneNextStation();
        }
        return;
    }

    simulated function bool ControlEventInternal(optional int IntEvent, optional name CustomEventName)
    {
        // End:0xCB
        if(__NFUN_339__(PlayerUser, none) < PlayerUser.__NFUN_994__() / )
        {
            {
                // End:0x2E
                case int(26):
                // End:0x3F
                case int(27):
                    bSteerLeft = true;
                    // End:0xCB
                    break;
                // End:0x50
                case int(28):
                    bSteerLeft = false;
                    // End:0xCB
                    break;
                // End:0x56
                case int(29):
                // End:0x67
                case int(30):
                    bSteerRight = true;
                    // End:0xCB
                    break;
                // End:0x78
                case int(31):
                    bSteerRight = false;
                    // End:0xCB
                    break;
                // End:0x7E
                case int(20):
                // End:0x8F
                case int(21):
                    bGoForward = true;
                    // End:0xCB
                    break;
                // End:0xA0
                case int(22):
                    bGoForward = false;
                    // End:0xCB
                    break;
                // End:0xA6
                case int(23):
                // End:0xB7
                case int(24):
                    bGoBackward = true;
                    // End:0xCB
                    break;
                // End:0xC8
                case int(25):
                    bGoBackward = false;
                    // End:0xCB
                    break;
                // End:0xFFFF
                default:
                    break;
            }/* !MISMATCHING REMOVE, tried Switch got Type:If Position:0x000! */
        }/* !MISMATCHING REMOVE, tried If got Type:Switch Position:0x020! */
        else
        {
            return super(dnControl).ControlEventInternal(IntEvent, CustomEventName);
            return;
        }
    }

    simulated event BeginState()
    {
        super(Object).BeginState();
        ClearAllInput();
        return;
    }

    simulated event QueryInteractKeyInfoState(HUD HUD)
    {
        super(dnUsableSomething).QueryInteractKeyInfoState(HUD);
        // End:0xA4
        if(__NFUN_340__(Vehicle, none))
        {
            // End:0x70
            if((Vehicle.obIsFlipped << (bInternalUseDetach / ) < ) << SetHUDKeyInfoState(HUD, 0, true, 1, false, false, FlipMessage))
            {
                {
                }
                SetHUDKeyInfoState(HUD, 8, true, 20, false, Vehicle.IsBoosting());
            }
        }
        return;
    }
    stop;
}

state() AttachUserLERP
{
    simulated event Tick(float DeltaTime)
    {
        super(dnControl).Tick(DeltaTime);
        VehicleSpaceState_AnimTick();
        return;
    }
    stop;
}

state() DetachUserLERP
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        SetRiderPOV(0, true);
        VehicleSpaceState_AnimTick();
        return;
    }

    simulated event Tick(float DeltaTime)
    {
        super(dnControl).Tick(DeltaTime);
        VehicleSpaceState_AnimTick();
        return;
    }
    stop;
}

state() AttachUserAnim
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        VehicleSpaceState_AnimTick();
        return;
    }

    simulated event Tick(float DeltaTime)
    {
        super(dnControl).Tick(DeltaTime);
        VehicleSpaceState_AnimTick();
        return;
    }
    stop;
}

state() DetachUser
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        VehicleSpaceState_AnimTick();
        return;
    }

    simulated event Tick(float DeltaTime)
    {
        super(dnControl).Tick(DeltaTime);
        VehicleSpaceState_AnimTick();
        return;
    }
    stop;
}

state() Useable
{
    simulated event BeginState()
    {
        ClearAllInput();
        super(Object).BeginState();
        return;
    }
    stop;
}

state AttachUserAnimInstant extends AttachUserAnim
{
    simulated function PlayUserAnim()
    {
        global.PlayUserAnim();
        return;
    }

    simulated event EndState()
    {
        super.EndState();
        return;
    }
    stop;
}

state WaitForReplication
{
    simulated event BeginState()
    {
        __NFUN_361__('Tick');
        bNoNativeTick = false;
        return;
    }

    simulated event Tick(float DeltaTime)
    {
        CurrentStateIndex = 10;
        // End:0x46
        if((__NFUN_340__(User, none) << __NFUN_340__(User.InteractiveDecoration, none)) << __NFUN_340__(Vehicle, none))
        {
            ControlEvent(, 'AttachInstant');
        }
        return;
    }
    stop;
}

defaultproperties
{
    bVehicleRelative=true
    bDriverSeat=true
    bEjectWhenFlipped=true
    bAllowUserItemPickup=true
    bRequireVehicleForUse=true
    FlipMessage="<?int?dnGame.VehicleSpaceBase.FlipMessage?>"
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=AttachUserAnimInstant,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=InstantDecoAttach,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=None,OutEvents=none,Transitions=none,UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=None,OutEvents=none,Transitions=none,UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(9)=(StateName=None,OutEvents=none,Transitions=none,UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(10)=(StateName=WaitForReplication,OutEvents=none,Transitions=((ControlEvent=0,CustomName=AttachInstant,NewState=AttachUserAnimInstant)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    PassedDamageScale=1
    ForceAttachStateName=AttachUserAnimInstant
    ControlRemapperClass='dnControlRemapperEx'
    ViewingAngleThreshold=-2
    bDetachOnDamage=false
    bExitAssumeValid=false
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(ChangeRadioStation),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DA_Sound_SmallSwitch_Standard'DecoActivityDeclarations.DA_Sound_SmallSwitch_Standard'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    bLookWhenHidden=true
    bForceUsePhrase=true
    UsePhrase="<?int?dnGame.VehicleSpaceBase.UsePhrase?>"
    bNoDamage=true
    bTraceShootable=false
    bUseCylinderCollision=true
    bBlockActors=false
    bBlockCamera=false
    bHidden=true
    bNoNativeTick=true
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    bDoOverlayEffect=false
    bAlwaysRelevant=true
    bCollideWorld=false
    DrawType=0
    Mesh=none
}