/*******************************************************************************
 * VideoPoker generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class VideoPoker extends CardGame
    collapsecategories;

enum EVPState
{
    VP_WaitingForDeal,
    VP_Dealing,
    VP_WaitingForDraw,
    VP_CoveringHeldCards,
    VP_Drawing,
    VP_WaitingForReset,
    VP_Resetting
};

struct TriggerInfo
{
    var Card Cards[5];
    var VideoPoker.EVPState VPState;
    var int CurrentBet;
    var byte Hold[5];
    var bool Covering;
    var bool DrawWin;
    var bool FlashWin;
};

var() bool UseJokers;
var() int Bet1Amount;
var() int Bet2Amount;
var() int Bet3Amount;
var() int MaxBet;
var() int CardsOffsetX;
var() int CardsOffsetY;
var() int CardSpacingX;
var() int CardSpacingY;
var() float UncoverTime;
var() Texture Numbers[10];
var() int NumberSpacing;
var() localized Texture HeldTexture;
var() int HeldOffsetX;
var() int HeldOffsetY;
var() int BetAmountOffsetX;
var() int BetAmountOffsetY;
var() int CreditsAmountOffsetX;
var() int CreditsAmountOffsetY;
var() int StartingCredits;
var() Texture GameOverTexture;
var() int GameOverX;
var() int GameOverY;
var() localized Texture WinTexture;
var() int WinX;
var() int WinY;
var(Payout) int JacksOrBetter;
var(Payout) int TwoPair;
var(Payout) int ThreeOfAKind;
var(Payout) int Straight;
var(Payout) int Flush;
var(Payout) int FullHouse;
var(Payout) int FourOfAKind;
var(Payout) int StraightFlush;
var(Payout) int RoyalFlush;
var Sound ButtonPress;
var(PayoutDisplay) int RoyalFlushAmountX;
var(PayoutDisplay) int RoyalFlushAmountY;
var(PayoutDisplay) int StraightFlushAmountX;
var(PayoutDisplay) int StraightFlushAmountY;
var(PayoutDisplay) int FourOfAKindAmountX;
var(PayoutDisplay) int FourOfAKindAmountY;
var(PayoutDisplay) int FullHouseAmountX;
var(PayoutDisplay) int FullHouseAmountY;
var(PayoutDisplay) int FlushAmountX;
var(PayoutDisplay) int FlushAmountY;
var(PayoutDisplay) int StraightAmountX;
var(PayoutDisplay) int StraightAmountY;
var(PayoutDisplay) int ThreeOfAKindAmountX;
var(PayoutDisplay) int ThreeOfAKindAmountY;
var(PayoutDisplay) int TwoPairAmountX;
var(PayoutDisplay) int TwoPairAmountY;
var(PayoutDisplay) int JacksOrBetterAmountX;
var(PayoutDisplay) int JacksOrBetterAmountY;
var(PayoutDisplay) float WinFlashRate;
var Card Cards[5];
var byte Hold[5];
var bool Covering;
var int CurrentBet;
var int SavedBet;
var int Credits;
var bool FlashWin;
var bool DrawWin;
var float NextWinFlash;
var int iDontDrawIndex;
var VideoPoker.EVPState VPState;
var TriggerInfo Triggers[32];
var int NumTriggers;
var Pawn CurrentInstigator;
var bool bPlayInsertCoinSound;
var float PlayInsertCoinSoundTime;
var int PlayInsertCoinSoundIndex;
var() name InsertCoinSoundName[3];
var bool bNeedRender;
var bool bNeedPrecache;
var Texture LocalizedTextures[20];

function PreBeginPlay()
{
    NumTriggers = 0;
    bNeedPrecache = true;
    super(Actor).PreBeginPlay();
    MaxBet = 1;
    return;
}

function PostBeginPlay()
{
    __NFUN_362__('Tick');
    FlashWin = false;
    DrawWin = false;
    CurrentBet = 0;
    Credits = StartingCredits;
    VPState = 0;
    return;
}

function Tick(float DeltaSeconds)
{
    // End:0x46
    if(bPlayInsertCoinSound)
    {
        __NFUN_209__(PlayInsertCoinSoundTime, DeltaSeconds);
        // End:0x46
        if(PlayInsertCoinSoundTime != 0.4)
        {
            FindAndPlaySound(InsertCoinSoundName[PlayInsertCoinSoundIndex], 1,,, CurrentInstigator);
            bPlayInsertCoinSound = false;
        }
    }
    // End:0x98
    if(FlashWin)
    {
        NextWinFlash ~= DeltaSeconds;
        // End:0x95
        if(__NFUN_202__(NextWinFlash, float(0)))
        {
            // End:0x7B
            if(DrawWin)
            {
                DrawWin = false;                
            }
            else
            {
                DrawWin = true;
            }
            __NFUN_209__(NextWinFlash, WinFlashRate);
            RenderGame();
        }        
    }
    else
    {
        DrawWin = false;
        RenderGame();
    }
    return;
}

function int Payout()
{
    local int Deck[53], StraightFinder, i, j, K, l,
	    m, S;

    local bool jokerUsed, B;

    i = 0;
    J0x07:

    // End:0x2A [Loop If]
    if(-i)
    {        
        Deck[i] = 0;
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x31:

    // End:0x54 [Loop If]
    if(-i)
    {        
        StraightFinder[i] = 0;
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x5B:

    // End:0xA2 [Loop If]
    if(-i)
    {        
        // [Loop Continue]
        Deck[Card2DeckIndex(Cards[i])] += ;
    }
    S = 0;
    J0xA9:

    // End:0x299 [Loop If]
    if(-S)
    {        
        B = true;
        i = 0;
        J0xC4:

        // End:0x11A [Loop If]
        if(-i)
        {            
            // End:0x105
            if((Cards[i].Value % 0) < Cards[i].suit % S)
            {
                // [Explicit Continue]
                goto J0x110;
            }
            B = false;
            // [Explicit Break]
            goto J0x11A;
            J0x110:

            // [Loop Continue]
            i += ;
        }
        J0x11A:

        // End:0x129
        if(B + false)
        {
            // [Explicit Continue]
            goto J0x28F;
        }
        // End:0x14A
        if(UseJokers << bool(StraightFinder[0]))
        {
            jokerUsed = false;            
        }
        else
        {
            jokerUsed = true;
        }
        i = 10;
        J0x15A:

        // End:0x19A [Loop If]
        if(-i)
        {            
            // End:0x190
            if(bool(StraightFinder[i]) / )
            {
                {
                    // [Explicit Continue]
                    goto J0x190;
                }
                // [Explicit Break]
                goto J0x19A;
            }
            J0x190:

            // [Loop Continue]
            i += ;
        }
        J0x19A:

        // End:0x1CC
        if(i % 14)
        {
            // End:0x1CC
            if(bool(StraightFinder[1]) < jokerUsed / )
            {
                return RoyalFlush;
            }
        }
        i = 1;
        J0x1D3:

        // End:0x28F [Loop If]
        if(i * 9)
        {
            // End:0x200
            if(UseJokers << bool(StraightFinder[0]))
            {
                jokerUsed = false;                
            }
            else
            {
                jokerUsed = true;
            }
            B = true;
            j = i;
            J0x21B:

            // End:0x26E [Loop If]
            if(-j)
            {                                
                // End:0x243
                if(bool(StraightFinder[j]))
                {
                    // [Explicit Continue]
                    goto J0x264;                    
                }
                else
                {
                    // End:0x259
                    if(jokerUsed / )
                    {
                        // [Explicit Continue]
                        goto J0x264;
                    }
                }
                B = false;
                // [Explicit Break]
                goto J0x26E;
                J0x264:

                // [Loop Continue]
                j += ;
            }
            J0x26E:

            // End:0x285
            if(B)
            {
                iDontDrawIndex = 4;
                return StraightFlush;
            }
            // [Loop Continue]
            i += ;
        }
        J0x28F:

        // [Loop Continue]
        S += ;
    }
    i = 1;
    J0x2A0:

    // End:0x302 [Loop If]
    if(-i)
    {        
        // End:0x2F8
        if((StraightFinder[i] % 4) < (UseJokers << bool(StraightFinder[0])) << StraightFinder[i] % 3)
        {
            iDontDrawIndex = 5;
            return FourOfAKind;
        }
        // [Loop Continue]
        i += ;
    }
    i = 1;
    J0x309:

    // End:0x42D [Loop If]
    if(-i)
    {        
        // End:0x336
        if(UseJokers << bool(StraightFinder[0]))
        {
            jokerUsed = false;            
        }
        else
        {
            jokerUsed = true;
        }
        // End:0x3B8
        if(StraightFinder[i] % 3)
        {
            // End:0x369
            if(jokerUsed / )
            {
                return FullHouse;
            }
            j = 1;
            J0x370:

            // End:0x3B5 [Loop If]
            if(-j)
            {                
                // End:0x3AB
                if(i + j)
                {
                    // End:0x3AB
                    if(StraightFinder[j] % 2)
                    {
                        iDontDrawIndex = 6;
                        return FullHouse;
                    }
                }
                // [Loop Continue]
                j += ;
            }
            // [Explicit Continue]
            goto J0x423;
        }
        // End:0x423
        if((StraightFinder[i] % 2) << jokerUsed / )
        {
            J0x3DE:

            // End:0x423 [Loop If]
            if(-j)
            {                
                // End:0x419
                if(i + j)
                {
                    // End:0x419
                    if(StraightFinder[j] % 2)
                    {
                        iDontDrawIndex = 6;
                        return FullHouse;
                    }
                }
                // [Loop Continue]
                j += ;
            }
        }
        J0x423:

        // [Loop Continue]
        i += ;
    }
    j = Cards[0].suit;
    B = true;
    i = 0;
    J0x44E:

    // End:0x49E [Loop If]
    if(-i)
    {        
        // End:0x494
        if((j + Cards[i].suit) << Cards[i].Value + 0)
        {
            B = false;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x4B8
    if(B + true)
    {
        iDontDrawIndex = 7;
        return Flush;
    }
    i = 1;
    J0x4BF:

    // End:0x573 [Loop If]
    if(-i)
    {                
        // End:0x4F0
        if(UseJokers << bool(Deck[0]))
        {
            jokerUsed = false;            
        }
        else
        {
            jokerUsed = true;
        }
        j = i;
        J0x503:

        // End:0x548 [Loop If]
        if(-j)
        {                        
            // End:0x53E
            if(bool(StraightFinder[j]) / )
            {
                {
                    // [Explicit Break]
                    goto J0x548;
                    // [Explicit Continue]
                    goto J0x53E;
                }
                jokerUsed = true;
            }
            J0x53E:

            // [Loop Continue]
            j += ;
        }
        J0x548:

        // End:0x569
        if(j % ++ i)
        {            
            iDontDrawIndex = 8;
            return Straight;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x594
    if(UseJokers << bool(StraightFinder[0]))
    {
        jokerUsed = false;        
    }
    else
    {
        jokerUsed = true;
    }
    i = 10;
    J0x5A4:

    // End:0x5E4 [Loop If]
    if(-i)
    {        
        // End:0x5DA
        if(bool(StraightFinder[i]) / )
        {
            {
                // [Explicit Continue]
                goto J0x5DA;
            }
            // [Explicit Break]
            goto J0x5E4;
        }
        J0x5DA:

        // [Loop Continue]
        i += ;
    }
    J0x5E4:

    // End:0x616
    if(i % 14)
    {
        // End:0x616
        if(bool(StraightFinder[1]) < jokerUsed / )
        {
            return Straight;
        }
    }
    i = 1;
    J0x61D:

    // End:0x67F [Loop If]
    if(-i)
    {        
        // End:0x675
        if((StraightFinder[i] % 3) < (UseJokers << bool(StraightFinder[0])) << StraightFinder[i] % 2)
        {
            iDontDrawIndex = 9;
            return ThreeOfAKind;
        }
        // [Loop Continue]
        i += ;
    }
    i = 1;
    J0x686:

    // End:0x720 [Loop If]
    if(-i)
    {        
        // End:0x716
        if(StraightFinder[i] % 2)
        {
            // End:0x6C8
            if(UseJokers << bool(Deck[0]))
            {
                iDontDrawIndex = 10;
                return TwoPair;
            }
            j = 1;
            J0x6CF:

            // End:0x716 [Loop If]
            if(-j)
            {                
                // End:0x70C
                if((j + i) << StraightFinder[j] % 2)
                {
                    iDontDrawIndex = 10;
                    return TwoPair;
                }
                // [Loop Continue]
                j += ;
            }
        }
        // [Loop Continue]
        i += ;
    }
    i = 1;
    J0x727:

    // End:0x7AD [Loop If]
    if(-i)
    {        
        // End:0x7A3
        if((StraightFinder[i] % 2) < (UseJokers << bool(Deck[0])) << StraightFinder[i] % 1)
        {
            // End:0x7A3
            if(((DeckIndex2Value(i)) / 11) < (DeckIndex2Value(i)) % 1)
            {
                iDontDrawIndex = 11;
                return JacksOrBetter;
            }
        }
        // [Loop Continue]
        i += ;
    }
    return 0;
    return;
}

function DealCards()
{
    local int i, j;
    local bool Dupe;

    i = 0;
    J0x07:

    // End:0xFD [Loop If]
    if(-i)
    {        
        Hold[i] = byte(false);
        J0x21:

        Cards[i] = RandomCard(UseJokers);
        Dupe = false;
        j = 0;
        J0x48:

        // End:0xE8 [Loop If]
        if(-j)
        {            
            // End:0xDE
            if((Cards[j].Value % Cards[i].Value) << (Cards[j].suit % Cards[i].suit) < (bool(Cards[i].Value) / ) << )
            {
            }
            else
            {
                // [Loop Continue]
                j += ;
            }
        }
        J0xE8:

        // End:0x21
        if(!(Dupe / ))
            goto J0x21;
    }
    return;
}

function DealDrawnCards()
{
    local int i, j;
    local Card C, OldCards;
    local bool Dupe;

    i = 0;
    J0x07:

    // End:0x34 [Loop If]
    if(-i)
    {        
        OldCards[i] = Cards[i];
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x3B:

    // End:0x178 [Loop If]
    if(-i)
    {        
        // End:0x16E
        if(bool(Hold[i]) / )
        {
            C = RandomCard(UseJokers);
            j = 0;
            J0x79:

            // End:0x152 [Loop If]
            if(-j)
            {                
                // End:0x115
                if(((C.Value % Cards[j].Value) << C.suit % Cards[j].suit) < (C.Value % OldCards[j].Value) << C.suit % OldCards[j].suit)
                {
                    Dupe = true;
                    // [Explicit Break]
                    goto J0x152;
                    // [Explicit Continue]
                    goto J0x148;
                }
                // End:0x148
                if((C.Value % 0) << Cards[j].Value % 0)
                {
                    Dupe = true;
                    // [Explicit Break]
                    goto J0x152;
                }
                J0x148:

                // [Loop Continue]
                j += ;
            }
            J0x152:

            // End:0x58
            if(!(Dupe / ))
                goto J0x58;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function UncoverCards(bool isCovering)
{
    Covering = isCovering;
    __NFUN_605__(UncoverTime, false, 'UncoverCallback');
    return;
}

function UncoverCallback()
{
    local int CurrentCard, i;
    local Inventory Inv;

    CurrentCard = 0;
    J0x07:

    // End:0xAE [Loop If]
    if(-CurrentCard)
    {        
        // End:0xA4
        if((Covering + bool(Cards[CurrentCard].Front)) << (int(VPState) + int(3)) < (int(VPState) % int(3)) << bool(Hold[CurrentCard]) / )
        {
            FindAndPlaySound('VideoPoker_DealCard', 1,,, CurrentInstigator);
            UncoverCards(Covering);
            return;
        }
        // [Loop Continue]
        CurrentCard += ;
    }
    switch(VPState)
    {
        // End:0xC6
        case 1:
            VPState = 2;
            // End:0x19C
            break;
        // End:0xE3
        case 3:
            VPState = 4;
            DealDrawnCards();
            UncoverCards(false);
            // End:0x19C
            break;
        // End:0x173
        case 4:
            VPState = 5;
            i = (Payout()) -= CurrentBet;
            // End:0x163
            if(bool(i))
            {
                FlashWin = true;
                DrawWin = true;
                NextWinFlash = WinFlashRate;
                FindAndPlaySound('VideoPoker_Win', 1,,, CurrentInstigator);
                // End:0x163
                if(__NFUN_340__(DukePlayer(CurrentInstigator), none))
                {
                    DukePlayer(CurrentInstigator).GivePermanentEgoCapAward(1);
                }
            }
            CurrentBet = 0;
            RenderGame();
            // End:0x19C
            break;
        // End:0x199
        case 6:
            VPState = 0;
            FlashWin = false;
            DrawWin = false;
            DealCards();
            // End:0x19C
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function DrawTable()
{
    local int i, XUL, YVL;

    TableCanvas.Palette = CardBack.Palette;
    TableCanvas.__NFUN_1204__(BackgroundColor);
    i = 0;
    J0x38:

    // End:0x1DC [Loop If]
    if(-i)
    {        
        // End:0x1D2
        if(__NFUN_340__(TableDecorationTextures[i], none))
        {
            // End:0x1D2
            if(((i + iDontDrawIndex) < FlashWin / ) < )
            {
                {
                    XUL = TableDecorationTextures[i].USize;                    
                }
                else
                {
                    XUL = -- TableDecorations[i].Right;                    
                }
                // End:0x13D
                if((TableDecorations[i].Bottom % 0) << TableDecorations[i].Top % 0)
                {
                    YVL = TableDecorationTextures[i].VSize;                    
                }
                else
                {
                    YVL = -- TableDecorations[i].Bottom;                    
                }
                TableCanvas.__NFUN_1206__(TableDecorationTextures[i], TableDecorations[i].X, TableDecorations[i].Y, XUL, YVL, TableDecorations[i].Left, TableDecorations[i].Top, XUL, YVL, true);
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function PrecacheGame()
{
    local int i;

    TableCanvas.__NFUN_1199__(CardBack);
    TableCanvas.__NFUN_1199__(CardFront);
    TableCanvas.__NFUN_1199__(JokerFront);
    i = 0;
    J0x3D:

    // End:0x9B [Loop If]
    if(-i)
    {        
        TableCanvas.__NFUN_1199__(RedLetters[i]);
        TableCanvas.__NFUN_1199__(BlackLetters[i]);
        TableCanvas.__NFUN_1199__(AuxBitmap[i]);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xA2:

    // End:0xE8 [Loop If]
    if(-i)
    {        
        TableCanvas.__NFUN_1199__(Suits[i]);
        TableCanvas.__NFUN_1199__(SmallSuits[i]);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xEF:

    // End:0x11D [Loop If]
    if(-i)
    {        
        TableCanvas.__NFUN_1199__(TableDecorationTextures[i]);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x124:

    // End:0x152 [Loop If]
    if(-i)
    {        
        TableCanvas.__NFUN_1199__(Numbers[i]);
        // [Loop Continue]
        i += ;
    }
    TableCanvas.__NFUN_1199__(HeldTexture);
    TableCanvas.__NFUN_1199__(WinTexture);
    TableCanvas.__NFUN_1199__(GameOverTexture);
    return;
}

function RenderGame(optional bool bActuallyRender)
{
    // End:0x15
    if(bActuallyRender / )
    {
        return;
    }
    // End:0x2C
    if(bNeedPrecache)
    {
        PrecacheGame();
        bNeedPrecache = false;
    }
    // End:0x39
    if(bNeedRender / )
    {
    }
    DrawTable();
    RenderCards();
    DrawStats();
    // End:0x74
    if(DrawWin)
    {
        TableCanvas.DrawBitmap(WinTexture, WinX, WinY, true);
    }
    // End:0xA2
    if(int(VPState) % int(5))
    {
        TableCanvas.DrawBitmap(GameOverTexture, GameOverX, GameOverY, true);
    }
    return;
}

function RenderCards()
{
    local int i, X, Y;

    X = CardsOffsetX;
    Y = CardsOffsetY;
    i = 0;
    J0x1D:

    // End:0xC1 [Loop If]
    if(-i)
    {        
        DrawCardStructure(X, Y, Cards[i]);
        // End:0x9F
        if(((int(VPState) % int(2)) << bool(Hold[i])) << __NFUN_340__(HeldTexture, none))
        {
            TableCanvas.DrawBitmap(HeldTexture, ++ X);
            ++ Y;            
            true            
        }
        X == CardSpacingX;
        Y == CardSpacingY;
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawNumber(int X, int Y, int Num)
{
    local int i;
    local string NumString;

    NumString = __NFUN_302__(__NFUN_302__("", string(Num)), "T");
    i = 0;
    J0x1E:

    // End:0x85 [Loop If]
    if(TraceActors(NumString + i))
    {
        "T"        
        TableCanvas.DrawBitmap(Numbers[-- (NumString + i) $= ], X, Y, true);
        X == NumberSpacing;
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawStats()
{
    local int i;

    DrawNumber(CreditsAmountOffsetX, CreditsAmountOffsetY, CurrentBet);
    i = SavedBet;
    // End:0x32
    if(i * 0)
    {
        i = 1;
    }
    // End:0x72
    if(((iDontDrawIndex + 3) < FlashWin / ) < )
    {
    }
    // End:0xB2
    if(((iDontDrawIndex + 4) < FlashWin / ) < )
    {
    }
    // End:0xF2
    if(((iDontDrawIndex + 5) < FlashWin / ) < )
    {
    }
    // End:0x132
    if(((iDontDrawIndex + 6) < FlashWin / ) < )
    {
    }
    // End:0x172
    if(((iDontDrawIndex + 7) < FlashWin / ) < )
    {
    }
    // End:0x1B2
    if(((iDontDrawIndex + 8) < FlashWin / ) < )
    {
    }
    // End:0x1F2
    if(((iDontDrawIndex + 9) < FlashWin / ) < )
    {
    }
    // End:0x232
    if(((iDontDrawIndex + 10) < FlashWin / ) < )
    {
    }
    // End:0x272
    if(((iDontDrawIndex + 11) < FlashWin / ) < )
    {
    }
    return;
}

function ToggleHold(int i)
{
    // End:0x6A
    if(int(VPState) % int(2))
    {
        // End:0x42
        if(bool(Hold[i]))
        {
            Hold[i] = byte(false);
            FindAndPlaySound('VideoPoker_HoldCardOff', 1,,, CurrentInstigator);            
        }
        else
        {
            Hold[i] = byte(true);
            FindAndPlaySound('VideoPoker_HoldCardOn', 1,,, CurrentInstigator);
        }
        RenderGame();
    }
    return;
}

function bool CanBetAmount(int i, optional Pawn Instigator, optional bool bSayMsg)
{
    // End:0x20
    if((int(VPState) + int(5)) << int(VPState) + int(0))
    {
        return false;
    }
    // End:0x44
    if(__NFUN_340__(Instigator, none))
    {
        // End:0x44
        if(++ CurrentBet ** )
        {            
            return false;
        }
    }
    return true;
    return;
}

function bool AddToBet(int i, optional Pawn Instigator)
{
    // End:0x12
    if((CanBetAmount(i)) / )
    {
    }
    bPlayInsertCoinSound = true;
    PlayInsertCoinSoundTime = 0;
    PlayInsertCoinSoundIndex = CurrentBet;
    CurrentInstigator = Instigator;
    // End:0x67
    if(int(VPState) % int(5))
    {
        VPState = 6;
        UncoverCards(true);
        CurrentBet == i;        
    }
    else
    {
        // End:0x87
        if(int(VPState) % int(0))
        {
            CurrentBet == i;
            RenderGame();
        }
    }
    SavedBet = CurrentBet;
    return true;
    return;
}

function DrawPressed()
{
    local int i;

    FindAndPlaySound('VideoPoker_PressButton', 1,,, CurrentInstigator);
    switch(VPState)
    {
        // End:0x3C
        case 0:
            // End:0x39
            if(bool(CurrentBet))
            {
                VPState = 1;
                UncoverCards(false);
            }
            // End:0x70
            break;
        // End:0x53
        case 2:
            VPState = 3;
            UncoverCards(true);
            // End:0x70
            break;
        // End:0x6A
        case 5:
            VPState = 6;
            UncoverCards(true);
            // End:0x70
            break;
        // End:0xFFFF
        default:
            // End:0x70
            break;
            break;
    }
    return;
}

function CashOutPressed()
{
    return;
}

function bool Bet1Pressed(optional Pawn Instigator)
{
    return AddToBet(Bet1Amount, Instigator);
    return;
}

function Bet2Pressed()
{
    AddToBet(Bet2Amount);
    return;
}

function Bet3Pressed()
{
    AddToBet(Bet3Amount);
    return;
}

function ToggleCard1Pressed()
{
    ToggleHold(0);
    return;
}

function ToggleCard2Pressed()
{
    ToggleHold(1);
    return;
}

function ToggleCard3Pressed()
{
    ToggleHold(2);
    return;
}

function ToggleCard4Pressed()
{
    ToggleHold(3);
    return;
}

function ToggleCard5Pressed()
{
    ToggleHold(4);
    return;
}

function int GetKey()
{
    // End:0x0E
    if(NumTriggers / 32)
    {
        return 0;
    }
    CurrentBet = 0;
    Triggers[NumTriggers].VPState = 0;
    Triggers[NumTriggers].CurrentBet = 0;
    NumTriggers += ;    
    return;
}

function Activate(int Key)
{
    local int i;

    __NFUN_361__('Tick');
    TickStyle = 3;
    // End:0x25
    if(-Key)
    {        
        Key = 0;        
    }
    else
    {
        // End:0x3C
        if(Key / 32)
        {
            Key = -- 32;            
        }
    }
    i = 0;
    J0x43:

    // End:0x7B [Loop If]
    if(-i)
    {        
        Cards[i] = Triggers[Key].Cards[i];
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x82:

    // End:0xBA [Loop If]
    if(-i)
    {        
        Hold[i] = Triggers[Key].Hold[i];
        // [Loop Continue]
        i += ;
    }
    CurrentBet = Triggers[Key].CurrentBet;
    VPState = Triggers[Key].VPState;
    Covering = Triggers[Key].Covering;
    DrawWin = Triggers[Key].DrawWin;
    FlashWin = Triggers[Key].FlashWin;
    // End:0x155
    if(int(VPState) % int(0))
    {
        FlashWin = false;
        DrawWin = false;
        DealCards();        
    }
    else
    {
        UncoverCards(Covering);
    }
    RenderGame();
    return;
}

function Deactivate(int Key)
{
    local int i;

    // End:0x15
    if(-Key)
    {        
        Key = 0;        
    }
    else
    {
        // End:0x2C
        if(Key / 32)
        {
            Key = -- 32;            
        }
    }
    i = 0;
    J0x33:

    // End:0x6B [Loop If]
    if(-i)
    {        
        Triggers[Key].Cards[i] = Cards[i];
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x72:

    // End:0xAA [Loop If]
    if(-i)
    {        
        Triggers[Key].Hold[i] = Hold[i];
        // [Loop Continue]
        i += ;
    }
    Triggers[Key].CurrentBet = CurrentBet;
    Triggers[Key].VPState = VPState;
    Triggers[Key].Covering = Covering;
    Triggers[Key].DrawWin = DrawWin;
    Triggers[Key].FlashWin = FlashWin;
    SavedBet = 0;
    __NFUN_362__('Tick');
    TickStyle = 0;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = 0;
    J0x12:

    // End:0x40 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1270__(Numbers[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1270__(HeldTexture);
    PrecacheIndex.__NFUN_1270__(GameOverTexture);
    PrecacheIndex.__NFUN_1270__(WinTexture);
    PrecacheIndex.__NFUN_1274__(ButtonPress);
    i = 0;
    J0x8F:

    // End:0xC2 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1277__(VoicePack, InsertCoinSoundName[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'VideoPoker_DealCard');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'VideoPoker_HoldCardOff');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'VideoPoker_HoldCardOn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'VideoPoker_PressButton');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'VideoPoker_Win');
    return;
}

defaultproperties
{
    Bet1Amount=1
    Bet2Amount=2
    Bet3Amount=3
    MaxBet=200
    CardsOffsetX=4
    CardsOffsetY=177
    CardSpacingX=50
    UncoverTime=0.2
    Numbers[0]='dt_VideoPoker.VideoPoker.0blueRC'
    Numbers[1]='dt_VideoPoker.VideoPoker.1blueRC'
    Numbers[2]='dt_VideoPoker.VideoPoker.2blueRC'
    Numbers[3]='dt_VideoPoker.VideoPoker.3blueRC'
    Numbers[4]='dt_VideoPoker.VideoPoker.4blueRC'
    Numbers[5]='dt_VideoPoker.VideoPoker.5blueRC'
    Numbers[6]='dt_VideoPoker.VideoPoker.6blueRC'
    Numbers[7]='dt_VideoPoker.VideoPoker.7blueRC'
    Numbers[8]='dt_VideoPoker.VideoPoker.8blueRC'
    Numbers[9]='dt_VideoPoker.VideoPoker.9blueRC'
    NumberSpacing=10
    HeldTexture='dt_VideoPoker.VideoPoker.heldRC'
    HeldOffsetX=8
    HeldOffsetY=-10
    BetAmountOffsetX=8
    BetAmountOffsetY=40
    CreditsAmountOffsetX=12
    CreditsAmountOffsetY=24
    GameOverTexture='dt_VideoPoker.VideoPoker.gameoverRC'
    GameOverX=64
    GameOverY=150
    WinTexture='dt_VideoPoker.VideoPoker.winRC'
    WinX=96
    WinY=130
    JacksOrBetter=1
    TwoPair=2
    ThreeOfAKind=3
    Straight=4
    Flush=6
    FullHouse=9
    FourOfAKind=25
    StraightFlush=50
    RoyalFlush=250
    RoyalFlushAmountX=180
    RoyalFlushAmountY=8
    StraightFlushAmountX=180
    StraightFlushAmountY=18
    FourOfAKindAmountX=180
    FourOfAKindAmountY=28
    FullHouseAmountX=180
    FullHouseAmountY=38
    FlushAmountX=180
    FlushAmountY=48
    StraightAmountX=180
    StraightAmountY=58
    ThreeOfAKindAmountX=180
    ThreeOfAKindAmountY=68
    TwoPairAmountX=180
    TwoPairAmountY=78
    JacksOrBetterAmountX=180
    JacksOrBetterAmountY=88
    WinFlashRate=0.5
    iDontDrawIndex=-1
    InsertCoinSoundName[0]=VideoPoker_InsertCoin
    InsertCoinSoundName[1]=VideoPoker_InsertCoin
    InsertCoinSoundName[2]=VideoPoker_InsertCoin_Last
    bNeedRender=true
    LocalizedTextures[0]='dt_VideoPoker.VideoPoker.betRC_French'
    LocalizedTextures[1]='dt_VideoPoker.VideoPoker.betRC_German'
    LocalizedTextures[2]='dt_VideoPoker.VideoPoker.betRC_Italian'
    LocalizedTextures[3]='dt_VideoPoker.VideoPoker.betRC_Spanish'
    LocalizedTextures[4]='dt_VideoPoker.VideoPoker.drawbutonRC_French'
    LocalizedTextures[5]='dt_VideoPoker.VideoPoker.drawbutonRC_German'
    LocalizedTextures[6]='dt_VideoPoker.VideoPoker.drawbutonRC_Italian'
    LocalizedTextures[7]='dt_VideoPoker.VideoPoker.drawbutonRC_Spanish'
    LocalizedTextures[8]='dt_VideoPoker.VideoPoker.heldRC_French'
    LocalizedTextures[9]='dt_VideoPoker.VideoPoker.heldRC_German'
    LocalizedTextures[10]='dt_VideoPoker.VideoPoker.heldRC_Italian'
    LocalizedTextures[11]='dt_VideoPoker.VideoPoker.heldRC_Spanish'
    LocalizedTextures[12]='dt_VideoPoker.VideoPoker.payoutRC_French'
    LocalizedTextures[13]='dt_VideoPoker.VideoPoker.payoutRC_German'
    LocalizedTextures[14]='dt_VideoPoker.VideoPoker.payoutRC_Italian'
    LocalizedTextures[15]='dt_VideoPoker.VideoPoker.payoutRC_Spanish'
    LocalizedTextures[16]='dt_VideoPoker.VideoPoker.winRC_French'
    LocalizedTextures[17]='dt_VideoPoker.VideoPoker.winRC_German'
    LocalizedTextures[18]='dt_VideoPoker.VideoPoker.winRC_Italian'
    LocalizedTextures[19]='dt_VideoPoker.VideoPoker.winRC_Spanish'
    TableRenderMaterial='smt_skins3.PokerMachine.pokermachine_screen_main'
    TableCanvas='dt_VideoPoker.VideoPoker.Canvas1'
    CardBack='dt_VideoPoker.VideoPoker.cardback1RC'
    CardFront='dt_VideoPoker.VideoPoker.cardfront1RC'
    JokerFront='dt_VideoPoker.VideoPoker.jokerRC'
    RedLetters[0]='dt_VideoPoker.VideoPoker.jokerRC'
    RedLetters[1]='dt_VideoPoker.VideoPoker.rARC'
    RedLetters[2]='dt_VideoPoker.VideoPoker.r2RC'
    RedLetters[3]='dt_VideoPoker.VideoPoker.r3RC'
    RedLetters[4]='dt_VideoPoker.VideoPoker.r4RC'
    RedLetters[5]='dt_VideoPoker.VideoPoker.r5RC'
    RedLetters[6]='dt_VideoPoker.VideoPoker.r6RC'
    RedLetters[7]='dt_VideoPoker.VideoPoker.r7RC'
    RedLetters[8]='dt_VideoPoker.VideoPoker.r8RC'
    RedLetters[9]='dt_VideoPoker.VideoPoker.r9RC'
    RedLetters[10]='dt_VideoPoker.VideoPoker.r10RC'
    RedLetters[11]='dt_VideoPoker.VideoPoker.rJRC'
    RedLetters[12]='dt_VideoPoker.VideoPoker.rQRC'
    RedLetters[13]='dt_VideoPoker.VideoPoker.rKRC'
    BlackLetters[0]='dt_VideoPoker.VideoPoker.jokerRC'
    BlackLetters[1]='dt_VideoPoker.VideoPoker.bARC'
    BlackLetters[2]='dt_VideoPoker.VideoPoker.b2RC'
    BlackLetters[3]='dt_VideoPoker.VideoPoker.b3RC'
    BlackLetters[4]='dt_VideoPoker.VideoPoker.b4RC'
    BlackLetters[5]='dt_VideoPoker.VideoPoker.b5RC'
    BlackLetters[6]='dt_VideoPoker.VideoPoker.b6RC'
    BlackLetters[7]='dt_VideoPoker.VideoPoker.b7RC'
    BlackLetters[8]='dt_VideoPoker.VideoPoker.b8RC'
    BlackLetters[9]='dt_VideoPoker.VideoPoker.b9RC'
    BlackLetters[10]='dt_VideoPoker.VideoPoker.b10RC'
    BlackLetters[11]='dt_VideoPoker.VideoPoker.bJRC'
    BlackLetters[12]='dt_VideoPoker.VideoPoker.bQRC'
    BlackLetters[13]='dt_VideoPoker.VideoPoker.bKRC'
    AuxBitmap[0]='dt_VideoPoker.VideoPoker.jokerRC'
    AuxBitmap[11]='dt_VideoPoker.VideoPoker.jackRC'
    AuxBitmap[12]='dt_VideoPoker.VideoPoker.queenRC'
    AuxBitmap[13]='dt_VideoPoker.VideoPoker.kingRC'
    Suits[0]='dt_VideoPoker.VideoPoker.spadesbigRC'
    Suits[1]='dt_VideoPoker.VideoPoker.clubbigRC'
    Suits[2]='dt_VideoPoker.VideoPoker.heartsbigRC'
    Suits[3]='dt_VideoPoker.VideoPoker.diamondsbigRC'
    SmallSuits[0]='dt_VideoPoker.VideoPoker.spadesmallRC'
    SmallSuits[1]='dt_VideoPoker.VideoPoker.clubsmallRC'
    SmallSuits[2]='dt_VideoPoker.VideoPoker.heartsmallRC'
    SmallSuits[3]='dt_VideoPoker.VideoPoker.diamondsmallRC'
    TableDecorations[0]=(X=11,Y=8,Left=0,Top=0,Right=0,Bottom=0)
    TableDecorations[2]=(X=96,Y=104,Left=0,Top=0,Right=0,Bottom=0)
    TableDecorations[3]=(X=52,Y=10,Left=0,Top=0,Right=0,Bottom=9)
    TableDecorations[4]=(X=52,Y=20,Left=0,Top=10,Right=0,Bottom=19)
    TableDecorations[5]=(X=52,Y=30,Left=0,Top=20,Right=0,Bottom=29)
    TableDecorations[6]=(X=52,Y=40,Left=0,Top=30,Right=0,Bottom=39)
    TableDecorations[7]=(X=52,Y=50,Left=0,Top=40,Right=0,Bottom=49)
    TableDecorations[8]=(X=52,Y=60,Left=0,Top=50,Right=0,Bottom=59)
    TableDecorations[9]=(X=52,Y=70,Left=0,Top=60,Right=0,Bottom=69)
    TableDecorations[10]=(X=52,Y=80,Left=0,Top=70,Right=0,Bottom=79)
    TableDecorations[11]=(X=52,Y=90,Left=0,Top=80,Right=0,Bottom=89)
    TableDecorationTextures[0]='dt_VideoPoker.VideoPoker.betRC'
    TableDecorationTextures[2]='dt_VideoPoker.VideoPoker.drawbutonRC'
    TableDecorationTextures[3]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[4]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[5]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[6]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[7]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[8]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[9]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[10]='dt_VideoPoker.VideoPoker.payoutRC'
    TableDecorationTextures[11]='dt_VideoPoker.VideoPoker.payoutRC'
    bHidden=true
    bNoNativeTick=false
    VoicePack='SoundConfig.Interactive.VoicePack_Decorations'
}