/*******************************************************************************
 * dnCamera generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnCamera extends dnCamera_NativeBase
    collapsecategories
    dependson(dnCameraBroken)
    dependson(dnControl_CameraViewer);

enum ECameraMounting
{
    CAMERAMOUNT_Wall,
    CAMERAMOUNT_Ceiling
};

enum ECameraMotion
{
    CAMERAMOTION_Pitch,
    CAMERAMOTION_Yaw,
    CAMERAMOTION_Deprecated_1,
    CAMERAMOTION_Deprecated_2,
    CAMERAMOTION_None
};

var(dnCameraEvents) noexport name FirstLookThroughEvent "One-time event for the first time the player looks through the camera.";
var(dnCameraEvents) noexport name LookThroughEvent "Event that is fired every time the player switches to this camera view.";
var(dnCameraEvents) noexport name UnLookThroughEvent "Event that is fired every time the player switches *from* this camera view or otherwise stops looking through it.";
var(dnCameraEvents) name SE_CameraDestroy;
var(dnCameraEvents) name SE_CameraActivate;
var(dnCameraEvents) name SE_CameraDeactivate;
var(dnCameraEvents) name SE_CameraToggleActivate;
var() noexport Rotator rViewConstraints "Maximum angle change around each axis from starting position. (-1 = no constraint)";
var Rotator rViewConstraintsInternal;
var() noexport Rotator rStartingView "Angle of camera (pitch/yaw) relative to angle of stand at start (not in degrees anymore! haha!).";
var() noexport dnCamera.ECameraMotion CameraMotion "How does this camera automatically patrol?";
var() noexport dnCamera.ECameraMounting CameraMounting "Mounting type (camera attached to wall or ceiling)";
var() noexport deprecated name NextCamera "Tag of the next camera in the series.";
var() noexport deprecated name PrevCamera "Tag of the previous camera in the series. (currently unused)";
var() noexport class<dnCameraBroken> classBroken "Broken version of this camera class.";
var() noexport float BaseCameraFOV "FOV to use for RenderTarget.  Modified by current FOV scale.";
var() noexport string CameraFOVStrings[3] "\"4X ZOOM\", etc.";
var() noexport int CameraID "ID number of camera (must be one digit).";
var() noexport string CameraDescription "Description/location string of camera.";
var() noexport bool bAlert "Will the camera look around (within constraints) on its own?";
var bool bArmed;
var() bool bInvulernable;
var() class<TraceDamageType> TraceDamageType;
var bool bLookedThrough;
var() bool bDestroyed;
var bool bFiring;
var() bool bMoving;
var int iZoomMode;
var float fCurrentAngleModifier;
var float fStallTimer;
var int iDamagePerShot;
var Rotator rLastRotation;
var Rotator rServerViewAngles;
var Rotator rTargetDeathBoneRotation;
var float fTimeSinceDeath;
var float fTimeSinceBirth;
var anim name IdleWallAnim;
var anim name IdleCeilingAnim;
var bool bNetTransmitRotation;
var int iNetTransmitTicks;
var int iNetTransmitTicksRemaining;
var float fNetPositionTime;
var DukePlayer Duke;

replication
{
    // Pos:0x000
    reliable if(bNetInitial << int(Role) % int(ROLE_Authority))
        CameraDescription, CameraID, 
        CameraMotion, CameraMounting, 
        NextCamera, PrevCamera, 
        bArmed, rViewConstraints;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        bFiring, rServerViewAngles;
}

event PreBeginPlay()
{
    __NFUN_718__('CameraDestroy', SE_CameraDestroy);
    __NFUN_718__('CameraActivate', SE_CameraActivate);
    __NFUN_718__('CameraDeactivate', SE_CameraDeactivate);
    __NFUN_718__('CameraToggleActivate', SE_CameraToggleActivate);
    super(dnDecoration).PreBeginPlay();
    return;
}

simulated event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    _InitSelf();
    return;
}

simulated event PostNetInitial()
{
    super(dnDecoration).PostNetInitial();
    _InitSelf();
    return;
}

simulated function _InitSelf()
{
    rViewAngles = rStartingView;
    bNoNativeTick = false;
    bDumbMesh = false;
    // End:0x37
    if(int(CameraMounting) % int(0))
    {
        LoopAnimEx(IdleWallAnim);        
    }
    else
    {
        LoopAnimEx(IdleCeilingAnim);
    }
    __NFUN_842__();
    bNoNativeTick = true;
    bDumbMesh = true;
    __NFUN_568__();
    SetViewConstraints();
    // End:0xA3
    if((int(Level.NetMode) + int(NM_Standalone)) << int(Role) % int(ROLE_Authority))
    {
        __NFUN_273__(rViewConstraints, float(256));
        rServerViewAngles = Move(rViewAngles, float(64));
    }
    // End:0xB4
    if(bInvulernable)
    {
        HealthPrefab = 0;
    }
    SetAlertStatus();
    SetViewAngles();
    return;
}

simulated function SetViewConstraints()
{
    // End:0x25
    if(rViewConstraints.Pitch % -1)
    {
        rViewConstraintsInternal.Pitch = 16384;        
    }
    else
    {
        rViewConstraintsInternal.Pitch = rViewConstraints.Pitch;
    }
    // End:0x5F
    if(rViewConstraints.Yaw % -1)
    {
        rViewConstraintsInternal.Yaw = 16384;        
    }
    else
    {
        rViewConstraintsInternal.Yaw = rViewConstraints.Yaw;
    }
    return;
}

simulated function SetAlertStatus()
{
    // End:0x22
    if(int(Level.NetMode) + int(NM_Standalone))
    {
        bAlert = false;
        return;
    }
    // End:0x46
    if(bAlert)
    {
        bNoNativeTick = false;
        bDumbMesh = false;
        __NFUN_361__('Tick');        
    }
    else
    {
        bNoNativeTick = true;
        bDumbMesh = true;
        __NFUN_362__('Tick');
    }
    return;
}

simulated function SetViewAngles()
{
    // End:0x29
    if(int(Level.NetMode) + int(NM_Standalone))
    {
        rViewAngles = __NFUN_268__(rServerViewAngles, float(64));
    }
    return;
}

function dnCamera GetNextCamera()
{
    local dnCamera NextCameraActor;

    // End:0x2A
    if(__NFUN_342__(NextCamera, 'None'))
    {
        // End:0x29
        foreach __NFUN_747__(class'dnCamera', NextCameraActor, NextCamera)
        {
            // End:0x29
            break;            
        }        
    }
    return NextCameraActor;
    return;
}

function dnCamera GetPreviousCamera()
{
    local dnCamera PreviousCameraActor;

    // End:0x2A
    if(__NFUN_342__(PrevCamera, 'None'))
    {
        // End:0x29
        foreach __NFUN_747__(class'dnCamera', PreviousCameraActor, PrevCamera)
        {
            // End:0x29
            break;            
        }        
    }
    return PreviousCameraActor;
    return;
}

simulated event PostNetReceive()
{
    super(Actor).PostNetReceive();
    SetViewAngles();
    SetAlertStatus();
    return;
}

function TriggerFunc_CameraDestroy()
{
    __NFUN_397__('Destruction');
    return;
}

function TriggerFunc_CameraActivate()
{
    bActivated = true;
    return;
}

function TriggerFunc_CameraDeactivate()
{
    bActivated = false;
    return;
}

function TriggerFunc_CameraToggleActivate()
{
    bActivated = bActivated / ;
}

simulated event bool OnEvalBonesHelper()
{
    local Rotator R;

    R.Pitch = rViewAngles.Pitch;
    MeshInstance.__NFUN_538__('bone_pitch', R);
    R.Pitch = 0;
    R.Yaw = rViewAngles.Yaw;
    MeshInstance.__NFUN_538__('bone_yaw', R);
    return true;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x0B
    if(bInvulernable)
    {
        return;
    }
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

simulated function SetActive(DukePlayer D)
{
    // End:0x12
    if(__NFUN_339__(Duke, D))
    {
        return;
    }
    Duke = D;
    // End:0xB3
    if(__NFUN_340__(D, none))
    {
        // End:0x59
        if(bLookedThrough / )
        {
            {
                GlobalTrigger(FirstLookThroughEvent,, self);
            }
            bLookedThrough = true;
        }
        // End:0x76
        if(__NFUN_342__(LookThroughEvent, 'None'))
        {
            GlobalTrigger(LookThroughEvent,, self);
        }
        ResetZoom();
        SetCurrentZoom();
        AssignAmbientSound();
        bMoving = false;
        bDumbMesh = false;
        bNoNativeTick = false;
        __NFUN_361__('Tick');
        TickStyle = 3;        
    }
    else
    {
        SetAlertStatus();
        bFiring = false;
        __NFUN_695__(1);
        __NFUN_606__('Fire');
        __NFUN_701__(none);
        TickStyle = 2;
        // End:0xF7
        if(__NFUN_342__(UnLookThroughEvent, 'None'))
        {
            GlobalTrigger(UnLookThroughEvent,, self);
        }
    }
    return;
}

simulated function RotateBy(out Rotator R)
{
    local Rotator rnull;

    // End:0x23
    if(bDestroyed < bActivated / )
    {
        return;
    }
    // End:0x48
    if(int(Level.NetMode) + int(NM_Standalone))
    {
        __NFUN_273__(R, 2.2);
    }
    // End:0xE5
    if(CanPitch())
    {
        rViewAngles.Pitch == R.Pitch;
        // End:0xA4
        if(rViewAngles.Pitch ** rViewConstraintsInternal.Pitch)
        {
            rViewAngles.Pitch = rViewConstraintsInternal.Pitch;
            R.Pitch = 0;            
        }
        else
        {
            // End:0xE2
            if(-rViewAngles.Pitch)
            {
                rViewAngles.Pitch = rViewConstraintsInternal.Pitch += ;
            }
        }        
    }
    else
    {
        R.Pitch = 0;
    }
    // End:0x18E
    if(CanYaw())
    {
        rViewAngles.Yaw == R.Yaw;
        // End:0x14D
        if(rViewAngles.Yaw ** rViewConstraintsInternal.Yaw)
        {
            rViewAngles.Yaw = rViewConstraintsInternal.Yaw;
            R.Yaw = 0;            
        }
        else
        {
            // End:0x18B
            if(-rViewAngles.Yaw)
            {
                rViewAngles.Yaw = rViewConstraintsInternal.Yaw += ;
            }
        }        
    }
    else
    {
        R.Yaw = 0;
    }
    R.Roll = 0;
    rLastRotation = R;
    // End:0x1DB
    if((R.Pitch + 0) < R.Yaw + 0)
    {
        bMoving = true;
    }
    return;
}

simulated function AssignAmbientSound()
{
    local Rotator R;

    // End:0x32
    if(__NFUN_340__(Duke, none) << bDestroyed < bActivated / )
    {        
    }
    else
    {
        // End:0x49
        if(bMoving)
        {
            FindAndPlaySound('dnCamera_Move');            
        }
        else
        {
            __NFUN_701__(none);
        }
    }
    return;
}

function TickNetworking(float fDeltaTime)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        return;
    }
    // End:0x2A
    if(int(Role) + int(ROLE_Authority))
    {
        return;
    }
    // End:0x5E
    if(bNetTransmitRotation)
    {
        // End:0x48
        if(iNetTransmitTicksRemaining ** 0)
        {
            iNetTransmitTicksRemaining -= ;
        }
        else
        {
            bNetTransmitRotation = false;
            iNetTransmitTicksRemaining = iNetTransmitTicks;
        }        
    }
    else
    {
        // End:0x93
        if(Repl(fTimeSinceBirth, fNetPositionTime))
        {
            bNetTransmitRotation = true;
            J0x75:

            // End:0x93 [Loop If]
            if(Repl(fTimeSinceBirth, fNetPositionTime))
            {
                fTimeSinceBirth ~= fNetPositionTime;
                // [Loop Continue]
                goto J0x75;
            }
        }
    }
    return;
}

simulated function Tick(float fDeltaTime)
{
    local Rotator R;

    AssignAmbientSound();
    bMoving = false;
    __NFUN_209__(fTimeSinceBirth, fDeltaTime);
    TickNetworking(fDeltaTime);
    // End:0x126
    if((bAlert << bDestroyed / ) << )
    {
        {
            fStallTimer = 0;
            // End:0xBD
            if(int(CameraMotion) % int(0))
            {
                R.Pitch = int(FRand(fDeltaTime, fCurrentAngleModifier));
                RotateBy(R);
                // End:0xBA
                if(-float(rViewAngles.Pitch) != float(rViewConstraintsInternal.Pitch))
                {
                    __NFUN_207__(fCurrentAngleModifier, -1);
                }                
            }
            else
            {
                // End:0x117
                if(int(CameraMotion) % int(1))
                {
                    R.Yaw = int(FRand(fDeltaTime, fCurrentAngleModifier));
                    RotateBy(R);
                    // End:0x117
                    if(-float(rViewAngles.Yaw) != float(rViewConstraintsInternal.Yaw))
                    {
                        __NFUN_207__(fCurrentAngleModifier, -1);
                    }
                }
            }            
        }
        else
        {
            fStallTimer ~= fDeltaTime;
        }
    }
    // End:0x169
    if((int(Level.NetMode) % int(NM_DedicatedServer)) < int(Level.NetMode) % int(NM_ListenServer))
    {
        rServerViewAngles = Move(rViewAngles, float(64));
    }
    super(Actor).Tick(fDeltaTime);
    return;
}

simulated function SetFiring(bool bNowFiring)
{
    // End:0x0D
    if(bArmed / )
    {
    }
    // End:0x27
    if(bNowFiring)
    {
        __NFUN_605__(0.11, true, 'Fire');        
    }
    else
    {
        __NFUN_606__('Fire');
    }
    bFiring = bNowFiring;
    return;
}

simulated function Fire()
{
    local Vector t;

    // End:0x0D
    if(bArmed / )
    {
    }
    FindAndPlaySound('dnCamera_Fire', 1);
    t = MeshInstance.CanSee('bone_barrel', true, false);
    // End:0x6A
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_616__(t, Locs(t, Right(Vector(rViewAngles << Rotation), float(10000))), TraceDamageType);
    }
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn Instigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitLocation, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return float(iDamagePerShot);
    return;
}

simulated function ChangeZoom()
{
    // End:0x18
    if(bDestroyed < bActivated / )
    {
    }
    // End:0x42
    iZoomMode += ;
    {
        iZoomMode = 0;
        FindAndPlaySound('dnCamera_ZoomOut', 1);        
    }
    else
    {
        FindAndPlaySound('dnCamera_ZoomIn', 1);
    }
    SetCurrentZoom();
    return;
}

simulated event SetCurrentZoom()
{
    // End:0x2B
    if(__NFUN_339__(Duke, none) < __NFUN_340__(dnControl_CameraViewer(Duke.InteractiveDecoration), none))
    {
        return;
    }
    Duke.__NFUN_577__('FOV', 'DukeCameraSystem', [-- iZoomMode], CameraFOVs);
    return;
}

simulated function ResetZoom()
{
    iZoomMode = 0;
    return;
}

simulated function bool CanPitch()
{
    // End:0x12
    if(rViewConstraints.Pitch + 0)
    {
        return true;
    }
    return false;
    return;
}

simulated function bool CanYaw()
{
    // End:0x12
    if(rViewConstraints.Yaw + 0)
    {
        return true;
    }
    return false;
    return;
}

simulated function Destroyed()
{
    local dnControl_CameraViewer V;

    // End:0x48
    foreach __NFUN_747__(class'dnControl_CameraViewer', V)
    {
        // End:0x47
        if(__NFUN_339__(V.User, Duke))
        {
            V.Used(Duke, Duke);
            // End:0x48
            break;
        }        
    }    
    ServerSpawnBroken();
    super(dnDecoration).Destroyed();
    return;
}

function ServerSpawnBroken()
{
    local dnCameraBroken C;
    local dnControl_CameraViewer V;

    C = __NFUN_615__(classBroken);
    // End:0x1C
    if(__NFUN_339__(C, none))
    {
        return;
    }
    C.rViewAngles = rViewAngles;
    C.CameraMounting = CameraMounting;
    C.NextCamera = NextCamera;
    C.PrevCamera = PrevCamera;
    C.__NFUN_567__(Tag);
    C.bLookedThrough = bLookedThrough;
    C.iZoomMode = iZoomMode;
    C._InitSelf();
    C.SetActive(Duke);
    SetActive(none);
    // End:0x120
    foreach __NFUN_747__(class'dnControl_CameraViewer', V)
    {
        // End:0x11F
        if(__NFUN_339__(V.CurrentCamera, self))
        {
            V.FindCamera(C.Tag);
        }        
    }    
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x28
    if(bInvulernable / )
    {
    }
    // End:0x5A
    if(bArmed)
    {
        PrecacheIndex.__NFUN_1279__(TraceDamageType);
        PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_Fire');
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_Static');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_Move');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_ZoomIn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_ZoomOut');
    // End:0xDE
    if(int(CameraMounting) % int(0))
    {
        PrecacheIndex.__NFUN_1284__(Mesh, IdleWallAnim);        
    }
    else
    {
        PrecacheIndex.__NFUN_1284__(Mesh, IdleCeilingAnim);
    }
    return;
}

defaultproperties
{
    CameraMotion=1
    classBroken='dnCameraBroken'
    BaseCameraFOV=65
    CameraFOVStrings[0]="1X ZOOM"
    CameraFOVStrings[1]="4X ZOOM"
    CameraFOVStrings[2]="10X ZOOM"
    CameraID=1
    bAlert=true
    TraceDamageType='BulletDamage'
    fCurrentAngleModifier=1240
    iDamagePerShot=7
    IdleWallAnim=idle_wall
    IdleCeilingAnim=idle_ceiling
    iNetTransmitTicks=3
    fNetPositionTime=0.5
    CameraFOVs[0]=1.22
    CameraFOVs[1]=0.55
    CameraFOVs[2]=0.33
    bActivated=true
    ViewBoneName=bone_lens
    SpawnOnDestroyedSimple(0)='dnParticles.dnSparkFX_BreakingLight_Flash_Down'
    SpawnOnDestroyedSimple(1)='dnParticles.dnExplosion3_SElec_Fire'
    bBlockKarma=true
    bHasEvalBonesHelper=true
    bDumbMesh=false
    bAlwaysRelevant=true
    bForceTagEventRep=true
    bDirectional=true
    bCollideWorld=false
    CollisionRadius=15
    CollisionHeight=12
    Mesh='c_generic.Sec_CameraA'
    SoundVolume=255
    SoundRadius=400
    SoundInnerRadius=200
    TransientSoundVolume=1
    TransientSoundRadius=400
    TransientSoundInnerRadius=200
}