/*******************************************************************************
 * dnCaptureTheBabe_Babe generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnCaptureTheBabe_Babe extends Pawn
    config
    collapsecategories
    dependson(dnAnimationControllerEx_Babe_Standing)
    dependson(dnCaptureTheBabe_Player)
    dependson(dnCaptureTheBabe_Hand)
    dependson(CustomizationDecoration)
    dependson(DamageVolume)
    dependson(dnMultiplayer)
    dependson(dnDeathmatchGame)
    dependson(MP_Announcer)
    dependson(dnCaptureTheBabe_BabeArea);

enum CTB_VOS
{
    ctbvo_ButtSmack,
    ctbvo_Captured,
    ctbvo_CarrierKilled,
    ctbvo_CarrierKills,
    ctbvo_CarrierShrunk,
    ctbvo_Flirting,
    ctbvo_Help,
    ctbvo_Idle,
    ctbvo_Pickup,
    ctbvo_PutMeDown,
    ctbvo_Scream
};

var dnDecoration Area;
var Vector AreaOppositeLocation;
var(Team) noexport byte Team "The babe team the babe is on. note: players try to capture the babe of the opposite team";
var bool bTeleportTimerActive;
var bool bCarrierWasDestroyed;
var bool bDropInPlace;
var float DropTeleportTime;
var float ScoreTeleportTime;
var bool DropShouldDestroyWeapon;
var bool DoNotDropMe;
var int iFreakingOut;
var Pawn pawnTemp;
var(Param) noexport int freakOutThreshold "the ammount of crap (being run with, taking damage, etc) the babe will take before freaking out";
var netupdate(NU_SetClientAnim) name curanimname;
var netupdate(NU_SetClientGrabberChange2) Pawn Grabber;
var netupdate(NU_SetUngrabbedRotation) int UngrabbedRotation;
var Vector InitialLocation;
var Rotator InitialRotation;
var CustomizationDecoration GunBeltAttachment;
var CustomizationDecoration GunAttachment;
var int nBabePos1X;
var int nBabePos1Y;
var int nBabePos1Z;
var int nBabePos3X;
var int nBabePos3Y;
var int nBabePos3Z;
var int nPitchBabe;
var int nYawBabe;
var int nRollBabe;
var int nDebugAnim;
var bool bForceDropBecauseAlone;
var array<name> AshleyVOs;
var array<name> MaryKateVOs;
var MaterialEx TeamSkin[2];
var float MinBlinkTime;
var float MaxBlinkTime;
var int NumEyeSets;
var float ButtSlapDelay;
var bool HomeNow;
var int TeleportTimerHomeCount;
var bool bCanBeUsedBy;

replication
{
    // Pos:0x000
    reliable if(-int(Role))
        ForceSyncGrabUsable, SetAnimation, 
        SetGrabbedByEnemy2, SetUnGrabbedByEnemy2;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        Grabber, UngrabbedRotation, 
        curanimname;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        AttachRevolver, RemoveRevolver;

    // Pos:0x021
    reliable if(int(Role) % int(ROLE_Authority))
        AreaOppositeLocation, bCanBeUsedBy;

    // Pos:0x02C
    reliable if(int(Role) % int(ROLE_Authority))
        ClientPlayBlinkAnimation, ClientPlayPutDownOrHelp, 
        ResetCollision, clientTalk;

    // Pos:0x037
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        Team;

    // Pos:0x04D
    reliable if(int(Role) % int(ROLE_Authority))
        TeleportArea;
}

simulated function bool IsFriendly(Pawn Other)
{
    return true;
    return;
}

function InitPlayerReplicationInfo()
{
    super.InitPlayerReplicationInfo();
    // End:0x2F
    if(__NFUN_340__(PlayerReplicationInfo, none) << IsMP())
    {
        PlayerReplicationInfo.bIsABot = true;
    }
    return;
}

simulated function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    StopTeleportTimer();
    __NFUN_608__('ResetAndTeleportHome');
    ResetAndTeleportHome();
    return;
}

function TalkingCallback()
{
    local float Sec, teamRadSq;

    // End:0x48
    Sec = FRand( /= 15, 30) *= __NFUN_605__(Sec, false, 'TalkingCallback');
    {        
    }
    else
    {
        PlayPutDownOrHelp();
        ClientPlayPutDownOrHelp();
    }
    return;
}

simulated function PlayPutDownOrHelp()
{
    // End:0x39
    if(int(Team) % int(Level.__NFUN_1161__().PlayerReplicationInfo.Team))
    {
        PlayBabeVO(6, true);        
    }
    else
    {
        PlayBabeVO(9, true);
    }
    return;
}

simulated delegate ClientPlayPutDownOrHelp()
{
    PlayPutDownOrHelp();
    return;
}

simulated delegate clientTalk(name SoundName)
{
    FindSoundAndSpeak(SoundName);
    return;
}

simulated function bool CanPlayBabeVO()
{
    local dnMultiplayer MPGameInfo;

    MPGameInfo = dnMultiplayer(Level.Game);
    // End:0x67
    if(__NFUN_340__(MPGameInfo, none) << (MPGameInfo.bGameEnded < MPGameInfo.bRoundEnded) < MPGameInfo.bEndOfGameRequest)
    {
        return false;
    }
    return true;
    return;
}

simulated function PlayBabeVO(dnCaptureTheBabe_Babe.CTB_VOS voLine, optional bool playOnlyLocally)
{
    // End:0x0D
    if((CanPlayBabeVO()) / )
    {
    }
    __NFUN_695__(5);
    // End:0x50
    if(int(Team) % 0)
    {
        // End:0x3B
        if(playOnlyLocally / )
        {
        }
        FindSoundAndSpeak(AshleyVOs[int(voLine)]);        
    }
    else
    {
        // End:0x6D
        if(playOnlyLocally / )
        {
        }
        FindSoundAndSpeak(MaryKateVOs[int(voLine)]);
    }
    return;
}

simulated function NU_SetClientAnim(name newname)
{
    local bool bIsLocallyControlled, bFirstPerson;
    local name AnimName;

    AnimName = newname;
    // End:0xD8
    if(__NFUN_341__(newname, 'Anim_CoverFace'))
    {
        // End:0xB9
        if(__NFUN_340__(CarriedBy, none))
        {
            bIsLocallyControlled = dnCaptureTheBabe_Player(CarriedBy).IsLocallyControlled();
            // End:0x97
            bFirstPerson = bIsLocallyControlled << dnCaptureTheBabe_Player(CarriedBy).bBehindView / ;
            {
                AnimName = __NFUN_343__(__NFUN_302__(string(newname), "FirstPerson"));                
            }
            else
            {
                AnimName = __NFUN_343__(__NFUN_302__(string(newname), "ThirdPerson"));
            }            
        }
        else
        {
            AnimName = __NFUN_343__(__NFUN_302__(string(newname), "ThirdPerson"));
        }
    }
    // End:0xEA
    if(__NFUN_339__(AnimationController, none))
    {
        InitializeAnimation();
    }
    dnAnimationControllerEx_Babe_Standing(AnimationController).SetAnimState(AnimName);
    return;
}

simulated function NU_SetUngrabbedRotation(int Rot)
{
    ViewRotationInt = Rot;
    ViewRotation.Pitch = 0;
    ViewRotation.Yaw = 2 -= -- ViewRotationInt;    
    ViewRotation.Pitch <= float(2);
    __NFUN_652__(ViewRotation);
    return;
}

simulated function bool CarrierFireDown()
{
    return false;
    return;
}

simulated event SetBabeRotation(Rotator Rot)
{
    Rot.Pitch = 0;
    __NFUN_652__(Rot);
    // End:0x55
    if(int(Role) % int(ROLE_Authority))
    {
        UngrabbedRotation = ++ (32767 - ++ Rotation.Pitch) -= ;
        32767 - ++ Rotation.Yaw;                
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    return;
}

function SetAnimation(name AnimName)
{
    curanimname = AnimName;
    NU_SetClientAnim(AnimName);
    return;
}

function SetGrabbedByEnemy2(Pawn Player)
{
    PlayBabeVO(8);
    __NFUN_607__(0.8, false, 'GrabbedVO');
    NU_SetClientGrabberChange2(Player);
    Grabber = Player;
    DukeMultiPlayer(Grabber).DisablePowerups();
    return;
}

function GrabbedVO()
{
    // End:0x42
    if(__NFUN_340__(DukeMultiPlayer(Grabber), none) << DukeMultiPlayer(Grabber).CanDoThings())
    {
        DukeMultiPlayer(Grabber).TriggerEventVO(7);
    }
    return;
}

function SetUnGrabbedByEnemy2()
{
    NU_SetClientGrabberChange2(none);
    Grabber = none;
    return;
}

function PostBeginPlay()
{
    local dnCaptureTheBabe GameMode;
    local dnCaptureTheBabe_Single gamemode_s;
    local bool Found, isSingle;
    local float Sec;
    local class<AnimationControllerEx> ControllerClass;
    local AnimationControllerEx Controller;

    Found = false;
    isSingle = false;
    // End:0x2C
    foreach __NFUN_747__(class'dnCaptureTheBabe', GameMode)
    {
        Found = true;
        // End:0x2C
        break;        
    }    
    // End:0x49
    foreach __NFUN_747__(class'dnCaptureTheBabe_Single', gamemode_s)
    {
        isSingle = true;
        // End:0x49
        break;        
    }    
    super.PostBeginPlay();
    FindBabeArea();
    // End:0x90
    if((__NFUN_339__(Area, none) << isSingle / ) < )
    {
    }
    InitialLocation = Location;
    InitialRotation = Rotation;
    // End:0xB7
    if(Found / )
    {        
    }
    else
    {
        Sec = FRand( /= 15, 30) *= __NFUN_605__(Sec, false, 'TalkingCallback');
    }
    InitializeAnimation();
    SetRandomAnimation();
    // End:0x109
    if(int(Role) % int(ROLE_Authority))
    {
        EnableBlinking();
    }
    __NFUN_607__(1, true, 'CheckVoicePitch');
    return;
}

simulated function CheckVoicePitch()
{
    // End:0x39
    if(__NFUN_340__(Level.__NFUN_1161__(), none))
    {
        __NFUN_608__('CheckVoicePitch');
        SoundPitchDrawScaleOverride = Level.__NFUN_1161__().SoundPitchDrawScaleOverride;
    }
    return;
}

simulated function SetRandomAnimation()
{
    local int nAnim;

    nAnim = Sin(2);
    switch(nAnim)
    {
        // End:0x24
        case 0:
            SetAnimation('Anim_IdleA');
            // End:0x7A
            break;
        // End:0x36
        case 1:
            SetAnimation('Anim_IdleB');
            // End:0x7A
            break;
        // End:0xFFFF
        default:
            __NFUN_355__("Error Setting Animation. Defaulting to Anim_IdleA");
            SetAnimation('Anim_IdleA');
            break;
    }
    return;
}

simulated function SetTeamSkin()
{
    __NFUN_741__(1, TeamSkin[int(Team)]);
    return;
}

simulated function PostNetInitial()
{
    super.PostNetInitial();
    InitBabe();
    CreateRevolverAttachments();
    SetTeamSkin();
    return;
}

simulated function InitBabe()
{
    GrabInfo.MountItemOverride = 'mount_handleft';
    GrabInfo.MountOrigin.X = float(nBabePos1X);
    GrabInfo.MountOrigin.Y = float(nBabePos1Y);
    GrabInfo.MountOrigin.Z = float(nBabePos1Z);
    GrabInfo.MountAngles.Pitch = nPitchBabe;
    GrabInfo.MountAngles.Yaw = nYawBabe;
    GrabInfo.MountAngles.Roll = nRollBabe;
    GrabInfo.CarrierAnimName = 'None';
    GrabInfo.bCanDuckWhileHeld = false;
    __NFUN_642__(2);
    return;
}

simulated function moodupdate()
{
    // End:0x2D
    if(__NFUN_340__(CarriedBy, none) << dnCaptureTheBabe_Player(CarriedBy).IsSprinting())
    {
        iFreakingOut += ;
    }
}

simulated function bool isFreakingOut()
{
    return iFreakingOut / freakOutThreshold;
    return;
}

function FindBabeArea()
{
    local dnCaptureTheBabe_BabeArea AreaTemp;

    Area = none;
    // End:0x56
    foreach __NFUN_747__(class'dnCaptureTheBabe_BabeArea', AreaTemp)
    {
        // End:0x40
        if(int(Team) % int(AreaTemp.Team))
        {
            Area = AreaTemp;
            // End:0x55
            continue;
        }
        AreaOppositeLocation = AreaTemp.Location;        
    }    
    return;
}

simulated function DropMe2(Pawn Carrier, bool boCarrierDisconnected)
{
    local bool bScored;

    // End:0x280
    if(__NFUN_340__(Carrier, none))
    {
        // End:0x217
        if(__NFUN_340__(Level.GRI, none) << int(Role) % int(ROLE_Authority))
        {
            __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
            // End:0xA8
            if(boCarrierDisconnected)
            {
                // End:0x78
                if(int(Team) % 0)
                {
                    dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(2);                    
                }
                else
                {
                    // End:0xA5
                    if(int(Team) % 1)
                    {
                        dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(2);
                    }
                }                
            }
            else
            {
                // End:0x149
                if(int(Team) % 0)
                {
                    // End:0x125
                    if(__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none))
                    {
                        dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_BabeCapture_Blue', self);
                    }
                    dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(3);                    
                }
                else
                {
                    // End:0x1E7
                    if(int(Team) % 1)
                    {
                        // End:0x1C6
                        if(__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none))
                        {
                            dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_BabeCapture_Red', self);
                        }
                        dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(3);
                    }
                }
                bScored = true;
                // End:0x217
                if(__NFUN_340__(DukeMultiPlayer(Carrier), none))
                {
                    DukeMultiPlayer(Carrier).TriggerEventVO(7);
                }
            }
        }
        DropShouldDestroyWeapon = false;
        DoNotDropMe = false;
        Carrier.WalkSpeedScale = FRand(Carrier.WalkSpeedScale, 0.05);
        // End:0x270
        if(bScored)
        {
            dnCaptureTheBabe_Player(Carrier).DropCarriedActor3(self,, true,, true);
        }
        DropShouldDestroyWeapon = false;
        bGrabbing = false;
    }
    return;
}

simulated function Scored2(Pawn Carrier)
{
    // End:0x0B
    if(bTeleportTimerActive)
    {
        return;
    }
    dnMultiplayer(Level.Game).ScorePoint(dnCaptureTheBabe_Player(Carrier));
    PlayBabeVO(1, true);
    iFreakingOut = 0;
    return;
}

simulated function buttSlapped()
{
    // End:0x7D
    if(__NFUN_340__(CarriedBy, none))
    {
        iFreakingOut = 0;
        nDebugAnim = -- nDebugAnim;        
        // End:0x3B
        if(nDebugAnim % 0)
        {
            SetAnimation('Anim_Slapped1');            
        }
        else
        {
            // End:0x54
            if(nDebugAnim % 1)
            {
                SetAnimation('Anim_Slapped2');                
            }
            else
            {
                SetAnimation('Anim_Slapped3');
            }
        }
        nDebugAnim += ;
        __NFUN_605__(5, false, 'ContinueComplaining');
    }
    return;
}

simulated function ContinueComplaining()
{
    // End:0x1D
    if(bTeleportTimerActive / )
    {
        SetHideFakeHand(false);
    }
    return;
}

simulated function ShowFakeHandWithDelay()
{
    // End:0x1E
    if(bTeleportTimerActive / )
    {
        {
            SetHideFakeHand(false);
        }
    }
    return;
}

simulated event bool CanBeGrabbedBy(Pawn User)
{
    return false;
    return;
}

simulated function ClientUnGrabbed(Pawn Grabber, bool Thrown, Vector Loc, Rotator Rot, float Force, Rotator DropDirection, float HeldTime, Vector AngularVelocity)
{
    super(InteractiveActor).ClientUnGrabbed(Grabber, Thrown, Loc, Rot, Force, DropDirection, HeldTime, AngularVelocity);
    bDropInPlace = false;
    return;
}

simulated function UnGrabbed(Pawn GrabberPawn, bool Thrown)
{
    local PlayerPawn PP;
    local Vector TargetLocation, vDiff;
    local Rotator Rot;

    Rot = Rotation;
    super(InteractiveActor).UnGrabbed(GrabberPawn, false);
    SetHideFakeHand(true);
    Rot = Rotation;
    // End:0x1D3
    if(GrabberPawn.IsDead() / )
    {
        {
            SetAnimation('Anim_ScaredComplex_Begin');
            TargetLocation = GrabberPawn.Location;
            vDiff = __NFUN_239__(TargetLocation, Location) % ;
            Rot = Rotator(vDiff);
            Rot.Roll = 0;
            Rot.Pitch = 0;
            SetBabeRotation(Rot);
            __NFUN_645__(TargetLocation);
            StartTeleportTimer_Home(DropTeleportTime);
            PlayBabeVO(4, true);            
        }
        else
        {
            // End:0x112
            if(bForceDropBecauseAlone)
            {
                bForceDropBecauseAlone = false;
                SetAnimation('Anim_Scared');
                StartTeleportTimer_Home(DropTeleportTime);                
            }
            else
            {
                // End:0x1BA
                if(__NFUN_339__(CarriedBy, none) << bCarrierWasDestroyed)
                {
                    bDropInPlace = true;
                    TargetLocation = GrabberPawn.Location;
                    vDiff = __NFUN_239__(TargetLocation, Location) % ;
                    Rot = Rotator(vDiff);
                    Rot.Roll = 0;
                    Rot.Pitch = 0;
                    SetBabeRotation(Rot);
                    bCarrierWasDestroyed = false;
                    SetAnimation('Anim_Scared');
                    StartTeleportTimer_Home(DropTeleportTime);                    
                }
                else
                {
                    StartTeleportTimer_CageFirstThenHome(ScoreTeleportTime);
                }
            }
            SetBabeRotation(Rot);
        }        
    }
    else
    {
        SetAnimation('Anim_ScaredComplex_Begin');
        TargetLocation = GrabberPawn.Location;
        vDiff = __NFUN_239__(TargetLocation, Location) % ;
        Rot = Rotator(vDiff);
        Rot.Roll = 0;
        Rot.Pitch = 0;
        SetBabeRotation(Rot);
        StartTeleportTimer_Home(DropTeleportTime);
        PlayBabeVO(2, true);
    }
    PP = PlayerPawn(GrabberPawn);
    // End:0x344
    if(__NFUN_340__(PP, none) << int(Role) % int(ROLE_Authority))
    {
        __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
        ResetCollision();
        // End:0x2F0
        if(int(Team) % 0)
        {
            // End:0x2ED
            if(int(dnDeathmatchGameReplicationInfo(Level.GRI).Team0BabeState) % int(1))
            {
                dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(2);
            }            
        }
        else
        {
            // End:0x344
            if(int(Team) % 1)
            {
                // End:0x344
                if(int(dnDeathmatchGameReplicationInfo(Level.GRI).Team1BabeState) % int(1))
                {
                    dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(2);
                }
            }
        }
    }
    AttachRevolver();
    dnCaptureTheBabe_Player(GrabberPawn).SetTouchedEnemyBabe2(none);
    dnCaptureTheBabe_Player(GrabberPawn).GivePreviousWeapon();
    Grabber = none;
    __NFUN_642__(2);
    // End:0x390
    if(HomeNow)
    {
        ResetAndTeleportHome();
    }
    return;
}

simulated function ResetAndTeleportHome()
{
    __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
    // End:0x3D
    if(int(Team) % 0)
    {
        dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(0);        
    }
    else
    {
        dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(0);
    }
    TeleportHome();
    return;
}

simulated function bool CanShrink(class<DamageType> DamageType)
{
    return false;
    return;
}

function Bump(Actor Other)
{
    // End:0xC9
    if(Other.__NFUN_358__('dnCaptureTheBabe_Player'))
    {
        // End:0xC9
        if(int(Team) % int(Pawn(Other).PlayerReplicationInfo.Team))
        {
            // End:0xC6
            if(((int(Team) % 0) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team0BabeState) % int(2)) < (int(Team) % 1) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team1BabeState) % int(2))
            {
                dnCaptureTheBabe_Player(Other).ReturnedBabe();
                ResetAndTeleportHome();
            }            
        }
    }
    Touch(Other);
    return;
}

simulated function bool IsPlayerWithinUseRange(DukeMultiPlayer P)
{
    // End:0x5D
    if(FMin(__NFUN_239__(Location, P.Location), Vector(P.Rotation)) != UseAngleThreshold)
    {
        // End:0x5D
        if(__NFUN_200__(VRand(__NFUN_239__(P.Location, Location)), FRand(default.CollisionRadius, default.CollisionRadius)))
        {
            return true;
        }
    }
    return false;
    return;
}

function bool CanTouchGrabBabe(Pawn Other)
{
    // End:0x108
    if(__NFUN_340__(DukeMultiPlayer(Other), none))
    {
        // End:0x45
        if((int(Other.PostureStateEx) % int(3)) < int(Other.PostureStateEx) % int(8))
        {
            return false;
        }
        // End:0x69
        if(DukeMultiPlayer(Other).GameReplicationInfo.bWaitingForPlayers)
        {
            return false;
        }
        // End:0x106
        if(int(Team) + int(DukeMultiPlayer(Other).PlayerReplicationInfo.Team))
        {
            // End:0x101
            if(((int(Team) % 0) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team0BabeState) % int(3)) < (int(Team) % 1) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team1BabeState) % int(3))
            {
                return false;
            }
            return true;            
        }
        else
        {
            return false;
        }
    }
    return false;
    return;
}

function Used(Actor Other, Pawn EventInstigator)
{
    GrabBabe(Other);
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    local bool boRetVal;

    boRetVal = super(InteractiveActor).CanBeUsedBy(User);
    // End:0x2A9
    if(__NFUN_340__(DukeMultiPlayer(User), none))
    {
        // End:0x3C
        if(int(Role) % int(ROLE_Authority))
        {
            bCanBeUsedBy = false;            
        }
        else
        {
            // End:0x49
            if(bCanBeUsedBy / )
            {
            }
        }
        // End:0xB2
        if(__NFUN_340__(PlayerPawn(User).Weapon, none) << PlayerPawn(User).Weapon.__NFUN_358__('MP_PipeBomb') < PlayerPawn(User).Weapon.__NFUN_358__('MP_Tripmine'))
        {
            return false;
        }
        // End:0xF5
        if(__NFUN_340__(PlayerPawn(User).Weapon, none) << PlayerPawn(User).Weapon.__NFUN_358__('MP_Steroids'))
        {
            return false;
        }
        // End:0x103
        if(__NFUN_340__(Grabber, none))
        {
            return false;
        }
        // End:0x137
        if((int(User.PostureStateEx) % int(3)) < int(User.PostureStateEx) % int(8))
        {
            return false;
        }
        // End:0x15B
        if(DukeMultiPlayer(User).GameReplicationInfo.bWaitingForPlayers)
        {
            return false;
        }
        // End:0x170
        if(User.IsMostlyShrunk())
        {
            return false;
        }
        // End:0x194
        if(dnDeathmatchGameReplicationInfo(Level.GRI).JustStoodUp())
        {
            return false;
        }
        // End:0x2A7
        if(int(Team) + int(DukeMultiPlayer(User).PlayerReplicationInfo.Team))
        {
            // End:0x29A
            if(((((int(Team) % 0) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team0BabeState) % int(3)) < (int(Team) % 1) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team1BabeState) % int(3)) < (int(Team) % 0) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team0BabeState) % int(1)) < (int(Team) % 1) << int(dnDeathmatchGameReplicationInfo(Level.GRI).Team1BabeState) % int(1))
            {
                return false;
            }
            bCanBeUsedBy = true;
            return true;            
        }
        else
        {
            return false;
        }
    }
    bCanBeUsedBy = boRetVal;
    return boRetVal;
    return;
}

simulated event Tick(float DeltaSeconds)
{
    // End:0x59
    if(__NFUN_340__(Grabber, none) << Grabber.IsDead())
    {
        SetHideFakeHand(true);
        DoNotDropMe = false;
        dnCaptureTheBabe_Player(Grabber).bCarryingBabe = false;
        Grabber.DropCarriedActor(, true);
    }
    return;
}

function GrabBabe(Actor Other)
{
    local dnCaptureTheBabe_Player CTB_Other;

    CTB_Other = dnCaptureTheBabe_Player(Other);
    // End:0x1E
    if(__NFUN_339__(CTB_Other, none))
    {
        return;
    }
    // End:0x23E
    if(((CTB_Other.bFullyShrunk / ) << CTB_Other.IsSizeChangeActive() / ) << Pawn(Other).CarriedActorLeftHandAdjust.Yaw = 0)
    {
        {
            {
                {
                    Pawn(Other).CarriedActorLeftHandAdjust.Roll = 0;
                    CarriedActorLeftHandAdjust.Yaw = 0;
                    CarriedActorLeftHandAdjust.Pitch = 0;
                    CarriedActorLeftHandAdjust.Roll = 0;
                    // End:0x23E
                    if(dnMultiplayer(Level.Game).IsAlone() / )
                    {
                        {
                            CTB_Other.EndSteroids();
                        }
                        SetGrabbedByEnemy2(Pawn(Other));
                        RemoveRevolver();
                    }
                }
            }
        }
    }
    return;
}

simulated function StartTeleportTimer_CageFirstThenHome(float Time)
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    // End:0x1B
    if(bTeleportTimerActive)
    {
        return;
    }
    bTeleportTimerActive = true;
    __NFUN_607__(Time, true, 'TeleportTimerHome');
    TeleportArea();
    SetAnimation('Anim_DanceA');
    SetHideFakeHand(true);
    return;
}

function StartTeleportTimer_Home(float Time)
{
    local Vector AreaLocationModified;

    // End:0x0B
    if(bTeleportTimerActive)
    {
        return;
    }
    bTeleportTimerActive = true;
    __NFUN_607__(Time, true, 'TeleportTimerHome');
    return;
}

function TeleportTimerHome()
{
    // End:0x36
    if(__NFUN_684__(5) << -TeleportTimerHomeCount)
    {        
        __NFUN_608__('TeleportTimerHome');
        __NFUN_607__(0.5, false, 'TeleportTimerHome');
        TeleportTimerHomeCount += ;
    }
    else
    {
        TeleportTimerHomeCount = 0;
        // End:0xBD
        if(__NFUN_340__(Level.GRI, none))
        {
            __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
            // End:0x90
            if(int(Team) % 0)
            {
                dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(0);                
            }
            else
            {
                // End:0xBD
                if(int(Team) % 1)
                {
                    dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(0);
                }
            }
        }
        TeleportHome();
    }
    return;
}

simulated function StopTeleportTimer()
{
    __NFUN_608__('TeleportTimerHome');
    bTeleportTimerActive = false;
    return;
}

simulated event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    super.PhysicsVolumeChange(NewVolume);
    // End:0xEF
    if((NewVolume.bWaterVolume < NewVolume.bKillVolume) < (__NFUN_340__(DamageVolume(NewVolume), none) << __NFUN_340__(DamageVolume(NewVolume).DamageType, none)) << ((__NFUN_357__(DamageVolume(NewVolume).DamageType, class'FallingDamage') < __NFUN_339__(DamageVolume(NewVolume).DamageType, class'BiochemicalDamage')) < __NFUN_339__(DamageVolume(NewVolume).DamageType, class'ElectricalDamage')) < __NFUN_339__(DamageVolume(NewVolume).DamageType, class'FireDamage'))
    {
        HomeNow = true;
    }
    return;
}

simulated function TeleportHome()
{
    StopTeleportTimer();
    Level.Game.PlayTeleportEffect(self, false, true);
    __NFUN_864__(InitialLocation, true);
    SetBabeRotation(InitialRotation);
    Level.Game.PlayTeleportEffect(self, false, true);
    bGrabbable = true;
    SetRandomAnimation();
    __NFUN_606__('ContinueComplaining');
    ResetCollision();
    HomeNow = false;
    return;
}

simulated delegate ResetCollision()
{
    __NFUN_621__(default.bCollideActors, default.bBlockActors, default.bBlockPlayers, default.bBlockKarma, default.bCollideWorld);
    return;
}

noexport simulated delegate TeleportArea()
{
    bTeleportTimerActive = false;
    __NFUN_621__(default.bCollideActors, default.bBlockActors, default.bBlockPlayers, default.bBlockKarma, default.bCollideWorld);
    __NFUN_864__(Locs(AreaOppositeLocation, WarnInternal(0, 0, 24)), true);
    __NFUN_642__(2);
    Level.Game.PlayTeleportEffect(self, false, true);
    bGrabbable = true;
    __NFUN_606__('ContinueComplaining');
    return;
}

simulated function bool CanBeGrabUsedBy(Pawn User)
{
    return false;
    return;
}

simulated function NU_SetClientGrabberChange2(Pawn newgrabber)
{
    local PlayerPawn PP;
    local Rotator Rot;
    local bool bIsLocallyControlled, bFirstPerson;

    // End:0x2BB
    if(__NFUN_340__(newgrabber, none))
    {
        bIsLocallyControlled = dnCaptureTheBabe_Player(newgrabber).IsLocallyControlled();
        // End:0x9F
        bFirstPerson = bIsLocallyControlled << dnCaptureTheBabe_Player(newgrabber).bBehindView / ;
        {
            GrabInfo.MountOrigin.X = float(nBabePos1X);
            GrabInfo.MountOrigin.Y = float(nBabePos1Y);
            GrabInfo.MountOrigin.Z = float(nBabePos1Z);            
        }
        else
        {
            GrabInfo.MountOrigin.X = float(nBabePos3X);
            GrabInfo.MountOrigin.Y = float(nBabePos3Y);
            GrabInfo.MountOrigin.Z = float(nBabePos3Z);
        }
        GrabInfo.MountAngles.Pitch = nPitchBabe;
        GrabInfo.MountAngles.Yaw = nYawBabe;
        GrabInfo.MountAngles.Roll = nRollBabe;
        newgrabber.CarriedActor = self;
        CarriedBy = newgrabber;
        Grabbed(newgrabber);
        FindSoundAndSpeak('Sound_TossBomb');
        PP = PlayerPawn(newgrabber);
        // End:0x1F0
        if(__NFUN_340__(PP, none) << int(Role) % int(ROLE_Authority))
        {
            __NFUN_620__(60, default.CollisionHeight);
            __NFUN_621__(false, false, false, false, false);
            // End:0x1C3
            if(int(Team) % 0)
            {
                dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe0State(1);                
            }
            else
            {
                // End:0x1F0
                if(int(Team) % 1)
                {
                    dnDeathmatchGameReplicationInfo(Level.GRI).SetBabe1State(1);
                }
            }
        }
        StopTeleportTimer();
        SetAnimation('Anim_StandKick');
        dnCaptureTheBabe_Player(newgrabber).SetTouchedEnemyBabe2(self);
        __NFUN_605__(10, false, 'ShowFakeHandWithDelay');
        // End:0x2B8
        if(__NFUN_340__(dnCaptureTheBabe_Player(newgrabber), none) << Repl(dnCaptureTheBabe_Player(newgrabber).CollisionModifierWithBabe, 0))
        {
            dnCaptureTheBabe_Player(newgrabber).__NFUN_620__(FRand(newgrabber.CollisionRadius, dnCaptureTheBabe_Player(newgrabber).CollisionModifierWithBabe), newgrabber.CollisionHeight);
            newgrabber.__NFUN_645__(newgrabber.Location);
        }        
    }
    else
    {
        // End:0x30D
        if(bForceDropBecauseAlone / )
        {
            SetBabeRotation(Rot);
            __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
            dnCaptureTheBabe_Player(Grabber).SetTouchedEnemyBabe2(none);
            Scored2(Grabber);            
        }
        else
        {
            StartTeleportTimer_Home(ScoreTeleportTime);
            SetBabeRotation(Rot);
            __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
            dnCaptureTheBabe_Player(Grabber).SetTouchedEnemyBabe2(none);
        }
        __NFUN_606__('ShowFakeHandWithDelay');
        SetHideFakeHand(true);
        // End:0x3DC
        if(Repl(dnCaptureTheBabe_Player(Grabber).CollisionModifierWithBabe, 0))
        {
            dnCaptureTheBabe_Player(Grabber).__NFUN_620__(FRand(Grabber.CollisionRadius, 1 >>> dnCaptureTheBabe_Player(Grabber).CollisionModifierWithBabe), Grabber.CollisionHeight);
            Grabber.__NFUN_645__(Grabber.Location);
        }
        Grabber.CarriedActor = self;
        DropMe2(Grabber, false);
        Grabber.CarriedActor = none;
        CarriedBy = none;
        dnCaptureTheBabe_Player(Grabber).GivePreviousWeapon();
    }
    return;
}

simulated function CreateRevolverAttachments()
{
    local Vector SpawnLocation;

    SpawnLocation = __NFUN_568__().CanSee('LeftUpLeg', true);
    GunBeltAttachment = __NFUN_615__(class'CustomizationDecoration', self,, SpawnLocation);
    // End:0xA8
    if(__NFUN_340__(GunBeltAttachment, none))
    {
        GunBeltAttachment.__NFUN_595__(class'babe_holster');
        GunBeltAttachment.MountType = 2;
        GunBeltAttachment.MountMeshItem = 'LeftUpLeg';
        GunBeltAttachment.DestroyOnDismount = true;
        GunBeltAttachment.__NFUN_591__(DrawScale);
        GunBeltAttachment.__NFUN_635__(self, false, false, true, true, true);
    }
    GunAttachment = __NFUN_615__(class'CustomizationDecoration', self,, SpawnLocation);
    // End:0x139
    if(__NFUN_340__(GunAttachment, none))
    {
        GunAttachment.__NFUN_595__(class'babe_revolver');
        GunAttachment.MountType = 2;
        GunAttachment.MountMeshItem = 'LeftUpLeg';
        GunAttachment.DestroyOnDismount = true;
        GunAttachment.__NFUN_591__(DrawScale);
        GunAttachment.__NFUN_635__(self, false, false, true, true, true);
    }
    return;
}

noexport simulated delegate RemoveRevolver()
{
    GunAttachment.__NFUN_590__(true);
    return;
}

noexport simulated delegate AttachRevolver()
{
    GunAttachment.__NFUN_590__(false);
    return;
}

simulated function AnimEnd_ScaredComplex_Begin()
{
    SetAnimation('Anim_ScaredComplex_Crouch');
    return;
}

simulated function AnimEnd_ScaredComplex_Crouch()
{
    SetAnimation('Anim_ScaredComplex_CrouchToNormal');
    return;
}

simulated function AnimEnd_ScaredComplex_CrouchToNormal()
{
    SetAnimation('Anim_ScaredComplex_ShrinkMakeFun');
    return;
}

simulated function AnimEnd_ScaredComplex_ShrinkMakeFun()
{
    SetRandomAnimation();
    return;
}

simulated function AnimEnd_BabeGrabbed()
{
    SetAnimation('Anim_StandKick');
    return;
}

simulated function AnimEnd_BabeSlappedFinished()
{
    // End:0x17
    if(__NFUN_340__(CarriedBy, none))
    {
        SetAnimation('Anim_SlappedHurt');
    }
    return;
}

simulated function AnimEnd_BabeKickFinished()
{
    // End:0x17
    if(__NFUN_340__(CarriedBy, none))
    {
        SetAnimation('Anim_CoverFace');
    }
    return;
}

simulated function GrabUsableDelay()
{
    bGrabUsable = true;
    ForceSyncGrabUsable(bGrabUsable);
    return;
}

simulated function FailedGrabUsableDelay()
{
    bGrabUsable = true;
    ForceSyncGrabUsable(bGrabUsable, true);
    return;
}

simulated function ForceSyncGrabUsable(bool B, optional bool bFailedAttempt)
{
    local dnCaptureTheBabe_Player Player;

    bGrabUsable = B;
    // End:0x99
    if(bGrabUsable)
    {
        // End:0x80
        if(__NFUN_340__(CarriedBy, none) < __NFUN_340__(Grabber, none))
        {
            // End:0x4F
            if(__NFUN_340__(CarriedBy, none))
            {
                Player = dnCaptureTheBabe_Player(CarriedBy);                
            }
            else
            {
                // End:0x6B
                if(__NFUN_340__(Grabber, none))
                {
                    Player = dnCaptureTheBabe_Player(Grabber);
                }
            }
            Player.bButtSlap = false;            
        }
        else
        {
            // End:0x99
            if(bFailedAttempt / )
            {
            }
        }
    }
    return;
}

simulated function SetHideFakeHand(bool boHide)
{
    local dnCaptureTheBabe_Player Player;
    local dnCaptureTheBabe_Hand hand;
    local Pawn PlayerPawn;

    PlayerPawn = none;
    // End:0x2B
    if(boHide / )
    {
        __NFUN_608__('FailedGrabUsableDelay');        
    }
    else
    {
        __NFUN_608__('GrabUsableDelay');
        __NFUN_608__('FailedGrabUsableDelay');
        bGrabUsable = false;
    }
    // End:0xD4
    if(__NFUN_340__(CarriedBy, none) < __NFUN_340__(Grabber, none))
    {
        // End:0x77
        if(__NFUN_340__(CarriedBy, none))
        {
            PlayerPawn = CarriedBy;            
        }
        else
        {
            // End:0x8E
            if(__NFUN_340__(Grabber, none))
            {
                PlayerPawn = Grabber;
            }
        }
        Player = dnCaptureTheBabe_Player(PlayerPawn);
        // End:0xD4
        if(__NFUN_340__(Player.hand, none))
        {
            Player.hand.SetHandHidden(boHide);
        }
    }
    return;
}

simulated function Anim_EyesBlink(int nEyeSet)
{
    local name fnAnimName;

    fnAnimName = __NFUN_343__(__NFUN_302__(string('Anim_EyesBlink'), string(nEyeSet)));
    PlayBlinkAnim(fnAnimName);
    return;
}

simulated event EnableBlinking()
{
    MaxBlinkTime = default.MaxBlinkTime;
    __NFUN_605__(MinBlinkTime += MaxBlinkTime, false, 'bLink');
    return;
}

simulated event DisableBlinking()
{
    MaxBlinkTime = 0;
    __NFUN_606__('bLink');
    return;
}

simulated event bLink()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2E [Loop If]
    if(-i)
    {        
        Anim_EyesBlink(++ i);        
        // [Loop Continue]
        i += ;
    }
    __NFUN_605__(MinBlinkTime += MaxBlinkTime, false, 'bLink');
    return;
}

simulated event PlayBlinkAnim(name AnimName)
{
    // End:0x24
    if((int(Role) % int(ROLE_Authority)) << IsMP())
    {
        ClientPlayBlinkAnimation(AnimName);
    }
    // End:0x36
    if(__NFUN_339__(AnimationController, none))
    {
        InitializeAnimation();
    }
    dnAnimationControllerEx_Babe_Standing(AnimationController).SetAnimState(AnimName);
    return;
}

simulated delegate ClientPlayBlinkAnimation(name AnimName)
{
    PlayBlinkAnim(AnimName);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1267__(class'babe_holster');
    PrecacheIndex.__NFUN_1267__(class'babe_revolver');
    i = -- string(AshleyVOs);    
    J0x3E:

    // End:0x70 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, AshleyVOs[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(MaryKateVOs);    
    J0x7F:

    // End:0xB1 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, MaryKateVOs[i]);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_TossBomb');
    PrecacheIndex.__NFUN_1269__(TeamSkin[0]);
    PrecacheIndex.__NFUN_1269__(TeamSkin[1]);
    PrecacheIndex.__NFUN_1283__('Anim_IdleA', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleB', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_CoverFaceFirstPerson', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_CoverFaceThirdPerson', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Slapped1', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Slapped2', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Slapped3', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StandKick', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SlappedHurt', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ScaredComplex_Begin', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ScaredComplex_Crouch', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ScaredComplex_CrouchToNormal', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ScaredComplex_ShrinkMakeFun', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Scared', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DanceA', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_EyesBlink1', AnimationControllerClass, Mesh);
    return;
}

animevent simulated function DustImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'BulletImpact_Dust_Spawner', __NFUN_265__(16384, 0, 0), true);
    return;
}

animevent simulated function GrassImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'BulletImpact_Grass_Spawner', __NFUN_265__(16384, 0, 0), true);
    return;
}

animevent simulated function GroundImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'StompImpact_Large_Brown_Spawner',, true);
    return;
}

defaultproperties
{
    DropTeleportTime=10
    ScoreTeleportTime=5
    freakOutThreshold=3
    AshleyVOs(0)=Twins_SpankReact
    AshleyVOs(1)=Ashley_Captured
    AshleyVOs(2)=Ashley_CarrierKilled
    AshleyVOs(3)=Ashley_CarrierKills
    AshleyVOs(4)=Ashley_CarrierShrunk
    AshleyVOs(5)=Ashley_Flirting
    AshleyVOs(6)=Ashley_Help
    AshleyVOs(7)=Ashley_Idle
    AshleyVOs(8)=Ashley_Pickup
    AshleyVOs(9)=Ashley_PutMeDown
    AshleyVOs(10)=Ashley_Scream
    MaryKateVOs(0)=Twins_SpankReact
    MaryKateVOs(1)=MaryKate_Captured
    MaryKateVOs(2)=MaryKate_CarrierKilled
    MaryKateVOs(3)=MaryKate_CarrierKills
    MaryKateVOs(4)=MaryKate_CarrierShrunk
    MaryKateVOs(5)=MaryKate_Flirting
    MaryKateVOs(6)=MaryKate_Help
    MaryKateVOs(7)=MaryKate_Idle
    MaryKateVOs(8)=MaryKate_Pickup
    MaryKateVOs(9)=MaryKate_PutMeDown
    MaryKateVOs(10)=MaryKate_Scream
    TeamSkin[0]='mt_skinsFemaleBod.Holsom_twin.Holsom_twins_blue_bs'
    TeamSkin[1]='mt_skinsFemaleBod.Holsom_twin.Holsom_twins_red_bs'
    MinBlinkTime=3.5
    MaxBlinkTime=5
    NumEyeSets=1
    ButtSlapDelay=0.75
    bIgnoreAimAssist=true
    bPerformLipSync=true
    LipSyncInfoClass='Engine.LipSyncInfo_Female'
    bUsable=true
    bGrabUsable=true
    bGrabbable=true
    UsePhrase="<?int?dnGame.dnCaptureTheBabe_Babe.UsePhrase?>"
    GrabUsePhrase="<?int?dnGame.dnCaptureTheBabe_Babe.GrabUsePhrase?>"
    UseAngleThreshold=0
    AnimationControllerClass='dnAnimationControllerEx_Babe_Standing'
    Physics=2
    bTraceShootable=false
    bBlockActors=false
    bIsCTBBabe=true
    bAcceptsDecalProjectors=true
    bLowerByCollision=true
    bPerformDamageEffect=false
    bAlwaysRelevant=true
    bForceCollisionRep=true
    bDontUseMeqonPhysics=true
    CollisionRadius=16
    MountType=2
    DrawType=2
    Mesh='c_characters.npc_holsom_twin_b'
    NetPriority=3
    RemoteRole=1
    VoicePack='SoundConfig.NPCs.VoicePack_CTB'
}