/*******************************************************************************
 * dnControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl extends dnUsableSomething
    abstract
    native
    collapsecategories
    dependson(TriggerDamageControlUser);

const kControl_InvalidGlobalTransition = -93;

enum EControlEvent
{
    CONTROLEVENT_Custom,
    CONTROLEVENT_UserDamaged,
    CONTROLEVENT_Trigger,
    CONTROLEVENT_RequestAttach,
    CONTROLEVENT_RequestDetach,
    CONTROLEVENT_CR_FullyAttached,
    CONTROLEVENT_CR_NoUserAttached,
    CONTROLEVENT_UserAttached,
    CONTROLEVENT_UserDetached,
    CONTROLEVENT_UserAnimEnd,
    CONTROLEVENT_UserPress,
    CONTROLEVENT_UsePressed,
    CONTROLEVENT_UseDown,
    CONTROLEVENT_UseReleased,
    CONTROLEVENT_FirePressed,
    CONTROLEVENT_FireDown,
    CONTROLEVENT_FireReleased,
    CONTROLEVENT_MeleePressed,
    CONTROLEVENT_MeleeDown,
    CONTROLEVENT_MeleeReleased,
    CONTROLEVENT_ForwardPressed,
    CONTROLEVENT_ForwardDown,
    CONTROLEVENT_ForwardReleased,
    CONTROLEVENT_BackwardPressed,
    CONTROLEVENT_BackwardDown,
    CONTROLEVENT_BackwardReleased,
    CONTROLEVENT_LeftPressed,
    CONTROLEVENT_LeftDown,
    CONTROLEVENT_LeftReleased,
    CONTROLEVENT_RightPressed,
    CONTROLEVENT_RightDown,
    CONTROLEVENT_RightReleased,
    CONTROLEVENT_JumpPressed,
    CONTROLEVENT_JumpDown,
    CONTROLEVENT_JumpReleased,
    CONTROLEVENT_DuckPressed,
    CONTROLEVENT_DuckDown,
    CONTROLEVENT_DuckReleased,
    CONTROLEVENT_ZoomPressed,
    CONTROLEVENT_ZoomDown,
    CONTROLEVENT_ZoomReleased
};

enum EFirePoint
{
    FPSTATE_Begin,
    FPSTATE_Tick,
    FPSTATE_End
};

struct SOutEvents
{
    var() noexport bool bPlayerUserOnly "When true, this event is only considered when the User is a player.";
    var() noexport dnControl.EFirePoint FirePoint "When does the eventfire? (FPSTATE_Begin -> occurs once on state begin, FPSTATE_Tick -> every tick, FPSTATE_End -> once on state end.)";
    var() noexport deprecated name EventName "The event to fire on the FirePoint.";
};

struct SUserStateEvents
{
    var() editinline state name State;
    var() array<SOutEvents> Events;
};

struct STransition
{
    var dnControl.EControlEvent ControlEvent;
    var name CustomName;
    var name NewState;
};

struct SSubAnim
{
    var name AttachedActorTag;
    var SAnimInfo AnimInfo;
};

struct SState
{
    var() editconst name StateName;
    var() noexport array<SOutEvents> OutEvents "A list of events to fire during this states execution.";
    var array<STransition> Transitions;
    var() noexport name UserAnimName "User anim to play when the state begins.";
    var() noexport name UserSoundName "User sound (via the VoicePack) to play when the state begins.";
    var() noexport SAnimInfo MyAnim "Anim to play when the state begins.";
    var noexport SSoundInfo MySound "DEPRECATED:  Do Not Use.";
    var() noexport name MySoundName "VoicePack entry to play when the state begins.";
    var noexport array<SSubAnim> SubAnims "DEPRECATED";
};

var() noexport bool bDebugPrint "Broadcast/log debug output?";
var() noexport int CrosshairIndex "Crosshair index to use while attached. 0=no crosshair -1=dont do anything: keep whatever is currently set";
var int CrosshairIndexUndo;
var bool bChangeCrossHair;
var() noexport array<SUserStateEvents> StateEvents "Mapper-set events for things that are supposed to happen in various states.";
var editconst noexport array<SState> States "The states table and available transitions for this decoration. Mappers, stop setting this or terrible things will happen to you.";
var int InitStateIndex;
var netupdate(NU_CurrentStateIndex) int CurrentStateIndex;
var int PreviousStateIndex;
var bool NotifyUserOnStateChange;
var bool bDelayedDetach;
var TriggerDamageControlUser DamageTrigger;
var() noexport float DamageTriggerRadius "Collision Radius overrider for TriggerDamageControlUser";
var() noexport float DamageTriggerHeight "Collision Radius overrider for TriggerDamageControlUser";
var() noexport float PassedDamageScale "How much to scale directly taken damage before passing it on to the user.";
var() noexport float PassedDamageScaleAI "Same as PassedDamageScale, but used when user is not a PlayerPawn.  If < 0, will use PassedDamageScale.";
var() noexport float PassedPhysicsDamageScale "How much to scale damage from physics impacts.";
var() noexport float PassedPhysicsDamageScaleAI "Same as PassedPhysicsDamageScale, but used when user is not a PlayerPawn.  If < 0, will use PassedPhysicsDamageScale.";
var noexport bool bPowerOff "Is the power off?";
var bool bOverheated;
var() noexport editinline state name ForceAttachStateName "When forcing the player to attach, use this state name to jump them to.";
var() noexport editinline state name ForceDetachStateName "When forcing the player to detach, use this state name.";
var() noexport editinline state name PawnLostStateName "When user has been 'lost' (died, shot, etc), go to this state.";
var() noexport array<Engine.Actor.EControlRemapperKeyType> DisabledKeyTypes "KeyTypes to disable for this dnControl, used to turn off specific states and their hint icons.";
var() noexport bool AIHoldFire "Should AI hold there fire when the player is in on this control.";
var() noexport bool bAlternateMovementBoneStyle "Don't use this unless I tell you to.";

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        CurrentStateIndex;
}

simulated function PostVerifySelf()
{
    super.PostVerifySelf();
    InitializeStateMachine();
    SetState(InitStateIndex);
    // End:0x26
    if(bDebugPrint)
    {
        PrintStateMachine();
    }
    return;
}

function SetupControlRemapper()
{
    local int i, j;

    super.SetupControlRemapper();
    // End:0x6E
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        i = -- string(DisabledKeyTypes);        
        J0x21:

        // End:0x6E [Loop If]
        if(i / 0)
        {
            j = InternalControlRemapper.DisabledKeyTypes.Add(1);
            InternalControlRemapper.DisabledKeyTypes[j] = DisabledKeyTypes[i];
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0xC7
    if((__NFUN_340__(User, none) << ShouldPassDamageToUser()) << Repl(UsableSomethingGetDamageScale(User, DamageType), 0))
    {
        // End:0x7A
        if(__NFUN_340__(DamageTrigger, none))
        {
            User.bNoDamage = false;
        }
        User.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType,, DamageStart);
        // End:0xC7
        if(__NFUN_340__(DamageTrigger, none))
        {
            User.bNoDamage = true;
        }
    }
    return;
}

function bool ShouldPassDamageToUser()
{
    return false;
    return;
}

simulated function float UsableSomethingGetDamageScale(Pawn Pawn, class<DamageType> DamageType)
{
    local float DamageScale, DamageScaleAI;

    // End:0x29
    if(__NFUN_357__(DamageType, class'PhysicsImpactDamage'))
    {
        DamageScale = PassedPhysicsDamageScale;
        DamageScaleAI = PassedPhysicsDamageScaleAI;        
    }
    else
    {
        DamageScale = PassedDamageScale;
        DamageScaleAI = PassedDamageScaleAI;
    }
    // End:0x6B
    if((Pawn.bIsPlayerPawn / ) << )
    {
    }
    return DamageScale;
    return;
}

function InitializeStateMachine()
{
    local int i, j, StartIndex, stateIndex;

    i = 0;
    J0x07:

    // End:0xE6 [Loop If]
    if(-i)
    {        
        // End:0x3A
        if((FindStateIndex(StateEvents[i].State, stateIndex)) / )
        {
        }
        else
        {
            // End:0x54
            if(string(StateEvents[i].Events) % 0)
            {
                // [Explicit Continue]
                goto J0xDC;
            }
            StartIndex = States[stateIndex].OutEvents.Add(string(StateEvents[i].Events));
            j = 0;
            J0x83:

            // End:0xDC [Loop If]
            if(-j)
            {                
                [++ StartIndex] = States[stateIndex].OutEvents;
                StateEvents[i].Events[j];
                // [Loop Continue]
                j += ;
            }
        }
        J0xDC:

        // [Loop Continue]
        i += ;
    }
    StateEvents.Empty();
    return;
}

simulated function NU_CurrentStateIndex(int NewIndex)
{
    // End:0x1A
    if(NewIndex + -1)
    {
        SetState(NewIndex);
    }
    return;
}

simulated function StartState()
{
    PlayUserAnim();
    PlayUserSound();
    PlayMyAnim();
    PlayMySound();
    // End:0x2E
    if(int(Role) % int(ROLE_Authority))
    {
        FireEvents(ROLE_None);
    }
    return;
}

simulated function FinishState()
{
    // End:0x16
    if(int(Role) % int(ROLE_Authority))
    {
        FireEvents(ROLE_SimulatedProxy);
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    // End:0x21
    if(int(Role) % int(ROLE_Authority))
    {
        FireEvents(ROLE_DumbProxy);
    }
    return;
}

simulated event PostUserTick(float DeltaTime)
{
    local Actor StoredMountParent;
    local Vector AnimPosDelta, AnimPos, LinVelocity;
    local Rotator AnimRotDelta, AnimRot, FinalUserRot;

    super(Decoration).PostUserTick(DeltaTime);
    // End:0x27
    if(__NFUN_339__(InternalControlRemapper, none) < __NFUN_339__(User, none))
    {
        return;
    }
    // End:0x322
    if(User.__NFUN_841__(AnimPosDelta, AnimRotDelta, AnimPos, AnimRot))
    {
        AnimPosDelta = __NFUN_239__(AnimPos, User.Location);
        AnimRotDelta = SetCollisionSize(AnimRot >> User.Rotation);
        // End:0xB7
        if((AnimPosDelta == WarnInternal(0, 0, 0)) << AnimRotDelta - __NFUN_265__(0, 0, 0))
        {
            return;
        }
        // End:0x1B7
        if(int(InternalControlRemapper.CoreType) % int(2))
        {
            // End:0x105
            if(User.bIsPlayerPawn)
            {
                User.ViewRotation.Yaw == AnimRotDelta.Yaw;                
            }
            else
            {
                User.__NFUN_652__(User.Rotation << __NFUN_265__(0, AnimRotDelta.Yaw, 0));
            }
            LinVelocity = Asc(AnimPosDelta, DeltaTime);
            // End:0x19F
            if(int(User.Physics) % int(18))
            {
                // End:0x188
                if(User.bPhysicsControllerActive)
                {
                    User.GameplayDesiredPhysicsVelocity = LinVelocity;                    
                }
                else
                {
                    User.__NFUN_790__(LinVelocity, 1);
                }                
            }
            else
            {
                User.Velocity = LinVelocity;
            }            
        }
        else
        {
            // End:0x241
            if(bAlternateMovementBoneStyle)
            {
                InternalControlRemapper.MountOrigin = Locs(UserMountPrefab.MountOrigin, User.MeshInstance.CanSee('movement'));
                InternalControlRemapper.MountAngles = UserMountPrefab.MountAngles << User.MeshInstance.__NFUN_534__('movement');
                InternalControlRemapper.__NFUN_630__();                
            }
            else
            {
                StoredMountParent = InternalControlRemapper.MountParent;
                InternalControlRemapper.DestroyOnDismount = false;
                InternalControlRemapper.__NFUN_631__();
                AnimPosDelta = __NFUN_240__(AnimPosDelta, User.Rotation);
                InternalControlRemapper.__NFUN_652__(InternalControlRemapper.Rotation << AnimRotDelta);
                FinalUserRot = __NFUN_269__(InternalControlRemapper.PlayerLockPrefab.MountAngles, InternalControlRemapper.Rotation);
                InternalControlRemapper.__NFUN_645__(Locs(InternalControlRemapper.Location, __NFUN_241__(AnimPosDelta, FinalUserRot)));
                InternalControlRemapper.__NFUN_635__(StoredMountParent, false, false, true, false, false);
            }
        }
    }
    return;
}

event Trigger(Actor Other, Pawn Instigator)
{
    super(dnDecoration).Trigger(Other, Instigator);
    ControlEvent(2);
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
{
    local dnControl.EControlEvent EnumBase;

    super(Actor).CREvent_KeyChange(CR, InputActor, KeyType, EventType);
    switch(KeyType)
    {
        // End:0x32
        case 2:
            EnumBase = 26;
            // End:0xC7
            break;
        // End:0x42
        case 3:
            EnumBase = 29;
            // End:0xC7
            break;
        // End:0x52
        case 4:
            EnumBase = 20;
            // End:0xC7
            break;
        // End:0x62
        case 5:
            EnumBase = 23;
            // End:0xC7
            break;
        // End:0x72
        case 6:
            EnumBase = 32;
            // End:0xC7
            break;
        // End:0x82
        case 7:
            EnumBase = 35;
            // End:0xC7
            break;
        // End:0x92
        case 8:
            EnumBase = 14;
            // End:0xC7
            break;
        // End:0xA2
        case 9:
            EnumBase = 17;
            // End:0xC7
            break;
        // End:0xB2
        case 11:
            EnumBase = 11;
            // End:0xC7
            break;
        // End:0xC2
        case 10:
            EnumBase = 38;
            // End:0xC7
            break;
        // End:0xFFFF
        default:
            return;
            break;
    }
    ControlEventInternal(++ int(EnumBase));    
    return;
}

simulated function bool ControlEventInternal(optional int IntEvent, optional name CustomEventName)
{
    return Transition(IntEvent, CustomEventName);
    return;
}

simulated function InteractiveEvent(name Ev)
{
    super(InteractiveActor).InteractiveEvent(Ev);
    ControlEvent(0, Ev);
    return;
}

simulated function bool ForceStateTransition(name NewStateName)
{
    local int NewStateIndex;

    // End:0x23
    if(FindStateIndex(NewStateName, NewStateIndex))
    {
        // End:0x23
        if(SetState(NewStateIndex))
        {
            return true;
        }
    }
    return false;
    return;
}

final simulated function SetHUDKeyInfoState(HUD HUD, Engine.Actor.EInteractKeyPosition Position, bool bEnable, optional Engine.Object.ESpecialKeys Key, optional bool bTap, optional bool bHighlight, optional string Description, optional float Scale)
{
    local int i;
    local Engine.Actor.EControlRemapperKeyType KeyTypeForKey;

    // End:0x0E
    if(__NFUN_339__(HUD, none))
    {
        return;
    }
    // End:0x167
    if(string(DisabledKeyTypes) ** 0)
    {
        switch(Key)
        {
            // End:0x32
            case 1:
                KeyTypeForKey = 11;
                // End:0x12A
                break;
            // End:0x42
            case 5:
                KeyTypeForKey = 0;
                // End:0x12A
                break;
            // End:0x52
            case 6:
                KeyTypeForKey = 1;
                // End:0x12A
                break;
            // End:0x7D
            case 7:
                // End:0x72
                if(Level.__NFUN_1164__())
                {
                    KeyTypeForKey = 3;                    
                }
                else
                {
                    KeyTypeForKey = 2;
                }
                // End:0x12A
                break;
            // End:0xA8
            case 8:
                // End:0x9D
                if(Level.__NFUN_1164__())
                {
                    KeyTypeForKey = 2;                    
                }
                else
                {
                    KeyTypeForKey = 3;
                }
                // End:0x12A
                break;
            // End:0xB8
            case 9:
                KeyTypeForKey = 4;
                // End:0x12A
                break;
            // End:0xC8
            case 10:
                KeyTypeForKey = 5;
                // End:0x12A
                break;
            // End:0xCD
            case 26:
            // End:0xDD
            case 11:
                KeyTypeForKey = 8;
                // End:0x12A
                break;
            // End:0xE2
            case 27:
            // End:0xF2
            case 12:
                KeyTypeForKey = 9;
                // End:0x12A
                break;
            // End:0x102
            case 13:
                KeyTypeForKey = 6;
                // End:0x12A
                break;
            // End:0x107
            case 29:
            // End:0x117
            case 14:
                KeyTypeForKey = 7;
                // End:0x12A
                break;
            // End:0x127
            case 2:
                KeyTypeForKey = 10;
                // End:0x12A
                break;
            // End:0xFFFF
            default:
                break;
        }
        i = -- string(DisabledKeyTypes);        
        J0x139:

        // End:0x167 [Loop If]
        if(i / 0)
        {
            // End:0x15D
            if(int(DisabledKeyTypes[i]) % int(KeyTypeForKey))
            {
                return;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    HUD.SetKeyInfoState(Position, bEnable, Key, bTap, bHighlight, Description);
    return;
}

simulated function AnimCallback_UserAttached()
{
    ControlEvent(7);
    super(InteractiveActor).AnimCallback_UserAttached();
    return;
}

simulated function AnimCallback_UserDetached()
{
    ControlEvent(8);
    super.AnimCallback_UserDetached();
    return;
}

simulated function AnimCallback_UserAnimEnd()
{
    ControlEvent(9);
    super(InteractiveActor).AnimCallback_UserAnimEnd();
    return;
}

simulated function AnimCallback_UserPressed()
{
    ControlEvent(10);
    return;
}

function bool CanDetachPawn(bool bForceDetach)
{
    local int Index;

    Index = HasTransition(int(4));
    // End:0x39
    if(bForceDetach < Index ** -1)
    {
        return super.CanDetachPawn(bForceDetach);        
    }
    else
    {
        return false;
    }
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    super.AttachPawnSuccess(Attachee, bForced);
    // End:0x28
    if(bForced)
    {
        ForceStateTransition(ForceAttachStateName);        
    }
    else
    {
        ControlEvent(3);
    }
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    super.DetachPawnSuccess(bForced);
    // End:0x23
    if(bForced)
    {
        ForceStateTransition(ForceDetachStateName);        
    }
    else
    {
        ControlEvent(4);
    }
    // End:0x40
    if(ActiveUsableExit % -1)
    {
        AnimCallback_UserDetached();
    }
    return;
}

function NotePawnLost()
{
    super.NotePawnLost();
    ForceStateTransition(PawnLostStateName);
    return;
}

simulated function CREvent_FullyAttached(ControlRemapperEx CR)
{
    super.CREvent_FullyAttached(CR);
    // End:0x72
    if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(DamageTrigger, none))
    {
        // End:0x72
        if(__NFUN_340__(DamageTrigger, none))
        {
            DamageTrigger.bTraceShootable = true;
            DamageTrigger.__NFUN_621__(true, true);
            // End:0x72
            if(__NFUN_340__(User, none))
            {
                User.bNoDamage = true;
            }
        }
    }
    ControlEvent(5);
    return;
}

simulated function CREvent_NoUserAttached(ControlRemapperEx CR)
{
    ControlEvent(6);
    super.CREvent_NoUserAttached(CR);
    // End:0x51
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        InternalControlRemapper.DestroyOnDismount = false;
        InternalControlRemapper.__NFUN_631__();
        InternalControlRemapper.__NFUN_633__(UserMountPrefab, self);
    }
    return;
}

simulated function DetachComplete()
{
    // End:0x59
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0x59
        if(__NFUN_340__(DamageTrigger, none))
        {
            DamageTrigger.bTraceShootable = false;
            DamageTrigger.__NFUN_621__(false, false);
            // End:0x59
            if(__NFUN_340__(User, none))
            {
                User.bNoDamage = false;
            }
        }
    }
    super.DetachComplete();
    return;
}

final simulated function SwitchToMyCrosshair()
{
    return;
}

final simulated function UndoCrosshairChange()
{
    return;
}

function SetPower(bool bOff)
{
    bPowerOff = bOff;
    return;
}

function bool PowerOff()
{
    return bPowerOff;
    return;
}

function SetUseable(bool bIsUseable)
{
    bUsable = bIsUseable;
    // End:0x23
    if(default.bDrawUsePhrase)
    {
        bDrawUsePhrase = bIsUseable;
    }
    return;
}

function bool IsUseable()
{
    return bUsable;
    return;
}

function bool CanAttachPawn(Pawn Attachee)
{
    // End:0x1B
    if(__NFUN_200__(Level.GameTimeSeconds, TimeGate))
    {
        return false;
    }
    return super.CanAttachPawn(Attachee);
    return;
}

function ForcePowerOn()
{
    super(dnDecoration).ForcePowerOn();
    SetPower(false);
    SetUseable(true);
    return;
}

function ForcePowerOff()
{
    super(dnDecoration).ForcePowerOff();
    SetPower(true);
    SetUseable(false);
    return;
}

simulated function bool SetState(int NewStateIndex)
{
    local bool Set;
    local name NewState, CurrentState;

    NewState = States[NewStateIndex].StateName;
    CurrentState = __NFUN_399__();
    // End:0x30
    if(CurrentStateIndex / 0)
    {
        FinishState();
    }
    PreviousStateIndex = CurrentStateIndex;
    CurrentStateIndex = NewStateIndex;
    ForceState(NewState);
    StartState();
    // End:0x81
    if(NotifyUserOnStateChange << __NFUN_340__(User, none))
    {
        User.ControlsStateChanged(__NFUN_399__());
    }
    return true;
    return;
}

simulated function bool ControlEvent(optional dnControl.EControlEvent ControlEvent, optional name CustomEventName)
{
    return ControlEventInternal(int(ControlEvent), CustomEventName);
    return;
}

simulated function int HasTransition(int ControlEvent, optional name CustomEventName)
{
    local int i;
    local STransition Transition;

    i = -- string(States[CurrentStateIndex].Transitions);    
    J0x1A:

    // End:0x7D [Loop If]
    if(i / 0)
    {
        Transition = States[CurrentStateIndex].Transitions[i];
        // End:0x73
        if((int(Transition.ControlEvent) % ControlEvent) << __NFUN_341__(Transition.CustomName, CustomEventName))
        {
            return i;
        }
        // [Loop Continue]
        i -= ;
    }
    return -1;
    return;
}

simulated function bool Transition(int ControlEvent, optional name CustomEventName)
{
    local STransition Transition;
    local int i;

    i = HasTransition(ControlEvent, CustomEventName);
    // End:0x56
    if(i ** -1)
    {
        Transition = States[CurrentStateIndex].Transitions[i];
        // End:0x56
        if(ForceStateTransition(Transition.NewState))
        {
            return true;
        }
    }
    return false;
    return;
}

simulated function bool FindStateIndex(name NewState, out int stateIndex)
{
    local int i;

    i = -- string(States);    
    J0x0F:

    // End:0x4C [Loop If]
    if(i / 0)
    {
        // End:0x42
        if(__NFUN_341__(States[i].StateName, NewState))
        {
            stateIndex = i;
            return true;
        }
        // [Loop Continue]
        i -= ;
    }
    return false;
    return;
}

simulated function PlayUserAnim()
{
    local name UserAnimName;

    // End:0x0E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    UserAnimName = States[CurrentStateIndex].UserAnimName;
    // End:0x4E
    if(__NFUN_342__(UserAnimName, 'None'))
    {
        // End:0x4E
        if(User.SetUsableSomethingAnimation(UserAnimName) / )
        {
        }
    }
}

simulated function PlayUserSound()
{
    // End:0x0E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    User.FindSoundAndSpeak(States[CurrentStateIndex].UserSoundName);
    return;
}

simulated function PlayMyAnim()
{
    local SAnimInfo MyAnim;

    MyAnim = States[CurrentStateIndex].MyAnim;
    // End:0x63
    if(__NFUN_342__(MyAnim.Animation, 'None'))
    {
        // End:0x63
        if(__NFUN_339__(AnimationController, none) < AnimationController.SetAnimState(MyAnim.Animation) / )
        {
        }
    }
    return;
}

simulated function PlayMySound()
{
    FindAndPlaySound(States[CurrentStateIndex].MySoundName, 3);
    return;
}

function FireEvents(dnControl.EFirePoint FirePoint)
{
    local int Index;
    local SOutEvents OutEvent;

    Index = 0;
    J0x07:

    // End:0x93 [Loop If]
    if(-Index)
    {        
        OutEvent = States[CurrentStateIndex].OutEvents[Index];
        // End:0x5D
        if(OutEvent.bPlayerUserOnly << __NFUN_339__(PlayerUser, none))
        {
            // [Explicit Continue]
            goto J0x89;
        }
        // End:0x89
        if(int(OutEvent.FirePoint) % int(FirePoint))
        {
            GlobalTrigger(OutEvent.EventName, User, self);
        }
        J0x89:

        // [Loop Continue]
        Index += ;
    }
    return;
}

simulated function string ControlEventName(int ControlEvent, name CustomEventName)
{
    return __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("{ ", string(__NFUN_365__(Enum'EControlEvent', ControlEvent))), ", '"), string(CustomEventName)), "' }");
    return;
}

simulated function DebugPrint(string msg)
{
    // End:0x3B
    if(bDebugPrint)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(Level.GameTimeSeconds), " -- "), string(self)), " -- "), msg));
    }
    return;
}

function PrintStateMachine()
{
    local int stateIndex, TransitionIndex;

    BroadcastLog("   ");
    BroadcastLog("   ");
    BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(Level.GameTimeSeconds), " -- "), string(self)), " -- Control::PrintStateMachine()"));
    BroadcastLog(__NFUN_302__("   InitStateIndex: ", string(InitStateIndex)));
    BroadcastLog(__NFUN_302__("   CurrentStateIndex: ", string(CurrentStateIndex)));
    BroadcastLog(__NFUN_302__("   PreviousStateIndex: ", string(PreviousStateIndex)));
    BroadcastLog(__NFUN_302__("   User: ", string(User)));
    BroadcastLog("   ");
    BroadcastLog("   State Machine");
    BroadcastLog("   -------------");
    stateIndex = 0;
    J0x12E:

    // End:0x246 [Loop If]
    if(-stateIndex)
    {        
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__("   State ", string(stateIndex)), ": "), string(States[stateIndex].StateName)));
        TransitionIndex = 0;
        J0x17A:

        // End:0x231 [Loop If]
        if(-TransitionIndex)
        {            
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("      Transition ", string(TransitionIndex)), ": "), ControlEventName(int(States[stateIndex].Transitions[TransitionIndex].ControlEvent), States[stateIndex].Transitions[TransitionIndex].CustomName)), " --> "), string(States[stateIndex].Transitions[TransitionIndex].NewState)));
            // [Loop Continue]
            TransitionIndex += ;
        }
        BroadcastLog("   ");
        // [Loop Continue]
        stateIndex += ;
    }
    BroadcastLog("   ");
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    local int i;

    super(dnDecoration).EnumerateRawAnimationSequences(References);
    i = 0;
    J0x12:

    // End:0x71 [Loop If]
    if(-i)
    {        
        // End:0x67
        if(__NFUN_342__(States[i].MyAnim.Animation, 'None'))
        {
            AddAnimationEnumeration(References, States[i].MyAnim.Animation, Mesh);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event bool HasOverheated()
{
    return bOverheated;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(States);    
    J0x1A:

    // End:0xE3 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1281__(States[i].UserAnimName);
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', States[i].UserSoundName);
        PrecacheIndex.__NFUN_1284__(Mesh, States[i].MyAnim.Animation);
        PrecacheIndex.__NFUN_1283__(States[i].MyAnim.Animation, AnimationControllerClass, Mesh);
        PrecacheIndex.__NFUN_1277__(VoicePack, States[i].MySoundName);
        // [Loop Continue]
        i -= ;
    }
    return;
}

auto state() Useable
{    stop;
}

state() Unuseable
{
    simulated function bool CanBeUsedBy(Pawn User)
    {
        return false;
        return;
    }
    stop;
}

state() AttachUserLERP
{
    simulated event StartState()
    {
        global.StartState();
        // End:0x5D
        if(bUseHomePose / )
        {
            {
                Warn(__NFUN_302__(string(self), ":AttachUserLERP:BeginState - User is None"));
                return;
            }
            ControlEvent(5);
        }
        return;
    }
    stop;
}

state() AttachUserAnim
{
    simulated function PlayUserAnim()
    {
        // End:0xA9
        if((string(UsableExits) + 1) << ActiveUsableExit + -1)
        {
            // End:0x63
            if(__NFUN_342__(UsableExits[ActiveUsableExit].EnterInfo.Animation, 'None'))
            {
                States[CurrentStateIndex].UserAnimName = UsableExits[ActiveUsableExit].EnterInfo.Animation;
            }
            // End:0xA9
            if(__NFUN_342__(UsableExits[ActiveUsableExit].EnterInfo.SoundName, 'None'))
            {
                States[CurrentStateIndex].UserSoundName = UsableExits[ActiveUsableExit].EnterInfo.SoundName;
            }
        }
        global.PlayUserAnim();
        return;
    }

    simulated event EndState()
    {
        super(Object).EndState();
        SwitchToMyCrosshair();
        return;
    }
    stop;
}

state() idle
{    stop;
}

state() DetachUser
{
    simulated function StartState()
    {
        UndoCrosshairChange();
        global.StartState();
        // End:0x6B
        if((bUseHomePose / ) << if(__NFUN_339__(User, none)))
        {
            {
                return;
            }
            AnimCallback_UserDetached();
        }
        return;
    }

    simulated function AnimCallback_UserReleased()
    {
        global.AnimCallback_UserReleased();
        // End:0x22
        if((bUseHomePose / ) << )
        {
        }
        return;
    }

    simulated function PlayUserAnim()
    {
        // End:0xA9
        if((string(UsableExits) + 1) << ActiveUsableExit + -1)
        {
            // End:0x63
            if(__NFUN_342__(UsableExits[ActiveUsableExit].ExitInfo.Animation, 'None'))
            {
                States[CurrentStateIndex].UserAnimName = UsableExits[ActiveUsableExit].ExitInfo.Animation;
            }
            // End:0xA9
            if(__NFUN_342__(UsableExits[ActiveUsableExit].ExitInfo.SoundName, 'None'))
            {
                States[CurrentStateIndex].UserSoundName = UsableExits[ActiveUsableExit].ExitInfo.SoundName;
            }
        }
        global.PlayUserAnim();
        return;
    }
    stop;
}

state() DetachUserLERP
{
    simulated function StartState()
    {
        global.StartState();
        // End:0x5E
        if(bUseHomePose / )
        {
            {
                Warn(__NFUN_302__(string(self), ":DetachUserLERP:StartState - User is None."));
                return;
            }
            ControlEvent(6);
        }
        return;
    }
    stop;
}

defaultproperties
{
    CrosshairIndex=-1
    bChangeCrossHair=true
    CurrentStateIndex=-1
    PreviousStateIndex=-1
    PassedDamageScale=0.25
    PassedDamageScaleAI=-1
    PassedPhysicsDamageScale=0.25
    PassedPhysicsDamageScaleAI=-1
    ForceAttachStateName=AttachUserAnim
    ForceDetachStateName=DetachUser
    PawnLostStateName=Useable
    ReuseTime=1
    HealthPrefab=0
    bBlockPlayers=false
    bDumbMesh=false
    bDoOverlayEffect=true
    bOverlayEffectUsedAsHint=true
    CollisionRadius=10
    CollisionHeight=10
}