/*******************************************************************************
 * dnControl_CameraViewer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_CameraViewer extends dnControl
    collapsecategories;

var() noexport deprecated name StartingCamera "Tag of the camera to look through on first activation.";
var() noexport string CameraString "What are these objects we're looking through?";
var() noexport string CameraIdent "Displayed before camera ID number.";
var() noexport string FlavorText "Flavor text under camera number.";
var() noexport bool bHideCameraKey "Don't show \"Camera: [alt-fire]\" text on screen.";
var() noexport int ScreenSectionIndex "Section number of mesh/staticmesh to change when changing the screen display.";
var() noexport RenderTarget CameraRenderTarget "RenderTarget to use for rendering of the current camera's scene.";
var dnCamera CurrentCamera;
var name CurrentCameraName;
var float fMotionScaleFactor;
var float MaxRotationPerSecond;
var Rotator DeltaRotation;
var int RotationSpeedFactor;
var MaterialEx texDefaultScreen;
var MaterialEx offScreen;
var StaticTexture texBrokenCamera;
var(dnControl_CameraViewer_Events) deprecated name FireDownEvent;
var(dnControl_CameraViewer_Events) deprecated name FireUpEvent;
var(dnControl_CameraViewer_Events) deprecated name AltFireDownEvent;
var(dnControl_CameraViewer_Events) deprecated name AltFireUpEvent;
var(dnControl_CameraViewer_Events) deprecated name PlayerLookEvent;
var(dnControl_CameraViewer_Events) deprecated name PlayerUnlookEvent;

simulated function PostBeginPlay()
{
    super(dnUsableSomething).PostBeginPlay();
    texDefaultScreen = __NFUN_740__(ScreenSectionIndex);
    FindStartingCamera();
    return;
}

simulated function FindCamera(name TargetCameraName)
{
    local dnCamera C;

    // End:0x12
    if(__NFUN_341__(TargetCameraName, 'None'))
    {
        return;
    }
    UnsetCurrentCamera();
    // End:0x3C
    foreach __NFUN_747__(class'dnCamera', C, TargetCameraName)
    {
        CurrentCamera = C;
        // End:0x3C
        break;        
    }    
    SetCurrentCamera();
    return;
}

simulated function FindStartingCamera()
{
    CurrentCameraName = StartingCamera;
    FindCamera(CurrentCameraName);
    return;
}

simulated function UnsetCurrentCamera()
{
    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    // End:0x39
    if(__NFUN_340__(DukePlayer(User), none))
    {
        DukePlayer(User).RemoveListener(CurrentCamera);
    }
    CurrentCamera.SetActive(none);
    CurrentCamera = none;
    CurrentCameraName = 'None';
    __NFUN_695__(3);
    return;
}

simulated function SetCurrentCamera()
{
    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    CurrentCameraName = CurrentCamera.Tag;
    SwitchToCameraView();
    // End:0x74
    if(__NFUN_340__(DukePlayer(User), none))
    {
        DukePlayer(User).AddListener(CurrentCamera);
        CurrentCamera.SetActive(DukePlayer(User));
        SetCurrentFOV();
    }
    return;
}

simulated function ChangeZoom()
{
    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    // End:0x3A
    if(CurrentCamera.bDestroyed < CurrentCamera.bActivated / )
    {
    }
    // End:0x82
    CurrentCamera.iZoomMode += ;
    {
        CurrentCamera.iZoomMode = 0;
        FindAndPlaySound('dnCamera_ZoomOut', 1);        
    }
    else
    {
        FindAndPlaySound('dnCamera_ZoomIn', 1);
    }
    SetCurrentFOV();
    return;
}

function SetCurrentFOV()
{
    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    CurrentCamera.CameraFOV = FRand(CurrentCamera.BaseCameraFOV, [-- CurrentCamera.iZoomMode], CurrentCamera.CameraFOVs);
    return;
}

simulated function NextCamera()
{
    local dnCamera C;
    local name n;

    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    // End:0x2A
    if(__NFUN_341__(CurrentCamera.NextCamera, 'None'))
    {
        return;
    }
    n = CurrentCamera.NextCamera;
    UnsetCurrentCamera();
    // End:0x69
    foreach __NFUN_747__(class'dnCamera', C, n)
    {
        CurrentCamera = C;
        // End:0x69
        break;        
    }    
    SetCurrentCamera();
    return;
}

simulated function PreviousCamera()
{
    local dnCamera C;
    local name n;

    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    // End:0x2A
    if(__NFUN_341__(CurrentCamera.PrevCamera, 'None'))
    {
        return;
    }
    n = CurrentCamera.PrevCamera;
    UnsetCurrentCamera();
    // End:0x69
    foreach __NFUN_747__(class'dnCamera', C, n)
    {
        CurrentCamera = C;
        // End:0x69
        break;        
    }    
    SetCurrentCamera();
    return;
}

simulated function SwitchToCameraView()
{
    local PlayerPawn PlayerUser;
    local int i;

    PlayerUser = PlayerPawn(User);
    // End:0x2C
    if(__NFUN_339__(CurrentCamera, none) < __NFUN_339__(User, none))
    {
        return;
    }
    FindAndPlaySound('CameraViewer_CameraChange', 1);
    SetCurrentFOV();
    // End:0x7B
    if(__NFUN_340__(DukeHUD(PlayerUser.MyHUD), none))
    {
        DukeHUD(PlayerUser.MyHUD).bNoDraw = false;
    }
    // End:0x99
    if(__NFUN_340__(PlayerUser, none))
    {
        PlayerUser.bUseHelpPanel = true;
    }
    // End:0x104
    if(__NFUN_340__(PlayerUser, none) << bHideCameraKey / )
    {
        PlayerUser.HelpKeyAlt[i] = 0;
        PlayerUser.HelpText[i] = CameraString;
        // End:0x20F
        i += ;
        {
            {
            }
            PlayerUser.HelpKey[i] = 2;
            PlayerUser.HelpKeyAlt[i] = 0;
            PlayerUser.HelpText[i] = "Zoom";
            // End:0x1DE
            i += ;
            {
                PlayerUser.HelpKey[i] = 26;
                PlayerUser.HelpKeyAlt[i] = 0;
                PlayerUser.HelpText[i] = "Fire";
                i += ;
            }
        }
        MirrorRenderTarget = CameraRenderTarget;
        // End:0x20C
        if(bEMPulsed / )
        {
        }        
    }
    else
    {
        CameraActor = none;
        MirrorRenderTarget = none;
        // End:0x235
        if(bEMPulsed / )
        {
        }
    }
    // End:0x303
    if(__NFUN_340__(PlayerUser, none))
    {
        PlayerUser.HelpKey[i] = 1;
        PlayerUser.HelpKeyAlt[i] = 0;
        PlayerUser.HelpText[i] = "Disconnect";
        i += ;
        J0x2A5:

        // End:0x303 [Loop If]
        if(-i)
        {            
            PlayerUser.HelpKey[i] = 0;
            PlayerUser.HelpKeyAlt[i] = 0;
            PlayerUser.HelpText[i] = "";
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

simulated event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    // End:0x1C
    if(__NFUN_339__(User, none) < __NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    CurrentCamera.__NFUN_722__(CameraLocation, CameraRotation);
    return;
}

simulated function PlayerEnter()
{
    local DukePlayer Duke;

    // End:0x12
    if(__NFUN_339__(CurrentCamera, none))
    {
        FindStartingCamera();
    }
    FindCamera(CurrentCameraName);
    // End:0x48
    if(__NFUN_340__(CurrentCamera, none))
    {
        CameraActor = CurrentCamera;
        GlobalTrigger(PlayerLookEvent, User, self);        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__("dnControl_CameraViewer: could not find camera named \"", string(CurrentCameraName)), "\"."));
    }
    Duke = DukePlayer(User);
    // End:0xC1
    if(__NFUN_340__(Duke, none))
    {
        Duke.CameraUpgradesOff();
    }
    return;
}

function PlayerExit()
{
    local DukePlayer Duke;
    local int i;

    GlobalTrigger(PlayerUnlookEvent, User, self);
    CurrentCamera.SetActive(none);
    MirrorRenderTarget = none;
    // End:0x41
    if(bEMPulsed / )
    {
    }
    Duke = DukePlayer(User);
    // End:0x134
    if(__NFUN_340__(Duke, none))
    {
        Duke.__NFUN_577__('FOV', 'DukeCameraSystem', 1);
        i = 0;
        J0x80:

        // End:0xDE [Loop If]
        if(-i)
        {            
            Duke.HelpKey[i] = 0;
            Duke.HelpKeyAlt[i] = 0;
            Duke.HelpText[i] = "";
            // [Loop Continue]
            i += ;
        }
        // End:0x11A
        if(__NFUN_340__(DukeHUD(Duke.MyHUD), none))
        {
            DukeHUD(Duke.MyHUD).bNoDraw = false;
        }
        DukePlayer(User).RemoveListener(CurrentCamera);
    }
    __NFUN_695__(3);
    CameraActor = none;
    return;
}

simulated function MeleeDown()
{
    GlobalTrigger(AltFireDownEvent, User, self);
    return;
}

simulated function MeleeUp()
{
    GlobalTrigger(AltFireUpEvent, User, self);
    return;
}

simulated function FireDown()
{
    GlobalTrigger(FireDownEvent, User, self);
    return;
}

simulated function FireUp()
{
    GlobalTrigger(FireUpEvent, User, self);
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
{
    super.CREvent_KeyChange(CR, InputActor, KeyType, EventType);
    switch(KeyType)
    {
        // End:0x55
        case 8:
            // End:0x3E
            if(int(EventType) % int(0))
            {
                FireDown();                
            }
            else
            {
                // End:0x52
                if(int(EventType) % int(2))
                {
                    FireUp();
                }
            }
            // End:0x8B
            break;
        // End:0x88
        case 9:
            // End:0x71
            if(int(EventType) % int(0))
            {
                MeleeDown();                
            }
            else
            {
                // End:0x85
                if(int(EventType) % int(2))
                {
                    MeleeUp();
                }
            }
            // End:0x8B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated function bool ViewmapperCanUseHUD()
{
    return false;
    return;
}

function float GetZoomFactor()
{
    switch(CurrentCamera.iZoomMode)
    {
        // End:0x1C
        case 0:
            return 1;
        // End:0x26
        case 1:
            return 0.75;
        // End:0x31
        case 2:
            return 0.5;
        // End:0xFFFF
        default:
            return 0.5;
            break;
    }
    return;
}

animevent simulated function ButtonPressed()
{
    return;
}

animevent simulated function ButtonReleased()
{
    return;
}

function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    DeltaRotation.Pitch = PitchAdjust;
    DeltaRotation.Yaw = YawAdjust;
    DeltaRotation.Roll = RollAdjust;
    super(dnUsableSomething).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    PitchAdjust = 0;
    YawAdjust = 0;
    RollAdjust = 0;
    return;
}

event Tick(float DeltaTime)
{
    local Rotator R;
    local int MaxDelta;

    super.Tick(DeltaTime);
    // End:0x4F
    if(__NFUN_339__(CurrentCamera, none) < ((DeltaRotation.Pitch % 0) << DeltaRotation.Yaw % 0) << DeltaRotation.Roll % 0)
    {
        return;
    }
    MaxDelta = int(FRand(MaxRotationPerSecond, DeltaTime));
    // End:0xE5
    if(CurrentCamera.CanPitch())
    {
        R.Pitch = Exp(++ DeltaRotation.Pitch);
        MaxDelta += ;        
        R.Yaw = 0;
        // End:0xE5
        if(R.Pitch + 0)
        {
            CurrentCamera.RotateBy(R);
            CurrentCamera.fStallTimer = 2;
        }
    }
    // End:0x168
    if(CurrentCamera.CanYaw())
    {
        R.Yaw = Exp(++ DeltaRotation.Yaw);
        MaxDelta += ;        
        R.Pitch = 0;
        // End:0x168
        if(R.Yaw + 0)
        {
            CurrentCamera.RotateBy(R);
            CurrentCamera.fStallTimer = 2;
        }
    }
    DeltaRotation.Pitch = 0;
    DeltaRotation.Yaw = 0;
    DeltaRotation.Roll = 0;
    return;
}

function HitByEMP(optional float Duration, optional Pawn Instigator)
{
    super(dnDecoration).HitByEMP(Duration, Instigator);
    __NFUN_741__(ScreenSectionIndex, offScreen);
    bUsable = false;
    bDrawUsePhrase = false;
    return;
}

function EMPDone()
{
    super(dnDecoration).EMPDone();
    __NFUN_741__(ScreenSectionIndex, texDefaultScreen);
    bUsable = true;
    bDrawUsePhrase = true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_ZoomIn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'dnCamera_ZoomOut');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'CameraViewer_CameraChange');
    PrecacheIndex.__NFUN_1269__(texBrokenCamera);
    PrecacheIndex.__NFUN_1269__(offScreen);
    return;
}

state() AttachUserLERP
{
    event BeginState()
    {
        local DukePlayer Duke;

        super(Object).BeginState();
        Duke = DukePlayer(User);
        // End:0x34
        if(__NFUN_340__(Duke, none))
        {
            Duke.bIZoom = false;
        }
        return;
    }
    stop;
}

state() AttachUserAnim
{
    event EndState()
    {
        super.EndState();
        PlayerEnter();
        return;
    }
    stop;
}

state() idle
{
    event BeginState()
    {
        local Rotator R;

        super(Object).BeginState();
        CurrentCamera.RotateBy(R);
        return;
    }

    simulated function InputHook(out float aForward, out float aLookUp, out float aTurn, out float aStrafe, optional float fDeltaTime)
    {
        super(Actor).InputHook(aForward, aLookUp, aTurn, aStrafe, fDeltaTime);
        // End:0x3B
        if(__NFUN_339__(CurrentCamera, none) < __NFUN_339__(User, none))
        {
            return;
        }
        // End:0x89
        if(CurrentCamera.CanPitch())
        {
            // End:0x6D
            if(Repl(aForward, 0))
            {
                ControlEvent(0, 'UpPressed');                
            }
            else
            {
                // End:0x89
                if(__NFUN_200__(aForward, 0))
                {
                    ControlEvent(0, 'DownPressed');
                }
            }
        }
        // End:0xD7
        if(CurrentCamera.CanYaw())
        {
            // End:0xBB
            if(Repl(aStrafe, 0))
            {
                ControlEvent(0, 'RightPressed');                
            }
            else
            {
                // End:0xD7
                if(__NFUN_200__(aStrafe, 0))
                {
                    ControlEvent(0, 'LeftPressed');
                }
            }
        }
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        SetHUDKeyInfoState(HUD, 3, true, 26);
        SetHUDKeyInfoState(HUD, 2, true, 2);
        return;
    }
    stop;
}

state() DetachUser
{
    event BeginState()
    {
        super(Object).BeginState();
        PlayerExit();
        return;
    }
    stop;
}

state() FirePressStart
{
    function BeginState()
    {
        // End:0x29
        if(__NFUN_340__(CurrentCamera, none) << CurrentCamera.bArmed)
        {
            super(Object).BeginState();
            return;
        }
        ControlEvent(, 'AbortFire');
        return;
    }
    stop;
}

state() FirePressEarlyEnd
{    stop;
}

state() FirePressIdle
{
    function BeginState()
    {
        // End:0x45
        if(__NFUN_340__(CurrentCamera, none))
        {
            // End:0x33
            if(CurrentCamera.bArmed)
            {
                CurrentCamera.SetFiring(true);                
            }
            else
            {
                CurrentCamera.bFiring = true;
            }
        }
        return;
    }

    function EndState()
    {
        // End:0x45
        if(__NFUN_340__(CurrentCamera, none))
        {
            // End:0x33
            if(CurrentCamera.bArmed)
            {
                CurrentCamera.SetFiring(false);                
            }
            else
            {
                CurrentCamera.bFiring = false;
            }
        }
        return;
    }
    stop;
}

state() FirePressEnd
{    stop;
}

state() NextCam
{
    animevent simulated function ButtonPressed()
    {
        global.ButtonPressed();
        NextCamera();
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() Zooming
{
    animevent simulated function ButtonPressed()
    {
        global.ButtonPressed();
        ChangeZoom();
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

defaultproperties
{
    CameraString="Camera"
    CameraIdent="CAMERA"
    FlavorText="AUDIO/VIDEO"
    ScreenSectionIndex=1
    CameraRenderTarget='dt_Electronics.props.512_512videopanel_rendertarget'
    fMotionScaleFactor=6400
    MaxRotationPerSecond=65536
    RotationSpeedFactor=4
    offScreen='dt_masking.Glass.genglass1RC'
    texBrokenCamera='dt_effects.tv_static'
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=DeskMonitor_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=15,CustomName=None,NewState=FirePressStart),(ControlEvent=0,CustomName=None,NewState=None)),UserAnimName=DeskMonitor_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FirePressStart,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=FirePressIdle),(ControlEvent=16,CustomName=None,NewState=FirePressEarlyEnd),(ControlEvent=0,CustomName=AbortFire,NewState=idle)),UserAnimName=DeskMonitor_FireStart,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=FirePressEarlyEnd,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=FirePressEnd)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=FirePressIdle,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=FirePressEnd)),UserAnimName=DeskMonitor_Fire,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(9)=(StateName=FirePressEnd,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=DeskMonitor_FireStop,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(10)=(StateName=NextCam,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=DeskMonitor_CameraChange,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=deskmon_camchange,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(11)=(StateName=Zooming,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=DeskMonitor_CameraZoom,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=deskmon_camzoomin,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=32,Y=0,Z=-54),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    bManipulateViewOnAttach=false
    bManipulateViewOnIdle=false
    EMPDisableTime=10
    bBlockPlayers=true
    bDrawableViewMapper=true
    PlacementZOffset=54
    CollisionRadius=0
    CollisionHeight=11.9
    Mesh='c_generic.Sec_MonitorDesk'
}