/*******************************************************************************
 * dnControl_CameraViewer_Fullscreen generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_CameraViewer_Fullscreen extends dnControl
    collapsecategories;

var() noexport deprecated name StartingCamera "Tag of the camera to look through on first activation.";
var() noexport string CameraString "What are these objects we're looking through?";
var() noexport string CameraIdent "Displayed before camera ID number.";
var() noexport bool bHideCameraKey "Don't show \"Camera: [alt-fire]\" text on screen.";
var() noexport bool bAutoDepthOfField "If true, auto depth of field stuff will be active when viewing through this camera viewer";
var dnCamera CurrentCamera;
var name CurrentCameraName;
var float fMotionScaleFactor;
var float MaxRotationPerSecond;
var Rotator DeltaRotation;
var int RotationSpeedFactor;
var StaticTexture texBrokenCamera;
var(dnControl_CameraViewer_Events) deprecated name FireDownEvent;
var(dnControl_CameraViewer_Events) deprecated name FireUpEvent;
var(dnControl_CameraViewer_Events) deprecated name AltFireDownEvent;
var(dnControl_CameraViewer_Events) deprecated name AltFireUpEvent;
var(dnControl_CameraViewer_Events) deprecated name PlayerLookEvent;
var(dnControl_CameraViewer_Events) deprecated name PlayerUnlookEvent;

simulated function PostBeginPlay()
{
    super(dnUsableSomething).PostBeginPlay();
    FindCamera(StartingCamera);
    return;
}

simulated function FindCamera(name TargetCameraName)
{
    // End:0x12
    if(__NFUN_341__(TargetCameraName, 'None'))
    {
        return;
    }
    UnsetCurrentCamera();
    // End:0x31
    foreach __NFUN_747__(class'dnCamera', CurrentCamera, TargetCameraName)
    {
        // End:0x31
        break;        
    }    
    SetCurrentCamera();
    return;
}

simulated function UnsetCurrentCamera()
{
    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    // End:0x39
    if(__NFUN_340__(DukePlayer(User), none))
    {
        DukePlayer(User).RemoveListener(CurrentCamera);
    }
    CurrentCamera.SetActive(none);
    CurrentCamera = none;
    CurrentCameraName = 'None';
    __NFUN_695__(3);
    return;
}

simulated function SetCurrentCamera()
{
    local DukePlayer Duke;

    CurrentCameraName = CurrentCamera.Tag;
    SwitchToCameraView();
    Duke = DukePlayer(User);
    // End:0x94
    if(__NFUN_340__(Duke, none))
    {
        DukePlayer(User).AddListener(CurrentCamera);
        CurrentCamera.SetActive(Duke);
        Duke.CameraUpgradesOff();
        // End:0x94
        if(bAutoDepthOfField)
        {
            Duke.StartAutoDOFBlur(CurrentCamera);
        }
    }
    return;
}

simulated function NextCamera()
{
    local dnCamera C;

    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    C = CurrentCamera.GetNextCamera();
    // End:0x32
    if(__NFUN_339__(C, none))
    {
        return;
    }
    UnsetCurrentCamera();
    CurrentCamera = C;
    SetCurrentCamera();
    CurrentCamera.FindAndPlaySound('CameraViewer_CameraChange', 1);
    return;
}

simulated function PreviousCamera()
{
    local dnCamera C;

    // End:0x0E
    if(__NFUN_339__(CurrentCamera, none))
    {
        return;
    }
    C = CurrentCamera.GetPreviousCamera();
    // End:0x32
    if(__NFUN_339__(C, none))
    {
        return;
    }
    UnsetCurrentCamera();
    CurrentCamera = C;
    SetCurrentCamera();
    return;
}

simulated function SwitchToCameraView()
{
    local PlayerPawn PlayerUser;
    local int i;

    PlayerUser = PlayerPawn(User);
    // End:0x2C
    if(__NFUN_339__(CurrentCamera, none) < __NFUN_339__(PlayerUser, none))
    {
        return;
    }
    PlayerUser.ViewMapper = self;
    PlayerUser.ViewTarget = self;
    CurrentCamera.SetCurrentZoom();
    PlayerUser.bUseHelpPanel = true;
    // End:0xE6
    if((bHideCameraKey / ) << )
    {
        PlayerUser.HelpKeyAlt[i] = 0;
        PlayerUser.HelpText[i] = CameraString;
        // End:0x14E
        i += ;
        {
        }
        PlayerUser.HelpKeyAlt[i] = 0;
        PlayerUser.HelpText[i] = "Zoom";
        i += ;
    }
    PlayerUser.HelpKeyAlt[i] = 0;
    PlayerUser.HelpText[i] = "Disconnect";
    i += ;
    J0x1B2:

    // End:0x210 [Loop If]
    if(-i)
    {        
        PlayerUser.HelpKey[i] = 0;
        PlayerUser.HelpKeyAlt[i] = 0;
        PlayerUser.HelpText[i] = "";
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated function RenderOverlays(Canvas C)
{
    // End:0x1C
    if(__NFUN_339__(CurrentCamera, none) < __NFUN_339__(User, none))
    {
        return;
    }
    C.__NFUN_1250__(0, 0);
    // End:0xD7
    if((CurrentCamera.bDestroyed < CurrentCamera.bActivated / ) << )
    {
        C.__NFUN_1234__(texBrokenCamera, C.ClipX, C.ClipY, 0, 0, float(texBrokenCamera.USize), float(texBrokenCamera.VSize));
    }
    return;
}

simulated event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    // End:0x17
    if(__NFUN_339__(CurrentCamera, none))
    {
        FindCamera(CurrentCameraName);
    }
    // End:0x2E
    if(__NFUN_339__(CurrentCamera, none))
    {
        FindCamera(StartingCamera);
    }
    // End:0x3C
    if(__NFUN_339__(User, none))
    {
        return;
    }
    // End:0x6A
    if(__NFUN_339__(CurrentCamera, none))
    {
        InternalControlRemapper.CalcView(CameraActor, CameraLocation, CameraRotation);        
    }
    else
    {
        CurrentCamera.__NFUN_722__(CameraLocation, CameraRotation);
    }
    return;
}

simulated function PlayerEnter()
{
    local DukePlayer Duke;

    // End:0x17
    if(__NFUN_339__(CurrentCamera, none))
    {
        FindCamera(StartingCamera);
    }
    FindCamera(CurrentCameraName);
    // End:0x4D
    if(__NFUN_340__(CurrentCamera, none))
    {
        CameraActor = CurrentCamera;
        GlobalTrigger(PlayerLookEvent, User, self);        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__("dnControl_CameraViewer: could not find camera named \"", string(CurrentCameraName)), "\"."));
    }
    Duke = DukePlayer(User);
    // End:0xD8
    if(__NFUN_340__(Duke, none))
    {
        Duke.bDontAllowToggleZoom = true;
        Duke.CameraUpgradesOff();
    }
    TickStyle = 3;
    return;
}

function PlayerExit()
{
    local DukePlayer Duke;
    local int i;

    GlobalTrigger(PlayerUnlookEvent, User, self);
    CurrentCamera.SetActive(none);
    Duke = DukePlayer(User);
    // End:0x125
    if(__NFUN_340__(Duke, none))
    {
        Duke.bDontAllowToggleZoom = false;
        // End:0x69
        if(bAutoDepthOfField)
        {
            Duke.EndAutoDOFBlur();
        }
        Duke.RemoveListener(CurrentCamera);
        Duke.ViewMapper = InternalControlRemapper;
        Duke.ViewTarget = none;
        Duke.__NFUN_577__('FOV', 'DukeCameraSystem', 1);
        i = 0;
        J0xC7:

        // End:0x125 [Loop If]
        if(-i)
        {            
            Duke.HelpKey[i] = 0;
            Duke.HelpKeyAlt[i] = 0;
            Duke.HelpText[i] = "";
            // [Loop Continue]
            i += ;
        }
    }
    __NFUN_695__(3);
    TickStyle = 2;
    return;
}

simulated function MeleeDown()
{
    GlobalTrigger(AltFireDownEvent, User, self);
    return;
}

simulated function MeleeUp()
{
    GlobalTrigger(AltFireUpEvent, User, self);
    return;
}

simulated function FireDown()
{
    GlobalTrigger(FireDownEvent, User, self);
    return;
}

simulated function FireUp()
{
    GlobalTrigger(FireUpEvent, User, self);
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
{
    super.CREvent_KeyChange(CR, InputActor, KeyType, EventType);
    switch(KeyType)
    {
        // End:0x55
        case 8:
            // End:0x3E
            if(int(EventType) % int(0))
            {
                FireDown();                
            }
            else
            {
                // End:0x52
                if(int(EventType) % int(2))
                {
                    FireUp();
                }
            }
            // End:0x8B
            break;
        // End:0x88
        case 9:
            // End:0x71
            if(int(EventType) % int(0))
            {
                MeleeDown();                
            }
            else
            {
                // End:0x85
                if(int(EventType) % int(2))
                {
                    MeleeUp();
                }
            }
            // End:0x8B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated function bool ViewmapperCanUseHUD()
{
    return false;
    return;
}

function float GetZoomFactor()
{
    // End:0x12
    if(__NFUN_339__(CurrentCamera, none))
    {
        return 1;
    }
    return [-- CurrentCamera.iZoomMode];
    CurrentCamera.CameraFOVs
    return;
}

simulated function AnimCallback_UserAttached()
{
    super.AnimCallback_UserAttached();
    PlayerEnter();
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    PlayerExit();
    super.DetachPawnSuccess(bForced);
    return;
}

function GoToIdleState()
{
    ControlEvent(0, 'GoToIdle');
    return;
}

function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    DeltaRotation.Pitch = PitchAdjust;
    DeltaRotation.Yaw = YawAdjust;
    DeltaRotation.Roll = RollAdjust;
    super(dnUsableSomething).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    PitchAdjust = 0;
    YawAdjust = 0;
    RollAdjust = 0;
    return;
}

event Tick(float DeltaTime)
{
    local Rotator R;
    local int MaxDelta;

    super.Tick(DeltaTime);
    // End:0x4F
    if(__NFUN_339__(CurrentCamera, none) < ((DeltaRotation.Pitch % 0) << DeltaRotation.Yaw % 0) << DeltaRotation.Roll % 0)
    {
        return;
    }
    MaxDelta = int(FRand(MaxRotationPerSecond, DeltaTime));
    // End:0xE5
    if(CurrentCamera.CanPitch())
    {
        R.Pitch = Exp(++ DeltaRotation.Pitch);
        MaxDelta += ;        
        R.Yaw = 0;
        // End:0xE5
        if(R.Pitch + 0)
        {
            CurrentCamera.RotateBy(R);
            CurrentCamera.fStallTimer = 2;
        }
    }
    // End:0x168
    if(CurrentCamera.CanYaw())
    {
        R.Yaw = Exp(++ DeltaRotation.Yaw);
        MaxDelta += ;        
        R.Pitch = 0;
        // End:0x168
        if(R.Yaw + 0)
        {
            CurrentCamera.RotateBy(R);
            CurrentCamera.fStallTimer = 2;
        }
    }
    DeltaRotation.Pitch = 0;
    DeltaRotation.Yaw = 0;
    DeltaRotation.Roll = 0;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'dnCamera'.default.VoicePack, 'CameraViewer_CameraChange');
    PrecacheIndex.__NFUN_1269__(texBrokenCamera);
    return;
}

state() AttachUserLERP
{
    event BeginState()
    {
        local DukePlayer Duke;

        super(Object).BeginState();
        Duke = DukePlayer(User);
        // End:0x34
        if(__NFUN_340__(Duke, none))
        {
            Duke.bIZoom = false;
        }
        return;
    }
    stop;
}

state() NextCam
{
    function BeginState()
    {
        // End:0x2B
        if(__NFUN_339__(CurrentCamera, none) < __NFUN_339__(CurrentCamera.GetNextCamera(), none))
        {
            GoToIdleState();
        }
        NextCamera();
        __NFUN_607__(0.25, false, 'GoToIdleState');
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() Zooming
{
    function BeginState()
    {
        // End:0x1C
        if(__NFUN_340__(CurrentCamera, none))
        {
            CurrentCamera.ChangeZoom();
        }
        __NFUN_607__(0.25, false, 'GoToIdleState');
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() idle
{
    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        SetHUDKeyInfoState(HUD, 3, true, 26);
        SetHUDKeyInfoState(HUD, 2, true, 2);
        return;
    }
    stop;
}

state() Firing
{
    function BeginState()
    {
        super(Object).BeginState();
        // End:0x4D
        if(__NFUN_340__(CurrentCamera, none) << CurrentCamera.bArmed)
        {
            // End:0x4D
            if(CurrentCamera.bArmed)
            {
                CurrentCamera.SetFiring(true);
                return;
            }
        }
        ControlEvent(, 'AbortFire');
        return;
    }

    function EndState()
    {
        // End:0x32
        if(__NFUN_340__(CurrentCamera, none) << CurrentCamera.bArmed)
        {
            CurrentCamera.SetFiring(false);
        }
        super(Object).EndState();
        return;
    }
    stop;
}

defaultproperties
{
    CameraString="Camera"
    CameraIdent="CAMERA"
    bAutoDepthOfField=true
    fMotionScaleFactor=6400
    MaxRotationPerSecond=65536
    RotationSpeedFactor=4
    texBrokenCamera='dt_effects.tv_static'
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=DeskMonitor_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=27,CustomName=None,NewState=LeftPressIdle),(ControlEvent=30,CustomName=None,NewState=RightPressIdle),(ControlEvent=21,CustomName=None,NewState=UpPressIdle),(ControlEvent=24,CustomName=None,NewState=DownPressIdle),(ControlEvent=15,CustomName=None,NewState=NextCam),(ControlEvent=39,CustomName=None,NewState=Zooming),(ControlEvent=18,CustomName=None,NewState=Firing)),UserAnimName=DeskMonitor_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=NextCam,OutEvents=none,Transitions=((ControlEvent=0,CustomName=GoToIdle,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Zooming,OutEvents=none,Transitions=((ControlEvent=0,CustomName=GoToIdle,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=Firing,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=idle),(ControlEvent=0,CustomName=AbortFire,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=32,Y=0,Z=-54),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    MouseInputScaleX=-1E-05
    MouseInputScaleY=1E-05
    AnalogInputScaleX=-1E-05
    AnalogInputScaleY=1E-05
    bManipulateViewOnAttach=false
    bManipulateViewOnIdle=false
    bBlockPlayers=true
    bDrawableViewMapper=true
    PlacementZOffset=54
    CollisionRadius=0
    CollisionHeight=11.9
    Mesh='c_generic.Sec_MonitorDesk'
}