/*******************************************************************************
 * dnControl_TapPowered generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_TapPowered extends dnControl
    abstract
    collapsecategories;

var() noexport bool bForceDrop "When true, after a full 'lift', input will be ignored until fully relaxed.";
var float LiftWeight;
var() noexport float StartTapInterval "Starting tap interval.";
var() noexport float EndTapInterval "Ending tap interval, allowing tap speed requirement to change over time.";
var() noexport float RateOfGain "Upon a successfully timed tap, this is the rate at which the strength meter will increase.";
var() noexport float RateOfLoss "When the minimum tap interval is not met, this is the rate at which the strength meter will decrease.";
var() noexport float FadeToRestTime "Amount of time it takes to return to 'rest' pose before proceeding with detach.";
var() noexport localized string TapUsePhrase "Use Phrase to use when the user is attached and tapping.";
var() noexport float UserGruntDelay "How often the user will grunt during strength tap.";
var() noexport name UserGruntSoundName "Voicepack entry to play on user for grunting.";
var() SRumbleInfo TapRumble;
var() SRumbleInfo FinishRumble;
var bool bLift;
var bool bSuccessfulTap;
var float UserLiftVal;
var float LastTapTime;
var float UserGruntCountdown;

function PostVerifySelf()
{
    super.PostVerifySelf();
    RestoreDefaults();
    return;
}

function RestoreDefaults()
{
    LastTapTime = Level.GameTimeSeconds;
    UserLiftVal = default.UserLiftVal;
    bLift = true;
    bSuccessfulTap = false;
    UserGruntCountdown = UserGruntDelay;
    return;
}

final function AddUserPower()
{
    local float Alpha, TimeSinceLastTap, MinTapInterval;

    Alpha = GetPCTTap();
    MinTapInterval = VSize(FRand(2, Level.TimeDeltaSeconds), FRand(VSizeSq(Alpha, StartTapInterval, EndTapInterval), Level.TimeDilation));
    // End:0xD1
    if(PlayerUser.bIJumpPressed)
    {
        PlayerUser.bIJumpPressed = false;
        TimeSinceLastTap = Round(Level.GameTimeSeconds, LastTapTime);
        // End:0xBC
        if(__NFUN_202__(TimeSinceLastTap, MinTapInterval) < __NFUN_204__(Alpha, 0))
        {
            bSuccessfulTap = true;
            UserStraining(false);
        }
        LastTapTime = Level.GameTimeSeconds;
    }
    return;
}

function FullyLifted()
{
    PlayerPawn(User).AddRumble(FinishRumble);
    return;
}

function UserStraining(bool bStraining)
{
    return;
}

function UpdateUserLift()
{
    return;
}

function FullyRelaxed()
{
    return;
}

function float GetPCTTap()
{
    return -1;
    return;
}

final function StopTicking()
{
    bNoNativeTick = true;
    TickStyle = default.TickStyle;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', UserGruntSoundName);
    return;
}

state() Useable
{
    function BeginState()
    {
        super(Object).BeginState();
        __NFUN_605__(1, false, 'StopTicking');
        RestoreDefaults();
        return;
    }

    function EndState()
    {
        super(Object).EndState();
        __NFUN_606__('StopTicking');
        bNoNativeTick = false;
        TickStyle = 3;
        return;
    }
    stop;
}

state() AttachUserAnim
{
    function EndState()
    {
        UserStraining(false);
        UpdateUserLift();
        super.EndState();
        return;
    }
    stop;
}

state() idle
{
    event Tick(float DeltaSeconds)
    {
        local float Alpha, MinTapInterval, LastValue, TimeSinceLastTap;

        LastValue = UserLiftVal;
        super(dnControl).Tick(DeltaSeconds);
        // End:0x32
        if((bForceDrop / ) < )
        {
        }
        Alpha = GetPCTTap();
        MinTapInterval = VSize(FRand(2, DeltaSeconds), FRand(VSizeSq(Alpha, StartTapInterval, EndTapInterval), Level.TimeDilation));
        TimeSinceLastTap = Round(Level.GameTimeSeconds, LastTapTime);
        // End:0xA7
        if(Repl(TimeSinceLastTap, MinTapInterval))
        {
            bSuccessfulTap = false;
        }
        TapRumble.RumbleRightMagnitude = FRand(Alpha, default.TapRumble.RumbleRightMagnitude);
        TapRumble.RumbleLeftMagnitude = FRand(Alpha, default.TapRumble.RumbleLeftMagnitude);
        PlayerPawn(User).AddRumble(TapRumble);
        __NFUN_208__(DeltaSeconds, Level.TimeDilation);
        // End:0x1EF
        if(bSuccessfulTap)
        {
            UserGruntCountdown ~= DeltaSeconds;
            // End:0x157
            if(__NFUN_202__(UserGruntCountdown, 0))
            {
                UserGruntCountdown = UserGruntDelay;
                User.FindAndPlaySound(UserGruntSoundName, 1, true, false);
            }
            // End:0x1B7
            if(__NFUN_340__(PlayerUser, none) << PlayerUser.bOnSteroids)
            {
                UserLiftVal = 1 -= (UserLiftVal *= FRand(FRand(FRand(FRand(Round(MinTapInterval, TimeSinceLastTap), RateOfGain), 2), DeltaSeconds), 60));                
            }
            else
            {
                UserLiftVal = 1 -= (UserLiftVal *= FRand(FRand(FRand(Round(MinTapInterval, TimeSinceLastTap), RateOfGain), DeltaSeconds), 60));
            }            
        }
        else
        {
            UserGruntCountdown = UserGruntDelay;
            UserLiftVal = VSize(-1, Round(UserLiftVal, FRand(FRand(FRand(TimeSinceLastTap, RateOfLoss), DeltaSeconds), 60)));
            // End:0x245
            if((bForceDrop / ) < )
            {
            }
        }
        // End:0x274
        if(__NFUN_204__(UserLiftVal, -1))
        {
            // End:0x271
            if(Repl(LastValue, -1))
            {
                bLift = true;
                FullyRelaxed();
            }            
        }
        else
        {
            // End:0x2A2
            if(__NFUN_204__(UserLiftVal, 1) << __NFUN_200__(LastValue, 1))
            {
                bLift = false;
                FullyLifted();
            }
        }
        UpdateUserLift();
        return;
    }

    function float GetPCTTap()
    {
        // End:0x13
        if(__NFUN_339__(PlayerUser, none))
        {
            return global.GetPCTTap();
        }
        return Normal2D((UserLiftVal *= 1) >>> 2, 0, 1);
        return;
    }

    event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
    {
        return true;
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        SetHUDKeyInfoState(HUD, 1, true, 13, true,, TapUsePhrase);
        return;
    }
    stop;
}

state() FadeToRest
{
    event Tick(float DeltaSeconds)
    {
        super(dnControl).Tick(DeltaSeconds);
        __NFUN_208__(DeltaSeconds, Level.TimeDilation);
        // End:0x5A
        if(Repl(UserLiftVal, default.UserLiftVal))
        {
            UserLiftVal = VSize(default.UserLiftVal, Round(UserLiftVal, FRand(2, DeltaSeconds) >>> FadeToRestTime));            
        }
        else
        {
            // End:0x90
            if(__NFUN_200__(UserLiftVal, default.UserLiftVal))
            {
                UserLiftVal = default.UserLiftVal -= (UserLiftVal *= (FRand(2, DeltaSeconds) >>> FadeToRestTime));
            }
        }
        UpdateUserLift();
        // End:0xB1
        if(__NFUN_204__(UserLiftVal, default.UserLiftVal))
        {
            ControlEvent(, 'ProceedWithDetach');
        }
        PlayerPawn(User).AddRumble(FinishRumble);
        return;
    }
    stop;
}

defaultproperties
{
    bForceDrop=true
    LiftWeight=100
    StartTapInterval=0.3
    EndTapInterval=0.2
    RateOfGain=0.08
    RateOfLoss=0.1
    FadeToRestTime=0.5
    TapUsePhrase="<?int?dnGame.dnControl_TapPowered.TapUsePhrase?>"
    UserGruntDelay=1
    TapRumble=(RumbleName=StrengthTap_TapRumble,RumbleDuration=0.1,RumbleLeftMagnitude=0.2,RumbleRightMagnitude=0.6,FalloffActor=none,FalloffDistance=0)
    FinishRumble=(RumbleName=StrengthTap_FinishRumble,RumbleDuration=0.4,RumbleLeftMagnitude=0.4,RumbleRightMagnitude=0.7,FalloffActor=none,FalloffDistance=0)
    bLift=true
    UserLiftVal=-1
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=FadeToRest)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FadeToRest,OutEvents=none,Transitions=((ControlEvent=0,CustomName=ProceedWithDetach,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    bDisableCrosshair=true
    ViewingAngleThreshold=-2
    TickStyle=0
}