/*******************************************************************************
 * dnControl_Valves generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Valves extends dnControl_LimitedRangeMover
    abstract
    collapsecategories
    dependson(dnValvePuzzle)
    dependson(dnPressureGauge);

var() noexport bool bForceGaugeStartingState "Force the starting state of the gauges to match the starting state of the valve?";
var() noexport deprecated name PressureGaugeTag "Tag of the pressure gauge to link to this valve.";
var int ValveAnimEntries;
var name PressureGaugeLeftEvent;
var name PressureGaugeRightEvent;
var dnValvePuzzle Puzzle;

function PostBeginPlay()
{
    super.PostBeginPlay();
    SetupPressureGauge();
    return;
}

function SetupPressureGauge()
{
    local dnPressureGauge PG;

    // End:0x12
    if(__NFUN_341__(PressureGaugeTag, 'None'))
    {
        return;
    }
    PressureGaugeLeftEvent = __NFUN_344__(PressureGaugeTag, 'Left');
    PressureGaugeRightEvent = __NFUN_344__(PressureGaugeTag, 'Right');
    // End:0x6D
    if(bForceGaugeStartingState)
    {
        // End:0x6C
        foreach __NFUN_747__(class'dnPressureGauge', PG, PressureGaugeTag)
        {
            PG.SetGaugeState(stateIndex);            
        }        
    }
    return;
}

function PlayMyAnim()
{
    local int StateOffset;
    local name BaseName;

    switch(__NFUN_399__())
    {
        // End:0x1C
        case 'DoPressLeft':
            BaseName = 'TurnLeft';
            // End:0x63
            break;
        // End:0x32
        case 'DoPressRight':
            BaseName = 'TurnRight';
            // End:0x63
            break;
        // End:0x48
        case 'PressLeftStuck':
            BaseName = 'CantTurnLeft';
            // End:0x63
            break;
        // End:0x5E
        case 'PressRightStuck':
            BaseName = 'CantTurnRight';
            // End:0x63
            break;
        // End:0xFFFF
        default:
            return;
            break;
    }
    States[CurrentStateIndex].MyAnim.Animation = BaseName;
    super(dnControl).PlayMyAnim();
    return;
}

function TurnedValve(bool bTurnedRight)
{
    // End:0x23
    if(__NFUN_340__(Puzzle, none))
    {
        Puzzle.ValveMoved(self, bTurnedRight);
    }
    return;
}

function MoveLeft()
{
    super.MoveLeft();
    GlobalTrigger(PressureGaugeLeftEvent);
    TurnedValve(false);
    return;
}

function MoveRight()
{
    super.MoveRight();
    GlobalTrigger(PressureGaugeRightEvent);
    TurnedValve(true);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1283__('TurnLeft', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('TurnRight', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('CantTurnLeft', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('CantTurnRight', AnimationControllerClass, Mesh);
    return;
}

defaultproperties
{
    PassedDamageScale=1
    HUDHelpEntries(0)=(Key=7,KeyAlt=0,HelpText="Turn Left")
    HUDHelpEntries(1)=(Key=8,KeyAlt=0,HelpText="Turn Right")
    HUDHelpEntries(2)=(Key=1,KeyAlt=0,HelpText="Let Go")
    bDisableCrosshair=true
    bBlockPlayers=true
    bBlockKarma=true
}