/*******************************************************************************
 * dnDecoration generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnDecoration extends Decoration
    native
    collapsecategories
    dependson(StochasticSpawner_FlickerLights)
    dependson(DecoActivities_Animation)
    dependson(DecoActivities)
    dependson(dnProjectile);

const BUMPCOUNT_DECAY_INTERVAL = 5.0f;
const BUMPCOUNT_DECAY = 25;

enum EDecoState
{
    DECOSTATE_Alive,
    DECOSTATE_MostlyDead,
    DECOSTATE_ReallyDead
};

enum EHealthPrefab
{
    HEALTH_NeverBreak,
    HEALTH_Easy,
    HEALTH_Medium,
    HEALTH_SortaHard,
    HEALTH_Hard,
    HEALTH_UseHealthVar
};

enum EDecoActivityMethod
{
    DECOACTMETH_Linear,
    DECOACTMETH_LinearRetry,
    DECOACTMETH_Random
};

enum EDecoActivityID
{
    DECOACT_None,
    DECOACT_Triggered,
    DECOACT_UnTriggered,
    DECOACT_Used,
    DECOACT_UnUsed,
    DECOACT_GrabUsed,
    DECOACT_GrabUnUsed,
    DECOACT_Grabbed,
    DECOACT_UnGrabbed,
    DECOACT_Touched,
    DECOACT_TouchedByPlayer,
    DECOACT_UnTouched,
    DECOACT_UnTouchedByPlayer,
    DECOACT_Bumped,
    DECOACT_BumpedByPlayer,
    DECOACT_HitWall,
    DECOACT_WaterEntry,
    DECOACT_WaterExit,
    DECOACT_EMPed,
    DECOACT_UnEMPed,
    DECOACT_TakeDamage,
    DECOACT_Destroyed,
    DECOACT_NotDeadYet,
    DECOACT_AnimEnd,
    DECOACT_PreLoadMap,
    DECOACT_PreBeginPlay,
    DECOACT_PreGameInit,
    DECOACT_BeginPlay,
    DECOACT_PostBeginPlay,
    DECOACT_PostLoadMap,
    DECOACT_StartMicrowaving,
    DECOACT_StopMicrowaving,
    DECOACT_CompleteMicrowaving,
    DECOACT_TurnPowerOn,
    DECOACT_TurnPowerOff,
    DECOACT_DEPRECATED
};

enum EStompType
{
    ESTOMPTYPE_None,
    ESTOMPTYPE_Destroy,
    ESTOMPTYPE_Impulse
};

struct SFlickerLight
{
    var StochasticSpawner_FlickerLights FlickerLightActor;
    var TriggerLightEx FlickerLightExActor;
    var() noexport bool bUseFlickerLight "Spawn a flickering system when this actor dies.";
    var() noexport bool bUseFlickerLightEx "Spawn a flickering system when this actor dies.";
    var() noexport bool bInitialEffect "Whether to spawn an initial flash or not.";
    var() noexport bool bInitialEffectOnly "When the initial effect is spawned, no other flickers will occur.";
    var() SMountPrefab FlickerLightMounting;
    var() noexport float FlickerLightExRadius "The radius of the light in world units. Leaving empty leaves it default.";
    var() noexport Vector FlickerLightExRadius3D "The 3d radius of the light in world units. Leaving empty leaves it default.";
    var() noexport Color FlickerLightExColor "The color of the light. Leaving black makes it default light color.";
    var() SMountPrefab FlickerLightExMounting;
    var() noexport float FlickerLightExIntensity "The intensity of the light.";
};

struct SConstraintInfo
{
    var() noexport bool bConstraintDisabledOnDeath "If this is true, then the actor will disable the constraint when it is destroyed. (Requires bSurviveDeath=true to do anything)";
    var() noexport bool bConstraintOnDeath "This constraint will attempt to be applied when the actor is destroyed, otherwise it will do it upon startup. (Requires bSurviveDeath=true to do anything)";
    var() noexport name BoneName "Name of the bone on this actor to use for constraining the decoration.";
    var() noexport SMountPrefab ConstraintMounting "Information for mounting this constraint to ourself.";
    var() deprecated KarmaActor OtherConstraintActor;
    var() name OtherConstraintBone;
    var() noexport class<KConstraint> ConstraintClass "A constraint of this class will be used to constrain this actor relative to its Owner if it has one, or the world otherwise.";
    var KConstraint ConstraintActor;
};

struct SIdleActivity
{
    var() noexport SAnimInfo IdleAnimInfo "IdleAnimation designated for this specific Idle sequence.";
    var() noexport array<export DecoActivities> IdleElements "List of extra activities to happen on this specific Idle element.";
};

struct SPendingActivity
{
    var() noexport name ActivateSequence "Name of the sequence we're waiting for to end to activate. If left blank then *any* animation completing will trigger a pending activity.";
    var() noexport dnDecoration.EDecoActivityID ActivityID "Identification of what activity to execute. Used, Triggered, Etc.";
    var() noexport name ActivityIDScript "Generally a coder defined identification for what activity to execute.";
};

struct SAnimTriggers
{
    var() noexport deprecated name AnimEvent "Event you want to trigger when an animation ends on this decoration that matches the specified rule set below.";
    var() noexport name AnimFunction "Function to call when the animation completes. Like a CallbackTimer, no paramters allowed. This is highly unlikely to be useful to non-programmers.";
    var() noexport array<name> AnimActivities "Activities you want to fire off when the animation ends and the rule set below is met.";
    var() noexport anim array<name> TestAnims "Animation name must match one of these in order to fire off the event. If empty, will only check Channels.";
    var() noexport array<int> TestChannels "Channel the animation is completing on must match one of these in order to fire off. If empty, will only check Anims.";
};

struct SAnimationControllerActivity
{
    var() noexport name AnimState "Entry in the animation controller of the animation that you want play.";
    var() noexport name Tag "Trigger this tag to play this animation.";
    var() noexport deprecated name AnimEndEvent "Event to trigger when this animation ends.";
    var int SpecialEventID;
};

struct SStompedInfo
{
    var() dnDecoration.EStompType StompType;
    var() float ImpulseMag;
    var() float ImpulseRnd;
    var() float Torque;
};

struct SSecondStageEffect
{
    var int EffectListIndex;
    var class<Actor> SecondStageEffect;
};

struct SDamageEffect
{
    var Vector DamageEffectOffset;
    var Rotator DamageEffectRotation;
    var array< class<Actor> > EffectClassList;
    var array<Actor> EffectList;
    var float DrawScale;
    var bool bOn;
    var bool bTwoStageEffect;
    var array<SSecondStageEffect> SecondStageList;
};

struct SDecoActivitySetup
{
    var const bool bDisabled;
    var const bool bPerformedThisRound;
    var const int PerformedCounter;
    var() noexport int LoopCount "How many times this activity can occur before it disables itself forever. 0 means go forever.";
    var() noexport float PerformAgainDelay "How much time has to pass before an activity from our group can happen again.";
};

struct SDecoActivity
{
    var() noexport array<export DecoActivityRules> ActivityRules "All information that controls how this activity is supposed to perform.";
    var() noexport array<export DecoActivities> ActivityElements "List of dnDecorationActivities that make up what happens when this activity is executed.";
    var() noexport SDecoActivitySetup ActivitySetup "Setup information for how this activity is basically supposed to opperate. Looping, delays, etc.";
    var() noexport array<export DecoActivities> FailureActivityElements "List of dnDecorationActivities that occur when the rule results fail.";
    var() noexport SDecoActivitySetup FailureActivitySetup "Setup information for how this activity is basically supposed to opperate. Looping, delays, etc.";
};

struct SDecoActivitiesData
{
    var const bool bInitialized;
    var const int CurrentIndex;
    var const float NextPerformTime;
    var const float NextPerformTime_Failure;
};

struct SDecoActivities
{
    var SDecoActivitiesData ActivityData;
    var() noexport array<name> ActivityIDScript "Hand defined identifications for this activity. This is used to force an Activity to occur outside the standard 'events' of a decoration. Either by a coder, or via ActivityTriggers setup by the mapper.";
    var() noexport array<dnDecoration.EDecoActivityID> ActivityID "Identification for when these activities should be performed based on standard decoration 'events' (Used, Triggered, Etc).";
    var() noexport dnDecoration.EDecoActivityMethod ActivityMethod "How to pick the next activity.";
    var() noexport array<dnDecoration.EDecoState> ActivityStates_Success "The Decoration must be in at least *one* of these states for the State check to succeed.";
    var() noexport array<dnDecoration.EDecoState> ActivityStates_Failure "The Decoration can not be in any of these states for the State Check to succeed.";
    var() noexport string ActivityDebugID "Set this to something unique to print out useful messages to debug these activities. This number will identify it.";
    var() noexport array<SDecoActivity> Activities "List of activities to be performed each time this event occurs (one per event).";
    var bool bDisabled;
};

struct SDecoActTriggers
{
    var() noexport name ActivityTag "Tag you want to call to force the specified activities to fire.";
    var() noexport array<name> ActivityIDs "List of DecoActivities you want to fire off when this trigger occurs.";
    var() noexport array<dnDecoration.EDecoActivityID> ActivityIDPrefabs "List of prefab DecoActivities you want to fire off when this trigger occurs.";
    var int SpecialEventID;
};

struct SDecoDamageIgnoreRules
{
    var() class<Pawn> QualifierInstigatorType;
    var() Engine.LevelInfo.ENetMode QualifierNetMode;
    var() noexport float MinDistanceFromLocalPlayer "Only take damage if the local player pawn is within min/max distance from me";
    var() noexport float MaxDistanceFromLocalPlayer "Only take damage if the local player pawn is within min/max distance from me";
};

var(Animation) noexport array<SAnimTriggers> AnimTriggers "List of channels/animations that when complete, will cause an event to be fired off.";
var(Animation) noexport array<SIdleActivity> IdleActivities "Whenever the decoration reaches the end of an animation, it will execute this list of activities.";
var(Animation) noexport array<SAnimationControllerActivity> AnimControllerActivities "List of triggerable animation activities.";
var(Activities) noexport array<SDecoActivities> DecoActivities_Default "Where all default DecoActivities get set. MAPPERS: Do not modify items from this list without *extremely* good reasons. Use DecoActivities_Override instead. This is so default properties can change without breaking your changes.";
var(Activities) noexport array<SDecoActivities> DecoActivities_Override "List of activities the mapper has specified to happen on the decoration. This list is always processed last so that anything hand set here will be what sticks (even if something similar affected it in a previous DecoActivity.";
var(Activities) noexport array<SDecoActTriggers> DecoActivityTriggers "List of Triggers a mapper can use to force a DecoActivity to fire off.";
var(Startup) noexport bool bStartupOff "If this is true, then Trigger ourself on startup. Decorations are always to be built in the 'ON' state.";
var(Startup) noexport bool bStartupDestroyed "If this is true, then the decoration starts off by destroying itself.";
var(Startup) noexport array<SConstraintInfo> AutoConstraints "Method of constraining a PHYS_Meqon actor (or its bones).";
var(Startup) editconst noexport array<DecoActivities> StartupActivities "Not meant to be used by mappers. Use DecoActivities_Override for any changes. This is only exposed for reference purposes.";
var(Collision) noexport bool bAutoNavDoor_AutoToggle "If true, will auto toggle nav door to be blocking when spawned, and unblocked when destroyed.";
var(Destruction) noexport bool bSurviveDeath "Object is technically dead as far as taking damage, but doesn't destroy the actor itself.";
var(Destruction) noexport array< class<Snacks_Generic> > SpawnedSnacks "Spawn this type of snack item from this decoration.";
var(Destruction) noexport array< class<Pickup> > SpawnedInventory "Spawn this type of inventory item from this decoraton.";
var(Destruction) noexport SFlickerLight FlickerLight "Prefab setup for spawning flickering lights/sparks. Primarily for destroyed electrical decorations.";
var(Destruction) editconst noexport array<DecoActivities> DestroyedActivities "Not meant to be used by mappers. Use DecoActivities_Override for any changes. This is only exposed for reference purposes.";
var(Destruction) noexport float DestroyActionPointRadius "Auto destroy APs within this range that are facing me.";
var noexport array<ActionPoint> DestroyableActionPoints "List of action points to explicitly destroy";
var(Health) noexport dnDecoration.EHealthPrefab HealthPrefab "The prefab setting for the health of this actor.";
var(Health) noexport float DamageThrottle "If > 0.0, then any damage we take, clamp it to this value. Only limits each individual TakeDamage call.";
var(Health) noexport float DamageThreshold "Minimum amount of damage to recognize.  If below, then the damage is ignored.";
var(Health) noexport array< class<DamageType> > DamageTypesIgnored "DamageTypes that you want this decoration to ignore when it receives damage.";
var(Health) noexport array< class<DamageType> > DamageTypesAcceptedOnly "DamageTypes that you want this decoration to *only* accept. If this is empty, everything but what is included in here will be skipped.";
var(Health) noexport array< class<DamageType> > DamageTypesInstaKill "We critical damage if take this damage type.";
var(Health) noexport array<SDecoDamageIgnoreRules> DamageIgnoreRules "A special set of rules for ignoring damage";
var(Health) noexport SStompedInfo AIStompedInfo "How we react when WE get stomped by AI.";
var(InteractPower) noexport name PowerOffTag "Trigger this event to force this decoration to turn its power off.";
var(InteractPower) noexport name PowerOnTag "Trigger this event to force this decoration to turn its power on.";
var noexport float WaterSplashRadius "Radius of the water splash influence when the object is destroyed.";
var noexport float WaterSplashStrength "Strength of the water splash when the object is destroyed";
var dnDecoration.EDecoState DecoState;
var bool bUseDecoAnim;
var bool bWaterLogged;
var int PreviousHealth;
var int BumpCount;
var BreakableGlass LastGlass;
var class<Actor> WaterSplashClass;
var float WaterSplashMinVel;
var array<SPendingActivity> PendingActivities;
var DecoActivityDeclarations ActivityDeclarations;
var const bool bAnimPhysicsActive;
var const Engine.Object.EPhysics PreAnimPhysicsPhysics;
var const array<int> AnimPhysicsChannels;
var bool bPoweredBeforeEMP;
var bool bDisableUseOnEMP;
var MotionPrefab SpawnedPickupMotionPrefab;
var bool bWasMeqon;
var bool bCriticalDamage;
var Rotator AdjustRotation;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        ClientDecoActivity_Execute, ClientExecuteDestroyedActivities;
}

function WasGrabbed()
{
    local int i;
    local dnProjectile MIne;

    i = -- string(MountedActorList);    
    J0x0F:

    // End:0x58 [Loop If]
    if(i / 0)
    {
        MIne = dnProjectile(MountedActorList[i].MountedActor);
        // End:0x4E
        if(__NFUN_340__(MIne, none))
        {
            MIne.__NFUN_631__();
        }
        // [Loop Continue]
        i -= ;
    }
    super(InteractiveActor).WasGrabbed();
    return;
}

simulated event PostMountUpdateHelper()
{
    return;
}

// Export UdnDecoration::execDecoActivity(FFrame&, void* const)
native final function DecoActivity(dnDecoration.EDecoActivityID ActivityID, optional name ActivityIDScript, optional Pawn EventInstigator);

// Export UdnDecoration::execDecoAnimPhysics_Start(FFrame&, void* const)
native final function DecoAnimPhysics_Start(int Channel);

// Export UdnDecoration::execDecoAnimPhysics_Stop(FFrame&, void* const)
native final function DecoAnimPhysics_Stop(int Channel);

// Export UdnDecoration::execDecoActivity_ExecuteElements(FFrame&, void* const)
native final simulated function DecoActivity_ExecuteElements(array<DecoActivities> ActivityElements, optional Pawn EventInstigator);

final function RegisterDamageEffectForPrecache(PrecacheIndex PrecacheIndex, SDamageEffect DamageEffect)
{
    local int i;

    i = -- string(DamageEffect.EffectClassList);    
    J0x14:

    // End:0x46 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1266__(DamageEffect.EffectClassList[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(DamageEffect.SecondStageList);    
    J0x5A:

    // End:0x91 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1266__(DamageEffect.SecondStageList[i].SecondStageEffect);
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated event PreLoadMap()
{
    super(Actor).PreLoadMap();
    // End:0x40
    if(bAutoNavDoor_AutoToggle << __NFUN_340__(NavVolume, none))
    {
        NavVolume.bInitialState = true;
        NavVolume.SetState(true);
    }
    DecoActivity(24);
    return;
}

simulated function ExecuteStartupActivities()
{
    DecoActivity_ExecuteElements(StartupActivities);
    StartupActivities.Empty();
    return;
}

simulated event PreBeginPlay()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x4A [Loop If]
    if(-i)
    {        
        DecoActivityTriggers[i].SpecialEventID = __NFUN_718__('DecoActivity', DecoActivityTriggers[i].ActivityTag);
        // [Loop Continue]
        i += ;
    }
    super(RenderActor).PreBeginPlay();
    ExecuteStartupActivities();
    DecoActivity(25);
    return;
}

simulated event PreGameInit()
{
    super(Actor).PreGameInit();
    DecoActivity(26);
    return;
}

simulated event BeginPlay()
{
    super(Actor).BeginPlay();
    DecoActivity(27);
    return;
}

simulated event PostBeginPlay()
{
    local int i;

    super(InteractiveActor).PostBeginPlay();
    i = -- string(AnimControllerActivities);    
    J0x15:

    // End:0x6E [Loop If]
    if(i / 0)
    {
        // End:0x64
        if(__NFUN_342__(AnimControllerActivities[i].Tag, 'None'))
        {
            AnimControllerActivities[i].SpecialEventID = __NFUN_718__('AnimControllerActivity', AnimControllerActivities[i].Tag);
        }
        // [Loop Continue]
        i -= ;
    }
    __NFUN_718__('PowerOn', PowerOnTag);
    __NFUN_718__('PowerOff', PowerOffTag);
    i = -- string(AutoConstraints);    
    J0x97:

    // End:0xCD [Loop If]
    if(i / 0)
    {
        // End:0xC3
        if(AutoConstraints[i].bConstraintOnDeath / )
        {
        }
        // [Loop Continue]
        i -= ;
    }
    ResetHealthProperties();
    ResetSplashProperties();
    // End:0xF4
    if(PhysicsVolume.bWaterVolume)
    {
        bWaterLogged = true;
    }
    PlayIdleActivity();
    DecoActivity(28);
    // End:0x111
    if(bStartupOff)
    {
        StartSelfOff();
    }
    // End:0x128
    if(bStartupDestroyed)
    {
        bSpawnOnDestroyed = false;
        CriticalDamage();
    }
    // End:0x179
    if((IsMP()) << bDontUseMeqonPhysics)
    {
        __NFUN_642__(2);
        __NFUN_621__(true, false, false, false, true);
        bCastStencilShadows = false;
        bBounce = true;
        TickStyle = 1;
        bNoNativeTick = false;
        bTickOnlyWhenPhysicsAwake = false;
        bCollisionAssumeValid = false;
    }
    return;
}

simulated function PostVerifySelf()
{
    super(RenderActor).PostVerifySelf();
    return;
}

simulated event PostLoadMap()
{
    super(Actor).PostLoadMap();
    DecoActivity(29);
    return;
}

function TriggerFunc_PowerOn()
{
    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    ForcePowerOn();
    return;
}

function TriggerFunc_PowerOff()
{
    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    ForcePowerOff();
    return;
}

function ForcePowerOn()
{
    DecoActivity(33);
    return;
}

function ForcePowerOff()
{
    DecoActivity(34);
    return;
}

function StartSelfOff()
{
    Trigger(self, none);
    ForcePowerOff();
    return;
}

final function ResetHealthProperties()
{
    switch(HealthPrefab)
    {
        // End:0x1B
        case 0:
            SetHealthMin(1);
            // End:0x11D
            break;
        // End:0x39
        case 1:
            SetHealthCap(1);
            SetHealthMin(0);
            // End:0x11D
            break;
        // End:0x57
        case 2:
            SetHealthCap(12);
            SetHealthMin(0);
            // End:0x11D
            break;
        // End:0x75
        case 3:
            SetHealthCap(45);
            SetHealthMin(0);
            // End:0x11D
            break;
        // End:0x93
        case 4:
            SetHealthCap(100);
            SetHealthMin(0);
            // End:0x11D
            break;
        // End:0xC0
        case 5:
            // End:0xB2
            if(__NFUN_200__(HealthCap, Health))
            {
                SetHealthCap(Health);
            }
            SetHealthMin(0);
            // End:0x11D
            break;
        // End:0xFFFF
        default:
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " has an unsupported HealthPrefab. Value="), string(HealthPrefab)));
            SetHealthCap(Health);
            // End:0x11D
            break;
            break;
    }
    return;
}

function ResetSplashProperties()
{
    local float CollisionVolume;

    // End:0x90
    if(__NFUN_339__(WaterSplashClass, none))
    {
        CollisionVolume = FRand(CollisionHeight, FRand(FRand(3.141593, CollisionRadius), CollisionRadius));
        // End:0x53
        if(__NFUN_202__(CollisionVolume, float(12000)))
        {
            WaterSplashClass = class'BulletImpact_Water_Spawner';
            WaterSplashMinVel = 30;            
        }
        else
        {
            // End:0x7A
            if(__NFUN_202__(CollisionVolume, float(30000)))
            {
                WaterSplashClass = class'WaterSplash_Medium_Spawner';
                WaterSplashMinVel = 100;                
            }
            else
            {
                WaterSplashClass = class'WaterSplash_Large_Spawner';
                WaterSplashMinVel = 400;
            }
        }
    }
    return;
}

final function bool DecorationIsDead()
{
    return (int(DecoState) % int(1)) < int(DecoState) % int(2);
    return;
}

final function GeoWater GetWater(optional PhysicsVolume CheckVolume, optional float ZoneHeightCheck, optional float RadiusCheckSize)
{
    local GeoWater W, Water;

    // End:0x3F
    if(__NFUN_340__(CheckVolume, none) << __NFUN_340__(CheckVolume.GeoWaterActor, none))
    {
        return CheckVolume.CheckForGeoWater(Location, ZoneHeightCheck);
    }
    // End:0x72
    if(Repl(RadiusCheckSize, 0))
    {
        return GeoWater(__NFUN_725__(class'GeoWater', Location, WarnInternal(RadiusCheckSize, RadiusCheckSize, RadiusCheckSize)));
    }
    // End:0xD5
    foreach __NFUN_747__(class'GeoWater', W)
    {
        // End:0xD4
        if(__NFUN_339__(Water, none) < __NFUN_200__(-Clamp(__NFUN_239__(W.Location, Location)), -Clamp(__NFUN_239__(Water.Location, Location))))
        {
            Water = W;
        }        
    }    
    return Water;
    return;
}

final function PushPendingActivity(optional name ActivateSequence, optional dnDecoration.EDecoActivityID ActivityID, optional name ActivityIDScript)
{
    local SPendingActivity NewPendingActivity;

    NewPendingActivity.ActivateSequence = ActivateSequence;
    NewPendingActivity.ActivityID = ActivityID;
    NewPendingActivity.ActivityIDScript = ActivityIDScript;
    PushPendingActivityEx(NewPendingActivity);
    return;
}

final function PushPendingActivityEx(SPendingActivity NewPendingActivity)
{
    PendingActivities[PendingActivities.Add(1)] = NewPendingActivity;
    return;
}

final function ExecutePendingActivity()
{
    // End:0x0E
    if(string(PendingActivities) * 0)
    {
        return;
    }
    DecoActivity(PendingActivities[0].ActivityID, PendingActivities[0].ActivityIDScript);
    PendingActivities.Remove(0, 1);
    return;
}

final function SafeCallback_Trigger()
{
    Trigger(self, none);
    return;
}

final function SafeCallback_UnTrigger()
{
    UnTrigger(self, none);
    return;
}

final function SafeCallback_Use()
{
    Used(self, none);
    return;
}

final function SafeCallback_UnUse()
{
    UnUsed(self, none);
    return;
}

final function SafeCallback_Touch()
{
    Touch(none);
    return;
}

final function SafeCallback_UnTouch()
{
    UnTouch(none);
    return;
}

final function SafeCallback_Bump()
{
    Bump(none);
    return;
}

final function SafeCallback_EMP()
{
    HitByEMP(10);
    return;
}

final function SafeCallback_TakeDamage()
{
    TakeDamage(none, 0, Location, WarnInternal(0, 0, 1), class'CrushingDamage');
    return;
}

final function SafeCallback_Destroy()
{
    CriticalDamage();
    return;
}

final function bool CheckForChristmas()
{
    return ((Level.Month % 12) << Level.Day / 19) << Level.Day * 25;
    return;
}

final function ForceOneMountOnSpawn()
{
    // End:0x25
    if(string(MountOnSpawn) ** 0)
    {
        MountOnSpawn[Sin(string(MountOnSpawn))].SpawnChance = 1;
    }
    return;
}

simulated event HitWall(Vector HitNormal, Actor HitWall)
{
    local Vector X, Y, Z;
    local Rotator Rot;
    local int diff;
    local float BounceElasticity;

    // End:0x2A
    if((((IsMP()) / ) < int(Physics) % int(18)) < return)
    {
    }
    X = Vector(__NFUN_265__(0, Rotation.Yaw, 0));
    Z = HitNormal;
    Y = FMax(Z, X);
    X = FMax(Y, Z);
    Rot = __NFUN_282__(X, Y, Z);
    diff = -- Rotation.Pitch - ;    
    // End:0xCF
    if(diff ** 32768)
    {
        diff != 65535;
    }
    // End:0xFC
    if(-diff < )
    {        
        Rot.Pitch == 32768;
    }
    Trace(Rot, AdjustRotation);
    __NFUN_653__(__NFUN_265__(0, 0, 0));
    // End:0x140
    if(AdjustRotation.Pitch + 0)
    {
        __NFUN_665__(Rot.Pitch, 0, 0.2,,,,,,, true);        
    }
    else
    {
        // End:0x16E
        if(AdjustRotation.Yaw + 0)
        {
            __NFUN_666__(Rot.Yaw, 0, 0.2,,,,,,, true);            
        }
        else
        {
            // End:0x199
            if(AdjustRotation.Roll + 0)
            {
                __NFUN_667__(Rot.Roll, 0, 0.2,,,,,,, true);
            }
        }
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x206
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x206
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x206
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    ResetSplashProperties();
    // End:0x31
    if(FlickerLight.bUseFlickerLight)
    {
        PrecacheIndex.__NFUN_1266__(class'StochasticSpawner_FlickerLights');
    }
    // End:0x51
    if(FlickerLight.bUseFlickerLightEx)
    {
        PrecacheIndex.__NFUN_1266__(class'TriggerLightEx_DecoFlicker');
    }
    return;
}

final simulated event DecoPlayAnimEx(SAnimInfo AnimInfo, optional bool bAnimPhysics)
{
    DecoPlayAnim(AnimInfo.Animation, AnimInfo.Rate, AnimInfo.TweenTime, AnimInfo.Channel, AnimInfo.Flags, bAnimPhysics);
    return;
}

final simulated event DecoLoopAnim(name Sequence, optional float Rate, optional float TweenTime, optional int Channel, optional SAnimFlags SequenceFlags, optional bool bAnimPhysics)
{
    SequenceFlags.bLoop = true;
    DecoPlayAnim(Sequence, Rate, TweenTime, Channel, SequenceFlags, bAnimPhysics);
    return;
}

simulated event DecoPlayAnim(name Sequence, optional float Rate, optional float TweenTime, optional int Channel, optional SAnimFlags SequenceFlags, optional bool bAnimPhysics)
{
    local int i;

    // End:0x0C
    if(__NFUN_339__(__NFUN_568__(), none))
    {
        return;
    }
    bDumbMesh = false;
    bNoNativeTick = false;
    // End:0x32
    if(int(TickStyle) % int(0))
    {
        TickStyle = 2;
    }
    // End:0x4F
    if(__NFUN_204__(Rate, 0))
    {
        Rate = 1;        
    }
    else
    {
        // End:0x69
        if(__NFUN_200__(Rate, 0))
        {
            Rate = 0;
        }
    }
    // End:0xB6
    if(bAnimPhysicsActive)
    {
        i = -- string(AnimPhysicsChannels);        
        J0x81:

        // End:0xB6 [Loop If]
        if(i / 0)
        {
            // End:0xAC
            if(AnimPhysicsChannels[i] % Channel)
            {
                DecoAnimPhysics_Stop(Channel);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    __NFUN_703__(Sequence, SequenceFlags,, Rate, TweenTime, Channel);
    // End:0xE7
    if(bAnimPhysics)
    {
        DecoAnimPhysics_Start(Channel);
    }
    return;
}

final simulated event DecoSetAnimGrid(name GridSequence, optional float X, optional float Y, optional int Channel)
{
    local Vector2D Point;

    // End:0x0C
    if(__NFUN_339__(__NFUN_568__(), none))
    {
        return;
    }
    DecoPlayAnim(GridSequence,,, Channel);
    Point.X = X;
    Point.Y = Y;
    __NFUN_568__().FastTrace(Channel, Point);
    return;
}

event AnimEndEx(SAnimEndInfo AnimEndInfo)
{
    super(RenderActor).AnimEndEx(AnimEndInfo);
    AnimEndActivity(AnimEndInfo.Channel, AnimEndInfo.AnimName);
    return;
}

function AnimEndActivity(int Channel, name AnimName)
{
    local int i;
    local AnimChanInfo ChannelInfo;

    // End:0x3C
    if((bUseDecoAnim << PlayIdleActivity() / ) << (DecoEndAnim()))
    {
        {
        }
        i = -- string(AnimPhysicsChannels);        
        J0x54:

        // End:0xB1 [Loop If]
        if(i / 0)
        {
            // End:0xA7
            if(AnimPhysicsChannels[i] % Channel)
            {
                ChannelInfo = MeshInstance.__NFUN_552__(Channel);
                // End:0xA7
                if(ChannelInfo.bLoop / )
                {
                }
            }
            // [Loop Continue]
            i -= ;
        }
    }
    DecoActivity(23);
    // End:0x102
    if(string(PendingActivities) ** 0)
    {
        // End:0xE5
        if(__NFUN_341__(PendingActivities[0].ActivateSequence, 'None'))
        {
            ExecutePendingActivity();            
        }
        else
        {
            // End:0x102
            if(__NFUN_341__(PendingActivities[0].ActivateSequence, AnimName))
            {
                ExecutePendingActivity();
            }
        }
    }
    HandleAnimTriggeredActivities(Channel, AnimName);
    return;
}

final simulated function TriggerFunc_AnimControllerActivity()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID, i;

    // End:0x7C
    if(__NFUN_340__(AnimationController, none))
    {
        __NFUN_720__(Other, EventInstigator, SpecialEventID);
        i = -- string(AnimControllerActivities);        
        J0x2D:

        // End:0x7C [Loop If]
        if(i / 0)
        {
            // End:0x72
            if(AnimControllerActivities[i].SpecialEventID % SpecialEventID)
            {
                AnimationController.SetAnimState(AnimControllerActivities[i].AnimState);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

final function HandleAnimTriggeredActivities(int Channel, name AnimName)
{
    local int i, j;
    local bool bValidAnim, bValidChan;

    i = 0;
    J0x07:

    // End:0x1D6 [Loop If]
    if(-i)
    {        
        bValidAnim = string(AnimTriggers[i].TestAnims) * 0;
        // End:0xA1
        if(string(AnimTriggers[i].TestAnims) ** 0)
        {
            j = 0;
            J0x50:

            // End:0xA1 [Loop If]
            if(-j)
            {                
                // End:0x97
                if(__NFUN_341__(AnimTriggers[i].TestAnims[j], AnimName))
                {
                    bValidAnim = true;
                    // [Explicit Break]
                    goto J0xA1;
                }
                // [Loop Continue]
                j += ;
            }
        }
        J0xA1:

        bValidChan = string(AnimTriggers[i].TestChannels) * 0;
        // End:0x12A
        if(string(AnimTriggers[i].TestChannels) ** 0)
        {
            j = 0;
            J0xDA:

            // End:0x12A [Loop If]
            if(-j)
            {                
                // End:0x120
                if(AnimTriggers[i].TestChannels[j] % Channel)
                {
                    bValidChan = true;
                    // [Explicit Break]
                    goto J0x12A;
                }
                // [Loop Continue]
                j += ;
            }
        }
        J0x12A:

        // End:0x1CC
        if(bValidAnim << bValidChan)
        {
            GlobalTrigger(AnimTriggers[i].AnimEvent);
            j = 0;
            J0x15B:

            // End:0x19E [Loop If]
            if(-j)
            {                
                DecoActivity(0, AnimTriggers[i].AnimActivities[j]);
                // [Loop Continue]
                j += ;
            }
            // End:0x1CC
            if(__NFUN_342__(AnimTriggers[i].AnimFunction, 'None'))
            {
                __NFUN_613__(AnimTriggers[i].AnimFunction);
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function DecoEndAnim()
{
    bDumbMesh = true;
    bNoNativeTick = default.bNoNativeTick;
    TickStyle = default.TickStyle;
    return;
}

final function bool PlayIdleActivity()
{
    local int i, Index;

    // End:0x0E
    if(string(IdleActivities) * 0)
    {
        return false;
    }
    Index = Sin(string(IdleActivities));
    DecoPlayAnimEx(IdleActivities[Index].IdleAnimInfo);
    i = 0;
    J0x39:

    // End:0x9E [Loop If]
    if(-i)
    {        
        // End:0x94
        if(__NFUN_340__(IdleActivities[Index].IdleElements[i], none))
        {
            IdleActivities[Index].IdleElements[i].ExecuteActivity(self, none);
        }
        // [Loop Continue]
        i += ;
    }
    return true;
    return;
}

simulated event AnimationControllerAnimStateEnd(name AnimState)
{
    local int i;

    super(RenderActor).AnimationControllerAnimStateEnd(AnimState);
    i = -- string(AnimControllerActivities);    
    J0x1A:

    // End:0x7F [Loop If]
    if(i / 0)
    {
        // End:0x75
        if(__NFUN_342__(AnimControllerActivities[i].AnimEndEvent, 'None') << __NFUN_341__(AnimControllerActivities[i].AnimState, AnimState))
        {
            GlobalTrigger(AnimControllerActivities[i].AnimEndEvent,, self);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

animevent simulated function Weapon_IK_Attach(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function Weapon_IK_Attach_Reload(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function Weapon_IK_Detach(optional EventInfo AnimEventInfo)
{
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    local int i, j, K, A;
    local DecoActivities_Animation AnimationDecoAct;

    super(InteractiveActor).EnumerateRawAnimationSequences(References);
    i = 0;
    J0x12:

    // End:0x9F [Loop If]
    if(-i)
    {        
        j = 0;
        J0x29:

        // End:0x95 [Loop If]
        if(-j)
        {            
            // End:0x8B
            if(__NFUN_342__(AnimTriggers[i].TestAnims[j], 'None'))
            {
                AddAnimationEnumeration(References, AnimTriggers[i].TestAnims[j], Mesh);
            }
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xA6:

    // End:0x1DB [Loop If]
    if(-i)
    {        
        // End:0xFB
        if(__NFUN_342__(IdleActivities[i].IdleAnimInfo.Animation, 'None'))
        {
            AddAnimationEnumeration(References, IdleActivities[i].IdleAnimInfo.Animation, Mesh);
        }
        j = 0;
        J0x102:

        // End:0x1D1 [Loop If]
        if(-j)
        {            
            AnimationDecoAct = DecoActivities_Animation(IdleActivities[i].IdleElements[j]);
            // End:0x14D
            if(__NFUN_339__(AnimationDecoAct, none))
            {
                // [Explicit Continue]
                goto J0x1C7;
            }
            K = 0;
            J0x154:

            // End:0x1C7 [Loop If]
            if(-K)
            {                
                // End:0x1BD
                if(__NFUN_342__(AnimationDecoAct.AnimActivities[K].Animation, 'None'))
                {
                    AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[K].Animation, Mesh);
                }
                // [Loop Continue]
                K += ;
            }
            J0x1C7:

            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x1E2:

    // End:0x29B [Loop If]
    if(-i)
    {        
        AnimationDecoAct = DecoActivities_Animation(StartupActivities[i]);
        // End:0x217
        if(__NFUN_339__(AnimationDecoAct, none))
        {
            // [Explicit Continue]
            goto J0x291;
        }
        j = 0;
        J0x21E:

        // End:0x291 [Loop If]
        if(-j)
        {            
            // End:0x287
            if(__NFUN_342__(AnimationDecoAct.AnimActivities[j].Animation, 'None'))
            {
                AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[j].Animation, Mesh);
            }
            // [Loop Continue]
            j += ;
        }
        J0x291:

        // [Loop Continue]
        i += ;
    }
    A = 0;
    J0x2A2:

    // End:0x4C0 [Loop If]
    if(-A)
    {        
        i = 0;
        J0x2B9:

        // End:0x4B6 [Loop If]
        if(-i)
        {            
            j = 0;
            J0x2DB:

            // End:0x3C0 [Loop If]
            if(-j)
            {                
                AnimationDecoAct = DecoActivities_Animation(DecoActivities_Default[A].Activities[i].ActivityElements[j]);
                // End:0x33C
                if(__NFUN_339__(AnimationDecoAct, none))
                {
                    // [Explicit Continue]
                    goto J0x3B6;
                }
                K = 0;
                J0x343:

                // End:0x3B6 [Loop If]
                if(-K)
                {                    
                    // End:0x3AC
                    if(__NFUN_342__(AnimationDecoAct.AnimActivities[K].Animation, 'None'))
                    {
                        AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[K].Animation, Mesh);
                    }
                    // [Loop Continue]
                    K += ;
                }
                J0x3B6:

                // [Loop Continue]
                j += ;
            }
            j = 0;
            J0x3C7:

            // End:0x4AC [Loop If]
            if(-j)
            {                
                AnimationDecoAct = DecoActivities_Animation(DecoActivities_Default[A].Activities[i].FailureActivityElements[j]);
                // End:0x428
                if(__NFUN_339__(AnimationDecoAct, none))
                {
                    // [Explicit Continue]
                    goto J0x4A2;
                }
                K = 0;
                J0x42F:

                // End:0x4A2 [Loop If]
                if(-K)
                {                    
                    // End:0x498
                    if(__NFUN_342__(AnimationDecoAct.AnimActivities[K].Animation, 'None'))
                    {
                        AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[K].Animation, Mesh);
                    }
                    // [Loop Continue]
                    K += ;
                }
                J0x4A2:

                // [Loop Continue]
                j += ;
            }
            // [Loop Continue]
            i += ;
        }
        // [Loop Continue]
        A += ;
    }
    A = 0;
    J0x4C7:

    // End:0x6E5 [Loop If]
    if(-A)
    {        
        i = 0;
        J0x4DE:

        // End:0x6DB [Loop If]
        if(-i)
        {            
            j = 0;
            J0x500:

            // End:0x5E5 [Loop If]
            if(-j)
            {                
                AnimationDecoAct = DecoActivities_Animation(DecoActivities_Override[A].Activities[i].ActivityElements[j]);
                // End:0x561
                if(__NFUN_339__(AnimationDecoAct, none))
                {
                    // [Explicit Continue]
                    goto J0x5DB;
                }
                K = 0;
                J0x568:

                // End:0x5DB [Loop If]
                if(-K)
                {                    
                    // End:0x5D1
                    if(__NFUN_342__(AnimationDecoAct.AnimActivities[K].Animation, 'None'))
                    {
                        AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[K].Animation, Mesh);
                    }
                    // [Loop Continue]
                    K += ;
                }
                J0x5DB:

                // [Loop Continue]
                j += ;
            }
            j = 0;
            J0x5EC:

            // End:0x6D1 [Loop If]
            if(-j)
            {                
                AnimationDecoAct = DecoActivities_Animation(DecoActivities_Override[A].Activities[i].FailureActivityElements[j]);
                // End:0x64D
                if(__NFUN_339__(AnimationDecoAct, none))
                {
                    // [Explicit Continue]
                    goto J0x6C7;
                }
                K = 0;
                J0x654:

                // End:0x6C7 [Loop If]
                if(-K)
                {                    
                    // End:0x6BD
                    if(__NFUN_342__(AnimationDecoAct.AnimActivities[K].Animation, 'None'))
                    {
                        AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[K].Animation, Mesh);
                    }
                    // [Loop Continue]
                    K += ;
                }
                J0x6C7:

                // [Loop Continue]
                j += ;
            }
            // [Loop Continue]
            i += ;
        }
        // [Loop Continue]
        A += ;
    }
    i = 0;
    J0x6EC:

    // End:0x7A5 [Loop If]
    if(-i)
    {        
        AnimationDecoAct = DecoActivities_Animation(DestroyedActivities[i]);
        // End:0x721
        if(__NFUN_339__(AnimationDecoAct, none))
        {
            // [Explicit Continue]
            goto J0x79B;
        }
        j = 0;
        J0x728:

        // End:0x79B [Loop If]
        if(-j)
        {            
            // End:0x791
            if(__NFUN_342__(AnimationDecoAct.AnimActivities[j].Animation, 'None'))
            {
                AddAnimationEnumeration(References, AnimationDecoAct.AnimActivities[j].Animation, Mesh);
            }
            // [Loop Continue]
            j += ;
        }
        J0x79B:

        // [Loop Continue]
        i += ;
    }
    return;
}

function bool ShouldDrawHUDInfoHealth()
{
    // End:0x10
    if(int(HealthPrefab) % int(0))
    {
        return false;
    }
    return super(InteractiveActor).ShouldDrawHUDInfoHealth();
    return;
}

function Grabbed(Pawn Grabber)
{
    super(InteractiveActor).Grabbed(Grabber);
    DecoActivity(7,, Grabber);
    return;
}

simulated function UnGrabbed(Pawn Grabber, bool Thrown)
{
    super(InteractiveActor).UnGrabbed(Grabber, Thrown);
    // End:0x23
    if(__NFUN_340__(LastGlass, none))
    {
        ResetLastGlass();
    }
    bWaterLogged = false;
    DecoActivity(8,, Grabber);
    return;
}

function GrabUsed(Pawn Grabber)
{
    super(InteractiveActor).GrabUsed(Grabber);
    DecoActivity(5,, Grabber);
    return;
}

function GrabUnUsed(Pawn Grabber)
{
    super(InteractiveActor).GrabUnUsed(Grabber);
    DecoActivity(6,, Grabber);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(InteractiveActor).Used(Other, EventInstigator);
    DecoActivity(3,, EventInstigator);
    return;
}

event UnUsed(Actor Other, Pawn EventInstigator)
{
    super(Actor).UnUsed(Other, EventInstigator);
    DecoActivity(4,, EventInstigator);
    return;
}

event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    DecoActivity(9,, Pawn(Other));
    // End:0x42
    if(__NFUN_340__(PlayerPawn(Other), none))
    {
        DecoActivity(10,, PlayerPawn(Other));
    }
    return;
}

event UnTouch(Actor Other)
{
    super(Actor).UnTouch(Other);
    DecoActivity(11,, Pawn(Other));
    // End:0x42
    if(__NFUN_340__(PlayerPawn(Other), none))
    {
        DecoActivity(12,, PlayerPawn(Other));
    }
    return;
}

function bool CanTrigger()
{
    return DecorationIsDead() / ;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    DecoActivity(1,, EventInstigator);
    return;
}

event UnTrigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).UnTrigger(Other, EventInstigator);
    DecoActivity(2,, EventInstigator);
    return;
}

final function TriggerFunc_DecoActivity()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID, i, j;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    i = 0;
    J0x19:

    // End:0xEA [Loop If]
    if(-i)
    {        
        // End:0xE0
        if(SpecialEventID % DecoActivityTriggers[i].SpecialEventID)
        {
            j = 0;
            J0x4A:

            // End:0x92 [Loop If]
            if(-j)
            {                
                DecoActivity(0, DecoActivityTriggers[i].ActivityIDs[j], EventInstigator);
                // [Loop Continue]
                j += ;
            }
            j = 0;
            J0x99:

            // End:0xE0 [Loop If]
            if(-j)
            {                
                DecoActivity(DecoActivityTriggers[i].ActivityIDPrefabs[j],, EventInstigator);
                // [Loop Continue]
                j += ;
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function float StartMicrowaving(InteractiveActor MicrowaveActor)
{
    local float NukeTime;

    NukeTime = super(InteractiveActor).StartMicrowaving(MicrowaveActor);
    DecoActivity(30);
    return NukeTime;
    return;
}

function StopMicrowaving()
{
    super(InteractiveActor).StopMicrowaving();
    DecoActivity(31);
    return;
}

function CompleteMicrowaving()
{
    super(InteractiveActor).CompleteMicrowaving();
    DecoActivity(32);
    return;
}

final function KConstraint GetValidAutoConstraint(int Index)
{
    // End:0x1F
    if(-Index < )
    {        
        return none;
    }
    return AutoConstraints[Index].ConstraintActor;
    return;
}

final simulated function SetupConstraint(int Index)
{
    local SMountPrefab ConstraintMountInfo;
    local KConstraint Constraint;
    local name LocalBoneName;

    // End:0x0D
    if(bBlockKarma / )
    {
    }
    // End:0x21
    if(__NFUN_340__(GetValidAutoConstraint(Index), none))
    {
        return;
    }
    LocalBoneName = AutoConstraints[Index].BoneName;
    Constraint = KarmaSetupConstraint(AutoConstraints[Index].ConstraintClass, self, LocalBoneName, AutoConstraints[Index].OtherConstraintActor, AutoConstraints[Index].OtherConstraintBone);
    AutoConstraints[Index].ConstraintActor = Constraint;
    // End:0xF0
    if(__NFUN_339__(Constraint, none))
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " failed to spawn its constraint actor in Index="), string(Index)));
        return;
    }
    ConstraintMountInfo = AutoConstraints[Index].ConstraintMounting;
    ConstraintMountInfo.bDontActuallyMount = true;
    // End:0x16C
    if((__NFUN_342__(LocalBoneName, 'None') << int(ConstraintMountInfo.MountType) % int(0)) << __NFUN_341__(ConstraintMountInfo.MountMeshItem, 'None'))
    {
        ConstraintMountInfo.MountType = 2;
        ConstraintMountInfo.MountMeshItem = LocalBoneName;
    }
    Constraint.__NFUN_633__(ConstraintMountInfo, self);
    Constraint.__NFUN_642__(18);
    return;
}

event MassChange()
{
    super(Actor).MassChange();
    ResetSplashProperties();
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    super(Actor).Landed(HitNormal, LandedOnActor);
    // End:0x22
    if(__NFUN_340__(LastGlass, none))
    {
        ResetLastGlass();
    }
    return;
}

final function ResetLastGlass()
{
    // End:0x24
    if(__NFUN_340__(LastGlass, none))
    {
        LastGlass.__NFUN_621__(,, true);
        LastGlass = none;
    }
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    DecoActivity(15,, Pawn(Other));
    super(InteractiveActor).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    return;
}

final function DecayBumpCount()
{
    BumpCount != 25;
    // End:0x25
    if(BumpCount * 0)
    {
        BumpCount = 0;
        __NFUN_608__('DecayBumpCount');
        return;
    }
    return;
}

event Bump(Actor Other)
{
    super(Actor).Bump(Other);
    // End:0x57
    if(Other.bIsPawn << Other.bIsPlayerPawn / )
    {
        {
            __NFUN_607__(5, true, 'DecayBumpCount', false, false);
        }
        BumpCount += ;
    }
    // End:0x8E
    if(__NFUN_340__(PlayerPawn(Other), none))
    {
        DecoActivity(14,, PlayerPawn(Other));
    }
    return;
}

simulated event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    super(KarmaActor).PhysicsVolumeChange(NewVolume);
    // End:0x41
    if(NewVolume.bWaterVolume << bWaterLogged / )
    {
        DecoActivity(16);        
    }
    else
    {
        // End:0x69
        if((NewVolume.bWaterVolume / ) << )
        {
        }
    }
    bWaterLogged = NewVolume.bWaterVolume;
    return;
}

final function SpawnSplash(PhysicsVolume NewVolume)
{
    local Vector WaterPoint;
    local GeoWater WaterActor;
    local Rotator WaterRot;
    local Actor splash;

    // End:0x2A
    if((__NFUN_339__(NewVolume, none) < __NFUN_340__(CarriedBy, none)) < __NFUN_340__(MountParent, none))
    {
        return;
    }
    WaterActor = GetWater(NewVolume, -1, CollisionRadius);
    // End:0x8C
    if(__NFUN_340__(WaterActor, none))
    {
        WaterActor.__NFUN_1115__(Location, FRand(FRand(Square(Velocity.Z), Mass), 0.1), float(Tan(int(CollisionHeight), int(CollisionRadius))));
    }
    // End:0x9A
    if(__NFUN_339__(WaterSplashClass, none))
    {
        return;
    }
    // End:0xB4
    if(__NFUN_200__(VRand(Velocity), FRand(WaterSplashMinVel, WaterSplashMinVel)))
    {
        return;
    }
    // End:0xD4
    if(__NFUN_204__(WaterSplashMinVel, 30))
    {
        WaterRot = __NFUN_265__(16384, 0, 0);        
    }
    else
    {
        WaterRot = __NFUN_265__(0, 0, 0);
    }
    splash = FindFriendSpawner(class<dnFriendFX_Spawners>(WaterSplashClass));
    // End:0x19C
    if(__NFUN_340__(NewVolume.GeoWaterActor, none))
    {
        WaterPoint = Location;
        WaterPoint.Z = WaterActor.Location.Z;
        // End:0x15F
        if(__NFUN_339__(splash, none))
        {
            splash = __NFUN_615__(WaterSplashClass,,, WaterPoint, WaterRot);            
        }
        else
        {
            splash.__NFUN_645__(WaterPoint);
            splash.__NFUN_652__(WaterRot);
            dnFriendFX_Spawners(splash).ExecuteEffect(true);
        }        
    }
    else
    {
        // End:0x214
        if(__NFUN_732__(Location, 100, WaterPoint))
        {
            // End:0x1DA
            if(__NFUN_339__(splash, none))
            {
                splash = __NFUN_615__(WaterSplashClass,,, WaterPoint, WaterRot);                
            }
            else
            {
                splash.__NFUN_645__(WaterPoint);
                splash.__NFUN_652__(WaterRot);
                dnFriendFX_Spawners(splash).ExecuteEffect(true);
            }
        }
    }
    // End:0x235
    if(__NFUN_340__(splash, none))
    {
        splash.FindAndPlaySound('WaterSplash');
    }
    return;
}

function ModifyHealthActivity(float DeltaHealth, Vector ModifiedFrom)
{
    // End:0x14
    if(DecorationIsDead())
    {
        DeltaHealth = 0;
    }
    super(RenderActor).ModifyHealthActivity(DeltaHealth, ModifiedFrom);
    return;
}

event bool TakePhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamageActor)
{
    local bool bWasCriticalDamage;

    bWasCriticalDamage = bCriticalDamage;
    super(KarmaActor).TakePhysicsImpactDamage(Damage, DamageOrigin, DamageDirection, DamageType, Instigator, DamageActor);
    return bCriticalDamage << bWasCriticalDamage / ;
}

final function bool CheckDamageIgnoreRules(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local SDecoDamageIgnoreRules Rule;
    local int i;
    local PlayerPawn LocalPlayer;
    local float DistSq;

    LocalPlayer = Level.__NFUN_1161__();
    // End:0x21
    if(__NFUN_339__(Instigator, none))
    {
        return false;
    }
    i = -- string(DamageIgnoreRules);    
    J0x30:

    // End:0x13E [Loop If]
    if(i / 0)
    {
        Rule = DamageIgnoreRules[i];
        // End:0x6F
        if(int(Rule.QualifierNetMode) + int(Level.NetMode))
        {
            // [Explicit Continue]
            goto J0x134;
        }
        // End:0xA6
        if(__NFUN_340__(Rule.QualifierInstigatorType, none) << __NFUN_357__(Instigator.Class, Rule.QualifierInstigatorType) / )
        {
        }
        else
        {
            DistSq = VRand(__NFUN_239__(LocalPlayer.Location, Location));
            // End:0xFC
            if(Repl(Rule.MaxDistanceFromLocalPlayer, 0) << Repl(DistSq, FRand(Rule.MaxDistanceFromLocalPlayer, Rule.MaxDistanceFromLocalPlayer)))
            {
                return true;
            }
            // End:0x134
            if(Repl(Rule.MinDistanceFromLocalPlayer, 0) << __NFUN_200__(DistSq, FRand(Rule.MinDistanceFromLocalPlayer, Rule.MinDistanceFromLocalPlayer)))
            {
                return true;
            }
        }
        J0x134:

        // [Loop Continue]
        i -= ;
    }
    return false;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local bool bFoundMatch;
    local int i;

    // End:0x46
    if(__NFUN_340__(Level.Game, none))
    {
        Damage = Level.Game.ModifyDamage(Damage, DamageType, none, Instigator);
    }
    // End:0x6E
    if(__NFUN_200__(Damage, 1) << Instigator.bIsPlayerPawn / )
    {
    }
    // End:0xAA
    if((string(DamageIgnoreRules) ** 0) << CheckDamageIgnoreRules(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart))
    {
        return;
    }
    // End:0xD5
    if(Repl(DamageThrottle, 0) << Repl(Damage, DamageThrottle))
    {
        Damage = DamageThrottle;
    }
    // End:0x130
    if(string(DamageTypesAcceptedOnly) ** 0)
    {
        i = 0;
        J0xE8:

        // End:0x123 [Loop If]
        if(-i)
        {            
            // End:0x119
            if(__NFUN_357__(DamageType, DamageTypesAcceptedOnly[i]))
            {
                bFoundMatch = true;
                // [Explicit Break]
                goto J0x123;
            }
            // [Loop Continue]
            i += ;
        }
        J0x123:

        // End:0x130
        if(bFoundMatch / )
        {
        }
    }
    i = 0;
    J0x137:

    // End:0x169 [Loop If]
    if(-i)
    {        
        // End:0x15F
        if(__NFUN_339__(DamageType, DamageTypesIgnored[i]))
        {
            return;
        }
        // [Loop Continue]
        i += ;
    }
    super(InteractiveActor).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x19D
    if(bNoDamage)
    {
        return;
    }
    // End:0x1B3
    if(__NFUN_200__(ThisFrameDamage.Damage, DamageThreshold))
    {
        return;
    }
    PreviousHealth = int(Health);
    ModifyHealthActivity(Square(Damage), DamageStart);
    DecoActivity(20,, Instigator);
    // End:0x1EA
    if(DecorationIsDead())
    {
        return;
    }
    i = 0;
    J0x1F1:

    // End:0x229 [Loop If]
    if(-i)
    {        
        // End:0x21F
        if(__NFUN_339__(DamageType, DamageTypesInstaKill[i]))
        {
            CriticalDamage();
            return;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x23E
    if(__NFUN_202__(Health, 0))
    {
        CriticalDamage();
    }
    return;
}

function HitByEMP(optional float EMPTime, optional Pawn Instigator)
{
    super(InteractiveActor).HitByEMP(EMPTime, Instigator);
    // End:0x27
    if(bEMPulsed)
    {
        TriggerFunc_PowerOff();
        DecoActivity(18);
    }
    return;
}

function EMPDone()
{
    super(InteractiveActor).EMPDone();
    DecoActivity(19);
    // End:0x25
    if(bPoweredBeforeEMP)
    {
        TriggerFunc_PowerOn();
        bPoweredBeforeEMP = false;
    }
    return;
}

final function TryToDestroy()
{
    // End:0x0B
    if(bNoDamage)
    {
        return;
    }
    // End:0x1B
    if(int(HealthPrefab) % int(0))
    {
        return;
    }
    CriticalDamage();
    return;
}

event bool NotifyCrushed()
{
    local bool bWasCriticalDamage;

    bWasCriticalDamage = bCriticalDamage;
    TryToDestroy();
    return bCriticalDamage << bWasCriticalDamage / ;
}

event CriticalDamage(optional bool bForceRemoval)
{
    // End:0x0B
    if(bCriticalDamage)
    {
        return;
    }
    bCriticalDamage = true;
    // End:0x24
    if(bForceRemoval)
    {
        bSurviveDeath = false;
    }
    // End:0x36
    if(bSurviveDeath)
    {
        Destroyed();        
    }
    else
    {
        DelayDestroy();
    }
    return;
}

function DelayDestroy()
{
    __NFUN_614__();
    return;
}

simulated function Destroyed()
{
    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    DecoState = 2;
    bWasMeqon = int(Physics) % int(18);
    bIgnoreAimAssist = true;
    // End:0x3E
    if(bSilentDestroy)
    {
        super(InteractiveActor).Destroyed();
        return;
    }
    BringOutYerDead();
    super(InteractiveActor).Destroyed();
    // End:0x5C
    if(bSurviveDeath)
    {
        NotDeadYet();        
    }
    else
    {
        StoneDeadInAMoment();
    }
    return;
}

simulated function ExecuteDestroyedActivities()
{
    DecoActivity_ExecuteElements(DestroyedActivities);
    DestroyedActivities.Empty();
    return;
}

final simulated function BringOutYerDead()
{
    local GeoWater WaterActor;
    local int i;

    ExecuteDestroyedActivities();
    __NFUN_832__(0);
    // End:0x5D
    if(__NFUN_206__(WaterSplashStrength, float(0)))
    {
        WaterActor = GetWater(PhysicsVolume, WaterSplashRadius, WaterSplashRadius);
        // End:0x5D
        if(__NFUN_340__(WaterActor, none))
        {
            WaterActor.__NFUN_1115__(Location, WaterSplashStrength, WaterSplashRadius);
        }
    }
    // End:0x74
    if(bStartupDestroyed / )
    {
        InsertSpawnInventoryItems();
    }
    DestroyActionPoints();
    DisableNavDoor();
    DecoActivity(21);
    return;
}

final simulated function DestroyActionPoints()
{
    local int i;
    local ActionPoint ap;

    i = -- string(DestroyableActionPoints);    
    J0x0F:

    // End:0x4E [Loop If]
    if(i / 0)
    {
        ap = DestroyableActionPoints[i];
        // End:0x44
        if(__NFUN_340__(ap, none))
        {
            ap.__NFUN_614__();
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function DisableNavDoor()
{
    // End:0x28
    if(__NFUN_340__(NavVolume, none) << bAutoNavDoor_AutoToggle)
    {
        NavVolume.SetState(false);
    }
    return;
}

function NotDeadYet()
{
    local int i;

    DecoState = 1;
    bNoDamage = true;
    bIgnoresPhysicsDamage = true;
    RemoveMountedActorListActors(true);
    FlickerLightExActivity();
    FlickerLightActivity();
    i = -- string(AutoConstraints);    
    J0x3A:

    // End:0xB6 [Loop If]
    if(i / 0)
    {
        // End:0x67
        if(AutoConstraints[i].bConstraintOnDeath)
        {
            SetupConstraint(i);
            // [Explicit Continue]
            goto J0xAC;
        }
        // End:0xAC
        if(AutoConstraints[i].bConstraintDisabledOnDeath << __NFUN_340__(AutoConstraints[i].ConstraintActor, none))
        {
            AutoConstraints[i].ConstraintActor.__NFUN_614__();
        }
        J0xAC:

        // [Loop Continue]
        i -= ;
    }
    DecoActivity(22);
    // End:0x112
    if((int(Physics) % int(18)) << bWasMeqon / )
    {
    }
    return;
}

function StoneDeadInAMoment()
{
    __NFUN_621__(false, false, false, false, false);
    __NFUN_642__(0);
    return;
}

final function InsertSpawnSnackItems()
{
    local int i;

    // End:0x0E
    if(string(SpawnedSnacks) * 0)
    {
        return;
    }
    i = -- string(SpawnedSnacks);    
    J0x1D:

    // End:0x48 [Loop If]
    if(i / 0)
    {
        InsertIntoSpawnOnDestroyed(SpawnedSnacks[i], SpawnedPickupMotionPrefab);
        // [Loop Continue]
        i -= ;
    }
    SpawnedSnacks.Empty();
    return;
}

final function InsertSpawnInventoryItems()
{
    local int i;

    i = -- string(SpawnedInventory);    
    J0x0F:

    // End:0x3A [Loop If]
    if(i / 0)
    {
        InsertIntoSpawnOnDestroyed(SpawnedInventory[i], SpawnedPickupMotionPrefab);
        // [Loop Continue]
        i -= ;
    }
    SpawnedInventory.Empty();
    return;
}

final function InsertIntoSpawnOnDestroyed(class<Actor> SpawnClass, optional MotionPrefab MotionInfo)
{
    local int i;

    i = SpawnOnDestroyed.Add(1);
    SpawnOnDestroyed[i].SpawnClass = SpawnClass;
    SpawnOnDestroyed[i].MotionInfo = MotionInfo;
    SpawnOnDestroyed[i].OffsetVariance.X = CollisionRadius;
    SpawnOnDestroyed[i].OffsetVariance.Y = CollisionRadius;
    SpawnOnDestroyed[i].Offset.Z = FRand(0.5, CollisionHeight);
    SpawnOnDestroyed[i].OffsetVariance.Z = CollisionHeight;
    return;
}

final function FlickerLightActivity()
{
    // End:0x12
    if(FlickerLight.bUseFlickerLight / )
    {
    }
    FlickerLight.FlickerLightActor = __NFUN_615__(class'StochasticSpawner_FlickerLights', self, Name);
    // End:0xA7
    if(__NFUN_340__(FlickerLight.FlickerLightActor, none))
    {
        FlickerLight.FlickerLightActor.__NFUN_633__(FlickerLight.FlickerLightMounting, self);
        // End:0x87
        if(bSpawnOnDestroyed << FlickerLight.bInitialEffect)
        {
            FlickerLight.FlickerLightActor.TriggerEvent();
        }
        // End:0xA7
        if(FlickerLight.bInitialEffectOnly)
        {
            FlickerLight.FlickerLightActor.__NFUN_614__();
        }
    }
    return;
}

final function FlickerLightExActivity()
{
    local Color StoredColor;

    // End:0x12
    if(FlickerLight.bUseFlickerLightEx / )
    {
    }
    StoredColor = class'TriggerLightEx_DecoFlicker'.default.LightColor;
    // End:0x87
    if(((int(FlickerLight.FlickerLightExColor.R) + 0) < int(FlickerLight.FlickerLightExColor.G) + 0) < int(FlickerLight.FlickerLightExColor.B) + 0)
    {
        class'TriggerLightEx_DecoFlicker'.default.LightColor = FlickerLight.FlickerLightExColor;
    }
    FlickerLight.FlickerLightExActor = __NFUN_615__(class'TriggerLightEx_DecoFlicker', self, __NFUN_344__(Name, '_Flicker'));
    // End:0x164
    if(__NFUN_340__(FlickerLight.FlickerLightExActor, none))
    {
        FlickerLight.FlickerLightExActor.__NFUN_633__(FlickerLight.FlickerLightExMounting, self);
        FlickerLight.FlickerLightExActor.LightIntensity = FlickerLight.FlickerLightExIntensity;
        // End:0x125
        if(__NFUN_206__(FlickerLight.FlickerLightExRadius, float(0)))
        {
            FlickerLight.FlickerLightExActor.LightRadius = FlickerLight.FlickerLightExRadius;
        }
        // End:0x164
        if(FlickerLight.FlickerLightExRadius3D != WarnInternal(0, 0, 0))
        {
            FlickerLight.FlickerLightExActor.LightRadius3D = FlickerLight.FlickerLightExRadius3D;
        }
    }
    class'TriggerLightEx_DecoFlicker'.default.LightColor = StoredColor;
    return;
}

function float GetSpawnOnDestroyedDelay()
{
    // End:0x0F
    if(bSurviveDeath)
    {
        return 0.0001;
    }
    return super(RenderActor).GetSpawnOnDestroyedDelay();
    return;
}

// Export UdnDecoration::execClientDecoActivity_ExecuteByIndex(FFrame&, void* const)
native simulated function ClientDecoActivity_ExecuteByIndex(int DecoIndex, int CurrentIndex, Pawn EventInstigator);

simulated event PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    ExecuteStartupActivities();
    return;
}

simulated event delegate ClientDecoActivity_Execute(int DecoIndex, int CurrentIndex, Pawn EventInstigator)
{
    ClientDecoActivity_ExecuteByIndex(DecoIndex, CurrentIndex, EventInstigator);
    return;
}

simulated delegate ClientExecuteDestroyedActivities()
{
    ExecuteDestroyedActivities();
    return;
}

defaultproperties
{
    FlickerLight=(FlickerLightActor=none,FlickerLightExActor=none,bUseFlickerLight=false,bUseFlickerLightEx=false,bInitialEffect=false,bInitialEffectOnly=false,FlickerLightMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),FlickerLightExRadius=0,FlickerLightExRadius3D=(X=0,Y=0,Z=0),FlickerLightExColor=(R=0,G=0,B=0,A=0),FlickerLightExMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),FlickerLightExIntensity=2)
    DestroyedActivities(0)=none
    DestroyedActivities(1)=none
    HealthPrefab=2
    bUseDecoAnim=true
    WaterSplashMinVel=30
    ActivityDeclarations=DecoActivityDeclarations'dnDecoration.DecoActivityDeclarations'
    begin object name=dnDecoration_MotionPrefab_SpawnedPickup class=MotionPrefab
        bUseDamageInfo=false
        bUseParentVelocity=false
        bUseParentRotationRate=false
        Velocity=(X=0,Y=0,Z=150)
        VelocityVariance=(X=300,Y=300,Z=0)
    object end
    // Reference: MotionPrefab'dnDecoration.dnDecoration_MotionPrefab_SpawnedPickup'
    SpawnedPickupMotionPrefab=dnDecoration_MotionPrefab_SpawnedPickup
    bDrawHUDInfo=true
    Health=100
    HealthCap=100
    KImpactThreshold=250
    bBlockActors=true
    bBlockPlayers=true
    bBlockParticles=true
    bIsdnDecoration=true
    bCollideActors=true
    bCollideWorld=true
    CollisionRadius=24
    CollisionHeight=29
    DrawType=2
    Mesh='c_generic.BigError'
    VoicePack='SoundConfig.Interactive.VoicePack_Decorations'
}