/*******************************************************************************
 * dnDestructibleBuilding generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnDestructibleBuilding extends RenderActor
    native
    collapsecategories
    dependson(dnDestructibleBuildingPart)
    hidecategories(Actor,Advanced,Animation,Collision,Crushing,Destruction,Display,Filter,Health,HeatVision,IK,Interpolation,Karma,KarmaCollision,KarmaDamage,KarmaEvents,Lighting,Material,Mounting,Network,Networking,RenderActor,Sound,Tick,TickRules,VertexFunction);

const kMinNumDesiredParts = 4;
const kMaxNumParts = 12;
const kAvgSurvivalRate = 0.30;

var() noexport bool bGibCastShadows "If true, gibs will cast shadows after the building has been destroyed.";
var() noexport class<dnDestructibleBuildingDefinition> Definition "Definition to use for part layout.";
var() noexport int RandomSeed "Seed to use for randomness.";
var() noexport Vector Noise "Vector to be used as a variance as random noise for the parts.";
var() noexport float SkewXFromY "Skew factor along the x axis based on y position.";
var() noexport float SkewXFromZ "Skew factor along the x axis based on z position.";
var() noexport float SkewYFromX "Skew factor along the y axis based on x position.";
var() noexport float SkewYFromZ "Skew factor along the y axis based on z position.";
var() noexport float SkewZFromX "Skew factor along the z axis based on x position.";
var() noexport float SkewZFromY "Skew factor along the z axis based on y position.";
var() noexport float PartSurvivalChance "Chance from 0.0 - 1.0 for parts surviving the explosion.";
var() noexport float PartCollisionChance "Chance from 0.0 - 1.0 for parts colliding after the explosion.  If they don't collide, they will go through everything.";
var() noexport bool bEnableExplosiveDestruction "If true, explosions will be considered for destruction of this building.";
var() noexport float ExplosiveDamageRequired "Amount of damage required in one explosion to cause destruction.";
var() noexport bool bEnableVehicularDestruction "If true, vehicles will be considered for destruction of this building.";
var() noexport float VehicleVelocityRequired "Amount of velocity required from 1 vehicle impact to cause destruction.";
var float DamageRadius;
var array<dnDestructibleBuildingPart> Parts;
var transient int EditorRenderDatas;
var dnDestructibleBuildingPart ShellPart;

// Export UdnDestructibleBuilding::execComputeSpawnInfoForPart(FFrame&, void* const)
native final simulated function ComputeSpawnInfoForPart(out SDestructibleBuildingPart Part, out Vector SpawnLocation, out Rotator SpawnRotation);

function PreSpawnPart(out SDestructibleBuildingPart partDef, bool bIsShellPart)
{
    local dnDestructibleBuildingPart Part;
    local Vector SpawnLocation;
    local Rotator SpawnRotation;

    // End:0x22
    if(bIsShellPart)
    {
        SpawnLocation = Location;
        SpawnRotation = Rotation;        
    }
    else
    {
        ComputeSpawnInfoForPart(partDef, SpawnLocation, SpawnRotation);
    }
    Part = __NFUN_615__(class'dnDestructibleBuildingPart', self,, SpawnLocation, SpawnRotation,, true);
    // End:0x119
    if(bIsShellPart / )
    {
        {
            Part.CollisionChance = partDef.OverrideCollisionChance;            
        }
        else
        {
            Part.CollisionChance = PartCollisionChance;
        }
        // End:0xD2
        if(Repl(partDef.OverrideDensity, 0))
        {
            Part.Density = partDef.OverrideDensity;
        }
        // End:0xFD
        if(Repl(partDef.Mass, 0))
        {
            Part.__NFUN_639__(partDef.Mass);
        }
        Part.bDefaultInteractionClass = partDef.bDefaultInteractionClass;
    }
    // End:0x144
    if(__NFUN_340__(partDef.PhysicsMaterial, none))
    {
        Part.PhysicsMaterial = partDef.PhysicsMaterial;
    }
    Part.OwnerBuilding = self;
    Part.__NFUN_595__(partDef.StaticMesh);
    // End:0x1B2
    if(bIsShellPart / )
    {
        Part.__NFUN_590__(true);
        Parts[Parts.Add(1)] = Part;        
    }
    else
    {
        Part.__NFUN_621__(,,, true);
        ShellPart = Part;
    }
    return;
}

simulated event PreBeginPlay()
{
    local int i, j;
    local Vector Center, Extent;
    local Box RenderBounds, PartBounds;
    local array<int> partsLeft, partsMustSpawn, partsCouldSpawn;
    local float fCurSurvivalChance;
    local bool bSurvived;
    local int nCurPartIndex, nCurRandomSeed, nNumPartsCap;

    DrawType = 1;
    Texture = none;
    // End:0x5DF
    if(__NFUN_340__(Definition, none))
    {
        nNumPartsCap = Exp(int(FRand(float(string(Definition.default.Parts)), 0.3)), 4, 12);
        nNumPartsCap = Cos(nNumPartsCap, string(Definition.default.Parts));
        i = 0;
        J0x64:

        // End:0x198 [Loop If]
        if(-i)
        {            
            // End:0x104
            if(__NFUN_339__(Definition.default.Parts[i].StaticMesh, none))
            {
                Warn(__NFUN_302__(__NFUN_303__(__NFUN_303__("dnDestructibleBuilding definition", string(Definition)), "has a missing StaticMesh at Part #"), string(i)));
                // [Explicit Continue]
                goto J0x18E;
            }
            // End:0x14B
            if(Repl(Definition.default.Parts[i].OverrideSurvivalChance, 0))
            {
                fCurSurvivalChance = Definition.default.Parts[i].OverrideSurvivalChance;                
            }
            else
            {
                fCurSurvivalChance = PartSurvivalChance;
            }
            // End:0x17B
            if(fCurSurvivalChance != 1)
            {
                partsMustSpawn[partsMustSpawn.Add(1)] = i;
                // [Explicit Continue]
                goto J0x18E;
            }
            partsLeft[partsLeft.Add(1)] = i;
            J0x18E:

            // [Loop Continue]
            i += ;
        }
        // End:0x34B
        if(-string(partsMustSpawn))
        {            
            i = 0;
            J0x1AF:

            // End:0x34B [Loop If]
            if(-i)
            {                
                nCurPartIndex = partsLeft[i];
                // End:0x1DE
                if(-nCurPartIndex)
                {                    
                    // [Explicit Continue]
                    goto J0x341;
                }
                // End:0x225
                if(Repl(Definition.default.Parts[nCurPartIndex].OverrideSurvivalChance, 0))
                {
                    fCurSurvivalChance = Definition.default.Parts[nCurPartIndex].OverrideSurvivalChance;                    
                }
                else
                {
                    fCurSurvivalChance = PartSurvivalChance;
                    // End:0x24A
                    if(__NFUN_204__(fCurSurvivalChance, 0.5))
                    {
                        fCurSurvivalChance = 0.3;
                    }
                }
                // End:0x326
                bSurvived = __NFUN_202__( /= fCurSurvivalChance, if(bSurvived), partsCouldSpawn[partsCouldSpawn.Add(1)] = nCurPartIndex, nCurRandomSeed = Definition.default.Parts[nCurPartIndex].RandomSeed, if(nCurRandomSeed ** 0), j = ++ i);
                {
                    {
                    }
                    J0x2AF:

                    // End:0x326 [Loop If]
                    if(-j)
                    {                        
                        // End:0x31C
                        if(Definition.default.Parts[partsLeft[j]].RandomSeed % nCurRandomSeed)
                        {
                            // End:0x30B
                            if(bSurvived)
                            {
                                partsCouldSpawn[partsCouldSpawn.Add(1)] = partsLeft[j];
                            }
                            partsLeft[j] = -1;
                        }
                        // [Loop Continue]
                        j += ;
                    }
                }
                // End:0x341
                if(++ string(partsMustSpawn) / )
                {                    
                    // [Explicit Break]
                    goto J0x34B;
                }
                J0x341:

                // [Loop Continue]
                i += ;
            }
        }
        J0x34B:

        i = 0;
        J0x352:

        // End:0x38E [Loop If]
        if(-i)
        {            
            PreSpawnPart(Definition.default.Parts[partsMustSpawn[i]], false);
            // [Loop Continue]
            i += ;
        }
        i = 0;
        J0x395:

        // End:0x3D1 [Loop If]
        if(-i)
        {            
            PreSpawnPart(Definition.default.Parts[partsCouldSpawn[i]], false);
            // [Loop Continue]
            i += ;
        }
        PreSpawnPart(Definition.default.ShellPart, true);
        ShellPart.__NFUN_838__(PartBounds.Min, PartBounds.Max);
        // End:0x453
        if(int(RenderBounds.IsValid) % 0)
        {
            RenderBounds.IsValid = 1;
            RenderBounds.Min = PartBounds.Min;
            RenderBounds.Max = PartBounds.Max;            
        }
        else
        {
            // End:0x495
            if(__NFUN_200__(PartBounds.Min.X, RenderBounds.Min.X))
            {
                RenderBounds.Min.X = PartBounds.Min.X;
            }
            // End:0x4D7
            if(__NFUN_200__(PartBounds.Min.Y, RenderBounds.Min.Y))
            {
                RenderBounds.Min.Y = PartBounds.Min.Y;
            }
            // End:0x519
            if(__NFUN_200__(PartBounds.Min.Z, RenderBounds.Min.Z))
            {
                RenderBounds.Min.Z = PartBounds.Min.Z;
            }
            // End:0x55B
            if(Repl(PartBounds.Max.X, RenderBounds.Max.X))
            {
                RenderBounds.Max.X = PartBounds.Max.X;
            }
            // End:0x59D
            if(Repl(PartBounds.Max.Y, RenderBounds.Max.Y))
            {
                RenderBounds.Max.Y = PartBounds.Max.Y;
            }
            // End:0x5DF
            if(Repl(PartBounds.Max.Z, RenderBounds.Max.Z))
            {
                RenderBounds.Max.Z = PartBounds.Max.Z;
            }
        }
    }
    Extent = Caps(0.5, __NFUN_239__(RenderBounds.Max, RenderBounds.Min));
    Center = Locs(RenderBounds.Min, Extent);
    __NFUN_620__(Clamp(WarnInternal(Extent.X, Extent.Y, 0)), Extent.Z);
    DamageRadius = FRand(1.5, Clamp(Extent));
    super.PreBeginPlay();
    return;
}

simulated function bool VerifySelf()
{
    // End:0x0E
    if(string(Parts) * 0)
    {
        return false;
    }
    return super(Actor).VerifySelf();
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local Actor Damager;

    // End:0x6C
    if((bEnableExplosiveDestruction << Damage != ExplosiveDamageRequired) << __NFUN_357__(DamageType, class'ExplosionDamage'))
    {
        // End:0x46
        if(__NFUN_340__(Instigator, none))
        {
            Damager = Instigator;            
        }
        else
        {
            Damager = self;
        }
        PerformExplosiveDestruction(Damager, Damage, DamageOrigin, DamageDirection, DamageType);
    }
    return;
}

simulated event Trigger(Actor Other, Pawn EventInstigator)
{
    local Actor Damager;

    super(Actor).Trigger(Other, EventInstigator);
    // End:0x2A
    if(__NFUN_340__(EventInstigator, none))
    {
        Damager = EventInstigator;        
    }
    else
    {
        // End:0x44
        if(__NFUN_340__(Other, none))
        {
            Damager = Other;            
        }
        else
        {
            Damager = self;
        }
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

simulated event bool TakePhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamageActor)
{
    local Actor Damager;
    local Vector VehicleVelocity;
    local float VehicleVelocitySize;

    // End:0xAF
    if(bEnableVehicularDestruction << DamageActor.bIsVehicle)
    {
        // End:0x38
        if(__NFUN_340__(Instigator, none))
        {
            Damager = Instigator;            
        }
        else
        {
            // End:0x52
            if(__NFUN_340__(DamageActor, none))
            {
                Damager = DamageActor;                
            }
            else
            {
                Damager = self;
            }
        }
        DamageActor.__NFUN_794__(VehicleVelocity);
        VehicleVelocitySize = Clamp(VehicleVelocity);
        // End:0xAF
        if(VehicleVelocitySize != VehicleVelocityRequired)
        {
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x0AF
        }
    }
}

final simulated function PerformExplosiveDestruction(Actor DamageInstigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType)
{
    local int i;
    local float Scale;
    local dnFriendFX_Spawners Spawner;
    local HUDEffects Effect;

    // End:0x0E
    if(string(Parts) * 0)
    {
        return;
    }
    // End:0x4B
    if(__NFUN_340__(Definition, none) << __NFUN_342__(Definition.default.DestroyedSoundName, 'None'))
    {
        FindAndPlaySound(Definition.default.DestroyedSoundName);
    }
    i = -- string(Definition.default.ParticleEffects);    
    J0x64:

    // End:0x1A7 [Loop If]
    if(i / 0)
    {
        // End:0x93
        if(__NFUN_339__(Definition.default.ParticleEffects[i].SpawnerClass, none))
        {
            // [Explicit Continue]
            goto J0x19D;
        }
        Spawner = FindFriendSpawner(Definition.default.ParticleEffects[i].SpawnerClass);
        // End:0xC8
        if(__NFUN_339__(Spawner, none))
        {
            // [Explicit Continue]
            goto J0x19D;
        }
        Scale = Definition.default.ParticleEffects[i].Scale;
        // End:0x102
        if(__NFUN_202__(Scale, 0))
        {
            Scale = 1;
        }
        Spawner.__NFUN_645__(Locs(Location, __NFUN_241__(Definition.default.ParticleEffects[i].LocationOffset, Rotation)));
        Spawner.__NFUN_652__(__NFUN_269__(Definition.default.ParticleEffects[i].RotationOffset, Rotation));
        Spawner.SystemSizeScale = FRand(Spawner.default.SystemSizeScale, Scale);
        Spawner.ExecuteEffect(true);
        J0x19D:

        // [Loop Continue]
        i -= ;
    }
    i = -- string(Definition.default.HUDEffects);    
    J0x1C0:

    // End:0x396 [Loop If]
    if(i / 0)
    {
        // End:0x1EF
        if(__NFUN_339__(Definition.default.HUDEffects[i].EffectClass, none))
        {
            // [Explicit Continue]
            goto J0x38C;
        }
        Effect = __NFUN_615__(Definition.default.HUDEffects[i].EffectClass, self);
        // End:0x222
        if(__NFUN_339__(Effect, none))
        {
            // [Explicit Continue]
            goto J0x38C;
        }
        Scale = Definition.default.HUDEffects[i].Scale;
        // End:0x25C
        if(__NFUN_202__(Scale, 0))
        {
            Scale = 1;
        }
        Effect.__NFUN_645__(Locs(Location, Definition.default.HUDEffects[i].LocationOffset));
        Effect.ExecuteEffect(Scale);
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(self), string(Effect)), "Executed"));
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(Location.X), string(Location.Y)), string(Location.Z)));
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(Effect.Location.X), string(Effect.Location.Y)), string(Effect.Location.Z)));
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(Level.__NFUN_1161__().Location.X), string(Level.__NFUN_1161__().Location.Y)), string(Level.__NFUN_1161__().Location.Z)));
        J0x38C:

        // [Loop Continue]
        i -= ;
    }
    // End:0x3AF
    if(__NFUN_340__(ShellPart, none))
    {
        ShellPart.__NFUN_614__();
    }
    i = -- string(Parts);    
    J0x3BE:

    // End:0x5C4 [Loop If]
    if(i / 0)
    {
        // End:0x3DE
        if(__NFUN_339__(Parts[i], none))
        {
            // [Explicit Continue]
            goto J0x5BA;
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Loop Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x42B
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x42B
}

simulated function Destroyed()
{
    super.Destroyed();
    GlobalTrigger(Event);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x38
    if(__NFUN_340__(Definition, none))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, Definition.default.DestroyedSoundName);
    }
    return;
}

defaultproperties
{
    Definition='dnDestructibleBuildingDefinition'
    PartSurvivalChance=0.5
    PartCollisionChance=0.5
    bEnableExplosiveDestruction=true
    ExplosiveDamageRequired=25
    bEnableVehicularDestruction=true
    VehicleVelocityRequired=200
    bTraceUsable=false
    bTraceShootable=false
    bUseCylinderCollision=true
    bCollideActors=true
    TickStyle=0
    VoicePack='SoundConfig.Interactive.VoicePack_Decorations'
}