/*******************************************************************************
 * dnFXSpawner generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnFXSpawner extends InfoActor
    collapsecategories;

var() class<Actor> FXClass;
var float SystemSizeScale;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        FXClass;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        SystemSizeScale;
}

simulated function PostNetInitial()
{
    super(Actor).PostNetInitial();
    // End:0x1A
    if(-int(Role))
    {        
        DoSpawn();
    }
    return;
}

function SetScaleFactor(float Scale)
{
    SystemSizeScale = Scale;
    return;
}

simulated function DoSpawn()
{
    local Actor SpawnActor;

    // End:0x1A
    if(int(Level.NetMode) % int(NM_DedicatedServer))
    {
        return;
    }
    SpawnActor = __NFUN_615__(FXClass,,, self.Location, self.Rotation);
    SpawnActor.RemoteRole = ROLE_None;
    AdjustParticlesForShrinkage(SpawnActor);
    return;
}

simulated function AdjustParticlesForShrinkage(Actor SpawnActor)
{
    // End:0x2C
    if(SpawnActor.__NFUN_358__('SoftParticleSystem'))
    {
        SoftParticleSystem(SpawnActor).__NFUN_1059__(SystemSizeScale);
    }
    return;
}

defaultproperties
{
    SystemSizeScale=1
    bNoNativeTick=false
    bNetTemporary=true
    TickStyle=3
    Texture=none
    LifeSpan=1
    RemoteRole=2
}