/*******************************************************************************
 * dnFlybyPlane_Fighter_AttackBeam generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnFlybyPlane_Fighter_AttackBeam extends BeamSystem
    collapsecategories
    hidecategories(Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Lighting,Networking,ParticleSystemBase,ParticleTextureInfo,SoftParticleSystem,Sound,SpawnOnDestroyed);

var SoftParticleSystem SparkSystem;
var float DamagePlayer;
var float DamageNonPlayer;

simulated function PostVerifySelf()
{
    local Actor A;

    // End:0x14
    if(-string(BeamSegments))
    {        
        string(BeamSegments) = 1;
    }
    BeamSegments[0].Actor1 = self;
    super(RenderActor).PostVerifySelf();
    __NFUN_361__('Tick');
    SparkSystem = SoftParticleSystem(FindMountedActor(, class'SoftParticleSystem'));
    // End:0x8C
    if(__NFUN_340__(SparkSystem, none))
    {
        SparkSystem.Enabled = false;
        SparkSystem.SpawnOnGroundLength = DynamicBeamPoints;
        SparkSystem.bCanExistOutOfWorld = true;
    }
    return;
}

function Tick(float DeltaSeconds)
{
    super.Tick(DeltaSeconds);
    return;
}

final function ActivateBeam()
{
    Enabled = true;
    __NFUN_621__(true);
    FindAndPlaySound('FlyByPlane_Fighter_AltFire');
    // End:0x35
    if(__NFUN_340__(SparkSystem, none))
    {
        SparkSystem.Enabled = true;
    }
    return;
}

final function DeactivateBeam()
{
    Enabled = false;
    __NFUN_621__(false);
    FindAndStopSound('FlyByPlane_Fighter_AltFire');
    // End:0x35
    if(__NFUN_340__(SparkSystem, none))
    {
        SparkSystem.Enabled = false;
    }
    return;
}

event Touch(Actor Other)
{
    local float dmg;

    super(Actor).Touch(Other);
    // End:0x2C
    if(Other.bIsPlayerPawn)
    {
        dmg = DamagePlayer;        
    }
    else
    {
        dmg = DamageNonPlayer;
    }
    Other.TakeDamage(none, dmg, Other.Location, WarnInternal(0, 0, 1), class'ExplosionDamage');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FlyByPlane_Fighter_AltFire');
    return;
}

defaultproperties
{
    Enabled=false
    DynamicBeamPoints=100024
    BeamTexture='dt_Effects2.Beams.BlueBeam_FB'
    BeamSegments(0)=(Lifetime=999999,Actor1=none,Actor2=none,Location1=(X=0,Y=0,Z=0),Location2=(X=0,Y=0,Z=0),bNonActor1=false,bNonActor2=true,Actor1Bone=None,Actor2Bone=None)
    BeamType=0
    bBeamOnlyCheckDynamicShootable=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.Alien_Fighter_Attack.Alien_Fighter_Attack_Melt',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=100,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Physics=9
    bTraceShootable=false
    bCanExistOutOfWorld=true
    bDumbMesh=false
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    CollisionRadius=100
    CollisionHeight=2000
    TouchClasses(0)='dnDecoration'
    TouchClasses(1)='Engine.BaseAI'
    TickStyle=3
    Style=6
    VoicePack='SoundConfig.Vehicles.VoicePack_AlienFighter'
}