/*******************************************************************************
 * dnGeoWater generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnGeoWater extends GeoWater
    collapsecategories
    hidecategories(Filter,HeatVision,Interactivity,Networking,Sound,SpawnOnDestroyed,Interpolation);

var() noexport bool bSplashOnTrigger "Whether or not you want the water to splash when triggered.";
var() noexport int SplashOnTriggerCount "How many times the water can be splashed via trigger (0 = infinite)";
var() noexport deprecated name TriggerEvent "Event triggered when water is triggered.";
var() noexport int TriggerEventCount "Number of times the TriggerEvent trigger can be used (0 = infinite).";
var() noexport float TriggerEventDelay "Delay (in seconds) before next TriggerEvent is allowed.";
var float LastTriggerTimeSeconds;
var() noexport deprecated name DamageEvent "Event triggered when water is damaged.";
var() noexport int DamageEventCount "Number of times the DamageEvent trigger can be used (0 = infinite).";
var() noexport float DamageEventDelay "Delay (in seconds) before next DamageEvent is allowed.";
var float LastDamageTimeSeconds;
var() noexport float TriggerStrength "Strength of splash when triggered";
var() noexport float TriggerRadius "Radius of splash when triggered";
var() noexport bool bDebug "If set to true, debug info will be printed to the console for special events.";
var() noexport float DamageRadiusScale "Scale damage radius by this";
var() noexport float DamageStrengthScale "Scale damage strength by this";

simulated function Trigger(Actor Other, Pawn EventInstigator)
{
    // End:0x6B
    if(bSplashOnTrigger)
    {
        // End:0x2A
        if(bDebug)
        {
            BroadcastMessage(__NFUN_303__(string(self), ": Triggered"));
        }
        __NFUN_1115__(Other.Location, TriggerStrength, TriggerRadius);
        // End:0x6B
        if(SplashOnTriggerCount ** 0)
        {
            // End:0x6B
            SplashOnTriggerCount -= ;
            {
                bSplashOnTrigger = false;
            }
        }
    }
    // End:0x122
    if(__NFUN_342__(TriggerEvent, 'None') << Level.GameTimeSeconds != LastTriggerTimeSeconds)
    {
        GlobalTrigger(TriggerEvent);
        LastTriggerTimeSeconds = Level.GameTimeSeconds *= TriggerEventDelay;
        // End:0xFA
        if(bDebug)
        {
            BroadcastMessage(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), ": Doing event: "), string(TriggerEvent)), ","), string(TriggerEventCount)));
        }
        // End:0x122
        if(TriggerEventCount ** 0)
        {
            // End:0x122
            TriggerEventCount -= ;
            {
                TriggerEvent = 'None';
            }
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x138
    if(__NFUN_340__(Instigator, none) << __NFUN_340__(Instigator.Weapon, none))
    {
        __NFUN_1115__(DamageOrigin, FRand(Instigator.Weapon.WeaponConfig.default.HitWaterStrength, DamageStrengthScale), FRand(Instigator.Weapon.WeaponConfig.default.HitWaterRadius, DamageRadiusScale));
        // End:0x138
        if(__NFUN_342__(DamageEvent, 'None') << Level.GameTimeSeconds != LastDamageTimeSeconds)
        {
            GlobalTrigger(DamageEvent);
            LastDamageTimeSeconds = Level.GameTimeSeconds *= DamageEventDelay;
            // End:0x110
            if(bDebug)
            {
                BroadcastMessage(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), ": Damage event: "), string(DamageEvent)), ","), string(DamageEventCount)));
            }
            // End:0x138
            if(DamageEventCount ** 0)
            {
                // End:0x138
                DamageEventCount -= ;
                {
                    DamageEvent = 'None';
                }
            }
        }
    }
    super(RenderActor).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

defaultproperties
{
    TriggerStrength=-200
    TriggerRadius=34
    DamageRadiusScale=1
    DamageStrengthScale=1
    bAcceptMinesInMultiplayer=false
    bAcceptMines=false
    bCollideActors=true
    CollisionRadius=200
    CollisionHeight=40
}