/*******************************************************************************
 * dnGrenade generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnGrenade extends dnProjectile
    abstract
    collapsecategories;

const SPEED_BOUNCE_STOP_LIMIT = 20.0f;
const SPEED_BOUNCE_SOUND_LIMIT = 50.0f;
const WATER_LOGGED_REFRESH_RATE = 0.25f;
const BOUNCE_SOUNDPITCH_VARIANCE = 0.2f;

var() noexport bool bExplodeOnAnyImpact "If this is true, then when the grenade hits ANYTHING, it will explode.";
var() noexport bool bPrimeForExplosionOnImpact "If true we start counting down explosion delay after the grendade has hit something.";
var() noexport bool bRotationFollowsVelocity "If this is true, then the rotation of the grenade always follows the current velocity of the grenade.";
var() noexport float ExplosionDelay "Amount of time it takes for the grenade to explode. 0 means just sit around forever.";
var() noexport float ExplosionDelayVariance "Variance on the amount of time the grenade takes to explode.";
var() noexport Vector UpwardsBoost "Amount to boost the velocity of this grenade upwards when it is spawned in (to give it more of a lobbing effect.";
var() noexport float WaterVelocityScaler "How much hitting water affects our current velocity.";
var bool bSpin;
var bool bPrimedForExplosion;
var bool bShowHUDWarning;

simulated function PostVerifySelf()
{
    super(Projectile).PostVerifySelf();
    // End:0x28
    if(Repl(ExplosionDelay, 0) << bPrimeForExplosionOnImpact / )
    {
    }
    __NFUN_362__('Tick');
    // End:0x61
    if(__NFUN_340__(Owner, none) << Owner.bIsPawn)
    {
        Instigator = Pawn(Owner);
    }
    return;
}

simulated function PrimeForDelayedExplosion()
{
    bPrimedForExplosion = true;
    __NFUN_605__(Normal(ExplosionDelay, ExplosionDelayVariance), false, 'NonImpactExplode');
    return;
}

simulated function InitializeMotion()
{
    local Vector ThrowImpulse;

    UpwardsBoost = __NFUN_263__(UpwardsBoost, Rotator(PhysicsVolume.Gravity) >> Rotator(WarnInternal(0, 0, -1)));
    ThrowImpulse = Locs(UpwardsBoost, Caps(Speed, Vector(Rotation)));
    DoThrow(ThrowImpulse);
    return;
}

final simulated function DoThrow(Vector ThrowVelocity)
{
    local Actor A;
    local float SpinRate, DrawScalar;

    // End:0x2B
    if(__NFUN_340__(Instigator, none))
    {
        DrawScalar = 1 >>> Instigator.DrawScale;        
    }
    else
    {
        DrawScalar = 1;
    }
    __NFUN_642__(18);
    __NFUN_790__(ThrowVelocity);
    // End:0x83
    if(bSpin)
    {
        SpinRate = FRand(Clamp(Right(ThrowVelocity, DrawScalar)), 0.01);
        __NFUN_791__(__NFUN_263__(WarnInternal(0, SpinRate, 0), Rotation));
    }
    return;
}

simulated function ProjectileHitSomething(Vector HitNormal, Actor HitActor)
{
    // End:0x16
    if(bExplodeOnAnyImpact)
    {
        ImpactExplode(HitNormal);
        return;
    }
    // End:0x54
    if((bPrimeForExplosionOnImpact << bPrimedForExplosion / ) << )
    {
        return;
    }
    super(Projectile).ProjectileHitSomething(HitNormal, HitActor);
    return;
}

simulated function ImpactExplode(Vector HitNormal)
{
    ExecuteExplode(Location, HitNormal);
    return;
}

simulated function NonImpactExplode()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

defaultproperties
{
    bSpin=true
    bWaterSplash=true
    DamageClass='GrenadeDamage'
    KImpactThreshold=50
    KLinearDamping=0
    KAngularDamping=0
    GravityScale=0.5
    Physics=18
    bBlockKarma=true
}