/*******************************************************************************
 * dnHUDEffects generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnHUDEffects extends HUDEffects
    native
    collapsecategories;

cpptext
{
// Stripped
}

enum EFalloffStyle
{
    FALLOFF_None,
    FALLOFF_Linear,
    FALLOFF_Exponential
};

var(HUDFX_System) noexport bool bEnabled "This designates whether the system is currently spawning effects or not. Use the Trigger abilities to modify this in various ways.";
var(HUDFX_System) noexport bool bDestroyWhenEmpty "The actor will destroy itself when it goes from bEnabled=true to bEnabled=false.";
var(HUDFX_System) noexport bool bNoApplyUnderwater "This effect will not be applied for players that have their head underwater.";
var(HUDFX_System) noexport bool bIgnoreLimit "If true, this HUD effect will be added regardless of any HUD effect limits.";
var(HUDFX_System) noexport bool bAttachLocalPlayerPawn "If true, this HUD effect will be added directly to the local player pawn.";
var(HUDFX_System) noexport float EffectRadius "Radius to check for players to attach effects to. If less than or equal to 0, it will attach to all Players with tags matching our event. If no event is specified it auto attaches to all DukePlayers.";
var(HUDFX_System) noexport float EffectViewAngleFull "Angle the player is facing toward this actor to get the full number of effects. Value from 0 to 1, where 1 means the player has to be staring in an exact line towards this actor.";
var(HUDFX_System) noexport float EffectViewAngleNone "Angle the player is facing away from this actor to not get any effects (to simulate things spawning in behind them not hitting their eyes). Use the same values as EffectViewAngleFull.";
var(HUDFX_System) noexport float ExecuteThrottle "Enforce a delay between each call to ExecuteEffect.";
var(HUDFX_System) noexport dnHUDEffects.EFalloffStyle FalloffStyle "How fast effects should falloff based on how far away players are from this actor. The farther away they are, the fewer effects will hit their screen.";
var(HUDFX_System) noexport name EffectName "Name of the HUDEffect.  If none, will use the Name of this actor.";
var(HUDFX_Trigger) noexport name RestartTag "Call this to restart the entire system. Triggering the system itself will also start it. However, if it's already going, it will be ignored and only restart once spawning has stopped.";
var(HUDFX_Trigger) noexport name StopTag "Call this to force the system to stop creating effects.";
var(HUDFX_Trigger) noexport name RemoveTag "Call this to remove effects from all players who have effects created by us on their screen.";
var(HUDFX_Trigger) noexport float RemoveTime "Amount of time to fade out the effect from the player's screen. 0 means instant.";
var(HUDFX_Trigger) float RemoveTimeVariance;
var(HUDFX_Trigger) noexport name ToggleTag "Call this to toggle the system spawning abilities.";
var(HUDFX_Trigger) noexport name RefreshTag "Call this to refresh the system. This is only really useful when you have a SpawnDuration, and want to extend it again, but don't want to actually restart the entire system.";
var(HUDFX_Spawn) noexport int SpawnCount "How many individual effects to create. This number can be affected by both FalloffStyle and EffectViewAngle settings.";
var(HUDFX_Spawn) int SpawnCountVariance;
var(HUDFX_Spawn) noexport float SpawnDuration "When the system starts spawning, how long to continue spawning before automatically disabling itself. 0 means spawn forever.";
var(HUDFX_Spawn) float SpawnDurationVariance;
var(HUDFX_Spawn) noexport float SpawnPeriod "When spawning, how frequently to spawn effects. So if you have a Duration of 10 seconds, and a period of 2 seconds, you'll get an effect 5 times every two seconds.";
var(HUDFX_Spawn) float SpawnPeriodVariance;
var(HUDFX_Spawn) noexport float Lifetime "How long each effect will stay on screen. A negative value means that once it reaches this time limit it will hold steady visually (motion will still occur). This is how you make something fade in and stay.";
var(HUDFX_Spawn) float LifetimeVariance;
var(HUDFX_Spawn) noexport float UnderwaterTimescale "Scale on ticking when owner player's head is underwater.";
var(HUDFX_Texture) noexport bool bFullScreen "This forces the effect to stretch across the entire screen.";
var(HUDFX_Texture) noexport bool bCenter "When typing in position information, use the center of the texture instead of the upper left corner.";
var(HUDFX_Texture) noexport bool bInverse "jhdvfljbsdfljhbdef";
var(HUDFX_Texture) noexport bool bMaintainAspectRatio "If bFullScreen is true, this flag will keep the original aspect ratio of the texture.  SmackerTexture and BinkTexture will use the dimensions of the source and not the actual texture res (unless they are the same).";
var(HUDFX_Texture) noexport bool bTiled "If bFullScreen is true, this flag will fit the dimensions by tiling instead of stretching the texture.";
var(HUDFX_Texture) noexport bool bFlipInMirrorMode "If true, this HUD effect's U component will be flipped in mirror mode.";
var(HUDFX_Texture) noexport array<MaterialEx> Textures "List of textures to pick from when applying effects.";
var(HUDFX_Alpha) noexport bool bUseAlphaRamp "Use the AlphaRamp ability of the system. This allows something to fade in, then back out, for example.";
var(HUDFX_Alpha) noexport bool bSharedAlphaVariance "When picking how much to vary the alpha values by, if this is true then it will do one variance (based off of AlphaStartVariance) and apply that to *all* alpha values.";
var(HUDFX_Alpha) noexport float AlphaStart "Alpha level when starting out. Value from 0 to 1.";
var(HUDFX_Alpha) float AlphaStartVariance;
var(HUDFX_Alpha) noexport float AlphaMid "Alpha level when effect reaches the middle of it's lifetime. Only valid when bUseAlphaRamp=true.";
var(HUDFX_Alpha) float AlphaMidVariance;
var(HUDFX_Alpha) noexport float AlphaEnd "Alpha level when the effect reaches the end of it's life.";
var(HUDFX_Alpha) float AlphaEndVariance;
var(HUDFX_Alpha) noexport float AlphaRampMid "Where in the lifetime to consider the 'middle'. Value from 0 to 1.";
var(HUDFX_Alpha) float AlphaRampMidVariance;
var(HUDFX_Scale) noexport float bUseViewportDims "Set this to true to size your effect based on the HUD dimensions instead of the texture dimensions.";
var(HUDFX_Scale) noexport float EffectDrawScale "DrawScale applied to the width and the height of the texture.";
var(HUDFX_Scale) float EffectDrawScaleVariance;
var(HUDFX_ScaleX) noexport bool bUseScaleXRamp "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleX) noexport bool bSharedScaleXVariance "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleX) noexport float ScaleXStart "Starting scale to apply to the X direction of the textures being used.";
var(HUDFX_ScaleX) float ScaleXStartVariance;
var(HUDFX_ScaleX) noexport float ScaleXMid "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleX) float ScaleXMidVariance;
var(HUDFX_ScaleX) noexport float ScaleXEnd "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleX) float ScaleXEndVariance;
var(HUDFX_ScaleX) noexport float ScaleXRampMid "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleX) float ScaleXRampMidVariance;
var(HUDFX_ScaleY) noexport bool bUseScaleYRamp "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleY) noexport bool bSharedScaleYVariance "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleY) noexport float ScaleYStart "Starting scale to apply to the Y direction of the textures being used.";
var(HUDFX_ScaleY) float ScaleYStartVariance;
var(HUDFX_ScaleY) noexport float ScaleYMid "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleY) float ScaleYMidVariance;
var(HUDFX_ScaleY) noexport float ScaleYEnd "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleY) float ScaleYEndVariance;
var(HUDFX_ScaleY) noexport float ScaleYRampMid "Exact same concept as the similar property in Alpha.";
var(HUDFX_ScaleY) float ScaleYRampMidVariance;
var(HUDFX_Rotation) noexport float RotationInitial "Starting rotation for the effect. This is a value from 0 to 6.18 (two * pi), where 3.14 = 180 degrees = 32768 Unreal units.";
var(HUDFX_Rotation) float RotationInitialVariance;
var(HUDFX_Rotation) noexport float RotationVelocity "How fast to rotate the effect. Same value range as RotationInitial.";
var(HUDFX_Rotation) float RotationVelocityVariance;
var(HUDFX_Rotation) noexport float RotationAcceleration "How fast to accelerate the effect. Same value range as RotationInitial.";
var(HUDFX_Rotation) float RotationAccelerationVariance;
var(HUDFX_Movement) noexport float LocationDepth "This allows you to provide a pseudo 3Dness to the effect. This is applied as +/- this much to both sides of the Z axis.";
var(HUDFX_Movement) noexport float LocationDepthScaleFar "How much to scale the effect by when it is farthest away from the player.";
var(HUDFX_Movement) noexport float LocationDepthScaleNear "How much to scale the effect by when it is nearest the player.";
var(HUDFX_Movement) noexport Vector LocationInitial "Initial position on screen." "X=Horizontal position (0 to 1024)" "Y=Vertical position (0 to 768)" "Z=Depth position (value from -LocationDepth to LocationDepth)";
var(HUDFX_Movement) Vector LocationInitialVariance;
var(HUDFX_Movement) noexport Vector VelocityInitial "How fast to move the effect around on the screen.";
var(HUDFX_Movement) Vector VelocityInitialVariance;
var(HUDFX_Movement) noexport Vector AccelerationInitial "How fast to accelerate the effect around on the screen.";
var(HUDFX_Movement) Vector AccelerationInitialVariance;
var bool bCanExecute;
var SHUDEffect Effect;
var const SHUDEffect CleanEffect;

function bool VerifySelf()
{
    local int i;

    i = -- string(Textures);    
    J0x0F:

    // End:0x42 [Loop If]
    if(i / 0)
    {
        // End:0x38
        if(__NFUN_339__(Textures[i], none))
        {
            Textures.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    EffectViewAngleFull = Normal2D(EffectViewAngleFull, 0, 1);
    EffectViewAngleNone = Normal2D(EffectViewAngleNone, 0, EffectViewAngleFull);
    return super(Actor).VerifySelf();
    return;
}

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    __NFUN_718__('Toggle', ToggleTag);
    __NFUN_718__('Stop', StopTag);
    __NFUN_718__('Restart', RestartTag);
    __NFUN_718__('Remove', RemoveTag);
    __NFUN_718__('Refresh', RefreshTag);
    // End:0x62
    if(__NFUN_341__(Event, 'None'))
    {
        Event = 'DukePlayer';
    }
    // End:0x7D
    if(__NFUN_341__(EffectName, 'None'))
    {
        EffectName = Name;
    }
    // End:0x8C
    if(bEnabled)
    {
        StartEffect();
    }
    return;
}

event Destroyed()
{
    local PlayerPawn Player;

    // End:0x33
    if(__NFUN_341__(EffectName, Name))
    {
        // End:0x32
        foreach __NFUN_747__(class'PlayerPawn', Player, Event, true)
        {
            ClearEffectName(Player);            
        }        
    }
    super(Actor).Destroyed();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    NormalEffect();
    return;
}

final function TriggerFunc_Toggle()
{
    ToggleEffect();
    return;
}

final function TriggerFunc_Stop()
{
    StopAlwaysEffect();
    return;
}

final function TriggerFunc_Restart()
{
    RestartEffect();
    return;
}

final function TriggerFunc_Remove()
{
    RemoveEffect();
    return;
}

final function TriggerFunc_Refresh()
{
    RefreshEffect();
    return;
}

function NormalEffect()
{
    // End:0x0B
    if(bEnabled)
    {
        return;
    }
    StartEffect();
    return;
}

function ToggleEffect()
{
    // End:0x12
    if(bEnabled)
    {
        StopEffect();        
    }
    else
    {
        StartEffect();
    }
    return;
}

function StopAlwaysEffect()
{
    // End:0x0D
    if(bEnabled / )
    {
    }
    StopEffect();
    return;
}

function RestartEffect()
{
    StopEffect();
    StartEffect();
    return;
}

function RemoveEffect()
{
    local PlayerPawn Player;

    // End:0x22
    foreach __NFUN_747__(class'PlayerPawn', Player, Event, true)
    {
        RemoveEffectFrom(Player);        
    }    
    return;
}

function RefreshEffect()
{
    // End:0x12
    if(bEnabled)
    {
        PrepareStopEffect();        
    }
    else
    {
        StartEffect();
    }
    return;
}

function StartEffect()
{
    bEnabled = true;
    EnableTicking();
    ExecuteEffect();
    PrepareStopEffect();
    return;
}

final function PrepareStopEffect()
{
    // End:0x27
    if(Repl(SpawnDuration, 0))
    {
        __NFUN_605__(Normal(SpawnDuration, SpawnDurationVariance), false, 'StopEffect');        
    }
    else
    {
        // End:0x3C
        if(__NFUN_204__(SpawnDuration, 0))
        {
            StopEffect();
        }
    }
    return;
}

final function StopEffect()
{
    bEnabled = false;
    DisableTicking();
    __NFUN_606__('ExecuteEffectCallback');
    __NFUN_606__('DisableEffect');
    // End:0x2A
    if(bDestroyWhenEmpty)
    {
        __NFUN_614__();
    }
    return;
}

final function CanExecute()
{
    bCanExecute = true;
    return;
}

final function ExecuteEffectCallback()
{
    ExecuteEffect();
    return;
}

event ExecuteEffect(optional float Scale)
{
    local PlayerPawn Player;
    local float ScaledEffectRadius;

    // End:0x1F
    if(bAttachLocalPlayerPawn)
    {
        AttachEffectTo(Level.__NFUN_1161__());        
    }
    else
    {
        ScaledEffectRadius = EffectRadius;
        // End:0x4B
        if(Repl(Scale, 0))
        {
            ScaledEffectRadius = FRand(ScaledEffectRadius, Scale);
        }
        // End:0x70
        if(Repl(ExecuteThrottle, 0))
        {
            bCanExecute = false;
            __NFUN_607__(ExecuteThrottle, false, 'CanExecute');
        }
        // End:0xA4
        if(Repl(ScaledEffectRadius, 0))
        {
            // End:0xA0
            foreach __NFUN_754__(class'PlayerPawn', Player, ScaledEffectRadius)
            {
                AttachEffectTo(Player);                
            }                        
        }
        else
        {
            // End:0xC6
            foreach __NFUN_747__(class'PlayerPawn', Player, Event, true)
            {
                AttachEffectTo(Player);                
            }            
        }
    }
    // End:0xEB
    if(Repl(SpawnPeriod, 0))
    {
        __NFUN_605__(Normal(SpawnPeriod, SpawnPeriodVariance), false, 'ExecuteEffectCallback');
    }
    return;
}

simulated function HUDEffectAdded(PlayerPawn Player)
{
    assert(false);
    return;
}

// Export UdnHUDEffects::execAttachEffectTo(FFrame&, void* const)
native final function AttachEffectTo(PlayerPawn Player);

simulated event InRangeCallback(PlayerPawn Player)
{
    return;
}

final function RemoveEffectFrom(PlayerPawn Player)
{
    local DukeHUD PlayerHUD;
    local int i;

    // End:0x0E
    if(__NFUN_339__(Player, none))
    {
        return;
    }
    PlayerHUD = DukeHUD(Player.MyHUD);
    // End:0x36
    if(__NFUN_339__(PlayerHUD, none))
    {
        return;
    }
    i = 0;
    J0x3D:

    // End:0x167 [Loop If]
    if(-i)
    {        
        // End:0x7F
        if(__NFUN_342__(PlayerHUD.HUDEffects[i].Name, EffectName))
        {
            // [Explicit Continue]
            goto J0x15D;
        }
        PlayerHUD.HUDEffects[i].Name = 'None';
        PlayerHUD.HUDEffects[i].AlphaStart = PlayerHUD.HUDEffects[i].Alpha;
        PlayerHUD.HUDEffects[i].AlphaEnd = 0;
        PlayerHUD.HUDEffects[i].bUseAlphaRamp = false;
        PlayerHUD.HUDEffects[i].MaxLife = float(Tan(0, int(Normal(RemoveTime, RemoveTimeVariance))));
        PlayerHUD.HUDEffects[i].Lifetime = 0;
        J0x15D:

        // [Loop Continue]
        i += ;
    }
    return;
}

final function ClearEffectName(PlayerPawn Player)
{
    local DukeHUD PlayerHUD;
    local int i;

    // End:0x0E
    if(__NFUN_339__(Player, none))
    {
        return;
    }
    PlayerHUD = DukeHUD(Player.MyHUD);
    // End:0x36
    if(__NFUN_339__(PlayerHUD, none))
    {
        return;
    }
    i = -- string(PlayerHUD.HUDEffects);    
    J0x4F:

    // End:0xA9 [Loop If]
    if(i / 0)
    {
        // End:0x9F
        if(__NFUN_341__(PlayerHUD.HUDEffects[i].Name, EffectName))
        {
            PlayerHUD.HUDEffects[i].Name = 'None';
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

final function EnableTicking()
{
    TickStyle = 2;
    // End:0x2A
    if(Repl(EffectRadius, 0))
    {
        bTickOnlyNearby = true;
        TickNearbyRadius = EffectRadius;
    }
    return;
}

final function DisableTicking()
{
    TickStyle = 0;
    return;
}

// Export UdnHUDEffects::execGetDistScale(FFrame&, void* const)
native final function float GetDistScale(PlayerPawn Player);

// Export UdnHUDEffects::execGetAngleScale(FFrame&, void* const)
native final function float GetAngleScale(PlayerPawn Player);

defaultproperties
{
    bNoApplyUnderwater=true
    bAttachLocalPlayerPawn=true
    SpawnCount=1
    Lifetime=2
    UnderwaterTimescale=4
    bCenter=true
    AlphaStart=1
    EffectDrawScale=1
    ScaleXStart=1
    ScaleYStart=1
    LocationDepthScaleNear=10
    LocationInitial=(X=480,Y=360,Z=0)
}