/*******************************************************************************
 * dnKingOfTheHill generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnKingOfTheHill extends dnDeathmatchGame_TeamDM
    config(Multiplayer)
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor);

var bool bForceSpectateOnJoin;
var float switchTime;
var() float minSwitchTime;
var() float maxSwitchTime;
var float targetSwitchTime;
var() int maxOwnage;
var float hillmovesoundwarningtime;
var bool bAlertedHillMove;
var bool bInitMarkers;
var array<dnKingOfTheHill_Marker> markers;
var float markerUpdateDelta;
var dnKingOfTheHill_Marker InitialHill;
var dnKingOfTheHill_Marker CurrentMarker;
var bool bUseInitialHill;
var bool bGameStarted;
var int LastControlled;
var float CheckAnnounceStep;
var bool bCanSwitch;
var bool bCountdownValidated;

function PostBeginPlay()
{
    super.PostBeginPlay();
    __NFUN_607__(CheckAnnounceStep, true, 'AnnounceHillChangeMaybe');
    return;
}

function AnnounceHillChangeMaybe()
{
    // End:0xA1
    if((CurrentMarker.Fresh + LastControlled) << Repl(Round(targetSwitchTime, switchTime), CheckAnnounceStep))
    {
        switch(CurrentMarker.Fresh)
        {
            // End:0x63
            case -1:
                Announcer.TriggerQueueAnnounce('Announce_ControlContest');
                // End:0xA1
                break;
            // End:0x7F
            case 0:
                Announcer.TriggerQueueAnnounce('Announce_Control_Blue');
                // End:0xA1
                break;
            // End:0x9B
            case 1:
                Announcer.TriggerQueueAnnounce('Announce_Control_Red');
                // End:0xA1
                break;
            // End:0xFFFF
            default:
                // End:0xA1
                break;
                break;
        }
    }
    LastControlled = CurrentMarker.Fresh;
    return;
}

function ScoreKill(Pawn Killer, Pawn Victim)
{
    BaseMutator.ScoreKill(Killer, Victim);
    // End:0x69
    if(__NFUN_340__(dnKotHPlayer(Victim), none) << dnKotHPlayer(Victim).Capturing)
    {
        dnKotHPlayer(Killer).PlayerProgress.Stat_HTTKKillerInCapturePoint(Victim);
    }
    return;
}

function RequestEndGame(string Reason)
{
    local int i;

    super(dnDeathmatchGame).RequestEndGame(Reason);
    J0x0B:

    // End:0x3C [Loop If]
    if(-i)
    {        
        markers[i].SetActive(false);
        // [Loop Continue]
        i += ;
    }
    return;
}

function ScorePoint(DukeMultiPlayer Scorer)
{
    local Pawn P;

    // End:0x23
    if((bEndOfGameRequest < bGameStarted / ) < )
    {
    }
    Teams[int(Scorer.PlayerReplicationInfo.Team)].Score += ;
    J0x64:

    // End:0xEE [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xD6
        if(__NFUN_340__(dnKotHPlayer(P), none) << int(dnKotHPlayer(P).PlayerReplicationInfo.Team) % int(Scorer.PlayerReplicationInfo.Team))
        {
            dnKotHPlayer(P).AlertSound();
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x64;
    }
    super.ScorePoint(Scorer);
    // End:0x158
    if((bOvertime / ) << )
    {
        {
            RequestEndGame("ownagelimit");
        }
    }
    return;
}

function GameEndWaitTimer()
{
    super(dnDeathmatchGame).GameEndWaitTimer();
    return;
}

event InitGame(string Options, out string Error)
{
    super.InitGame(Options, Error);
    GoalTeamScore = GetIntOption(Options, "CaptureTime", GoalTeamScore);
    InitMarkers();
    return;
}

function InitMarkers()
{
    local dnKingOfTheHill_Marker marker;

    // End:0x56
    if(bInitMarkers / )
    {
        {
            // End:0x39
            if(marker.bInitial)
            {
                InitialHill = marker;
            }
            markers[markers.Add(1)] = marker;            
        }/* !MISMATCHING REMOVE, tried ForEach got Type:If Position:0x000! */        
        bInitMarkers = true;
    }/* !MISMATCHING REMOVE, tried If got Type:ForEach Position:0x00B! */
    return;
}

function NoTimerUpdate()
{
    local int i;
    local dnKingOfTheHill_Projector Projector;

    bGameStarted = false;
    // End:0x132
    if(bUseInitialHill / )
    {
        J0x38:

        // End:0x9A [Loop If]
        if(-i)
        {            
            // End:0x78
            if(markers[i].bActive)
            {
                markers[i].SetActive(false);
            }
            markers[i].bHasBeenUsed = false;
            // [Loop Continue]
            i += ;
        }
        bCanSwitch = true;
        switchTime = default.switchTime;
        targetSwitchTime = default.targetSwitchTime;
        bUseInitialHill = true;
        bCountdownValidated = false;
        dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown = 0;
        dnKotHGameReplicationInfo(Level.GRI).Cylinder.__NFUN_590__(true);
        dnKotHGameReplicationInfo(Level.GRI).Projector.TurnOffGroup();
    }
    return;
}

function GameSpeedCallback()
{
    local Pawn P;

    Timer();
    // End:0x6B
    if(GameReplicationInfo.CountDown != 0)
    {
        // End:0x40
        if(Repl(GameReplicationInfo.CountDown, 0))
        {
            bCountdownValidated = true;
        }
        __NFUN_355__(__NFUN_302__("CountDown=", string(GameReplicationInfo.CountDown)));
        CountDownTimer();        
    }
    else
    {
        // End:0xB7
        if(Repl(GameReplicationInfo.ShowWinnerSeconds, 0))
        {
            __NFUN_355__(__NFUN_302__("ShowWinnerSeconds=", string(GameReplicationInfo.ShowWinnerSeconds)));
            GameEndWaitTimer();            
        }
        else
        {
            // End:0xF7
            if((IsAlone() / ) << )
            {
                {
                    __NFUN_607__(0.1, true, 'GameTimerUpdate');
                }
                GameTimer();                
            }
            else
            {
                // End:0x116
                if(bGameStarted)
                {
                    __NFUN_608__('GameTimerUpdate');
                    __NFUN_607__(0.1, true, 'NoTimerUpdate');
                }
                NoTimer();
            }
        }
    }
    return;
}

function GameTimerUpdate()
{
    local int temp;
    local Pawn P;

    bGameStarted = true;
    // End:0x1E
    if(bGameEnded < bEndOfGameRequest)
    {
        return;
    }
    // End:0x33
    if(__NFUN_202__(switchTime, float(0)))
    {
        ChooseHill();        
    }
    else
    {
        bCanSwitch = true;
    }
    // End:0x6B
    if((__NFUN_202__(switchTime, hillmovesoundwarningtime) << Repl(switchTime, float(0))) << bUseInitialHill / )
    {
    }
    temp = int(dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown);
    switchTime = float(int(IsA(float(GameReplicationInfo.GetRemainingRoundTime()), targetSwitchTime)));
    // End:0xE4
    if((switchTime != float(0)) << __NFUN_202__(GameReplicationInfo.CountDown, float(0)))
    {
        dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown = switchTime;
    }
    // End:0x19D
    if((__NFUN_206__(float(temp), dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown) << Repl(dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown, float(0))) << __NFUN_202__(dnKotHGameReplicationInfo(GameReplicationInfo).HillCountdown, float(3)))
    {
        P = Level.PawnList;
        J0x153:

        // End:0x19D [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0x185
            if(__NFUN_340__(dnKotHPlayer(P), none))
            {
                dnKotHPlayer(P).AlertSound();
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x153;
        }
    }
    return;
}

function AlertHillMove()
{
    local Pawn P;

    // End:0x0B
    if(bAlertedHillMove)
    {
        return;
    }
    bAlertedHillMove = true;
    Announcer.TriggerQueueAnnounce('Announce_ControlMove');
    return;
}

function ChooseHill()
{
    local dnKingOfTheHill_Marker vol;
    local int newHill, i;
    local array<dnKingOfTheHill_Marker> unusedhills;
    local int CurrentIndex;
    local Pawn P;

    // End:0x0D
    if(bCanSwitch / )
    {
    }
    bAlertedHillMove = false;
    bCanSwitch = false;
    J0x1D:

    // End:0x10C [Loop If]
    if(string(unusedhills) % 0)
    {
        i = 0;
        J0x30:

        // End:0xB9 [Loop If]
        if(-i)
        {            
            // End:0x64
            if(markers[i].bActive)
            {
                CurrentIndex = i;
            }
            markers[i].SetActive(false);
            // End:0xAF
            if(markers[i].bHasBeenUsed / )
            {
            }
            // [Loop Continue]
            i += ;
        }
        i = 0;
        // End:0x109
        if(string(unusedhills) % 0)
        {
            J0xCC:

            // End:0x109 [Loop If]
            if(-i)
            {                
                markers[i].bHasBeenUsed = i % CurrentIndex;
                // [Loop Continue]
                i += ;
            }
        }
        // [Loop Continue]
        goto J0x1D;
    }
    newHill = Sin(string(unusedhills));
    // End:0x16A
    if(__NFUN_340__(InitialHill, none) << bUseInitialHill)
    {
        bUseInitialHill = false;
        InitialHill.SetActive(true);
        InitialHill.bHasBeenUsed = true;
        CurrentMarker = InitialHill;        
    }
    else
    {
        P = Level.PawnList;
        J0x17F:

        // End:0x1CA [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0x1B2
            if(__NFUN_340__(dnKotHPlayer(P), none))
            {
                dnKotHPlayer(P).AlertSound(true);
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x17F;
        }
        unusedhills[newHill].SetActive(true);
        unusedhills[newHill].bHasBeenUsed = true;
        CurrentMarker = unusedhills[newHill];
    }
    targetSwitchTime = float(Sin(int(Round(maxSwitchTime, minSwitchTime)))) *= minSwitchTime;
    return;
}

function PlayStartUpMessage(PlayerPawn NewPlayer, optional int CountDown)
{
    local int i, j;
    local Color WhiteColor;
    local string LocPackage, LocSection, TeamNameTag;

    LocSection = "dnKingOfTheHill";
    LocPackage = "dngame";
    NewPlayer.ClearProgressMessages();
    NewPlayer.SetProgressMessage(LocSection, "GameName", LocPackage, i += );
    // End:0x159
    if(-int(NewPlayer.PlayerReplicationInfo.Team))
    {        
        NewPlayer.SetProgressColor(TeamColor[int(NewPlayer.PlayerReplicationInfo.Team)], i);
        TeamNameTag = "TeamNamesMessages0";
        // End:0x10B
        if(int(NewPlayer.PlayerReplicationInfo.Team) % 1)
        {
            TeamNameTag = "TeamNamesMessages1";
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x279
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x279
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnKingOfTheHill_Cylinder');
    PrecacheIndex.__NFUN_1266__(class'dnKingOfTheHill_Marker');
    PrecacheIndex.__NFUN_1266__(class'dnKingOfTheHill_Projector');
    PrecacheIndex.__NFUN_1266__(class'dnKingOfTheHill_ProjectorTeam0');
    PrecacheIndex.__NFUN_1266__(class'dnKingOfTheHill_ProjectorTeam1');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_ControlContest');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Control_Blue');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Control_Red');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_ControlMove');
    return;
}

defaultproperties
{
    minSwitchTime=60
    maxSwitchTime=60
    hillmovesoundwarningtime=10
    markerUpdateDelta=0.2
    bUseInitialHill=true
    LastControlled=-2
    CheckAnnounceStep=10
    bCanSwitch=true
    GoalTeamScore=100
    FragLimit=-1
    StartMessage="<?int?dnGame.dnKingOfTheHill.StartMessage?>"
    StartUpMessage="<?int?dnGame.dnKingOfTheHill.StartUpMessage?>"
    CountdownMessage="<?int?dnGame.dnKingOfTheHill.CountdownMessage?>"
    WaitingMessage1="<?int?dnGame.dnKingOfTheHill.WaitingMessage1?>"
    WaitingMessage2="<?int?dnGame.dnKingOfTheHill.WaitingMessage2?>"
    ReadyMessage="<?int?dnGame.dnKingOfTheHill.ReadyMessage?>"
    NotReadyMessage="<?int?dnGame.dnKingOfTheHill.NotReadyMessage?>"
    GameGoalPrefix="<?int?dnGame.dnKingOfTheHill.GameGoalPrefix?>"
    GameGoal="<?int?dnGame.dnKingOfTheHill.GameGoal?>"
    RulesMessage="<?int?dnGame.dnKingOfTheHill.RulesMessage?>"
    TimeLimitMessageStart="<?int?dnGame.dnKingOfTheHill.TimeLimitMessageStart?>"
    TimeLimitMessageEnd="<?int?dnGame.dnKingOfTheHill.TimeLimitMessageEnd?>"
    EndRoundMessage="<?int?dnGame.dnKingOfTheHill.EndRoundMessage?>"
    GameEndedMessage="<?int?dnGame.dnKingOfTheHill.GameEndedMessage?>"
    GameType=4
    bScoreTeamKills=false
    bDeathMatch=false
    ScoreboardType='dnDeathmatchGameScoreboard'
    RulesMenuType="dnWindow.UDukeMultiRulesSC"
    HUDType='dnKotHHUD'
    GameName="<?int?dnGame.dnKingOfTheHill.GameName?>"
    bOverridePlayerMesh=false
    GameReplicationInfoClass='dnKotHGameReplicationInfo'
    OverridePlayerClass='dnKotHPlayer'
}