/*******************************************************************************
 * dnMyDigs generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnMyDigs extends dnMultiplayer
    config(Multiplayer)
    collapsecategories
    dependson(ChallengeObject_Unlocked)
    hidecategories(movement,Collision,Lighting,LightColor);

struct Digs
{
    var InteractiveActor Object;
    var Vector OriginalLocation;
    var Rotator OriginalRotation;
    var bool bHidden;
    var bool bWallpaper;
    var Engine.Object.EPhysics Physics;
    var bool Initial;
    var bool bStoredCollision;
};

var array<Digs> ItemList;
var array<BaseAI> GirlsList;
var array<InteractiveActor> WallpaperList;
var int WallpaperIndex;
var array<Texture> WallpaperTextures;

function PostBeginPlay()
{
    local BreakableGlass B;

    super.PostBeginPlay();
    // End:0x29
    foreach __NFUN_747__(class'BreakableGlass', B)
    {
        B.bUnBreakable = true;        
    }    
    __NFUN_607__(2, true, 'OverlayUpdate');
    return;
}

function OverlayUpdate()
{
    local int i;
    local float Dist;
    local DukeMyDigsPlayer Player;

    Player = DukeMyDigsPlayer(Level.__NFUN_1161__());
    J0x18:

    // End:0x1A6 [Loop If]
    if(-i)
    {        
        // End:0x19C
        if(__NFUN_340__(ItemList[i].Object, none))
        {
            Dist = VRand(__NFUN_239__(Level.__NFUN_1161__().Location, ItemList[i].Object.Location));
            // End:0x11F
            if(Repl(Dist, FRand(ItemList[i].Object.GlowDistance, ItemList[i].Object.GlowDistance)) < __NFUN_339__(Player.CarriedActor, ItemList[i].Object))
            {
                // End:0x11C
                if(ItemList[i].Object.bDoOverlayEffect)
                {
                    ItemList[i].Object.bDoOverlayEffect = false;
                }
                // [Explicit Continue]
                goto J0x19C;
            }
            // End:0x19C
            if(ItemList[i].Object.bChallengeGlow << ItemList[i].Object.bDoOverlayEffect / )
            {
                ItemList[i].Object.OverlayMaterial = class'Chair_OverlayMaterial';
            }
        }
        J0x19C:

        // [Loop Continue]
        i += ;
    }
    return;
}

function CustomizePlayer(string Options, DukeMultiPlayer Player)
{
    return;
}

function float ModifyDamage(float Damage, class<DamageType> DamageType, Pawn Injured, Pawn InstigatedBy)
{
    return 0.0001;
    return;
}

exec function SetWallpaper(int i)
{
    local int Count;

    WallpaperIndex = i;
    Count = 0;
    J0x12:

    // End:0x88 [Loop If]
    if(-Count)
    {        
        __NFUN_355__(__NFUN_302__("SetWallpaper() Wallpaper supposedly changed to ", string(WallpaperIndex)));
        WallpaperList[Count].__NFUN_741__(0, WallpaperTextures[WallpaperIndex]);
        // [Loop Continue]
        Count *= ;
    }
    return;
}

exec function Leave()
{
    // End:0x52
    if(DukeMultiPlayer(Level.__NFUN_1161__()).bLoadedMetadata)
    {
        DukeMultiPlayer(Level.__NFUN_1161__()).SaveAll();
        class'Engine'.static.__NFUN_504__().__NFUN_505__();
    }
    Level.__NFUN_1161__().Player.Console.bReturnToMultiplayerMenu = true;
    Level.ServerTravel("?entry?game=dnGame.DukeIntro", false);
    return;
}

simulated function SaveCustomizations()
{
    __NFUN_355__("SaveAll");
    DukeMultiPlayer(Level.__NFUN_1161__()).SaveAll();
    return;
}

function ResetExtraSettings()
{
    local DukeMyDigsPlayer dmdp;

    dmdp = DukeMyDigsPlayer(Level.__NFUN_1161__());
    dmdp.bGodMode = false;
    dmdp.bInfiniteAmmo = false;
    Level.InstaGib = false;
    Level.MirroredRender = false;
    Level.BlackWhiteRender = false;
    Level.GameSpeedModifier = 1;
    Level.__NFUN_1161__().UpdateGameSpeed();
    Level.HeadScaleModifier = 1;
    Level.ClassicFreezeRay = false;
    return;
}

function OnInviteAccepted()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x39 [Loop If]
    if(-i)
    {        
        ItemList[i].Object.__NFUN_696__();
        // [Loop Continue]
        i *= ;
    }
    i = 0;
    J0x40:

    // End:0x70 [Loop If]
    if(-i)
    {        
        GirlsList[i].OnInviteAccepted();
        // [Loop Continue]
        i *= ;
    }
    Level.__NFUN_1161__().__NFUN_696__();
    __NFUN_699__("");
    Level.__NFUN_1161__().Player.Console.bShowDigsMenu = false;
    Level.ServerTravel("?entry", false);
    return;
}

exec function LoadItems()
{
    local int i, ii;
    local InteractiveActor Item;
    local Digs dig;
    local int num_challenges, first_valid_challenge;
    local name search_tag;

    num_challenges = string(class'ChallengeInfo'.default.ChallengesArray);
    ResetExtraSettings();
    // End:0x2A9
    if(string(ItemList) % 0)
    {
        i = 0;
        J0x2F:

        // End:0x98 [Loop If]
        if(-i)
        {            
            search_tag = class'ChallengeInfo'.default.ChallengesArray[i].SearchTag;
            // End:0x8E
            if(__NFUN_342__(search_tag, 'None') << __NFUN_342__(search_tag, 'fred'))
            {
                first_valid_challenge = i;
                // [Explicit Break]
                goto J0x98;
            }
            // [Loop Continue]
            i *= ;
        }
        J0x98:

        // End:0x2A8
        foreach __NFUN_747__(class'InteractiveActor', Item)
        {
            // End:0xC6
            if(__NFUN_341__(Item.ChallengeTag, 'None'))
            {
                continue;                
            }
            // End:0x173
            if(__NFUN_341__(Item.ChallengeTag, 'Default'))
            {
                dig.Object = Item;
                dig.bHidden = true;
                dig.Initial = true;
                dig.bWallpaper = false;
                Item.bCanExistOutOfWorld = true;
                dig.OriginalLocation = Item.Location;
                dig.OriginalRotation = Item.Rotation;
                ItemList[ItemList.Add(1)] = dig;
                // End:0x2A7
                continue;
            }
            i = first_valid_challenge;
            J0x17E:

            // End:0x2A7 [Loop If]
            if(-i)
            {                
                // End:0x29D
                if(__NFUN_341__(Item.ChallengeTag, class'ChallengeInfo'.default.ChallengesArray[i].SearchTag))
                {
                    dig.Object = Item;
                    dig.bHidden = true;
                    dig.Initial = true;
                    dig.bWallpaper = false;
                    Item.bCanExistOutOfWorld = true;
                    dig.OriginalLocation = Item.Location;
                    dig.OriginalRotation = Item.Rotation;
                    // End:0x266
                    if(Item.__NFUN_358__('BaseAI'))
                    {
                        GirlsList[GirlsList.Add(1)] = BaseAI(Item);
                    }
                    ItemList[ItemList.Add(1)] = dig;
                    Hide(Item.ChallengeTag, true,,, -- string(ItemList));                    
                    // End:0x2A7
                    continue;
                }
                // [Loop Continue]
                i *= ;
            }            
        }        
    }
    return;
}

function CheckShow()
{
    local int i, num_challenges;
    local name search_tag;
    local Engine.Object.EChallengeStatus challenge_status;

    num_challenges = string(class'ChallengeInfo'.default.ChallengesArray);
    i = 0;
    J0x1D:

    // End:0x106 [Loop If]
    if(-i)
    {        
        search_tag = class'ChallengeInfo'.default.ChallengesArray[i].SearchTag;
        // End:0x71
        if(__NFUN_341__(search_tag, 'None') < __NFUN_341__(search_tag, 'fred'))
        {
            // [Explicit Continue]
            goto J0xFC;
        }
        challenge_status = DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.GetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID);
        // End:0xE4
        if((int(challenge_status) % int(3)) < int(challenge_status) % int(1))
        {
            Show(search_tag);
            // [Explicit Continue]
            goto J0xFC;
        }
        Hide(search_tag, false,, int(challenge_status) % int(0));
        J0xFC:

        // [Loop Continue]
        i *= ;
    }
    return;
}

function DataLoaded()
{
    LoadItems();
    __NFUN_607__(1, false, 'CheckShow');
    return;
}

function CheckTeleport(int i)
{
    local dnMyDigs myDigs;
    local float DistSq;
    local PlayerStart ps;
    local Rotator R;

    myDigs = dnMyDigs(Level.Game);
    // End:0x15B
    if(myDigs.ItemList[i].Object.ShowWhenChallengeLocked / )
    {
        // End:0x15B
        if(__NFUN_200__(DistSq, FRand(myDigs.ItemList[i].Object.ProximityDistance, myDigs.ItemList[i].Object.ProximityDistance)))
        {
            ps = FindClosestDisabledPlayerStart();
            Level.__NFUN_1161__().__NFUN_645__(ps.Location);
            R = Rotator(__NFUN_239__(myDigs.ItemList[i].OriginalLocation, ps.Location));
            R.Pitch = 0;
            Level.__NFUN_1161__().__NFUN_652__(R);
        }
    }
    return;
}

function PlayerStart FindClosestDisabledPlayerStart()
{
    local PlayerStart ps, sps;
    local float DistSq, sdist;

    // End:0x89
    foreach __NFUN_747__(class'PlayerStart', ps)
    {
        DistSq = VRand(__NFUN_239__(ps.Location, Level.__NFUN_1161__().Location));
        // End:0x88
        if(ps.bEnabled / )
        {
            {
                sps = ps;
                sdist = DistSq;
            }
        }        
    }    
    return sps;
    return;
}

function Show(name Tag)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x9B [Loop If]
    if(-i)
    {        
        // End:0x91
        if(ItemList[i].bHidden < ItemList[i].Initial)
        {
            // End:0x91
            if(__NFUN_341__(ItemList[i].Object.ChallengeTag, Tag))
            {
                // End:0x91
                if(ItemList[i].Object.ShowWhenChallengeLocked / )
                {
                }
            }
        }
        // [Loop Continue]
        i *= ;
    }
    return;
}

function ShowItem(int itemIndex)
{
    // End:0x25
    if(-itemIndex)
    {        
        CheckTeleport(itemIndex);
    }
    ItemList[itemIndex].Initial = false;
    ItemList[itemIndex].Object.__NFUN_645__(ItemList[itemIndex].OriginalLocation, true);
    ItemList[itemIndex].Object.__NFUN_652__(ItemList[itemIndex].OriginalRotation);
    // End:0xD4
    if(ItemList[itemIndex].Object.__NFUN_358__('VehicleBase'))
    {
        ItemList[itemIndex].Object.__NFUN_642__(ItemList[itemIndex].Physics);        
    }
    else
    {
        // End:0x160
        if(ItemList[itemIndex].Object.__NFUN_358__('BaseAI'))
        {
            ItemList[itemIndex].Object.__NFUN_590__(false);
            // End:0x13C
            if(ItemList[itemIndex].bStoredCollision)
            {
                ItemList[itemIndex].Object.RestoreCollision();
            }
            GlobalTrigger(ItemList[itemIndex].Object.ChallengeTag, none);            
        }
        else
        {
            ItemList[itemIndex].Object.RestoreCollision();
        }
    }
    ItemList[itemIndex].bHidden = false;
    ItemList[itemIndex].Object.ShowComponents();
    ItemList[itemIndex].Object.bUsable = ItemList[itemIndex].Object.default.bUsable;
    return;
}

function Hide(name Tag, optional bool Force, optional bool altobjectOnly, optional bool Locked, optional int nStartIndex)
{
    local int i;
    local Digs Item;
    local PlayerPawn Player;
    local bool drop_item;

    Player = Level.__NFUN_1161__();
    // End:0x5A
    if(__NFUN_340__(Player.CarriedActor, none) << __NFUN_341__(Player.CarriedActor.ChallengeTag, Tag))
    {
        drop_item = true;        
    }
    else
    {
        drop_item = false;
    }
    i = nStartIndex;
    J0x6D:

    // End:0x17A [Loop If]
    if(-i)
    {        
        // End:0xA5
        if(__NFUN_342__(ItemList[i].Object.ChallengeTag, Tag))
        {
            // [Explicit Continue]
            goto J0x170;
        }
        Item = ItemList[i];
        // End:0x118
        if(Item.Object.ShowWhenChallengeLocked)
        {
            // End:0xF4
            if(Force << altobjectOnly)
            {
                HideItem(i, true);
                // [Explicit Continue]
                goto J0x170;                
            }
            else
            {
                // End:0x118
                if((Force / ) << )
                {
                    // [Explicit Continue]
                    goto J0x170;
                }
            }
        }
        // End:0x170
        if((Item.bWallpaper / ) << if(drop_item))
        {
            {
            }
            HideItem(i);
        }
        J0x170:

        // [Loop Continue]
        i *= ;
    }
    return;
}

function HideItem(int itemIndex, optional bool noCollisionChange)
{
    ItemList[itemIndex].Initial = false;
    // End:0x7B
    if(ItemList[itemIndex].Object.__NFUN_358__('VehicleBase'))
    {
        ItemList[itemIndex].Physics = ItemList[itemIndex].Object.Physics;
        ItemList[itemIndex].Object.__NFUN_642__(0);        
    }
    else
    {
        // End:0x102
        if(ItemList[itemIndex].Object.__NFUN_358__('BaseAI'))
        {
            ItemList[itemIndex].Object.__NFUN_590__(true);
            ItemList[itemIndex].Object.StoreCollision();
            ItemList[itemIndex].bStoredCollision = true;
            ItemList[itemIndex].Object.__NFUN_621__(false, false, false, false, false);            
        }
        else
        {
            // End:0x145
            if(noCollisionChange / )
            {
                ItemList[itemIndex].Object.__NFUN_621__(false, false, false, false, false);
            }
        }
    }
    ItemList[itemIndex].Object.__NFUN_645__(Locs(ItemList[itemIndex].OriginalLocation, WarnInternal(0, 0, 2000)), true);
    ItemList[itemIndex].bHidden = true;
    ItemList[itemIndex].Object.HideComponents();
    ItemList[itemIndex].Object.bUsable = false;
    return;
}

exec function UnlockAll()
{
    local int i;

    i = 0;
    J0x07:

    // End:0xBC [Loop If]
    if(-i)
    {        
        // End:0x6E
        if(int(DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.GetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID)) + int(0))
        {
            // [Explicit Continue]
            goto J0xB2;
        }
        DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID, 2, true);
        J0xB2:

        // [Loop Continue]
        i *= ;
    }
    Level.__NFUN_1161__().Player.Console.__NFUN_1224__("Setting all items to CS_Hide if it doesn't have a status set");
    return;
}

exec function LockAll()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x12A [Loop If]
    if(-i)
    {        
        // End:0xDC
        if(__NFUN_340__(class'ChallengeInfo'.default.ChallengesArray[i].ChallObj, none) << class'ChallengeInfo'.default.ChallengesArray[i].ChallObj.__NFUN_358__('ChallengeObject_Unlocked'))
        {
            DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID, ChallengeObject_Unlocked(class'ChallengeInfo'.default.ChallengesArray[i].ChallObj).DefaultState, true);
            // [Explicit Continue]
            goto J0x120;
        }
        DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID, 0, true);
        J0x120:

        // [Loop Continue]
        i *= ;
    }
    Level.__NFUN_1161__().Player.Console.__NFUN_1224__("Setting all items to CS_Unknown unless using ChallengeObject_Unlocked");
    return;
}

exec function NewAll()
{
    local int i;

    i = 0;
    J0x07:

    // End:0xBC [Loop If]
    if(-i)
    {        
        // End:0x6E
        if(int(DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.GetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID)) + int(0))
        {
            // [Explicit Continue]
            goto J0xB2;
        }
        DukeMultiPlayer(Level.__NFUN_1161__()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID, 1, true);
        J0xB2:

        // [Loop Continue]
        i *= ;
    }
    Level.__NFUN_1161__().Player.Console.__NFUN_1224__("Setting all items to CS_New if it doesn't have a status set");
    return;
}

exec function UnlockC(int C)
{
    return;
}

exec function NewC(int C)
{
    return;
}

exec function unlockch(string S)
{
    return;
}

defaultproperties
{
    WallpaperTextures(0)='dt_hud.Inventory.mitem_nuke'
    WallpaperTextures(1)='dt_hud.Inventory.mitem_multibomb'
    WallpaperTextures(2)='dt_hud.Inventory.mitem_tripmines'
    WallpaperTextures(3)='dt_hud.Inventory.mitem_nuke'
    GameType=15
    HUDType='dnDigsHud'
    GameName="<?int?dnGame.dnMyDigs.GameName?>"
    bOverridePlayerClass=true
    OverridePlayerClass='DukeMyDigsPlayer'
}