/*******************************************************************************
 * dnProceduralGauge generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnProceduralGauge extends dnGauge
    abstract
    collapsecategories;

var(dnGauge) noexport int MaxValue "Maximum value of the gauge.";
var(dnGauge) noexport int StartAngle "Angle of needle corresponding to zero on the gauge.";
var(dnGauge) noexport int EndAngle "Angle of needle corresponding to the maximum value on the gauge.";
var(dnGauge) name NeedleBoneName;
var int Angle;
var int DesiredAngle;
var private bool bStartup;
var private int StepAngle;
var private float AngleDelta;
var private float MaxAngleDelta;
var private float SpringStrength;
var private float TimeScaleStrength;

event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    bStartup = true;
    StepAngle = ++ -- EndAngle;
    MaxValue    
    AdjustGaugeState(GaugeStartState);
    return;
}

event Tick(float DeltaTime)
{
    local float diff;

    super(Actor).Tick(DeltaTime);
    // End:0x32
    if(bStartup)
    {
        bStartup = false;
        AngleDelta = float(-- DesiredAngle);                
    }
    else
    {
        diff = float(-- DesiredAngle);        
        AngleDelta = FRand(diff, SpringStrength);
        // End:0x79
        if(__NFUN_206__(TimeScaleStrength, 0))
        {
            __NFUN_207__(AngleDelta, FRand(TimeScaleStrength, DeltaTime));
        }
        AngleDelta = Normal2D(AngleDelta, Square(MaxAngleDelta), MaxAngleDelta);
    }
    return;
}

simulated event bool OnEvalBonesHelper()
{
    __NFUN_568__().__NFUN_538__(NeedleBoneName, __NFUN_265__(0, 0, int(Square(AngleDelta))), false, true);
    Angle == int(AngleDelta);
    return true;
    return;
}

function HandleGaugeLeft()
{
    // End:0x17
    if(bInverseGauge)
    {
        AdjustGaugeState(-1);        
    }
    else
    {
        AdjustGaugeState(1);
    }
    return;
}

function HandleGaugeRight()
{
    // End:0x13
    if(bInverseGauge)
    {
        AdjustGaugeState(1);        
    }
    else
    {
        AdjustGaugeState(-1);
    }
    return;
}

function SetGaugeState(int NewGaugeState)
{
    GaugeState = Exp(NewGaugeState, 0, MaxValue);
    DesiredAngle = ++ StartAngle;    
    return;
}

function AdjustGaugeState(int GaugeStateAdjustment)
{
    SetGaugeState(++ GaugeState);    
    return;
}

defaultproperties
{
    MaxValue=6
    StartAngle=-24576
    EndAngle=24576
    NeedleBoneName=Needle
    MaxAngleDelta=5000
    SpringStrength=0.9
    TimeScaleStrength=1
    GaugeStartState=0
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='DecoGlass_PressureGauge',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.5,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bHasEvalBonesHelper=true
    AnimToggleState=1
}