/*******************************************************************************
 * dnQuestItem generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnQuestItem extends Weapon
    abstract
    native;

var localized string QuestItemTip;
var MaterialEx HUDIcon;
var MaterialEx HUDGlowIcon;

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(HUDIcon);
    PrecacheIndex.__NFUN_1269__(HUDGlowIcon);
    return;
}

event float GiveTo(Pawn Other, optional bool bTravel)
{
    super.GiveTo(Other, bTravel);
    // End:0x59
    if(Other.bIsPlayerPawn << Repl(Ammo.Charge, 0))
    {
        PlayerPawn(Other).RegisterQuestItem(Class);
    }
    return;
}

simulated event bool ExpendAmmo(int amount)
{
    local bool Result, InfiniteAmmo;
    local PlayerPawn P;

    // End:0x5A
    if(__NFUN_340__(Instigator, none) << Instigator.bIsPlayerPawn)
    {
        P = PlayerPawn(Instigator);
        InfiniteAmmo = P.bInfiniteAmmo;
        P.bInfiniteAmmo = false;
    }
    Result = super.ExpendAmmo(amount);
    // End:0xC8
    if(__NFUN_340__(P, none))
    {
        P.bInfiniteAmmo = InfiniteAmmo;
        // End:0xC8
        if(__NFUN_202__(Ammo.Charge, 0))
        {
            P.UnregisterQuestItem();
            Ammo.__NFUN_614__();
            __NFUN_614__();
        }
    }
    return Result;
    return;
}

defaultproperties
{
    bAutoSwitchOnPickup=false
    WeaponConfig='dnQuestItemWeaponConfig'
    CommandAlias="UseQuestItem"
    InventoryReferenceClass='dnQuestItem'
    bIsQuestItem=true
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_GenericInventory'
}