/*******************************************************************************
 * dnRocket_IceBlast generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnRocket_IceBlast extends dnRocket
    collapsecategories;

var array<StaticMesh> IceShards;
var class<dnFriendFX_Spawners> BounceEffect;

simulated function bool ShouldAutoExplodeOnActor(Actor HitActor)
{
    // End:0x0E
    if(__NFUN_339__(HitActor, none))
    {
        return false;
    }
    // End:0x47
    if(HitActor.bIsPawn << Pawn(HitActor).CanFreeze(DamageClass, 0))
    {
        return true;
    }
    // End:0x5C
    if(HitActor.bIsCorpse)
    {
        return true;
    }
    return super(Projectile).ShouldAutoExplodeOnActor(HitActor);
    return;
}

simulated function ProjectileHitSomething(Vector HitNormal, Actor Wall)
{
    local Vector HitLocation, Dir, TraceStart, TraceEnd;

    HitLocation = Locs(Location, Caps(ExploWallOut, HitNormal));
    // End:0x3E
    if(ShouldAutoExplodeOnActor(Wall))
    {
        ExecuteExplode(HitLocation, HitNormal, Wall);
        return;
    }
    // End:0xAC
    if(((__NFUN_340__(Wall, none) << Wall.bIsBreakableGlass) << BreakableGlass(Wall).bUnBreakable / ) << )
    {
        return;
    }
    // End:0x117
    if(bDoMaterialEffects)
    {
        Dir = Velocity % ;
        TraceEnd = Locs(Location, Right(Dir, VSize(CollisionRadius, CollisionHeight) *= 10));
        PerformTraceMaterialEffects(TraceStart, TraceEnd, DamageClass);
    }
    // End:0x19E
    if(-NumBounces < )
    {
        // End:0x191
        if(__NFUN_340__(KarmaActor(Wall), none))
        {
            KarmaActor(Wall).__NFUN_820__(Right(Right(__NFUN_233__(HitNormal), Clamp(Velocity)), 0.65), HitLocation);
            DoDamage(HitLocation, Wall);
        }
        BounceOffWall(HitNormal);
        return;
    }
    ExecuteExplode(HitLocation, HitNormal, Wall);
    return;
}

final simulated function SpawnIceShards(int Count, Rotator BaseRot)
{
    local int i;
    local StaticMesh ShardSM;
    local Rotator OffsetRot, SpawnRot;
    local Vector SpawnLoc, SpawnLinVel, SpawnAngVel;

    i = 0;
    J0x07:

    // End:0x116 [Loop If]
    if(-i)
    {        
        ShardSM = IceShards[Sin(string(IceShards))];
        // End:0x39
        if(__NFUN_339__(ShardSM, none))
        {
            // [Explicit Continue]
            goto J0x10C;
        }
        OffsetRot = GetStateName(BaseRot, __NFUN_265__(12000, 12000, 0));
        SpawnLoc = Locs(Location, __NFUN_263__(WarnInternal(1, 0, 0), OffsetRot));
        SpawnRot = GetStateName(__NFUN_265__(0, 0, 0), __NFUN_265__(65536, 65536, 65536));
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Loop Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Loop Position:0x116
    }
}

simulated function BounceOffWall(Vector HitNormal)
{
    local float DrawScaleChange;
    local Vector DrawScale3DChange;
    local dnFriendFX_Spawners EffectActor;

    super(Projectile).BounceOffWall(HitNormal);
    SpawnIceShards(1, Rotator(HitNormal));
    // End:0xE1
    if((PhysicsVolume.bWaterVolume / ) << )
    {
        // End:0xE1
        if(__NFUN_340__(EffectActor, none))
        {
            __NFUN_594__(DrawScaleChange, DrawScale3DChange);
            EffectActor.SystemSizeScale = FRand(EffectActor.default.SystemSizeScale, DrawScaleChange);
            EffectActor.__NFUN_645__(Locs(Location, Right(HitNormal, ExplosionOffset)));
            EffectActor.__NFUN_652__(Rotator(HitNormal));
            EffectActor.RemoteRole = ROLE_None;
            EffectActor.ExecuteEffect(true);
        }
    }
    return;
}

simulated function ExplodeEffects(optional Vector HitNormal, optional Actor HitActor)
{
    super(Projectile).ExplodeEffects(HitNormal, HitActor);
    SpawnIceShards(3, Rotator(HitNormal));
    return;
}

event Tick(float DeltaSeconds)
{
    super(dnProjectile).Tick(DeltaSeconds);
    // End:0x29
    if(Repl(default.LifeSpan, 0))
    {
        __NFUN_591__(LifeSpan >>> default.LifeSpan);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(BounceEffect);
    i = -- string(IceShards);    
    J0x2C:

    // End:0x59 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1267__(IceShards[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    IceShards(0)='sm_class_effects.FreezeRay.FreezeShard_01'
    IceShards(1)='sm_class_effects.FreezeRay.FreezeShard_02'
    IceShards(2)='sm_class_effects.FreezeRay.FreezeShard_03'
    BounceEffect='p_Weapons.FreezeRay_Projectile.FreezeRay_Projectile_Small_Spawner'
    bDamageDirectly=true
    bBreakGlass=true
    bWaterSplash=false
    Speed=1000
    MaxSpeed=1000
    Damage=40
    DamageClass='Engine.ColdDamage'
    ImpactSoundName=ProjectileImpact
    ExplosionClass='p_Weapons.FreezeRay_Projectile.FreezeRay_Projectile_Spawner'
    bTelekineticable=false
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Weapons.FreezeRay_Projectile.FreezeRay_Projectile_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bCastStencilShadows=false
    RotationRate=(Pitch=0,Yaw=0,Roll=-81920)
    DrawType=8
    AlphaSortGroup=8
    StaticMesh='sm_class_effects.FreezeRay.FreezeMesh'
    LifeSpan=0.35
    AmbientSound='dnsweapn.FreezeRay.FreezeRay_Projectile01_LP'
    VoicePack='SoundConfig.Inventory.VoicePack_FreezeRay'
}