/*******************************************************************************
 * dnRocket_RPG_HeatSeek generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnRocket_RPG_HeatSeek extends dnRocket_RPG
    collapsecategories;

var bool bEngaged;
var() float EngageDelay;
var() float ReseekDelay;
var() float ReseekDelayVariance;
var() float SeekTimeLimit;
var Pawn Shooter;
var Actor Target;
var Vector TargetLastLocation;
var Vector OriginalTargetLocation;
var() float SeekDistance;
var() float MaxRotationSpeed;
var() Rotator RotVar;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        SetTarget;
}

simulated event PostVerifySelf()
{
    super(Projectile).PostVerifySelf();
    Shooter = Instigator;
    return;
}

simulated function InitializeMotion()
{
    super(dnRocket).InitializeMotion();
    OriginalTargetLocation = Locs(Location, Caps(1000, Vector(Rotation)));
    TargetLastLocation = OriginalTargetLocation;
    return;
}

noexport simulated delegate SetTarget(Actor t)
{
    Target = t;
    return;
}

function Engage()
{
    // End:0x24
    if(__NFUN_339__(Target, none))
    {
        // End:0x1E
        if(bEngaged)
        {
            SearchForTarget();            
        }
        else
        {
            FlyInRandomDir();
        }
    }
    bEngaged = true;
    return;
}

function FlyInRandomDir()
{
    // End:0x1D
    if(TargetLastLocation != OriginalTargetLocation)
    {
        TargetLastLocation = OriginalTargetLocation;        
    }
    else
    {
        TargetLastLocation = Locs(Location, Caps(1000, Vector(GetStateName(Rotation, RotVar))));
    }
    return;
}

function SearchForTarget()
{
    local float DistSquared, MaxDistSquared, TargetChance;
    local Pawn P;
    local int i;
    local Decoration D;

    MaxDistSquared = FRand(SeekDistance, SeekDistance);
    TargetChance = 0.3;
    P = Level.PawnList;
    J0x32:

    // End:0x13E [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x92
        if(__NFUN_340__(Shooter, none))
        {
            // End:0x75
            if(Shooter.bIsPlayerPawn << P.bIgnoreAimAssist)
            {
                // [Explicit Continue]
                goto J0x126;
            }
            // End:0x92
            if(P.IsEnemyTo(Shooter) / )
            {
            }
            else
            {
            }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x092! */
            DistSquared = VRand(__NFUN_239__(P.Location, Location));
            // End:0x126
            if((((P.bHidden / ) << ) << ) << )
            {
                {
                }
            }
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x03E! */
        J0x126:

        P = P.NextPawn;
        // [Loop Continue]
        goto J0x32;
    }
    // End:0x21D
    if(__NFUN_340__(Shooter, none) << Shooter.bIsPlayerPawn)
    {
        i = -- string(Level.EnemyDecorations);        
        J0x178:

        // End:0x21D [Loop If]
        if(i / 0)
        {
            D = Level.EnemyDecorations[i];
            // End:0x213
            if(__NFUN_340__(D, none) << D.bIgnoreAimAssist / )
            {
                // End:0x213
                if(__NFUN_200__(DistSquared, MaxDistSquared))
                {
                    // End:0x213
                    if(__NFUN_339__(Target, none) < __NFUN_200__( /= TargetChance))
                    {
                    }
                }
            }
            // [Loop Continue]
            i -= ;
        }
    }
    // End:0x22F
    if(__NFUN_339__(Target, none))
    {
        FlyInRandomDir();
    }
    return;
}

function FollowTarget(Actor TargetActor, float DeltaTime)
{
    local Rotator TargetRotation;

    // End:0x18
    if(Repl(SeekTimeLimit, float(0)))
    {
        SeekTimeLimit ~= DeltaTime;
    }
    // End:0x26
    if(__NFUN_202__(SeekTimeLimit, float(0)))
    {
        return;
    }
    // End:0x47
    if(__NFUN_340__(TargetActor, none))
    {
        TargetLastLocation = TargetActor.Location;
    }
    TargetRotation = Rotator(__NFUN_239__(TargetLastLocation, Location));
    __NFUN_652__((1 -= FRand(MaxRotationSpeed, DeltaTime)) * Rotation);    
    Acceleration = Caps(AccelerationScaler, Vector(Rotation));
    Velocity = Caps(Clamp(Velocity), Vector(Rotation));
    return;
}

simulated event Tick(float DeltaTime)
{
    super(dnProjectile).Tick(DeltaTime);
    // End:0x23
    if(Repl(EngageDelay, float(0)))
    {
        EngageDelay ~= DeltaTime;
    }
    // End:0x53
    if(__NFUN_202__(EngageDelay, float(0)))
    {
        Engage();
        // End:0x53
        if(__NFUN_339__(Target, none))
        {
            EngageDelay = Normal(ReseekDelay, ReseekDelayVariance);
        }
    }
    // End:0x6C
    if(bEngaged)
    {
        FollowTarget(Target, DeltaTime);
    }
    return;
}

function ForceTarget(Actor NewTarget)
{
    SetTarget(NewTarget);
    return;
}

function StartTelekinesis(Pawn TKOwner)
{
    __NFUN_362__('Tick');
    super(InteractiveActor).StartTelekinesis(TKOwner);
    return;
}

defaultproperties
{
    EngageDelay=0.3
    ReseekDelay=0.2
    ReseekDelayVariance=0.1
    SeekTimeLimit=3.5
    SeekDistance=300
    MaxRotationSpeed=4
    RotVar=(Pitch=10548,Yaw=10548,Roll=0)
    Speed=400
    Damage=55
    DamageRadius=130
    DamageClass='EnforcerGunDamage'
    ShakeScalar=3.75
    ShakeInfo(0)=(bNoLerp=false,bToggleSign=false,Style=3,Function=0,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.45,ShakeFrequency=0.05,ShakeMagnitude=800,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=dnRocket_RPG_Shake)
    RumbleInfo(0)=(RumbleName=dnRocket_RPG_HeatSeek_Rumble,RumbleDuration=0.4,RumbleLeftMagnitude=0.6,RumbleRightMagnitude=0.2,FalloffActor=none,FalloffDistance=0)
    ExplosionClass='p_Weapons.EnforcerRocket_Explode.EnforcerRocket_Explode_Spawner'
    ExplosionLight='dnExplosionLight_RPG_HeatSeek'
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Weapon_LightEx_Rocket_HeatSeek',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-12,Y=0,Z=-6),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=-16384),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='p_Weapons.EnforcerRocketTrail.EnforcerRocketTrail_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-4,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='RPG_HeatSeek_Beam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-2,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='RPG_HeatSeek_TrailBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bNetTemporary=false
    DrawScale=0.5
}