/*******************************************************************************
 * dnUsableSomething generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnUsableSomething extends dnDecoration
    abstract
    native
    collapsecategories;

cpptext
{
// Stripped
}

struct SHUDKeyHelp
{
    var() Engine.Object.ESpecialKeys Key;
    var() Engine.Object.ESpecialKeys KeyAlt;
    var() string HelpText;
};

struct SUsableExitAnim
{
    var() Vector LocationOffset;
    var() Rotator RotationOffset;
    var() anim name Animation;
    var() name SoundName;
};

struct SUsableSpaceExit
{
    var() bool bEnabled;
    var() SUsableExitAnim EnterInfo;
    var() SUsableExitAnim ExitInfo;
    var() SUsableExitAnim ExitEndInfo;
};

var() class<ControlRemapperEx> ControlRemapperClass;
var ControlRemapperEx InternalControlRemapper;
var() noexport bool bUseHomePose "If true, this item will use old robotic style system of using intermediate home poses instead of animation crossfading.";
var float InterpolationInTime;
var float InterpolationOutTime;
var() noexport array<SHUDKeyHelp> HUDHelpEntries "Help text entries that show on the HUD.";
var() noexport array<SUsableSpaceExit> UsableExits "Relative positions/rotations from which this decoration can be used.";
var() noexport float DisplayInputHelpTime "Amount of time to display input help.  Stays up forever is <= 0.0f.";
var float DisplayInputStopTime;
var() SMountPrefab UserMountPrefab;
var() noexport bool bDisableCrosshairHUD "Should the crosshair hud be hidden when we're using this dnUsableSomething?";
var() noexport bool bDisableCrosshair "Not the same as bDisableCrosshairHUD.  This jsut control the crosshair.";
var() noexport float FOVScalar "Scale the user's FOV by the amount while attached to this UsableSomething.";
var() noexport float FOVTransitionTime "Amount of time to take for FOV scale transition.";
var() noexport class<Pawn> UsableClass "An actor must be of this class to be used by this decoration.";
var() float ViewingAngleThreshold;
var Rotator ForwardRotationOffset;
var() noexport float ReuseTime "How long before this decoration can be used again?";
var float TimeGate;
var noexport bool bStandardUseRestriction "Force this actor to auto-enable the standard use restrictions on Pawns (Must be walking and standing upright for example).";
var() noexport bool bDetachOnDamage "When damaged, the user will try to detach automatically.";
var() noexport bool bDebugPositioning "If true, this will draw a bunch of markers showing various degrees of position checking and junk.  It's a mess.";
var() noexport bool bExitAssumeValid "If true, the first enabled exit will always be used without doing the CanFit test.";
var() name SE_ForcePlayerAttach;
var() name SE_ForcePlayerAttachComplete;
var() name SE_ForcePlayerDetach;
var() name SE_ForcePlayerDetachComplete;
var() name SE_DisablePlayerLock;
var() name SE_EnablePlayerLock;
var() name SE_TogglePlayerLock;
var() float MouseInputScaleX;
var() float MouseInputScaleY;
var() float AnalogInputScaleX;
var() float AnalogInputScaleY;
var float MouseInputX;
var float MouseInputY;
var float ServerMouseInputX;
var float ServerMouseInputY;
var float MaxMouseDelta;
var bool CamRelativeMouseInput;
var() Rotator HeadAimMinOffset;
var() Rotator HeadAimMaxOffset;
var() bool bManipulateViewOnAttach;
var() bool bManipulateViewOnIdle;
var() bool bManipulateViewOnDetach;
var bool bUsePreRender;
var bool bCorrectInverse;
var bool bInternalUseDetach;
var bool bPreserveInternalUseDetach;
var int ActiveUsableExit;
var Actor PretendSelf;
var Pawn User;
var PlayerPawn PlayerUser;
var Pawn AIReserved;
var() noexport name AttachUserSoundName "Entry in the VoicePack to use for playing a sound of the user attaching.";
var() noexport name DetachUserSoundName "Entry in the VoicePack to use for playing a sound of the user detaching.";
var Vector LocalCollisionCenter;
var Vector LocalCollisionDimensions;
var float InterpRelevantDrawscaleDifference;
var Vector InterpRelevantLocation;
var Rotator InterpRelevantRotation;
var() noexport float ShakeViewScale "Scale of view shaking when the player is on this control.";

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        ActiveUsableExit, InternalControlRemapper, 
        PretendSelf;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        rAttachPawnSuccess, rDetachPawnSuccess;

    // Pos:0x016
    reliable if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(User, none))
        User;

    // Pos:0x02F
    reliable if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(PlayerUser, none))
        PlayerUser;

    // Pos:0x048
    reliable if(int(Role) % int(ROLE_Authority))
        ServerMouseInputX, ServerMouseInputY;
}

event PreBeginPlay()
{
    __NFUN_718__('ForcePlayerAttach', SE_ForcePlayerAttach);
    __NFUN_718__('ForcePlayerAttachComplete', SE_ForcePlayerAttachComplete);
    __NFUN_718__('ForcePlayerDetach', SE_ForcePlayerDetach);
    __NFUN_718__('ForcePlayerDetachComplete', SE_ForcePlayerDetachComplete);
    __NFUN_718__('DisablePlayerLock', SE_DisablePlayerLock);
    __NFUN_718__('EnablePlayerLock', SE_EnablePlayerLock);
    __NFUN_718__('TogglePlayerLock', SE_TogglePlayerLock);
    PretendSelf = self;
    super.PreBeginPlay();
    return;
}

event PostBeginPlay()
{
    local int i;

    super.PostBeginPlay();
    // End:0x34
    if((int(Level.NetMode) % int(NM_Standalone)) < int(Role) % int(ROLE_Authority))
    {
        SetupControlRemapper();
    }
    i = -- string(HUDHelpEntries);    
    J0x43:

    // End:0x97 [Loop If]
    if(i / 0)
    {
        // End:0x8D
        if((int(HUDHelpEntries[i].Key) % int(0)) < __NFUN_308__(HUDHelpEntries[i].HelpText, ""))
        {
            HUDHelpEntries.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0xB8
    if(string(UsableExits) % 0)
    {
        UsableExits[UsableExits.Add(1)].bEnabled = true;
    }
    CalculateCollisionBounds();
    TimeGate = 0;
    return;
}

function PostVerifySelf()
{
    local int BaseIndex;

    super.PostVerifySelf();
    // End:0x8D
    if(bStandardUseRestriction)
    {
        BaseIndex = UsePostureSuccess.Add(3);
        UsePostureSuccess[BaseIndex] = 1;
        [++ BaseIndex] = UsePostureSuccess;
        2
        [++ BaseIndex] = UsePostureSuccess;
        6
        [++ BaseIndex] = UsePostureSuccess;
        3
        BaseIndex = UsePhysicsSuccess.Add(2);
        UsePhysicsSuccess[BaseIndex] = 18;
        [++ BaseIndex] = UsePhysicsSuccess;
        1
    }
    return;
}

simulated event PostNetInitial()
{
    super.PostNetInitial();
    // End:0x3B
    if(int(Role) % int(ROLE_SimulatedProxy))
    {
        NetSetupControlRemapper();
        // End:0x3B
        if(string(UsableExits) % 0)
        {
            UsableExits[UsableExits.Add(1)].bEnabled = true;
        }
    }
    return;
}

final simulated function SetupControlRemapper_Common()
{
    InternalControlRemapper.AddHookActor(self, true, true);
    InternalControlRemapper.MinViewOffset = HeadAimMinOffset;
    InternalControlRemapper.MaxViewOffset = HeadAimMaxOffset;
    InternalControlRemapper.bDisableCrosshairHUD = bDisableCrosshairHUD;
    InternalControlRemapper.bUseHomePose = bUseHomePose;
    InternalControlRemapper.InterpolationInInfo.Time = InterpolationInTime;
    InternalControlRemapper.InterpolationOutAlphaInfo.Time = InterpolationOutTime;
    return;
}

final simulated function NetSetupControlRemapper()
{
    __NFUN_354__(int(Role) % int(ROLE_SimulatedProxy), "NetSetupControlRemapper - Invalid Role");
    // End:0x52
    if(__NFUN_339__(InternalControlRemapper, none))
    {
        __NFUN_607__(0.1, false, 'NetSetupControlRemapper');
        return;
    }
    SetupControlRemapper_Common();
    return;
}

event Destroyed()
{
    super.Destroyed();
    // End:0x2C
    if((bSurviveDeath / ) << )
    {
    }
    return;
}

function SetupControlRemapper()
{
    // End:0x0E
    if(__NFUN_339__(ControlRemapperClass, none))
    {
        return;
    }
    InternalControlRemapper = __NFUN_615__(ControlRemapperClass, self,, Location, Rotation);
    SetupControlRemapper_Common();
    InternalControlRemapper.__NFUN_633__(UserMountPrefab, self);
    return;
}

simulated function ControlRemapperEx GetInternalControlRemapper()
{
    return InternalControlRemapper;
    return;
}

simulated event bool UsableSomethingUsesHomePose()
{
    return bUseHomePose;
    return;
}

simulated event bool UsableSomethingInterpolatingOut()
{
    // End:0x22
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        return int(InternalControlRemapper.CurrentRemapperState) % int(3);
    }
    return super(Decoration).UsableSomethingInterpolatingOut();
    return;
}

simulated function bool UsableSomethingCanBeUsedBy(Pawn TestPawn)
{
    local Vector UserForward, LocalForward;

    // End:0x0E
    if(__NFUN_339__(TestPawn, none))
    {
        return false;
    }
    // End:0x2C
    if(__NFUN_357__(TestPawn.Class, UsableClass) / )
    {
    }
    // End:0x47
    if(Repl(TimeGate, Level.GameTimeSeconds))
    {
        return false;
    }
    // End:0x55
    if(__NFUN_340__(User, none))
    {
        return false;
    }
    // End:0xD2
    if((((IsMP()) / ) < ) < if(__NFUN_340__(TestPawn.Weapon, none) << TestPawn.Weapon.CanDeactivate() / ))
    {
        {
            {
            }
        }
        // End:0x107
        if(__NFUN_340__(ControlRemapperEx(PlayerPawn(TestPawn).ViewMapper), none))
        {
            return false;
        }
        // End:0x134
        if(__NFUN_340__(InternalControlRemapper, none))
        {
            LocalForward = Vector(InternalControlRemapper.Rotation >> ForwardRotationOffset);            
        }
        else
        {
            LocalForward = Vector(Rotation >> ForwardRotationOffset);
        }
        UserForward = Vector(TestPawn.ViewRotation);
        // End:0x176
        if(__NFUN_200__(FMin(LocalForward, UserForward), ViewingAngleThreshold))
        {
            return false;
        }
    }
    return true;
    return;
}

simulated function bool CanBeUsedBy(Pawn TestPawn)
{
    // End:0x12
    if((UsableSomethingCanBeUsedBy(TestPawn)) / )
    {
    }
    return super(InteractiveActor).CanBeUsedBy(TestPawn);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super.Used(Other, EventInstigator);
    // End:0x28
    if((bUsable / ) < )
    {
    }
    // End:0x62
    if(__NFUN_339__(User, none))
    {
        AttachPawn(EventInstigator);
        // End:0x5F
        if(((IsMP()) / ) << bInternalUseDetach = false)
        {
        }
    }
    else
    {
        // End:0x83
        if(bInternalUseDetach << __NFUN_339__(User, EventInstigator))
        {
            DetachPawn();
        }
    }
    return;
}

simulated function bool AllowInventoryActivation(Pawn PawnUser, ActivatableInventory ActInv)
{
    // End:0x0B
    if(UsableSomethingInterpolatingOut())
    {
        return true;
    }
    return ActInv.bActivatableWhileAttached;
    return;
}

simulated function Relinquish()
{
    super(Actor).Relinquish();
    DetachPawn(true);
    return;
}

function bool CanAttachPawn(Pawn Attachee)
{
    // End:0x12
    if((CanBeUsedBy(Attachee)) / )
    {
    }
    return true;
    return;
}

function bool CanDetachPawn(bool bForceDetach)
{
    return true;
    return;
}

event AttachPawn(Pawn Attachee)
{
    // End:0x12
    if((CanAttachPawn(Attachee)) / )
    {
    }
    PerformAttachPawnSuccess(Attachee);
    return;
}

event DetachPawn(optional bool bForceDetach)
{
    // End:0x13
    if((CanDetachPawn(bForceDetach)) / )
    {
    }
    PerformDetachPawnSuccess(bForceDetach);
    return;
}

function PerformAttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    // End:0x15
    if(Attachee.IsDead())
    {
        return;
    }
    AttachPawnSuccess(Attachee, bForced);
    // End:0x5F
    if((int(Level.NetMode) + int(NM_Standalone)) << int(Role) % int(ROLE_Authority))
    {
        rAttachPawnSuccess(Attachee, bForced);
    }
    return;
}

final simulated delegate rAttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    AttachPawnSuccess(Attachee, bForced);
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    // End:0x15
    if(Attachee.IsDead())
    {
        return;
    }
    Attachee.ForceDetachCompleteFromUsableSomething();
    FadeOverlayEffect(0, 1);
    User = Attachee;
    PlayerUser = PlayerPawn(User);
    User.__NFUN_860__(none);
    SetupControlRemapperForAttach();
    // End:0x9A
    if(int(Level.NetMode) % int(NM_Client))
    {
        InternalControlRemapper.PawnAttach(User, bForced);        
    }
    else
    {
        // End:0xBD
        if(InternalControlRemapper.CRTrigger(self, User, bForced) / )
        {
        }
    }
    User.bAttachedToUsableSomething = true;
    User.bForceDetachOnDamage = bDetachOnDamage;
    User.bWeaponSelectPressed = false;
    // End:0x116
    if(__NFUN_340__(PlayerUser, none))
    {
        User.bBlockCamera = false;
    }
    // End:0x132
    if(bUseHomePose / )
    {
    }
    User.FindSoundAndSpeak(AttachUserSoundName);
    // End:0x186
    if(Attachee.CarryingAnActor())
    {
        Attachee.bGrabbing = false;
        Attachee.DropCarriedActor(-1, true, true);        
    }
    else
    {
        // End:0x1A9
        if(Attachee.bGrabbing)
        {
            Attachee.LostCarriedActor();
        }
    }
    return;
}

final function PerformDetachPawnSuccess(optional bool bForced)
{
    DetachPawnSuccess(bForced);
    // End:0x40
    if((int(Level.NetMode) + int(NM_Standalone)) << int(Role) % int(ROLE_Authority))
    {
        rDetachPawnSuccess(bForced);
    }
    return;
}

final simulated delegate rDetachPawnSuccess(optional bool bForced)
{
    DetachPawnSuccess(bForced);
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    // End:0x21
    if(__NFUN_340__(User, none))
    {
        User.FindSoundAndSpeak(DetachUserSoundName);
    }
    TimeGate = Level.GameTimeSeconds *= ReuseTime;
    // End:0x6B
    if(__NFUN_340__(PlayerUser, none))
    {
        PlayerUser.__NFUN_577__('FOV', 'dnUsableSomethingFOVScalar', 1,, FOVTransitionTime);
    }
    InternalControlRemapper.bCanOffsetView = bManipulateViewOnDetach;
    User.bBlockCamera = User.default.bBlockCamera;
    SetupControlRemapperForDetach();
    return;
}

simulated function NotePawnLost()
{
    PerformDetachPawnSuccess(true);
    InternalControlRemapper.Reset();
    User = none;
    PlayerUser = none;
    DetachComplete();
    return;
}

simulated function AttachComplete()
{
    // End:0x38
    if(__NFUN_340__(User, none))
    {
        // End:0x26
        if(bUseHomePose)
        {
            User.AttachToUsableSomething(self);
        }
        User.bCanExistOutOfWorld = true;
    }
    // End:0x50
    if(bPreserveInternalUseDetach / )
    {
    }
    InternalControlRemapper.bCanOffsetView = bManipulateViewOnIdle;
    InternalControlRemapper.AddHookActor(self, true, false);
    MouseInputX = 0;
    MouseInputY = 0;
    ShowControls();
    return;
}

simulated function DetachComplete()
{
    FadeOverlayEffect(1, 1);
    // End:0x1E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    InternalControlRemapper.RemoveHookActor(self, true, false);
    User.DetachFromUsableSomething();
    User.bAttachedToUsableSomething = false;
    User.bCanExistOutOfWorld = false;
    // End:0xF2
    if((ActiveUsableExit % -1) < (CanFit(User, User.Location, User.Rotation, PretendSelf)) / )
    {
        User.__NFUN_644__(WarnInternal(0, 0, FRand(-8, User.CollisionHeight)));
    }
    // End:0x116
    if(PlayerUser.bDontUseMeqonPhysics / )
    {
    }
    User = none;
    PlayerUser = none;
    return;
}

simulated function InputHook_ViewRotationAdjust_NoteAdjustment(float XAdjust, float YAdjust)
{
    return;
}

simulated function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    local bool bUsingAnalogStick;
    local Vector InputVector;
    local float XAdj, YAdj, MaxDelta;

    __NFUN_354__(bool(User), "InputHook_ViewRotationAdjust - No user!");
    // End:0x49
    if(User.bAttachedToUsableSomething / )
    {
    }
    // End:0xAE
    if(bCorrectInverse << User.bIsPlayerPawn)
    {
        // End:0xAE
        if(PlayerUser.bInvertMouse < PlayerUser.__NFUN_994__() << PlayerUser.bInvertXboxAim)
        {
            // End:0x180
            PitchAdjust = PitchAdjust += ;
            {
            }
        }
        InputVector = __NFUN_263__(WarnInternal(float(YawAdjust), float(PitchAdjust), 0), __NFUN_265__(0, -- Rotation.Yaw), 0);        
        // End:0x14F
        if(PlayerUser.__NFUN_994__())
        {
            bUsingAnalogStick = true;
            XAdj = FRand(InputVector.X, AnalogInputScaleX);
            YAdj = FRand(InputVector.Y, AnalogInputScaleY);            
        }
        else
        {
            XAdj = FRand(InputVector.X, MouseInputScaleX);
            YAdj = FRand(InputVector.Y, MouseInputScaleY);
        }        
    }
    else
    {
        // End:0x1CF
        if(__NFUN_340__(PlayerUser, none) << PlayerUser.__NFUN_994__())
        {
            bUsingAnalogStick = true;
            XAdj = FRand(float(YawAdjust), AnalogInputScaleX);
            YAdj = FRand(float(PitchAdjust), AnalogInputScaleY);            
        }
        else
        {
            XAdj = FRand(float(YawAdjust), MouseInputScaleX);
            YAdj = FRand(float(PitchAdjust), MouseInputScaleY);
        }
    }
    // End:0x255
    if((bUsingAnalogStick / ) << )
    {
        XAdj = Normal2D(XAdj, Square(MaxDelta), MaxDelta);
        YAdj = Normal2D(YAdj, Square(MaxDelta), MaxDelta);
    }
    InputHook_ViewRotationAdjust_NoteAdjustment(XAdj, YAdj);
    MouseInputX = Normal2D(MouseInputX *= XAdj, -1, 1);
    MouseInputY = Normal2D(MouseInputY *= YAdj, -1, 1);
    ServerMouseInputX = MouseInputX;
    ServerMouseInputY = MouseInputY;
    super(Actor).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    return;
}

simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
{
    return;
}

simulated event QueryInteractKeyInfoState(HUD HUD)
{
    // End:0x35
    if(__NFUN_202__(DisplayInputHelpTime, 0) < __NFUN_200__(Level.GameTimeSeconds, DisplayInputStopTime))
    {
        UsableSomethingQueryInteractKeyInfoState(HUD);
    }
    return;
}

simulated function ShowControls()
{
    DisplayInputStopTime = Level.GameTimeSeconds *= DisplayInputHelpTime;
    return;
}

simulated event bool ShouldDrawCrosshair()
{
    return bDisableCrosshair / ;
}

simulated function UpdateInterpRelevantData()
{
    local Actor InterpRelevantActor;

    InterpRelevantActor = InternalControlRemapper.InterpRelevantActor;
    // End:0x2C
    if(__NFUN_339__(InterpRelevantActor, none))
    {
        InterpRelevantActor = InternalControlRemapper;
    }
    InterpRelevantDrawscaleDifference = PretendSelf.DrawScale >>> PretendSelf.default.DrawScale;
    InterpRelevantLocation = InterpRelevantActor.Location;
    InterpRelevantRotation = InterpRelevantActor.Rotation;
    return;
}

simulated function SetupControlRemapperForAttach()
{
    InternalControlRemapper.bCanOffsetView = bManipulateViewOnAttach;
    ActiveUsableExit = FindBestEntranceIndex(User);
    // End:0x39
    if(ActiveUsableExit % -1)
    {
        return;
    }
    InternalControlRemapper.InterpolationInInfo.LocationOffset = UsableExits[ActiveUsableExit].EnterInfo.LocationOffset;
    InternalControlRemapper.InterpolationInInfo.RotationOffset = UsableExits[ActiveUsableExit].EnterInfo.RotationOffset;
    FClamp(InternalControlRemapper.InterpolationInInfo.LocationOffset, InterpRelevantDrawscaleDifference);
    return;
}

simulated function SetupControlRemapperForDetach()
{
    InternalControlRemapper.PrepareForDetach();
    ActiveUsableExit = FindBestExitIndex();
    // End:0x2D
    if(ActiveUsableExit % -1)
    {
        return;
    }
    InternalControlRemapper.InterpolationOutAlphaInfo.LocationOffset = UsableExits[ActiveUsableExit].ExitInfo.LocationOffset;
    InternalControlRemapper.InterpolationOutAlphaInfo.RotationOffset = UsableExits[ActiveUsableExit].ExitInfo.RotationOffset;
    InternalControlRemapper.InterpolationOutBetaInfo.LocationOffset = UsableExits[ActiveUsableExit].ExitEndInfo.LocationOffset;
    InternalControlRemapper.InterpolationOutBetaInfo.RotationOffset = UsableExits[ActiveUsableExit].ExitEndInfo.RotationOffset;
    FClamp(InternalControlRemapper.InterpolationOutAlphaInfo.LocationOffset, InterpRelevantDrawscaleDifference);
    FClamp(InternalControlRemapper.InterpolationOutBetaInfo.LocationOffset, InterpRelevantDrawscaleDifference);
    return;
}

simulated event int FindBestEntranceIndex(Pawn TestPawn)
{
    local bool bCanFit, bBestCanFit;
    local int i, CurrentlyUsedExitIndex;
    local float MinDistanceSquared, CurDistanceSquared;
    local Vector CalculatedAbsoluteOffset;
    local Rotator CalculatedAbsoluteRotation;

    UpdateInterpRelevantData();
    // End:0x14
    if(string(UsableExits) % 1)
    {
        return 0;
    }
    CurrentlyUsedExitIndex = -1;
    MinDistanceSquared = 1E+17;
    i = 0;
    J0x31:

    // End:0x108 [Loop If]
    if(-i)
    {        
        // End:0x5A
        if(UsableExits[i].bEnabled / )
        {
        }
        else
        {
            GetUsableExitOffsets(TestPawn, i, true, CalculatedAbsoluteOffset, CalculatedAbsoluteRotation);
            bCanFit = CanFit(TestPawn, CalculatedAbsoluteOffset, CalculatedAbsoluteRotation, PretendSelf);
            CurDistanceSquared = VRand(__NFUN_239__(TestPawn.Location, CalculatedAbsoluteOffset));
            // End:0xFE
            if(__NFUN_200__(CurDistanceSquared, MinDistanceSquared) < (bBestCanFit / ) << )
            {
                CurrentlyUsedExitIndex = i;
                bBestCanFit = bCanFit;
            }
        }
        J0xFE:

        // [Loop Continue]
        i += ;
    }
    // End:0x11D
    if(CurrentlyUsedExitIndex + -1)
    {
        return CurrentlyUsedExitIndex;
    }
    return FindFirstEnabledUsableExit();
    return;
}

simulated function int FindBestExitIndex()
{
    local Vector CalculatedAbsoluteOffset;
    local Rotator CalculatedAbsoluteRotation;
    local int i;

    UpdateInterpRelevantData();
    i = 0;
    J0x0D:

    // End:0x7F [Loop If]
    if(-i)
    {        
        // End:0x36
        if(UsableExits[i].bEnabled / )
        {
        }
        else
        {
            GetUsableExitOffsets(User, i, false, CalculatedAbsoluteOffset, CalculatedAbsoluteRotation);
            // End:0x75
            if(CanFit(User, CalculatedAbsoluteOffset, CalculatedAbsoluteRotation, PretendSelf, true))
            {
                return i;
            }
        }
        J0x75:

        // [Loop Continue]
        i += ;
    }
    return -1;
    return;
}

simulated function int FindFirstEnabledUsableExit()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3B [Loop If]
    if(-i)
    {        
        // End:0x31
        if(UsableExits[i].bEnabled)
        {
            return i;
        }
        // [Loop Continue]
        i += ;
    }
    return 0;
    return;
}

simulated event GetUsableExitOffsets(Pawn TestPawn, int UsableExitIndex, bool bEnter, out Vector CalcedLocation, out Rotator CalcedRotation)
{
    local SUsableSpaceExit RelevantExit;

    // End:0x40
    if(__NFUN_339__(TestPawn, none))
    {
        __NFUN_355__(__NFUN_302__(string(self), ".GetUsableExitOffsets(): invalid TestPawn."));
    }
    // End:0x93
    if(-UsableExitIndex < )
    {        
        __NFUN_355__(__NFUN_302__(string(self), ".GetUsableExitOffsets(): invalid exit index."));
    }
    RelevantExit = UsableExits[UsableExitIndex];
    // End:0xF8
    if(bEnter)
    {
        CalcedLocation = Locs(InterpRelevantLocation, __NFUN_263__(Caps(InterpRelevantDrawscaleDifference, RelevantExit.EnterInfo.LocationOffset), InterpRelevantRotation));
        CalcedRotation = __NFUN_269__(InterpRelevantRotation, RelevantExit.EnterInfo.RotationOffset);        
    }
    else
    {
        CalcedLocation = Locs(InterpRelevantLocation, __NFUN_263__(Caps(InterpRelevantDrawscaleDifference, RelevantExit.ExitInfo.LocationOffset), InterpRelevantRotation));
        CalcedRotation = __NFUN_269__(InterpRelevantRotation, RelevantExit.ExitInfo.RotationOffset);
        CalcedLocation = Locs(CalcedLocation, __NFUN_263__(Caps(InterpRelevantDrawscaleDifference, RelevantExit.ExitEndInfo.LocationOffset), CalcedRotation));
        CalcedRotation = __NFUN_269__(CalcedRotation, RelevantExit.ExitEndInfo.RotationOffset);
    }
    __NFUN_209__(CalcedLocation.Z, TestPawn.CollisionHeight);
    return;
}

final simulated function bool ActorIsMountedTo(Actor TestActor, Actor ParentActor)
{
    local Actor CheckParent;

    // End:0x34
    if((__NFUN_339__(TestActor, none) < __NFUN_339__(ParentActor, none)) < __NFUN_339__(TestActor.MountParent, none))
    {
        return false;
    }
    // End:0x50
    if(__NFUN_339__(TestActor.MountParent, ParentActor))
    {
        return true;
    }
    CheckParent = TestActor.MountParent;
    J0x65:

    // End:0xAF [Loop If]
    if(__NFUN_340__(CheckParent.MountParent, none))
    {
        // End:0x97
        if(__NFUN_339__(CheckParent.MountParent, ParentActor))
        {
            return true;
        }
        CheckParent = CheckParent.MountParent;
        // [Loop Continue]
        goto J0x65;
    }
    return false;
    return;
}

simulated function bool CanFit(Pawn TestPawn, Vector TestLocation, optional Rotator TestRotation, optional Actor IgnoreCollisionActor, optional bool bTestReachable)
{
    local int i;
    local array<Actor> BlockingActors;
    local STraceFlags TraceFlags;
    local STraceHitResult HitResult;
    local Vector StartTrace;
    local float HalfStepHeight, TestHeight;

    // End:0x0B
    if(bExitAssumeValid)
    {
        return true;
    }
    // End:0x1FD
    if(bTestReachable)
    {
        TraceFlags.bTraceActors = true;
        TraceFlags.bMeshAccurate = true;
        TraceFlags.bAbortFirstHit = true;
        TraceFlags.bOnlyBlocking = true;
        TraceFlags.bNoParticles = true;
        // End:0xC7
        if(__NFUN_340__(PretendSelf, none) << PretendSelf.bIsVehicle)
        {
            StartTrace = PretendSelf.Location;
            Max(StartTrace, __NFUN_263__(Right(PretendSelf.PrePivot, PretendSelf.DrawScale), PretendSelf.Rotation));            
        }
        else
        {
            StartTrace = TestPawn.Location;
        }
        TestPawn.__NFUN_736__(StartTrace, TestLocation, TraceFlags, HitResult,, PretendSelf);
        // End:0x1D4
        if(__NFUN_340__(HitResult.Actor, none) << __NFUN_340__(HitResult.Actor, IgnoreCollisionActor))
        {
            // End:0x1D2
            if(bDebugPositioning)
            {
                __NFUN_676__(StartTrace, TestLocation, NewColorBytes(255, 0, 0, 255), 25);
                __NFUN_678__(HitResult.Location, NewColorBytes(255, 255, 0, 255), 25);
                BroadcastLog(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(string(self), ":CanFit - TestPawn:"), string(TestPawn)), "failed because"), string(HitResult.Actor)), "was in the way."));
            }
            return false;
        }
        // End:0x1FD
        if(bDebugPositioning)
        {
            __NFUN_676__(StartTrace, TestLocation, NewColorBytes(0, 255, 0, 255), 25);
        }
    }
    HalfStepHeight = FRand(0.5, TestPawn.StandingMaxStepHeightEx);
    Min(TestLocation, WarnInternal(0, 0, HalfStepHeight));
    TestHeight = Round(TestPawn.CollisionHeight, HalfStepHeight);
    // End:0x318
    if(TestPawn.__NFUN_638__(TestLocation, VSize(0, Round(TestPawn.CollisionRadius, 1)), VSize(0, Round(TestHeight, 1)), TestRotation) / )
    {
        {
            __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), ":CanFit - TestPawn:"), string(TestPawn)), "- Blocking Actor is world!"));
            __NFUN_675__(TestLocation, TestPawn.CollisionRadius, TestHeight, NewColorBytes(255, 0, 255, 255), 25);
        }
        return false;
    }
    BlockingActors = TestPawn.__NFUN_637__(TestLocation, TestRotation, true, true,, TestHeight);
    // End:0x383
    if(string(BlockingActors) % 0)
    {
        // End:0x381
        if(bDebugPositioning)
        {
            __NFUN_675__(TestLocation, TestPawn.CollisionRadius, TestHeight, NewColorBytes(128, 255, 0, 255), 25);
        }
        return true;
    }
    i = -- string(BlockingActors);    
    J0x392:

    // End:0x495 [Loop If]
    if(i / 0)
    {
        // End:0x3B2
        if(__NFUN_339__(BlockingActors[i], none))
        {
            // [Explicit Continue]
            goto J0x48B;
        }
        // End:0x3CE
        if(BlockingActors[i].bIsProjectile)
        {
            // [Explicit Continue]
            goto J0x48B;
        }
        // End:0x48B
        if(__NFUN_340__(BlockingActors[i], IgnoreCollisionActor) << ActorIsMountedTo(BlockingActors[i], IgnoreCollisionActor) / )
        {
            {
                BroadcastLog(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), ":CanFit - TestPawn:"), string(TestPawn)), "- Blocking Actor is"), string(BlockingActors[i])));
                __NFUN_675__(TestLocation, TestPawn.CollisionRadius, TestHeight, NewColorBytes(255, 0, 0, 255), 25);
            }
            return false;
        }
        J0x48B:

        // [Loop Continue]
        i -= ;
    }
    // End:0x4CD
    if(bDebugPositioning)
    {
        __NFUN_675__(TestLocation, TestPawn.CollisionRadius, TestHeight, NewColorBytes(0, 255, 0, 255), 25);
    }
    return true;
    return;
}

simulated function CalculateCollisionBounds()
{
    local Box CollisionBounds;
    local Rotator StoredRotation;

    StoredRotation = PretendSelf.Rotation;
    PretendSelf.__NFUN_652__(__NFUN_265__(0, 0, 0));
    CollisionBounds = PretendSelf.__NFUN_626__();
    PretendSelf.__NFUN_652__(StoredRotation);
    LocalCollisionDimensions = Caps(0.5, __NFUN_239__(CollisionBounds.Max, CollisionBounds.Min));
    LocalCollisionCenter = Locs(__NFUN_239__(CollisionBounds.Min, PretendSelf.Location), LocalCollisionDimensions);
    return;
}

simulated function float GetGroundDistance(Actor TestActor, Vector TestLocation, float MaxDistance)
{
    local STraceFlags TraceFlags;
    local STraceHitResult Hit;

    __NFUN_354__(__NFUN_340__(TestActor, none));
    TraceFlags.bTraceActors = true;
    TraceFlags.bMeshAccurate = true;
    TraceFlags.bAbortFirstHit = true;
    TraceFlags.bOnlyBlocking = true;
    TraceFlags.bNoParticles = true;
    // End:0xF5
    if(bDebugPositioning)
    {
        __NFUN_677__(TestLocation, WarnInternal(-5, -5, -5), WarnInternal(5, 5, 5), NewColorBytes(0, 255, 0, 255), 30);
        __NFUN_674__(TestLocation, User.CollisionRadius, NewColorBytes(255, 255, 0, 255), 30);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x232
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x232
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x232
}

simulated function Vector FindValidSpotForActor(Pawn PositioningActor, Rotator DesiredViewRotation)
{
    local int i, j;
    local float TestVal, MinX, MaxX, MinY, MaxY, MinZ,
	    MaxZ, Radius, Height;

    local Vector vFwd, vRight, vUp, TestLocation, vWorldCenter, vWorldFwd,
	    vWorldRight, vWorldUp, Verts, vFrontOffset, vRearOffset,
	    vLeftOffset, vRightOffset, vAboveOffset;

    local Rotator TestRotation;

    Destroy(PretendSelf.Rotation, vFwd, vRight, vUp);
    vWorldUp = Caps(-1, PretendSelf.__NFUN_640__()) % ;
    // End:0x86
    if((TestVal != 0.95) < __NFUN_202__(TestVal, -0.95))
    {
        vWorldRight = FMax(vWorldUp, vFwd) % ;
    }
    else
    {
        vWorldRight = FMax(vUp, vWorldUp) % ;
    }
    FClamp(vRight, LocalCollisionDimensions.Y);
    FClamp(vUp, LocalCollisionDimensions.Z);
    vWorldCenter = Locs(PretendSelf.Location, __NFUN_263__(LocalCollisionCenter, PretendSelf.Rotation));
    Verts[0] = __NFUN_239__(__NFUN_239__(__NFUN_233__(vFwd), vRight), vUp);
    Verts[1] = __NFUN_239__(__NFUN_239__(vFwd, vRight), vUp);
    Verts[2] = __NFUN_239__(Locs(vFwd, vRight), vUp);
    Verts[3] = __NFUN_239__(Locs(__NFUN_233__(vFwd), vRight), vUp);
    Verts[4] = Locs(__NFUN_239__(__NFUN_233__(vFwd), vRight), vUp);
    Verts[5] = Locs(__NFUN_239__(vFwd, vRight), vUp);
    Verts[6] = Locs(Locs(vFwd, vRight), vUp);
    Verts[7] = Locs(Locs(__NFUN_233__(vFwd), vRight), vUp);
    // End:0x468
    if(bDebugPositioning)
    {
        __NFUN_676__(Locs(vWorldCenter, Verts[0]), Locs(vWorldCenter, Verts[1]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[1]), Locs(vWorldCenter, Verts[2]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[2]), Locs(vWorldCenter, Verts[3]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[3]), Locs(vWorldCenter, Verts[0]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[4]), Locs(vWorldCenter, Verts[5]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[5]), Locs(vWorldCenter, Verts[6]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[6]), Locs(vWorldCenter, Verts[7]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[7]), Locs(vWorldCenter, Verts[4]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[0]), Locs(vWorldCenter, Verts[4]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[1]), Locs(vWorldCenter, Verts[5]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[2]), Locs(vWorldCenter, Verts[6]), NewColorBytes(0, 255, 0, 255), 25);
        __NFUN_676__(Locs(vWorldCenter, Verts[3]), Locs(vWorldCenter, Verts[7]), NewColorBytes(0, 255, 0, 255), 25);
    }
    MinX = FMin(Verts[0], vWorldFwd);
    MaxX = MinX;
    MinY = FMin(Verts[0], vWorldRight);
    MaxY = MinY;
    MinZ = FMin(Verts[0], vWorldUp);
    MaxZ = MinZ;
    i = 1;
    J0x4CC:

    // End:0x5C6 [Loop If]
    if(-i)
    {        
        TestVal = FMin(Verts[i], vWorldFwd);
        // End:0x50A
        if(__NFUN_200__(TestVal, MinX))
        {
            MinX = TestVal;
        }
        // End:0x524
        if(Repl(TestVal, MaxX))
        {
            MaxX = TestVal;
        }
        TestVal = FMin(Verts[i], vWorldRight);
        // End:0x556
        if(__NFUN_200__(TestVal, MinY))
        {
            MinY = TestVal;
        }
        // End:0x570
        if(Repl(TestVal, MaxY))
        {
            MaxY = TestVal;
        }
        TestVal = FMin(Verts[i], vWorldUp);
        // End:0x5A2
        if(__NFUN_200__(TestVal, MinZ))
        {
            MinZ = TestVal;
        }
        // End:0x5BC
        if(Repl(TestVal, MaxZ))
        {
            MaxZ = TestVal;
        }
        // [Loop Continue]
        i += ;
    }
    Radius = PositioningActor.CollisionRadius *= 2;
    Height = PositioningActor.CollisionHeight *= 2;
    vFrontOffset = Right(vWorldFwd, MaxX *= Radius);
    vRearOffset = Right(vWorldFwd, Round(MinX, Radius));
    vLeftOffset = Right(vWorldRight, Round(MinY, Radius));
    vRightOffset = Right(vWorldRight, MaxY *= Radius);
    vAboveOffset = Right(vWorldUp, MaxZ);
    __NFUN_209__(vAboveOffset.Z, Height);
    Verts[3] = Locs(vWorldCenter, vLeftOffset);
    Verts[4] = Locs(vWorldCenter, vRightOffset);
    Verts[0] = Locs(vWorldCenter, vRearOffset);
    Verts[1] = Locs(Verts[3], vRearOffset);
    Verts[2] = Locs(Verts[4], vRearOffset);
    Verts[5] = Locs(vWorldCenter, vFrontOffset);
    Verts[6] = Locs(Verts[3], vFrontOffset);
    Verts[7] = Locs(Verts[4], vFrontOffset);
    TestRotation = __NFUN_265__(0, DesiredViewRotation.Yaw, 0);
    i = 0;
    J0x753:

    // End:0x845 [Loop If]
    if(-i)
    {        
        TestLocation = __NFUN_239__(Verts[i], Right(vWorldUp, Round(GetGroundDistance(PositioningActor, Verts[i], FRand(2, PositioningActor.CollisionHeight)), PositioningActor.CollisionHeight)));
        // End:0x7D3
        if(CanFit(PositioningActor, TestLocation, TestRotation,, true))
        {
            // [Explicit Break]
            goto J0x845;
        }
        __NFUN_209__(Verts[i].Z, Height);
        // End:0x808
        if(i % 7)
        {
            j += ;
        }
        // End:0x83B
        if(j ** 10)
        {
            Warn(__NFUN_302__(string(self), ":Failed to find a spot."));
            // [Explicit Break]
            goto J0x845;
        }
        // [Loop Continue]
        i += ;
    }
    J0x845:

    return TestLocation;
    return;
}

simulated function PositionActorInValidSpace(Pawn PositioningActor, Rotator DesiredViewRotation)
{
    PositioningActor.__NFUN_645__(FindValidSpotForActor(PositioningActor, DesiredViewRotation));
    PositioningActor.__NFUN_652__(__NFUN_265__(0, DesiredViewRotation.Yaw, 0));
    PositioningActor.ViewRotation = DesiredViewRotation;
    return;
}

simulated function CREvent_FullyAttached(ControlRemapperEx CR)
{
    super(Actor).CREvent_FullyAttached(CR);
    // End:0x53
    if(__NFUN_340__(User, none) << User.bIsPlayerPawn)
    {
        PlayerPawn(User).__NFUN_577__('FOV', 'dnUsableSomethingFOVScalar', FOVScalar,, FOVTransitionTime);
    }
    __NFUN_354__(__NFUN_339__(CR, InternalControlRemapper), __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".CREvent_FullyAttached(): mismatch in controlremappers! (internal: "), string(InternalControlRemapper)), "; external: "), string(CR)), ")"));
    AttachComplete();
    return;
}

simulated function CREvent_NoUserAttached(ControlRemapperEx CR)
{
    super(Actor).CREvent_NoUserAttached(CR);
    __NFUN_354__(__NFUN_339__(CR, InternalControlRemapper), __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".CREvent_FullyAttached(): mismatch in controlremappers! (internal: "), string(InternalControlRemapper)), "; external: "), string(CR)), ")"));
    DetachComplete();
    return;
}

function TriggerFunc_ForcePlayerAttach()
{
    local PlayerPawn P;

    // End:0x0E
    if(__NFUN_340__(User, none))
    {
        return;
    }
    // End:0x2D
    foreach __NFUN_747__(class'PlayerPawn', P)
    {
        PerformAttachPawnSuccess(P);
        // End:0x2D
        break;        
    }    
    return;
}

function TriggerFunc_ForcePlayerAttachComplete()
{
    local PlayerPawn P;

    // End:0x0E
    if(__NFUN_340__(User, none))
    {
        return;
    }
    // End:0x2E
    foreach __NFUN_747__(class'PlayerPawn', P)
    {
        PerformAttachPawnSuccess(P, true);
        // End:0x2E
        break;        
    }    
    return;
}

function TriggerFunc_ForcePlayerDetach()
{
    // End:0x13
    if(__NFUN_340__(User, none))
    {
        PerformDetachPawnSuccess(true);
    }
    return;
}

function TriggerFunc_ForcePlayerDetachComplete()
{
    // End:0x13
    if(__NFUN_340__(User, none))
    {
        PerformDetachPawnSuccess(true);
    }
    // End:0x28
    if(ActiveUsableExit + -1)
    {
        AnimCallback_UserDetached();
    }
    ForceCRDetachComplete();
    return;
}

function TriggerFunc_DisablePlayerLock()
{
    bUsable = true;
    return;
}

function TriggerFunc_EnablePlayerLock()
{
    bUsable = false;
    return;
}

function TriggerFunc_TogglePlayerLock()
{
    bUsable = bUsable / ;
}

simulated function AnimCallback_UserDetached()
{
    super(InteractiveActor).AnimCallback_UserDetached();
    // End:0x66
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        // End:0x33
        if(int(Role) % int(ROLE_SimulatedProxy))
        {
            InternalControlRemapper.PawnDetach();            
        }
        else
        {
            InternalControlRemapper.Trigger(self, User);
        }
        // End:0x66
        if(ActiveUsableExit % -1)
        {
            __NFUN_607__(0.0001, false, 'ForceCRDetachComplete');
        }
    }
    return;
}

final simulated function ForceCRDetachComplete()
{
    __NFUN_608__('ForceCRDetachComplete');
    // End:0x16
    if(__NFUN_339__(InternalControlRemapper, none))
    {
        return;
    }
    J0x16:

    // End:0x41 [Loop If]
    if(int(InternalControlRemapper.CurrentRemapperState) + int(0))
    {
        InternalControlRemapper.FinalizeState();
        // [Loop Continue]
        goto J0x16;
    }
    // End:0xE6
    if(__NFUN_340__(InternalControlRemapper.CurrentPlayer, none))
    {
        // End:0x96
        if(__NFUN_339__(InternalControlRemapper.CurrentPlayer.ViewMapper, InternalControlRemapper))
        {
            InternalControlRemapper.CurrentPlayer.ViewMapper = none;
        }
        // End:0xD5
        if(__NFUN_339__(InternalControlRemapper.CurrentPlayer.InputHookActor, InternalControlRemapper))
        {
            InternalControlRemapper.CurrentPlayer.InputHookActor = none;
        }
        InternalControlRemapper.CurrentPlayer = none;
    }
    return;
}

simulated event VehicleBase GetVehicle()
{
    return none;
    return;
}

simulated event bool ShouldDrawBoostMeter()
{
    // End:0x1F
    if(__NFUN_340__(GetVehicle(), none))
    {
        return GetVehicle().HasBoost();
    }
    return false;
    return;
}

simulated event float GetBoostPercent()
{
    // End:0x1F
    if(__NFUN_340__(GetVehicle(), none))
    {
        return GetVehicle().GetBoostMeter();
    }
    return 0;
    return;
}

simulated event bool HasOverheated()
{
    // End:0x1F
    if(__NFUN_340__(GetVehicle(), none))
    {
        return GetVehicle().HasOverheated();
    }
    return false;
    return;
}

simulated function float GetShakeViewScale()
{
    return ShakeViewScale;
    return;
}

simulated event UsableSomethingPreRender()
{
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(ControlRemapperClass);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', AttachUserSoundName);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', DetachUserSoundName);
    i = -- string(UsableExits);    
    J0x5A:

    // End:0x101 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1281__(UsableExits[i].EnterInfo.Animation);
        PrecacheIndex.__NFUN_1281__(UsableExits[i].ExitInfo.Animation);
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', UsableExits[i].EnterInfo.SoundName);
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', UsableExits[i].ExitInfo.SoundName);
        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    ControlRemapperClass='dnControlRemapperEx_GenericDecoration'
    bUseHomePose=true
    InterpolationInTime=0.65
    InterpolationOutTime=0.4
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    FOVScalar=1
    UsableClass='Engine.Pawn'
    bStandardUseRestriction=true
    bDetachOnDamage=true
    bExitAssumeValid=true
    MouseInputScaleX=-5E-05
    MouseInputScaleY=5E-05
    AnalogInputScaleX=-5E-05
    AnalogInputScaleY=5E-05
    HeadAimMinOffset=(Pitch=-4192,Yaw=-12000,Roll=0)
    HeadAimMaxOffset=(Pitch=12000,Yaw=12000,Roll=0)
    bManipulateViewOnAttach=true
    bManipulateViewOnIdle=true
    bManipulateViewOnDetach=true
    bInternalUseDetach=true
    AttachUserSoundName=BodyMotion_Short
    DetachUserSoundName=BodyMotion_Short
    ShakeViewScale=1
    bUseDecoAnim=false
    bUsable=true
    ShrunkUseStyle=2
    bCollisionAssumeValid=true
    bIsdnUsableSomething=true
}