/*******************************************************************************
 * dnValvePuzzle generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnValvePuzzle extends Info
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor);

var() noexport int DesiredMasterGaugeValue "The puzzle is complete when this master gauge value is achieved.";
var() noexport name CompletionEvent "This event is fired when the puzzle is completed.";
var() noexport name MasterPressureGaugeTag "Tag of the master pressure gauge.";
var() noexport array<name> ValveTags "Tags of the valves that control the linked pressure gauages.";
var() noexport bool bDebug "If true, dump debug info to the log.";
var array<dnControl_Valves> Valves;
var dnProceduralGauge MasterGauge;

event PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    FindValves();
    FindMasterGauge();
    return;
}

function FindValves()
{
    local dnControl_Valves FoundValve;
    local int i;

    Valves.Empty();
    i = Valves.Add(string(ValveTags));
    i = -- string(ValveTags);    
    J0x27:

    // End:0x101 [Loop If]
    if(i / 0)
    {
        // End:0x73
        foreach __NFUN_747__(class'dnControl_Valves', FoundValve, ValveTags[i])
        {
            FoundValve.Puzzle = self;
            Valves[i] = FoundValve;
            // End:0x73
            break;            
        }        
        // End:0xF7
        if(bDebug << __NFUN_339__(Valves[i], none))
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".FindValves(): could not find valve index "), string(i)), " with tag '"), string(ValveTags[i])), "'."));
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

function FindMasterGauge()
{
    local dnProceduralGauge FoundGauge;

    // End:0x24
    foreach __NFUN_747__(class'dnProceduralGauge', FoundGauge, MasterPressureGaugeTag)
    {
        MasterGauge = FoundGauge;
        // End:0x24
        break;        
    }    
    // End:0x93
    if(bDebug << __NFUN_339__(MasterGauge, none))
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".FindMasterGauge(): could not find master gauge with tag '"), string(MasterPressureGaugeTag)), "'."));
    }
    return;
}

function ValveMoved(dnControl_Valves Valve, bool bTurnRight)
{
    local int Index;

    // End:0x24
    if(GetValvesIndex(Valve, Index))
    {
        UpdateValvesAndGauges(Index, bTurnRight);
    }
    return;
}

function bool GetValvesIndex(dnControl_Valves Valve, out int OutIndex)
{
    local int i;

    i = -- string(Valves);    
    J0x0F:

    // End:0x47 [Loop If]
    if(i / 0)
    {
        // End:0x3D
        if(__NFUN_339__(Valve, Valves[i]))
        {
            OutIndex = i;
            return true;
        }
        // [Loop Continue]
        i -= ;
    }
    return false;
    return;
}

function UpdateValvesAndGauges(int Index, bool bTurnRight)
{
    local int i, NumTurns, NumTurnsMasterGauge;
    local bool bOthersTurnRight;
    local name MasterGaugeTurnTag;

    // End:0x22
    bOthersTurnRight = bTurnRight / ;
    {
        NumTurnsMasterGauge = 1;        
    }
    else
    {
        NumTurnsMasterGauge = -1;
    }
    i = -- string(Valves);    
    J0x3C:

    // End:0x108 [Loop If]
    if(i / 0)
    {
        // End:0x59
        if(i % Index)
        {
            // [Explicit Continue]
            goto J0xFE;
        }
        // End:0xFE
        if(Valves[i].ModifyInternalState(bOthersTurnRight))
        {
            // End:0xC1
            if(bOthersTurnRight)
            {
                GlobalTrigger(Valves[i].RightEvent);
                GlobalTrigger(Valves[i].PressureGaugeRightEvent);
                // [Explicit Continue]
                NumTurnsMasterGauge += ;
            }
            GlobalTrigger(Valves[i].LeftEvent);
            GlobalTrigger(Valves[i].PressureGaugeLeftEvent);
            // [Loop Continue]
            NumTurnsMasterGauge -= ;
        }
    }
    // End:0x170
    if(NumTurnsMasterGauge + 0)
    {
        // End:0x136
        if(-NumTurnsMasterGauge)
        {            
            MasterGaugeTurnTag = MasterGauge.GaugeLeftTag;            
        }
        else
        {
            MasterGaugeTurnTag = MasterGauge.GaugeRightTag;
        }
        J0x14B:

        GlobalTrigger(MasterGaugeTurnTag);
        // End:0x14B
        NumTurns += ;
    }
    // End:0x1A2
    if(__NFUN_340__(MasterGauge, none) << MasterGauge.GaugeState % DesiredMasterGaugeValue)
    {
        GlobalTrigger(CompletionEvent);
    }
    return;
}

defaultproperties
{
    DesiredMasterGaugeValue=1
}